/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.client.adapter.cimxml;

import com.ws.cim.xmlcim.CIMXMLElementsWriter;
import java.io.OutputStream;
import java.util.Locale;
import java.util.UUID;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifierType;
import javax.cim.UnsignedInteger32;
import javax.security.auth.Subject;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.client.EnumerateResponse;
import javax.wbem.client.WBEMClient;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class CIMXMLRequestStreamWriter
implements WBEMClient {
    private final String mCIMVersion;
    private final String mDTDVersion;
    private final String mProtocolVersion;
    private OutputStream mStream;

    public CIMXMLRequestStreamWriter(String CIMVersion, String DTDVersion, String protocolVersion) {
        this.mCIMVersion = CIMVersion;
        this.mDTDVersion = DTDVersion;
        this.mProtocolVersion = protocolVersion;
    }

    public CIMXMLRequestStreamWriter(String CIMVersion, String DTDVersion, String protocolVersion, OutputStream outputStream) {
        this(CIMVersion, DTDVersion, protocolVersion);
        this.setStream(outputStream);
    }

    public CIMXMLRequestStreamWriter(OutputStream outputStream) {
        this("2.0", "2.0", "1.0", outputStream);
    }

    public CloseableIterator<CIMClass> associatorClasses(final CIMObjectPath target, final String assocClass, final String resultClass, final String role, final String resultRole, final boolean includeQualifiers) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.ASSOCIATORCLASSES, "Associators", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamObjectName(writer, target);
                    CIMXMLRequestStreamWriter.this.writeIParamAssocClass(writer, assocClass);
                    CIMXMLRequestStreamWriter.this.writeIParamResultClass(writer, resultClass);
                    CIMXMLRequestStreamWriter.this.writeIParamRole(writer, role);
                    CIMXMLRequestStreamWriter.this.writeIParamResultRole(writer, resultRole);
                    CIMXMLRequestStreamWriter.this.writeIParamIncludeQualifiers(writer, includeQualifiers);
                    CIMXMLRequestStreamWriter.this.writeIParamIncludeClassOrigin(writer, false);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.ASSOCIATORCLASSES, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public CloseableIterator<CIMInstance> associatorInstances(final CIMObjectPath target, final String assocClass, final String resultClass, final String role, final String resultRole, final String[] propertyList) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.OPENASSOCIATORS, "Associators", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamObjectName(writer, target);
                    CIMXMLRequestStreamWriter.this.writeIParamAssocClass(writer, assocClass);
                    CIMXMLRequestStreamWriter.this.writeIParamResultClass(writer, resultClass);
                    CIMXMLRequestStreamWriter.this.writeIParamRole(writer, role);
                    CIMXMLRequestStreamWriter.this.writeIParamResultRole(writer, resultRole);
                    CIMXMLRequestStreamWriter.this.writeIParamPropertyList(writer, propertyList);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> associators(final CIMObjectPath target, final String assocClass, final String resultClass, final String role, final String resultRole, final String[] propertyList, final String filterQueryLanguage, final String filterQuery, final UnsignedInteger32 timeout, final boolean continueOnError, final UnsignedInteger32 maxObjects) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.OPENASSOCIATORS, "OpenAssociatorInstances", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamInstanceName(writer, target);
                    CIMXMLRequestStreamWriter.this.writeIParamAssocClass(writer, assocClass);
                    CIMXMLRequestStreamWriter.this.writeIParamResultClass(writer, resultClass);
                    CIMXMLRequestStreamWriter.this.writeIParamRole(writer, role);
                    CIMXMLRequestStreamWriter.this.writeIParamResultRole(writer, resultRole);
                    CIMXMLRequestStreamWriter.this.writeIParamPropertyList(writer, propertyList);
                    CIMXMLRequestStreamWriter.this.writeIParamFilterQueryLanguage(writer, filterQueryLanguage);
                    CIMXMLRequestStreamWriter.this.writeIParamFilterQuery(writer, filterQuery);
                    CIMXMLRequestStreamWriter.this.writeIParamTimeout(writer, timeout);
                    CIMXMLRequestStreamWriter.this.writeIParamContinueOnError(writer, continueOnError);
                    CIMXMLRequestStreamWriter.this.writeIParamMaxObjects(writer, maxObjects);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.OPENASSOCIATORS, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public void close() {
    }

    public void closeEnumeration(final CIMObjectPath target, final String context) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.CLOSEENUMERATION, "CloseEnumeration", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamEnumerationContext(writer, context);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.CLOSEENUMERATION, (String)target.getObjectName());
                }
            }
        });
    }

    public void createClass(final CIMClass clazz) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.CREATECLASS, "CreateClass", clazz.getObjectPath(), new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamNewClass(writer, clazz);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)clazz.getObjectPath(), (Throwable)e, (WBEMOperation)WBEMOperation.CREATECLASS, clazz.getObjectPath() != null ? clazz.getObjectPath().getObjectName() : null);
                }
            }
        });
    }

    public CIMObjectPath createInstance(final CIMInstance instance) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.CREATEINSTANCE, "CreateInstance", instance.getObjectPath(), new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamNewInstance(writer, instance);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)instance.getObjectPath(), (Throwable)e, (WBEMOperation)WBEMOperation.CREATEINSTANCE, instance.getObjectPath() != null ? instance.getObjectPath().getObjectName() : null);
                }
            }
        });
        return null;
    }

    public void deleteClass(final CIMObjectPath target) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.DELETECLASS, "DeleteClass", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamClassName(writer, target);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.DELETECLASS, (String)target.getObjectName());
                }
            }
        });
    }

    public void deleteInstance(final CIMObjectPath target) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.DELETEINSTANCE, "DeleteInstance", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamInstanceName(writer, target);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.DELETEINSTANCE, (String)target.getObjectName());
                }
            }
        });
    }

    public void deleteQualifierType(final CIMObjectPath target) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.DELETEQUALIFIERTYPE, "DeleteQualifier", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamQualifierName(writer, target);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.DELETEQUALIFIERTYPE, (String)target.getObjectName());
                }
            }
        });
    }

    public CloseableIterator<CIMClass> enumerateClasses(final CIMObjectPath target, final boolean deep, final boolean localOnly, final boolean includeQualifiers) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.ENUMERATECLASSES, "EnumerateClasses", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamClassName(writer, target);
                    CIMXMLRequestStreamWriter.this.writeIParamDeepInheritance(writer, deep);
                    CIMXMLRequestStreamWriter.this.writeIParamLocalOnly(writer, localOnly);
                    CIMXMLRequestStreamWriter.this.writeIParamIncludeQualifiers(writer, includeQualifiers);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.ENUMERATECLASSES, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public CloseableIterator<CIMInstance> enumerateInstances(final CIMObjectPath target, final String[] propertyList) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.ENUMERATEINSTANCES, "EnumerateInstances", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamClassName(writer, target);
                    CIMXMLRequestStreamWriter.this.writeIParamLocalOnly(writer, false);
                    CIMXMLRequestStreamWriter.this.writeIParamPropertyList(writer, propertyList);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> enumerateInstances(final CIMObjectPath target, final String[] propertyList, final String filterQueryLanguage, final String filterQuery, final UnsignedInteger32 timeout, final boolean continueOnError, final UnsignedInteger32 maxObjects) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.OPENENUMERATEINSTANCES, "OpenEnumerateInstances", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamClassName(writer, target);
                    CIMXMLRequestStreamWriter.this.writeIParamDeepInheritance(writer, true);
                    CIMXMLRequestStreamWriter.this.writeIParamPropertyList(writer, propertyList);
                    CIMXMLRequestStreamWriter.this.writeIParamFilterQueryLanguage(writer, filterQueryLanguage);
                    CIMXMLRequestStreamWriter.this.writeIParamFilterQuery(writer, filterQuery);
                    CIMXMLRequestStreamWriter.this.writeIParamTimeout(writer, timeout);
                    CIMXMLRequestStreamWriter.this.writeIParamContinueOnError(writer, continueOnError);
                    CIMXMLRequestStreamWriter.this.writeIParamMaxObjects(writer, maxObjects);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.OPENENUMERATEINSTANCES, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public CloseableIterator<CIMQualifierType<?>> enumerateQualifierTypes(CIMObjectPath target) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.ENUMERATEQUALIFIERTYPES, "EnumerateQualifiers", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
            }
        });
        return null;
    }

    public CloseableIterator<CIMInstance> execQuery(final CIMObjectPath target, final String query, final String queryLanguage) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.EXECUTEQUERY, "ExecQuery", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamQueryLanguage(writer, queryLanguage);
                    CIMXMLRequestStreamWriter.this.writeIParamQuery(writer, query);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.EXECUTEQUERY, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> execQueryInstances(final CIMObjectPath target, final String filterQuery, final String filterQueryLanguage, final boolean returnQueryResultClass, final UnsignedInteger32 timeout, final boolean continueOnError, final UnsignedInteger32 maxObjects, CIMClass queryResultClass) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.OPENQUERYINSTANCES, "OpenQueryInstances", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamFilterQueryLanguage(writer, filterQueryLanguage);
                    CIMXMLRequestStreamWriter.this.writeIParamFilterQuery(writer, filterQuery);
                    CIMXMLRequestStreamWriter.this.writeIParamReturnQueryClass(writer, returnQueryResultClass);
                    CIMXMLRequestStreamWriter.this.writeIParamTimeout(writer, timeout);
                    CIMXMLRequestStreamWriter.this.writeIParamContinueOnError(writer, continueOnError);
                    CIMXMLRequestStreamWriter.this.writeIParamMaxObjects(writer, maxObjects);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.OPENQUERYINSTANCES, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    private String getCIMXMLDataTypefromCIMDataType(CIMDataType cdt) {
        String type = null;
        if (cdt == null) {
            return type;
        }
        if (-1 == cdt.getType()) {
            return CIMDataType.STRING_T.toString();
        }
        if (cdt.getType() != 14) {
            type = cdt.toString().toLowerCase();
            if (type.indexOf("_") > 0) {
                type = type.substring(0, type.indexOf("_"));
            } else if (type.indexOf("[") > 0) {
                type = type.substring(0, type.indexOf("["));
            }
        } else {
            type = "reference";
        }
        return type;
    }

    public CIMClass getClass(final CIMObjectPath target, final boolean localOnly, final boolean includeQualifiers) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.GETCLASS, "GetClass", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamClassName(writer, target);
                    CIMXMLRequestStreamWriter.this.writeIParamLocalOnly(writer, localOnly);
                    CIMXMLRequestStreamWriter.this.writeIParamIncludeQualifiers(writer, includeQualifiers);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.GETCLASS, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public CIMInstance getInstance(final CIMObjectPath target, final String[] propertyList) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.GETINSTANCE, "GetInstance", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamInstanceName(writer, target);
                    CIMXMLRequestStreamWriter.this.writeIParamLocalOnly(writer, false);
                    CIMXMLRequestStreamWriter.this.writeIParamPropertyList(writer, propertyList);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.GETINSTANCE, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> getInstances(final CIMObjectPath target, final String context, final UnsignedInteger32 maxObjects) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.PULLINSTANCES, "PullInstances", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamEnumerationContext(writer, context);
                    CIMXMLRequestStreamWriter.this.writeIParamMaxObjects(writer, maxObjects);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.PULLINSTANCES, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> getInstancesWithPath(final CIMObjectPath target, final String context, final UnsignedInteger32 maxObjects) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.PULLINSTANCESWITHPATH, "PullInstancesWithPath", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamEnumerationContext(writer, context);
                    CIMXMLRequestStreamWriter.this.writeIParamMaxObjects(writer, maxObjects);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.PULLINSTANCESWITHPATH, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public String getProperty(String name) {
        return null;
    }

    public CIMQualifierType<?> getQualifierType(final CIMObjectPath target) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.GETQUALIFIERTYPE, "GetQualifier", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamQualifierName(writer, target);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.GETQUALIFIERTYPE, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public void initialize(CIMObjectPath name, Subject subject, Locale[] locales) throws WBEMException {
    }

    private void writeArgument(XMLStreamWriter writer, CIMArgument<?> a) throws XMLStreamException {
        if (null != a) {
            CIMDataType cdt = a.getDataType();
            writer.writeStartElement("PARAMVALUE");
            writer.writeAttribute("NAME", a.getName());
            writer.writeAttribute("PARAMTYPE", this.getCIMXMLDataTypefromCIMDataType(cdt));
            Object v = a.getValue();
            if (null != v) {
                if (v instanceof CIMClass || v instanceof CIMInstance || v instanceof CIMClass[] || v instanceof CIMInstance[]) {
                    writer.writeAttribute("EmbeddedObject", "object");
                }
                if (cdt.getType() == 14) {
                    if (cdt.isArray()) {
                        CIMXMLElementsWriter.writeValueRefArray((XMLStreamWriter)writer, (CIMObjectPath[])((CIMObjectPath[])v));
                    } else {
                        CIMXMLElementsWriter.writeValueReference((XMLStreamWriter)writer, (CIMObjectPath)((CIMObjectPath)v));
                    }
                } else if (cdt.isArray()) {
                    CIMXMLElementsWriter.writeValueArray((XMLStreamWriter)writer, (Object[])((Object[])v));
                } else {
                    CIMXMLElementsWriter.writeValue((XMLStreamWriter)writer, (Object)v);
                }
            }
            writer.writeEndElement();
        }
    }

    public Object invokeMethod(CIMObjectPath target, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        try {
            XMLOutputFactory f = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = f.createXMLStreamWriter(this.mStream);
            writer.writeStartDocument();
            writer.writeStartElement("CIM");
            writer.writeAttribute("CIMVERSION", this.mCIMVersion);
            writer.writeAttribute("DTDVERSION", this.mDTDVersion);
            writer.writeStartElement("MESSAGE");
            writer.writeAttribute("ID", UUID.randomUUID().toString());
            writer.writeAttribute("PROTOCOLVERSION", this.mProtocolVersion);
            writer.writeStartElement("SIMPLEREQ");
            writer.writeStartElement("METHODCALL");
            writer.writeAttribute("NAME", methodName);
            if (null == target.getKeys()) {
                CIMXMLElementsWriter.writeLocalClassPath((XMLStreamWriter)writer, (CIMObjectPath)target);
            } else {
                CIMXMLElementsWriter.writeLocalInstancePath((XMLStreamWriter)writer, (CIMObjectPath)target);
            }
            if (null != inArgs) {
                for (CIMArgument<?> a : inArgs) {
                    if (null == a.getValue()) continue;
                    this.writeArgument(writer, a);
                }
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.INVOKEMETHOD, (String)(target.getObjectName() + "." + methodName));
        }
        return null;
    }

    public void modifyClass(final CIMClass clazz) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.MODIFYCLASS, "ModifyClass", clazz.getObjectPath(), new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamModifiedClass(writer, clazz);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)clazz.getObjectPath(), (Throwable)e, (WBEMOperation)WBEMOperation.MODIFYCLASS, clazz.getObjectPath() != null ? clazz.getObjectPath().getObjectName() : null);
                }
            }
        });
    }

    public void modifyInstance(final CIMInstance instance, final String[] propertyList) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.MODIFYINSTANCE, "ModifyInstance", instance.getObjectPath(), new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamModifiedInstance(writer, instance);
                    CIMXMLRequestStreamWriter.this.writeIParamPropertyList(writer, propertyList);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)instance.getObjectPath(), (Throwable)e, (WBEMOperation)WBEMOperation.MODIFYINSTANCE, instance.getObjectPath() != null ? instance.getObjectPath().getObjectName() : null);
                }
            }
        });
    }

    public CloseableIterator<CIMClass> referenceClasses(final CIMObjectPath target, final String resultClass, final String role, final boolean includeQualifiers) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.REFERENCECLASSES, "References", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamObjectName(writer, target);
                    CIMXMLRequestStreamWriter.this.writeIParamResultClass(writer, resultClass);
                    CIMXMLRequestStreamWriter.this.writeIParamRole(writer, role);
                    CIMXMLRequestStreamWriter.this.writeIParamIncludeQualifiers(writer, includeQualifiers);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.REFERENCECLASSES, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public CloseableIterator<CIMInstance> referenceInstances(final CIMObjectPath target, final String resultClass, final String role, final String[] propertyList) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.OPENREFERENCES, "References", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamObjectName(writer, target);
                    CIMXMLRequestStreamWriter.this.writeIParamResultClass(writer, resultClass);
                    CIMXMLRequestStreamWriter.this.writeIParamRole(writer, role);
                    CIMXMLRequestStreamWriter.this.writeIParamPropertyList(writer, propertyList);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public EnumerateResponse<CIMInstance> references(final CIMObjectPath target, final String resultClass, final String role, final String[] propertyList, final String filterQueryLanguage, final String filterQuery, final UnsignedInteger32 timeout, final boolean continueOnError, final UnsignedInteger32 maxObjects) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.OPENREFERENCES, "OpenReferenceInstances", target, new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamInstanceName(writer, target);
                    CIMXMLRequestStreamWriter.this.writeIParamResultClass(writer, resultClass);
                    CIMXMLRequestStreamWriter.this.writeIParamRole(writer, role);
                    CIMXMLRequestStreamWriter.this.writeIParamPropertyList(writer, propertyList);
                    CIMXMLRequestStreamWriter.this.writeIParamFilterQueryLanguage(writer, filterQueryLanguage);
                    CIMXMLRequestStreamWriter.this.writeIParamFilterQuery(writer, filterQuery);
                    CIMXMLRequestStreamWriter.this.writeIParamTimeout(writer, timeout);
                    CIMXMLRequestStreamWriter.this.writeIParamContinueOnError(writer, continueOnError);
                    CIMXMLRequestStreamWriter.this.writeIParamMaxObjects(writer, maxObjects);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.OPENREFERENCES, (String)target.getObjectName());
                }
            }
        });
        return null;
    }

    public void setLocales(Locale[] pLocales) {
    }

    public void setProperty(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public void createQualifierType(CIMQualifierType<?> qualifierType) throws WBEMException {
        this.setQualifierType(qualifierType);
    }

    public void modifyQualifierType(CIMQualifierType<?> qualifierType) throws WBEMException {
        this.setQualifierType(qualifierType);
    }

    public void setQualifierType(final CIMQualifierType<?> qualifierType) throws WBEMException {
        this.simpleIntrinsicRequest(WBEMOperation.CREATEQUALIFIERTYPE, "SetQualifier", qualifierType.getObjectPath(), new ParamIF(){

            @Override
            public void getParameters(XMLStreamWriter writer) throws WBEMException {
                try {
                    CIMXMLRequestStreamWriter.this.writeIParamQualifierType(writer, qualifierType);
                }
                catch (XMLStreamException e) {
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)qualifierType.getObjectPath(), (Throwable)e, (WBEMOperation)WBEMOperation.CREATEQUALIFIERTYPE, qualifierType.getObjectPath() != null ? qualifierType.getObjectPath().getObjectName() : null);
                }
            }
        });
    }

    protected void setStream(OutputStream stream) {
        this.mStream = stream;
    }

    private void simpleIntrinsicRequest(WBEMOperation genericOperationName, String operationName, CIMObjectPath target, ParamIF paramWriter) throws WBEMException {
        try {
            XMLOutputFactory f = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = f.createXMLStreamWriter(this.mStream);
            writer.writeStartDocument();
            writer.writeStartElement("CIM");
            writer.writeAttribute("CIMVERSION", this.mCIMVersion);
            writer.writeAttribute("DTDVERSION", this.mDTDVersion);
            writer.writeStartElement("MESSAGE");
            writer.writeAttribute("ID", UUID.randomUUID().toString());
            writer.writeAttribute("PROTOCOLVERSION", this.mProtocolVersion);
            writer.writeStartElement("SIMPLEREQ");
            writer.writeStartElement("IMETHODCALL");
            writer.writeAttribute("NAME", operationName);
            CIMXMLElementsWriter.writeLocalNamespacePath((XMLStreamWriter)writer, (String)target.getNamespace());
            paramWriter.getParameters(writer);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)genericOperationName, (String)target.getObjectName());
        }
    }

    private void writeIParamAssocClass(XMLStreamWriter writer, String value) throws XMLStreamException {
        if (null != value) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "AssocClass");
            writer.writeStartElement("CLASSNAME");
            writer.writeAttribute("NAME", value);
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeIParamClassName(XMLStreamWriter writer, CIMObjectPath target) throws XMLStreamException {
        if (null != target && null != target.getObjectName()) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "ClassName");
            CIMXMLElementsWriter.writeClassName((XMLStreamWriter)writer, (CIMObjectPath)target);
            writer.writeEndElement();
        }
    }

    private void writeIParamObjectName(XMLStreamWriter writer, CIMObjectPath target) throws XMLStreamException {
        if (null != target && null != target.getObjectName()) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "ObjectName");
            if (null != target.getKeys()) {
                CIMXMLElementsWriter.writeInstanceName((XMLStreamWriter)writer, (CIMObjectPath)target);
            } else {
                CIMXMLElementsWriter.writeClassName((XMLStreamWriter)writer, (CIMObjectPath)target);
            }
            writer.writeEndElement();
        }
    }

    private void writeIParamContinueOnError(XMLStreamWriter writer, boolean continueOnError) throws XMLStreamException {
        if (continueOnError) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "ContinueOnError");
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)writer, (Object)"true");
            writer.writeEndElement();
        }
    }

    private void writeIParamDeepInheritance(XMLStreamWriter writer, boolean deep) throws XMLStreamException {
        if (deep) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "DeepInheritance");
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)writer, (Object)"true");
            writer.writeEndElement();
        }
    }

    private void writeIParamEnumerationContext(XMLStreamWriter writer, String value) throws XMLStreamException {
        this.writeIParamValue(writer, value, "EnumerationContext");
    }

    private void writeIParamFilterQuery(XMLStreamWriter writer, String value) throws XMLStreamException {
        if (null != value) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "FilterQuery");
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)writer, (Object)value);
            writer.writeEndElement();
        }
    }

    private void writeIParamFilterQueryLanguage(XMLStreamWriter writer, String value) throws XMLStreamException {
        if (null != value) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "FilterQueryLanguage");
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)writer, (Object)value);
            writer.writeEndElement();
        }
    }

    private void writeIParamIncludeClassOrigin(XMLStreamWriter writer, boolean includeClassOrigin) throws XMLStreamException {
        if (includeClassOrigin) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "IncludeClassOrigin");
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)writer, (Object)"true");
            writer.writeEndElement();
        }
    }

    private void writeIParamIncludeQualifiers(XMLStreamWriter writer, boolean includeQualifiers) throws XMLStreamException {
        if (!includeQualifiers) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "IncludeQualifiers");
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)writer, (Object)"false");
            writer.writeEndElement();
        }
    }

    private void writeIParamInstanceName(XMLStreamWriter writer, CIMObjectPath target) throws XMLStreamException {
        if (null != target && null != target.getObjectName()) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "InstanceName");
            CIMXMLElementsWriter.writeInstanceName((XMLStreamWriter)writer, (CIMObjectPath)target);
            writer.writeEndElement();
        }
    }

    private void writeIParamLocalOnly(XMLStreamWriter writer, boolean localOnly) throws XMLStreamException {
        if (!localOnly) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "LocalOnly");
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)writer, (Object)"false");
            writer.writeEndElement();
        }
    }

    private void writeIParamMaxObjects(XMLStreamWriter writer, UnsignedInteger32 value) throws XMLStreamException {
        if (null != value) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "MaxObjectCount");
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)writer, (Object)value);
            writer.writeEndElement();
        }
    }

    private void writeIParamModifiedClass(XMLStreamWriter writer, CIMClass clazz) throws XMLStreamException {
        writer.writeStartElement("IPARAMVALUE");
        writer.writeAttribute("NAME", "ModifiedClass");
        CIMXMLElementsWriter.writeClass((XMLStreamWriter)writer, (CIMClass)clazz);
        writer.writeEndElement();
    }

    private void writeIParamModifiedInstance(XMLStreamWriter writer, CIMInstance instance) throws XMLStreamException {
        writer.writeStartElement("IPARAMVALUE");
        writer.writeAttribute("NAME", "ModifiedInstance");
        CIMXMLElementsWriter.writeValueNamedInstance((XMLStreamWriter)writer, (CIMInstance)instance);
        writer.writeEndElement();
    }

    private void writeIParamNewClass(XMLStreamWriter writer, CIMClass clazz) throws XMLStreamException {
        writer.writeStartElement("IPARAMVALUE");
        writer.writeAttribute("NAME", "NewClass");
        CIMXMLElementsWriter.writeClass((XMLStreamWriter)writer, (CIMClass)clazz);
        writer.writeEndElement();
    }

    private void writeIParamNewInstance(XMLStreamWriter writer, CIMInstance instance) throws XMLStreamException {
        writer.writeStartElement("IPARAMVALUE");
        writer.writeAttribute("NAME", "NewInstance");
        CIMXMLElementsWriter.writeInstance((XMLStreamWriter)writer, (CIMInstance)instance);
        writer.writeEndElement();
    }

    private void writeIParamPropertyList(XMLStreamWriter writer, String[] propertyList) throws XMLStreamException {
        if (null != propertyList) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "PropertyList");
            CIMXMLElementsWriter.writeValueArray((XMLStreamWriter)writer, (Object[])propertyList);
            writer.writeEndElement();
        }
    }

    private void writeIParamQualifierName(XMLStreamWriter writer, CIMObjectPath qtPath) throws XMLStreamException {
        this.writeIParamValue(writer, qtPath.getObjectName(), "QualifierName");
    }

    private void writeIParamQualifierType(XMLStreamWriter writer, CIMQualifierType<?> qt) throws XMLStreamException {
        writer.writeStartElement("IPARAMVALUE");
        writer.writeAttribute("NAME", "QualifierDeclaration");
        CIMXMLElementsWriter.writeQualifierType((XMLStreamWriter)writer, qt);
        writer.writeEndElement();
    }

    private void writeIParamQuery(XMLStreamWriter writer, String value) throws XMLStreamException {
        this.writeIParamValue(writer, value, "Query");
    }

    private void writeIParamQueryLanguage(XMLStreamWriter writer, String value) throws XMLStreamException {
        this.writeIParamValue(writer, value, "QueryLanguage");
    }

    private void writeIParamResultClass(XMLStreamWriter writer, String value) throws XMLStreamException {
        if (null != value) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "ResultClass");
            writer.writeStartElement("CLASSNAME");
            writer.writeAttribute("NAME", value);
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeIParamResultRole(XMLStreamWriter writer, String value) throws XMLStreamException {
        this.writeIParamValue(writer, value, "ResultRole");
    }

    private void writeIParamReturnQueryClass(XMLStreamWriter writer, boolean value) throws XMLStreamException {
        if (value) {
            this.writeIParamValue(writer, "true", "ReturnQueryResultClass");
        }
    }

    private void writeIParamRole(XMLStreamWriter writer, String value) throws XMLStreamException {
        this.writeIParamValue(writer, value, "Role");
    }

    private void writeIParamTimeout(XMLStreamWriter writer, UnsignedInteger32 value) throws XMLStreamException {
        if (null != value) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", "OperationTimeout");
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)writer, (Object)value);
            writer.writeEndElement();
        }
    }

    private void writeIParamValue(XMLStreamWriter writer, String value, String paramName) throws XMLStreamException {
        if (null != value) {
            writer.writeStartElement("IPARAMVALUE");
            writer.writeAttribute("NAME", paramName);
            CIMXMLElementsWriter.writeValue((XMLStreamWriter)writer, (Object)value);
            writer.writeEndElement();
        }
    }

    private static interface ParamIF {
        public void getParameters(XMLStreamWriter var1) throws WBEMException;
    }
}

