/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.query;

import java.util.ArrayList;
import java.util.Arrays;
import javax.cim.CIMInstance;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;
import org.wbemservices.wbem.query.NumericArrayValue;
import org.wbemservices.wbem.query.ValueExp;

public class ArrayValueExp
extends ValueExp {
    private static final long serialVersionUID = 5371460733273152487L;
    private static final String INTERVAL_RANGE = "..";
    protected String exp;
    private String propName = null;
    private String embeddedPropName = null;
    private String range = null;
    private int beginRange;
    private int endRange;

    public ArrayValueExp() {
    }

    public ArrayValueExp(String q) {
        this();
        this.exp = q;
        this.parse(q);
    }

    @Override
    public ValueExp apply(CIMInstance obj) throws WBEMException {
        CIMProperty cp;
        CIMInstance ci = obj;
        if (this.embeddedPropName != null) {
            cp = ci.getProperty(this.embeddedPropName);
            if (cp == null) {
                throw new IllegalArgumentException("Property not found: " + this.embeddedPropName);
            }
            ci = (CIMInstance)cp.getValue();
            if (ci == null) {
                return null;
            }
        }
        if ((cp = ci.getProperty(this.propName)) == null) {
            throw new IllegalArgumentException("Property not found: " + this.propName);
        }
        Number[] val = (Number[])cp.getValue();
        if (val == null) {
            return null;
        }
        ArrayList<Number> values = new ArrayList<Number>(Arrays.asList(val));
        if (this.range.equals(INTERVAL_RANGE)) {
            int tmpEnd = this.endRange < values.size() ? this.endRange + 1 : values.size();
            int tmpBegin = this.beginRange < 0 ? 0 : this.beginRange;
            values = new ArrayList<Number>(values.subList(tmpBegin, tmpEnd));
        }
        return new NumericArrayValue(values.toArray());
    }

    private void parse(String q) {
        int dot = this.exp.indexOf(46);
        int scope = this.exp.indexOf("::");
        int open = q.indexOf(91);
        if (dot != -1) {
            if (scope == -1) {
                this.propName = q.substring(dot + 1, open == -1 ? q.length() : open);
                this.embeddedPropName = q.substring(0, dot);
            } else {
                this.propName = q.substring(scope + 2, open == -1 ? q.length() : open);
                this.embeddedPropName = q.substring(0, dot);
            }
        } else {
            this.propName = scope == -1 ? q.substring(0, open == -1 ? q.length() : open) : q.substring(scope + 2, open == -1 ? q.length() : open);
        }
        int close = q.indexOf(93);
        int dotdot = q.indexOf(INTERVAL_RANGE);
        if (open == -1) {
            this.range = "*";
        } else if (dotdot == -1) {
            this.range = q.substring(open + 1, close);
        } else {
            this.range = INTERVAL_RANGE;
            try {
                this.beginRange = new Integer(q.substring(open + 1, dotdot));
                this.endRange = new Integer(q.substring(dotdot + 2, close));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.exp;
    }
}

