/*
 * Decompiled with CFR 0.152.
 */
package sanproject.trlog.utility.com;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class StatusFileUty {
    private static final String PROPERTIES_KEY_COMMON = "com.hitachi.sanproject.process.";
    private static final String PROPERTIES_KEY_STATUS = "com.hitachi.sanproject.process.status";
    private static final String PROPERTIES_KEY_TRB = "com.hitachi.sanproject.process.trb";
    private static final String PROPERTIES_KEY_DISP = "com.hitachi.sanproject.process.disp";
    private static final String PROPERTIES = "status.properties";
    private static final String RELATIVE_PATH_PERIOD = "..";
    private static final String STATUS_STOPPED = "Stopped";
    private static final String STATUS_READY = "Ready";
    private static final String STATUS_INITIALIZING = "Initializing";
    private static final String STATUS_STOPPING = "Stopping";
    private static final String STATUS_FAILED = "Failed";
    private static final String STATUS_WARINING = "Warning";
    private static final String[] STATUS_ARRAY = new String[]{"Stopped", "Ready", "Initializing", "Stopping", "Failed", "Warning"};
    private static final long INTERVAL = 2L;
    static int RETRY = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void outStatusFile(String appName, String trbCode, String summary, String moduleId) {
        if (appName == null || trbCode == null || summary == null || moduleId == null) {
            return;
        }
        if (moduleId.length() == 0 || moduleId.contains(RELATIVE_PATH_PERIOD)) {
            return;
        }
        String currentPath = System.getProperty("SN_BasePath");
        if (currentPath == null) {
            return;
        }
        File currentDir = new File(currentPath);
        String baseDir = currentDir.getParent();
        String outPutDir = baseDir + File.separator + moduleId;
        File outDir = new File(outPutDir);
        if (!outDir.exists()) {
            return;
        }
        String statusFilePath = outPutDir + File.separator + PROPERTIES;
        File file = new File(outPutDir, PROPERTIES);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Properties prop = new Properties();
        FileOutputStream out = null;
        FileChannel channel = null;
        FileLock lock = null;
        String trbCodeLast = null;
        prop = StatusFileUty.readProperties(statusFilePath);
        trbCodeLast = prop.getProperty(PROPERTIES_KEY_TRB, "");
        String status = StatusFileUty.getStatusNumber(summary);
        String errCode = StatusFileUty.getTrbcode(status, trbCode, trbCodeLast);
        int retryCount = 0;
        while (true) {
            try {
                out = new FileOutputStream(statusFilePath);
                channel = out.getChannel();
                lock = channel.lock();
                prop.setProperty(PROPERTIES_KEY_STATUS, status);
                prop.setProperty(PROPERTIES_KEY_TRB, errCode);
                prop.setProperty(PROPERTIES_KEY_DISP, appName);
                prop.store(out, null);
                channel.force(true);
                out.getFD().sync();
            }
            catch (Exception ex) {
                if (RETRY < ++retryCount) break;
                try {
                    TimeUnit.MILLISECONDS.sleep(2L);
                    continue;
                }
                catch (InterruptedException e) {
                }
            }
            finally {
                if (lock != null) {
                    try {
                        lock.release();
                    }
                    catch (IOException e) {}
                }
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {}
                }
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (IOException e) {}
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readProperties(String filePath) {
        Properties result = null;
        FileInputStream in = null;
        try {
            result = new Properties();
            in = new FileInputStream(filePath);
            result.load(in);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    private static String getStatusNumber(String summary) {
        String result = "";
        for (String status : STATUS_ARRAY) {
            if (!summary.startsWith(status)) continue;
            result = status;
            break;
        }
        return result;
    }

    private static String getTrbcode(String status, String TrbCode, String TrbCodeLast) {
        String result = "";
        if (status.equals(STATUS_STOPPED)) {
            result = TrbCodeLast;
        } else if (status.equals(STATUS_FAILED) || status.equals(STATUS_WARINING)) {
            result = TrbCode;
        }
        return result;
    }
}

