/*
 * Decompiled with CFR 0.152.
 */
package sanproject.snctrl.thread;

import java.io.IOException;
import java.util.List;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcTRLogUty;
import sanproject.snctrl.com.utility.SJcSleepUty;
import sanproject.snctrl.thread.SJsnctrlMonitoringWork;
import sanproject.snctrl.thread.SJsnctrlSnStreamGobbler;
import sanproject.snctrl.thread.SJsnctrlSnWebAppFinishThread;
import sanproject.snctrl.thread.SJsnctrlSnWebAppThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsnctrlSnWebAppSurveillanceThread
extends SJsnctrlSnWebAppThread {
    private static final String LOG_FUNCTION = "Jetty";
    private static final String LOG_TITLE = SJsnctrlSnWebAppSurveillanceThread.class.getSimpleName();
    private long period;
    private StringBuilder execcmd;
    private StringBuilder stopcmd;
    private StringBuilder pre_stopcmd;
    private boolean endflag = false;
    private Runtime runtime = null;
    private Process execProc = null;
    private SJsnctrlSnStreamGobbler eerrorGobbler = null;
    private SJsnctrlSnStreamGobbler eoutputGobbler = null;
    final SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
    private SJsnctrlMonitoringWork monitoringWork = null;
    private boolean shutdownFlg = false;
    private boolean isReadyFlg = false;

    public SJsnctrlSnWebAppSurveillanceThread(List<StringBuilder> cmdList, long period, String dkcpath) {
        this.period = period;
        this.dkcpath = dkcpath;
        this.execcmd = cmdList.get(0);
        this.stopcmd = cmdList.get(1);
        this.pre_stopcmd = cmdList.get(2);
        this.monitoringWork = new SJsnctrlMonitoringWork(dkcpath);
    }

    @Override
    public void run() {
        String LOG_SUBTITLE = "run";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "run", "start.");
        this.runInit();
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "run", "loop started. (service surveillance)");
        while (!this.endflag) {
            this.runExitValue();
            if (this.endflag || this.runExecProc() && this.runSleep()) continue;
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "run", "loop end. (service surveillance)");
        if (this.shutdownFlg) {
            this.releasePortNo();
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "run", "Shutdown.");
            System.exit(0);
        }
    }

    public synchronized void end() {
        String LOG_SUBTITLE = "end";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "end", "start.");
        this.endflag = true;
        this.monitoringWork.stopMonitoring();
        if (this.execProc != null) {
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "end", "execProc.destroy()");
            this.execProc.destroy();
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "end", "end.");
    }

    public synchronized void runInit() {
        String LOG_SUBTITLE = "runInit";
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runInit", "start.");
        this.runtime = Runtime.getRuntime();
        new SJsnctrlSnWebAppFinishThread(this.stopcmd, this, this.dkcpath).start();
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runInit", "SN2 Service STOP COMMAND start.");
        boolean cmdResult = this.execLocalServiceStop(this.pre_stopcmd);
        if (cmdResult) {
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runInit", "SN2 Service STOP COMMAND is normal end.");
            this.waitSNService();
        } else {
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runInit", "SN2 Service STOP COMMAND is abnormal end.");
        }
        this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runInit", "end.");
    }

    public synchronized void runExitValue() {
        String LOG_SUBTITLE = "runExitValue";
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "runExitValue", "start.");
        if (this.endflag) {
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runExitValue", "Shift to stop processing");
            return;
        }
        try {
            if (this.execProc != null) {
                int endValue = this.execProc.exitValue();
                if (endValue != 0) {
                    this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runExitValue", "SN2 Service is error exit. code = " + endValue);
                } else {
                    this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runExitValue", "SN2 Service is normal exit.");
                }
                SJcTRLogUty.warn((String)"Web Application Server", (String)"TRSTNA000007", (String)"Warning : An unexpected error has occurred in a Storage Navigator.", (String)"jetty");
                this.execProc.getErrorStream().close();
                this.execProc.getInputStream().close();
                this.execProc.getOutputStream().close();
                this.execProc.destroy();
                this.execProc = null;
                this.isReadyFlg = false;
            }
        }
        catch (IllegalThreadStateException ile) {
            if (!this.isReadyFlg) {
                SJcTRLogUty.info((String)"Web Application Server", (String)"TRSTNA000002", (String)"Ready", (String)"jetty");
                this.isReadyFlg = true;
            }
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runExitValue", "SN2 Service is running.");
        }
        catch (IOException ioe) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "runExitValue", "IOException", (Throwable)ioe);
            this.isReadyFlg = false;
        }
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "runExitValue", "end.");
    }

    public synchronized boolean runExecProc() {
        String LOG_SUBTITLE = "runExecProc";
        boolean result = true;
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "runExecProc", "start.");
        try {
            if (this.execProc == null) {
                this.monitoringWork.stopMonitoring();
                this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runExecProc", "SN2 Service START COMMAND start.");
                this.execProc = this.runtime.exec(this.execcmd.toString());
                this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runExecProc", "SN2 Service START COMMAND started.");
                this.eerrorGobbler = new SJsnctrlSnStreamGobbler(this.execProc.getErrorStream(), System.err);
                this.eoutputGobbler = new SJsnctrlSnStreamGobbler(this.execProc.getInputStream(), System.out);
                this.eerrorGobbler.start();
                this.eoutputGobbler.start();
                this.monitoringWork.startMonitoring();
            }
        }
        catch (IOException e) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "runExecProc", "runtime.exec() java.io.IOException", (Throwable)e);
            result = false;
        }
        catch (Throwable th) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "runExecProc", "runtime.exec() Throwable", th);
            result = false;
        }
        if (!result) {
            SJcTRLogUty.error((String)"Web Application Server", (String)"TRSTNA000003", (String)"Failed : Failed to start a Storage Navigator.", (String)"jetty");
            this.shutdownFlg = true;
        }
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "runExecProc", "end.");
        return result;
    }

    public boolean runSleep() {
        String LOG_SUBTITLE = "runSleep";
        boolean result = true;
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "runSleep", "start.");
        if (this.endflag) {
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "runSleep", "Shift to stop processing");
            result = false;
        } else if (!SJcSleepUty.sleepSchedule(this.period)) {
            this.STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "runSleep", "The abnormal termination in sleep.");
        }
        this.STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "runSleep", "end.");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execLocalServiceStop(StringBuilder cmd) {
        String LOG_SUBTITLE = "execLocalServiceStop";
        boolean result = false;
        Process stopProc = null;
        SJsnctrlSnStreamGobbler errorGobbler = null;
        SJsnctrlSnStreamGobbler outputGobbler = null;
        try {
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "execLocalServiceStop", "start.");
            Runtime runtime = Runtime.getRuntime();
            stopProc = runtime.exec(cmd.toString());
            errorGobbler = new SJsnctrlSnStreamGobbler(stopProc.getErrorStream(), System.err);
            outputGobbler = new SJsnctrlSnStreamGobbler(stopProc.getInputStream(), System.out);
            errorGobbler.start();
            outputGobbler.start();
            int stopVal = stopProc.waitFor();
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "execLocalServiceStop", "exit code = " + stopVal);
            errorGobbler.join();
            outputGobbler.join();
            stopProc.getErrorStream().close();
            stopProc.getInputStream().close();
            stopProc.getOutputStream().close();
            stopProc.destroy();
            stopProc = null;
            if (stopVal == 0) {
                result = true;
            }
            boolean bl = result;
            return bl;
        }
        catch (IOException e) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "execLocalServiceStop", "runtime.exec() java.io.IOException", (Throwable)e);
            boolean bl = result;
            return bl;
        }
        catch (Throwable th) {
            this.STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "execLocalServiceStop", "runtime.exec() Throwable", th);
            boolean bl = result;
            return bl;
        }
        finally {
            this.STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "execLocalServiceStop", "end.");
        }
    }
}

