/*
 * Decompiled with CFR 0.152.
 */
package sanproject.snctrl.utility;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJsnctrlSnLockUtility {
    private static final String LOG_FUNCTION = "Jetty";
    private static final String LOG_TITLE = SJsnctrlSnLockUtility.class.getSimpleName();
    private static FileOutputStream fos = null;
    private static FileChannel fchan = null;
    private static FileLock flock = null;
    private static boolean releseflag = false;
    private static SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
    private static String lockKeyPath = null;

    public static synchronized boolean lock(String keyPath) throws FileNotFoundException, ClosedChannelException, IOException {
        String LOG_SUBTITLE = "lock";
        boolean result = true;
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "lock", "Start.");
        if (!releseflag) {
            try {
                lockKeyPath = keyPath;
                fos = new FileOutputStream(lockKeyPath);
                fchan = fos.getChannel();
                flock = fchan.tryLock();
            }
            catch (FileNotFoundException fe) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "lock", "FileNotFoundException.", (Throwable)fe);
                throw fe;
            }
            catch (ClosedChannelException ce) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "lock", "ClosedChannelException.", (Throwable)ce);
                throw ce;
            }
            catch (IOException ie) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "lock", "IOException.", (Throwable)ie);
                throw ie;
            }
            if (null == flock) {
                result = false;
            }
            releseflag = result;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "lock", "End.");
        return result;
    }

    public static synchronized void release() {
        String LOG_SUBTITLE = "release";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "release", "Start.");
        if (releseflag) {
            SJsnctrlSnLockUtility.releaseChannel();
            SJsnctrlSnLockUtility.closeChannel();
            SJsnctrlSnLockUtility.closeOutputStream();
            SJsnctrlSnLockUtility.fileDelete();
            releseflag = false;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "release", "End.");
    }

    private static void releaseChannel() {
        String LOG_SUBTITLE = "releaseChannel";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "releaseChannel", "Start.");
        try {
            if (flock != null) {
                flock.release();
                flock = null;
            }
        }
        catch (ClosedChannelException ce) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "releaseChannel", "ClosedChannelException.", (Throwable)ce);
        }
        catch (IOException ie) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "releaseChannel", "IOException.", (Throwable)ie);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "releaseChannel", "End.");
    }

    private static void closeChannel() {
        String LOG_SUBTITLE = "closeChannel";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "closeChannel", "Start.");
        try {
            if (fchan != null) {
                fchan.close();
                fchan = null;
            }
        }
        catch (IOException ie) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "closeChannel", "IOException.", (Throwable)ie);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "closeChannel", "End.");
    }

    private static void closeOutputStream() {
        String LOG_SUBTITLE = "closeOutputStream";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "closeOutputStream", "Start.");
        try {
            if (fos != null) {
                fos.close();
                fos = null;
            }
        }
        catch (IOException ie) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "closeOutputStream", "IOException.", (Throwable)ie);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "closeOutputStream", "End.");
    }

    private static void fileDelete() {
        String LOG_SUBTITLE = "fileDelete";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "fileDelete", "Start.");
        if (lockKeyPath == null || "".equals(lockKeyPath)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "fileDelete", "lockKeyPath (" + lockKeyPath.toString() + ") is null");
        } else {
            try {
                if (!new File(lockKeyPath).delete()) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "fileDelete", "lockKeyPath (" + lockKeyPath.toString() + ") delete is failed");
                }
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "fileDelete", "Exception.", (Throwable)ex);
            }
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "fileDelete", "End.");
    }
}

