/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.ldapcheckgroup;

import java.io.IOException;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalGroupBooleanInfo;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapBind;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseGetGroupLdapBind;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseCheckGroupLdapBind
extends SJbaseGetGroupLdapBind {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseCheckGroupLdapBind";
    private static final String GROUP_ATTR = "group";

    public SJbaseExternalGroupBooleanInfo execute(SJbaseLdapGroupConfiguration ldapGroupConf, String groupDN) throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        String method = "execute";
        logger.info(module, method, "", "start");
        Context ldapContext = null;
        Boolean group = false;
        try {
            logger.info(module, method, "", "search user is registerd," + ldapGroupConf.getSearchUserDN());
            ldapContext = this.bindAuthorization(ldapGroupConf, ldapGroupConf.getSearchUserDN(), ldapGroupConf.getSearchUserPassword());
            SearchControls scon = new SearchControls();
            scon.setSearchScope(2);
            String filterStr = "(cn=" + SJbaseLdapBind.escapeGroupStr(groupDN) + ")";
            NamingEnumeration<SearchResult> resultEnu = ldapContext.search(ldapGroupConf.getSearchDN(), filterStr, scon);
            while (resultEnu.hasMore()) {
                SearchResult resultItem = resultEnu.next();
                group = resultItem.getAttributes().get("objectclass").contains(GROUP_ATTR);
                logger.info(module, method, "binded the DN", resultItem.getNameInNamespace());
                if (!group.booleanValue()) continue;
                logger.info(module, method, "binded the Group DN", resultItem.getNameInNamespace());
                String groupCN = resultItem.getAttributes().get("cn").get().toString();
                logger.info(module, method, "case-sensitive check", "groupCN = " + groupCN + ", groupName = " + groupDN);
                if (groupCN.equals(groupDN)) {
                    logger.info(module, method, "case-sensitive check", "succeeded");
                    break;
                }
                logger.info(module, method, "case-sensitive check", "failed");
                group = false;
            }
            if (group.booleanValue()) {
                logger.info(module, method, "check the group", "succeeded");
            } else {
                logger.info(module, method, "check the group", "failed");
            }
        }
        catch (NameNotFoundException e) {
            logger.info(module, method, "try the bind operation", "failed", e);
            group = false;
        }
        catch (PartialResultException e) {
            logger.info(module, method, "try the bind operation", "failed", e);
            group = false;
        }
        catch (CommunicationException e) {
            logger.info(module, method, "try the bind operation", "failed", e);
            throw new SJbaseExCommunicationException();
        }
        catch (ServiceUnavailableException e) {
            logger.info(module, method, "try the bind operation", "failed", e);
            throw new SJbaseExCommunicationException();
        }
        catch (AuthenticationException e) {
            logger.info(module, method, "try the bind operation", "failed", e);
            throw new SJbaseExAuthenticationException();
        }
        catch (NamingException e) {
            logger.info(module, method, "try the bind operation", "failed", e);
            throw new SJbaseExCommunicationException();
        }
        catch (IOException e) {
            logger.info(module, method, "try the bind operation", "failed", e);
            throw new SJbaseExCommunicationException();
        }
        finally {
            if (ldapContext != null) {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {}
                ldapContext = null;
            }
        }
        logger.info(module, method, "check group", "succeeded");
        SJbaseExternalGroupBooleanInfo groupInfo = new SJbaseExternalGroupBooleanInfo();
        groupInfo.setGroupInfo(group);
        logger.info(module, method, "", "end");
        return groupInfo;
    }
}

