/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.ldapgetgroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import sanproject.sn2.base.authentication.module.external.common.SJbaseCustomSocketFactory;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationGroupException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExGetGroupException;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapBind;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseGetGroupLdapBind {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseGetGroupLdapBind";
    private static int Search_Level_MAX = 128;
    private static int GRoup_Get_Max_Cnt = 256;
    private static final String SERACH_LEVEL_NAME = "SN_NEST_GROUP_LEVEL_CNT";
    private static final String GROUP_CNT_NAME = "SN_GROUP_MAX_CNT";
    private static final int SEARCH_LEVEL_DEF = 128;
    private static final int GROUP_CNT_DEF = 256;
    SJbaseExternalAccountInfo account;
    private static final String[][] DN_ESCAPE_LIST = new String[][]{{",", "\\,"}, {"\\", "\\\\"}, {"#", "\\#"}, {"+", "\\+"}, {"<", "\\<"}, {">", "\\>"}, {";", "\\;"}, {"\"", "\\\""}, {"=", "\\="}};

    public SJbaseGetGroupLdapBind(SJbaseExternalAccountInfo account) {
        this.account = account;
    }

    public SJbaseGetGroupLdapBind() {
    }

    public SJbaseExternalAccountInfo execute(SJbaseLdapGroupConfiguration ldapGroupConf) throws SJbaseExGetGroupException, SJbaseExCommunicationGroupException {
        String method = "execute";
        logger.info(module, method, "", "start");
        Context ldapContext = null;
        Attribute group = null;
        Attribute pGroup = null;
        ArrayList<String> nest_group = null;
        ArrayList<String> search_group = null;
        int step_cnt = 1;
        try {
            try {
                logger.info(module, method, "", "search user is registerd," + ldapGroupConf.getSearchUserDN());
                ldapContext = this.bindAuthorization(ldapGroupConf, ldapGroupConf.getSearchUserDN(), ldapGroupConf.getSearchUserPassword());
            }
            catch (AuthenticationException e) {
                logger.error(module, method, "authenticate the search user", "authentication error", e);
                SJbaseExGetGroupException ex = new SJbaseExGetGroupException();
                ex.setErrCode(1);
                throw ex;
            }
            if (ldapGroupConf.getSearchDN() == "abbr") {
                String base = "";
                String filter = "(objectclass=*)";
                SearchControls controls = new SearchControls();
                controls.setSearchScope(0);
                NamingEnumeration<SearchResult> result = ldapContext.search(base, filter, controls);
                if (result.hasMore()) {
                    SearchResult resultItem = result.next();
                    String searchDN = resultItem.getAttributes().get("defaultNamingContext").get().toString();
                    ldapGroupConf.setSearchDN(searchDN);
                } else {
                    SJbaseExGetGroupException ex = new SJbaseExGetGroupException();
                    ex.setErrCode(2);
                    throw ex;
                }
            }
            SearchControls scon = null;
            NamingEnumeration<SearchResult> resultEnu = null;
            try {
                scon = new SearchControls();
                scon.setSearchScope(2);
                String userID = this.account.getUserId();
                userID = SJbaseLdapBind.escapeGroupStr(userID);
                String userAttr = ldapGroupConf.getUserAttr();
                userAttr = SJbaseLdapBind.escapeGroupStr(userAttr);
                String filterStr = "(" + userAttr + "=" + userID + ")";
                logger.info(module, method, "search the user entry", "filterStr:" + filterStr);
                resultEnu = ldapContext.search(ldapGroupConf.getSearchDN(), filterStr, scon);
            }
            catch (NamingException e) {
                logger.error(module, method, "search the user entry", e.toString(true));
                SJbaseExGetGroupException ex = new SJbaseExGetGroupException();
                ex.setErrCode(2);
                throw ex;
            }
            if (!resultEnu.hasMore()) {
                throw new SJbaseExGetGroupException();
            }
            SearchResult resultItem = resultEnu.next();
            group = resultItem.getAttributes().get("memberOf");
            logger.info(module, method, "get the group of login user", "succeeded:" + group);
            Attribute primaryGroupID = resultItem.getAttributes().get("primaryGroupID");
            String stringPrimaryGroupID = primaryGroupID.get().toString();
            logger.info(module, method, "primaryGroupID", stringPrimaryGroupID);
            int intPrimaryGroupID = Integer.parseInt(stringPrimaryGroupID);
            byte[] bytesPrimaryGroupID = new byte[4];
            for (int i = 0; i < 4; ++i) {
                bytesPrimaryGroupID[i] = (byte)(intPrimaryGroupID >>> (bytesPrimaryGroupID.length - 1 - i) * 8 & 0xFF);
            }
            logger.info(module, method, "byte array of primaryGroupID", bytesPrimaryGroupID[0] + "'" + bytesPrimaryGroupID[1] + "'" + bytesPrimaryGroupID[2] + "'" + bytesPrimaryGroupID[3]);
            byte[] bytesObjectSID = (byte[])resultItem.getAttributes().get("objectSID").get();
            logger.info(module, method, "users SID", resultItem.getAttributes().get("objectSID").get().toString());
            for (int k = 0; k < bytesPrimaryGroupID.length; ++k) {
                int len = bytesObjectSID.length;
                bytesObjectSID[len - bytesPrimaryGroupID.length + k] = bytesPrimaryGroupID[3 - k];
            }
            String primaryGroupSID = "";
            for (int i = 0; i < bytesObjectSID.length; ++i) {
                int j = bytesObjectSID[i] & 0xFF;
                logger.info(module, method, "before format SID item", String.valueOf(j));
                primaryGroupSID = j <= 15 ? primaryGroupSID + "\\0" + Integer.toHexString(j) : primaryGroupSID + "\\" + Integer.toHexString(j);
            }
            String filterPGrp = "(objectSID=" + primaryGroupSID + ")";
            logger.info(module, method, "search filter", filterPGrp);
            NamingEnumeration<SearchResult> resultEnu2 = ldapContext.search(ldapGroupConf.getSearchDN(), filterPGrp, scon);
            if (resultEnu2.hasMore()) {
                SearchResult resultItem2 = resultEnu2.next();
                pGroup = resultItem2.getAttributes().get("distinguishedName");
            }
            nest_group = new ArrayList<String>();
            search_group = new ArrayList<String>();
            Search_Level_MAX = SJcEnvUty.getProperty2int(SERACH_LEVEL_NAME, 128);
            GRoup_Get_Max_Cnt = SJcEnvUty.getProperty2int(GROUP_CNT_NAME, 256);
            if (pGroup != null || group != null) {
                int i;
                String GName = "";
                if (pGroup != null) {
                    try {
                        GName = (String)pGroup.get();
                        logger.info(module, method, "get the primary group name", "GName:" + GName);
                        nest_group.add(GName);
                        search_group.add(GName);
                        if (GRoup_Get_Max_Cnt != 0 && nest_group.size() >= GRoup_Get_Max_Cnt) {
                            logger.info(module, method, "get the nestGroup of MaxCnt", "Cnt " + nest_group.size() + " " + GRoup_Get_Max_Cnt);
                            search_group.clear();
                            group.clear();
                        }
                    }
                    catch (NamingException e1) {
                        logger.info(module, method, "login user has no primay group info", "");
                    }
                }
                for (i = 0; i < group.size(); ++i) {
                    try {
                        GName = (String)group.get(i);
                        logger.info(module, method, "get the group name", "[" + i + "]GName:" + GName);
                        if (!nest_group.contains(GName)) {
                            nest_group.add(GName);
                            search_group.add(GName);
                        }
                        if (GRoup_Get_Max_Cnt == 0 || nest_group.size() < GRoup_Get_Max_Cnt) continue;
                        logger.info(module, method, "get the nestGroup of MaxCnt", "Cnt " + nest_group.size() + " " + GRoup_Get_Max_Cnt);
                        search_group.clear();
                        break;
                    }
                    catch (NamingException e) {
                        logger.info(module, method, "login user has no group info", "");
                    }
                }
                if (!(search_group.size() == 0 || Search_Level_MAX != 0 && step_cnt >= Search_Level_MAX || GRoup_Get_Max_Cnt != 0 && nest_group.size() >= GRoup_Get_Max_Cnt)) {
                    this.GetNestGrpName(search_group, nest_group, (LdapContext)ldapContext, ldapGroupConf, step_cnt);
                }
                for (i = 0; i < nest_group.size(); ++i) {
                    String groupDN = (String)nest_group.get(i);
                    String groupRDN = SJbaseGetGroupLdapBind.getFirstRDNFromDN(groupDN);
                    String groupName = SJbaseGetGroupLdapBind.unescapeDN(groupRDN);
                    logger.info(module, method, "setUserGroup", "[" + i + "]groupDN:" + groupDN + ", groupRDN:" + groupRDN + ", groupName:" + groupName);
                    this.account.setUserGroup(groupName);
                }
            }
            logger.info(module, method, "get the Primarygroup of login user", "succeeded:" + pGroup);
        }
        catch (SJbaseExAuthenticationException e) {
            throw e;
        }
        catch (SJbaseExCommunicationException e) {
            throw e;
        }
        catch (AuthenticationException e) {
            logger.info(module, method, "try the bind operation", "failed", e);
            throw new SJbaseExGetGroupException();
        }
        catch (NamingException e) {
            Throwable ex = e.getRootCause();
            if (ex instanceof SSLHandshakeException) {
                logger.error(module, method, "try the get ticket operation", "failed", ex);
                SJbaseExGetGroupException et = new SJbaseExGetGroupException();
                et.setErrCode(4);
                throw et;
            }
            logger.error(module, method, "try the bind operation", "failed 4", e);
            throw new SJbaseExCommunicationGroupException();
        }
        catch (Exception e) {
            logger.info(module, method, "try the bind operation", "failed", e);
            SJbaseExGetGroupException et = new SJbaseExGetGroupException();
            et.setErrCode(9999);
            throw et;
        }
        finally {
            if (ldapContext != null) {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {}
                ldapContext = null;
            }
        }
        logger.info(module, method, "", "end");
        return this.account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapContext bindAuthorization(SJbaseLdapGroupConfiguration ldapGroupConf, String userDN, String userPwd) throws IOException, NamingException {
        String method = "bindAuthentication";
        logger.info(module, method, "", "start");
        Context ldapContext = null;
        boolean authSuccess = false;
        if (userPwd == null || userPwd.length() == 0) {
            logger.info(module, method, "check the password", "invalid");
            throw new AuthenticationException();
        }
        if (userDN == null || userDN.length() == 0) {
            logger.info(module, method, "check the DN", "invalid");
            throw new AuthenticationException();
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", ldapGroupConf.getUrl());
            env.put("java.naming.ldap.attributes.binary", "objectSID");
            int timeout = ldapGroupConf.getTimeout();
            String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
            String systemPath = SJcFileUty.concatFolderPath(dataPath, "base\\setting\\extAuth\\");
            String keystoreFileName = SJcFileUty.concatFolderPath(systemPath, "ExternalAuth.keystore");
            logger.info(module, method, "keystoreFileName=", keystoreFileName);
            System.setProperty("KEY_SNBASE_KEYSTORE", keystoreFileName);
            if (timeout != 0) {
                logger.info(module, method, "set  timeout", Integer.toString(timeout));
                env.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(timeout * 1000));
            }
            if (ldapGroupConf.getProtocol().compareToIgnoreCase("ldaps") == 0) {
                logger.info(module, method, "check ldap protocol", "ldaps");
                env.put("java.naming.security.protocol", "ssl");
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", userDN);
                env.put("java.naming.security.credentials", userPwd);
                env.put("java.naming.ldap.factory.socket", "sanproject.sn2.base.authentication.module.external.common.SJbaseCustomSocketFactory");
                ldapContext = new InitialLdapContext(env, null);
            } else {
                ldapContext = new InitialLdapContext(env, null);
                if (ldapGroupConf.getProtocol().equalsIgnoreCase("starttls")) {
                    logger.info(module, method, "check ldap protocol", "starttls");
                    StartTlsResponse tls = (StartTlsResponse)ldapContext.extendedOperation(new StartTlsRequest());
                    SSLSocketFactory sslSocketFactory = SJbaseCustomSocketFactory.getDefault();
                    logger.info(module, method, "try the TLS negotiation", "");
                    tls.negotiate(sslSocketFactory);
                }
                ldapContext.addToEnvironment("java.naming.security.authentication", "simple");
                ldapContext.addToEnvironment("java.naming.security.principal", userDN);
                ldapContext.addToEnvironment("java.naming.security.credentials", userPwd);
                logger.info(module, method, "try the reconnection", "");
                ldapContext.reconnect(null);
            }
            authSuccess = true;
        }
        finally {
            if (!authSuccess && ldapContext != null) {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {}
                ldapContext = null;
            }
        }
        logger.info(module, method, "", "end");
        return ldapContext;
    }

    private void GetNestGrpName(ArrayList<String> SearchGroup, ArrayList<String> NestGroup, LdapContext ldapContext, SJbaseLdapGroupConfiguration ldapGroupConf, int step_cnt) throws IOException, NamingException {
        String method = "GetNestGrpName";
        SearchControls scon = null;
        NamingEnumeration<SearchResult> resultEnu = null;
        Attribute group = null;
        ArrayList<String> SearchGroupEx = null;
        SearchGroupEx = new ArrayList<String>();
        try {
            for (int cnt = 0; cnt < SearchGroup.size(); ++cnt) {
                SearchResult resultItem;
                try {
                    String GName = SearchGroup.get(cnt);
                    GName = SJbaseLdapBind.escapeGroupStr(GName);
                    scon = new SearchControls();
                    scon.setSearchScope(2);
                    String filterStr = "(distinguishedName=" + GName + ")";
                    logger.info(module, method, "search the group entry", "[" + cnt + "]filterStr:" + filterStr);
                    resultEnu = ldapContext.search(ldapGroupConf.getSearchDN(), filterStr, scon);
                }
                catch (NamingException e) {
                    logger.error(module, method, "search the group entry", e.toString(true));
                    SJbaseExGetGroupException ex = new SJbaseExGetGroupException();
                    ex.setErrCode(2);
                    throw ex;
                }
                if (!resultEnu.hasMore() || (group = (resultItem = resultEnu.next()).getAttributes().get("memberOf")) == null) continue;
                for (int i = 0; i < group.size(); ++i) {
                    String nestGrp = "";
                    try {
                        nestGrp = (String)group.get(i);
                        logger.info(module, method, "get the nest group name", "[" + i + "]nestGrp:" + nestGrp);
                        if (!NestGroup.contains(nestGrp)) {
                            NestGroup.add(nestGrp);
                            SearchGroupEx.add(nestGrp);
                        }
                        if (GRoup_Get_Max_Cnt == 0 || NestGroup.size() < GRoup_Get_Max_Cnt) continue;
                        logger.info(module, method, "get the nestGroup of MaxCnt", "cnt: " + NestGroup.size());
                        return;
                    }
                    catch (NamingException e) {
                        logger.info(module, method, "login user has no group info", "");
                    }
                }
            }
        }
        catch (SJbaseExAuthenticationException e) {
            throw e;
        }
        catch (SJbaseExCommunicationException e) {
            throw e;
        }
        catch (NamingException e) {
            Throwable ex = e.getRootCause();
            logger.error(module, method, "try the bind operation", "failed 5", ex);
            throw new SJbaseExCommunicationGroupException();
        }
        catch (Exception e) {
            logger.info(module, method, "try the bind operation", "failed 6", e);
            SJbaseExGetGroupException et = new SJbaseExGetGroupException();
            et.setErrCode(9999);
            throw et;
        }
        if (Search_Level_MAX != 0 && ++step_cnt >= Search_Level_MAX) {
            logger.info(module, method, "get the nestGroup of MaxLevelCnt", "Level Cnt : " + step_cnt);
            return;
        }
        if (SearchGroupEx.size() != 0) {
            this.GetNestGrpName(SearchGroupEx, NestGroup, ldapContext, ldapGroupConf, step_cnt);
        }
    }

    public static String getFirstRDNFromDN(String DN) {
        String result = null;
        if (DN != null) {
            int s = DN.indexOf("=");
            int e = DN.indexOf(",");
            while (DN.startsWith("\\", e - 1)) {
                e = DN.indexOf(",", e + 1);
            }
            result = DN.substring(s + 1, e);
        }
        return result;
    }

    public static String unescapeDN(String DN) {
        String result = null;
        if (DN != null) {
            result = DN;
            for (int i = 0; i < DN_ESCAPE_LIST.length; ++i) {
                result = result.replace(DN_ESCAPE_LIST[i][1], DN_ESCAPE_LIST[i][0]);
            }
            if (result.startsWith("\\ ")) {
                result = result.substring(1);
            }
            if (result.endsWith("\\ ")) {
                result = result.substring(0, result.length() - 2) + " ";
            }
        }
        return result;
    }
}

