/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.account;

import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.account.SJcAccountFileManage;
import sanproject.sn2.com.utility.account.SJcRmiAccess;
import sanproject.sn2.com.utility.account.SJcUserInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.com.utility.account.exception.SJcExistDataException;
import sanproject.sn2.com.utility.account.exception.SJcFailDataException;
import sanproject.sn2.com.utility.account.exception.SJcInvalidDataException;
import sanproject.sn2.com.utility.account.exception.SJcMaxCreateException;
import sanproject.sn2.com.utility.account.exception.SJcNoMatchDataException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundGroupException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundUserException;
import sanproject.sn2.com.utility.account.exception.SJcParamErrorException;
import sanproject.sn2.com.utility.account.exception.SJcTypeErrorException;

public class SJcAccountFileUserInfo
extends SJcAccountFileManage {
    private int m_iMaxCount = SJcEnvUty.getProperty2int("SN_ACCOUNT_MAX_USER", 512);

    public SJcAccountFileUserInfo() {
        super("UserInfo");
    }

    public static void createUser(String szUserName, int iAuthPtn, String szPassword, String[] szGrpName, int iEnable, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCcreateUser", lRscLockID);
        SanObject reqUser = request.newObj("User");
        reqUser.putString("Name", szUserName);
        reqUser.putInt("Authentication", iAuthPtn);
        if (szPassword != null) {
            reqUser.putString("Password", szPassword);
        }
        SanList userGroups = reqUser.newList("UserGroups");
        for (int i = 0; i < szGrpName.length; ++i) {
            SanObject userGroup = userGroups.addObj();
            userGroup.putString("Name", szGrpName[i]);
        }
        reqUser.putBoolean("AccountStatus", iEnable != 0);
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207005: {
                    throw new SJcInvalidDataException(207005);
                }
                case 105212: {
                    throw new SJcParamErrorException();
                }
                case 106200: {
                    throw new SJcParamErrorException();
                }
                case 105219: {
                    throw new SJcParamErrorException();
                }
                case 106061: {
                    throw new SJcParamErrorException();
                }
                case 106043: {
                    throw new SJcMaxCreateException();
                }
                case 106044: {
                    throw new SJcExistDataException();
                }
                case 205002: {
                    throw new SJcNotFoundGroupException();
                }
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static void setAuthPattern(String szUserName, int iAuthPtn, String szPassword, long lRscLockID) throws Exception {
        SanResponse response;
        SanObject errorInfo;
        int errorCode;
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCupdateUserAuthentication", lRscLockID);
        SanObject reqUser = request.newObj("User");
        reqUser.putString("Name", szUserName);
        reqUser.putInt("Authentication", iAuthPtn);
        if (szPassword != null) {
            reqUser.putString("Password", szPassword);
        }
        if ((errorCode = (errorInfo = (response = rmiAccess.invoke()).getObj("ErrorInfo")).getInt("ErrorCode")) != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207005: {
                    throw new SJcInvalidDataException(207005);
                }
                case 105212: {
                    throw new SJcParamErrorException();
                }
                case 106200: {
                    throw new SJcParamErrorException();
                }
                case 105219: {
                    throw new SJcParamErrorException();
                }
                case 207002: {
                    throw new SJcTypeErrorException();
                }
                case 205003: {
                    throw new SJcNotFoundUserException();
                }
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static void addUserGroup(String[] szUserName, String szGrpName, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCaddUsersToUserGroup", lRscLockID);
        SanObject reqUserGroup = request.newObj("UserGroup");
        reqUserGroup.putString("Name", szGrpName);
        SanList reqUsers = request.newList("Users");
        for (int i = 0; i < szUserName.length; ++i) {
            SanObject reqUser = reqUsers.addObj();
            reqUser.putString("Name", szUserName[i]);
        }
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode == 7000) {
            ArrayList<String> alList = new ArrayList<String>();
            SanList resUsers = response.getList("Users");
            for (int i = 0; i < resUsers.size(); ++i) {
                SanObject resUser = resUsers.getObj(i);
                SanObject userErrorInfo = resUser.getObj("ErrorInfo");
                int userErrorCode = userErrorInfo.getInt("ErrorCode");
                if (userErrorCode == 0) continue;
                alList.add(szUserName[i]);
            }
            String[] szFail = alList.toArray(new String[0]);
            throw new SJcFailDataException(szFail);
        }
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 106061: {
                    throw new SJcParamErrorException();
                }
                case 205002: {
                    throw new SJcNotFoundGroupException();
                }
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static void removeUserGroup(String[] szUserName, String szGrpName, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCremoveUsersFromUserGroup", lRscLockID);
        SanObject reqUserGroup = request.newObj("UserGroup");
        reqUserGroup.putString("Name", szGrpName);
        SanList reqUsers = request.newList("Users");
        for (int i = 0; i < szUserName.length; ++i) {
            SanObject reqUser = reqUsers.addObj();
            reqUser.putString("Name", szUserName[i]);
        }
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode == 7000) {
            ArrayList<String> alList = new ArrayList<String>();
            SanList resUsers = response.getList("Users");
            for (int i = 0; i < resUsers.size(); ++i) {
                SanObject resUser = resUsers.getObj(i);
                SanObject userErrorInfo = resUser.getObj("ErrorInfo");
                int userErrorCode = userErrorInfo.getInt("ErrorCode");
                if (userErrorCode == 0) continue;
                alList.add(szUserName[i]);
            }
            String[] szFail = alList.toArray(new String[0]);
            throw new SJcFailDataException(szFail);
        }
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 106061: {
                    throw new SJcParamErrorException();
                }
                case 205002: {
                    throw new SJcNotFoundGroupException();
                }
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static void setPassword(String szUserName, String szNowPassword, String szNewPassword, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCupdatePassword", lRscLockID);
        SanObject reqUser = request.newObj("User");
        reqUser.putString("Name", szUserName);
        if (szNowPassword != null) {
            reqUser.putString("Password", szNowPassword);
        }
        reqUser.putString("NewPassword", szNewPassword);
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207005: {
                    throw new SJcInvalidDataException(207005);
                }
                case 105212: {
                    throw new SJcParamErrorException();
                }
                case 105219: {
                    throw new SJcParamErrorException();
                }
                case 205003: {
                    throw new SJcNotFoundUserException();
                }
                case 106045: {
                    throw new SJcTypeErrorException();
                }
                case 207006: {
                    throw new SJcNoMatchDataException();
                }
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static void setEnableDisable(String[] szUserName, boolean bFlg, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        String functionId = bFlg ? "ACCenableUsers" : "ACCdisableUsers";
        SanRequest request = rmiAccess.getSanRequest(false, functionId, lRscLockID);
        SanList reqUsers = request.newList("Users");
        for (int i = 0; i < szUserName.length; ++i) {
            SanObject reqUser = reqUsers.addObj();
            reqUser.putString("Name", szUserName[i]);
        }
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode == 7000) {
            ArrayList<String> alList = new ArrayList<String>();
            SanList resUsers = response.getList("Users");
            for (int i = 0; i < resUsers.size(); ++i) {
                SanObject resUser = resUsers.getObj(i);
                SanObject userErrorInfo = resUser.getObj("ErrorInfo");
                int userErrorCode = userErrorInfo.getInt("ErrorCode");
                if (userErrorCode == 0) continue;
                alList.add(szUserName[i]);
            }
            String[] szFail = alList.toArray(new String[0]);
            throw new SJcFailDataException(szFail);
        }
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static void deleteUser(String[] szUserName, long lRscLockID) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(false, "ACCdeleteUsers", lRscLockID);
        SanList reqUsers = request.newList("Users");
        for (int i = 0; i < szUserName.length; ++i) {
            SanObject reqUser = reqUsers.addObj();
            reqUser.putString("Name", szUserName[i]);
        }
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode == 7000) {
            ArrayList<String> alList = new ArrayList<String>();
            SanList resUsers = response.getList("Users");
            for (int i = 0; i < resUsers.size(); ++i) {
                SanObject resUser = resUsers.getObj(i);
                SanObject userErrorInfo = resUser.getObj("ErrorInfo");
                int userErrorCode = userErrorInfo.getInt("ErrorCode");
                if (userErrorCode == 0) continue;
                alList.add(szUserName[i]);
            }
            String[] szFail = alList.toArray(new String[0]);
            throw new SJcFailDataException(szFail);
        }
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
    }

    public static String[] getAllUser() throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(true, "ACCreadAllUserNames", 0L);
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
        ArrayList<String> alList = new ArrayList<String>();
        SanList resUsers = response.getList("Users");
        for (int i = 0; i < resUsers.size(); ++i) {
            SanObject resUser = resUsers.getObj(i);
            String name = resUser.getString("Name");
            alList.add(name);
        }
        return alList.toArray(new String[0]);
    }

    public static SJcUserInfoContainer[] getUserInfo(String[] szUserName) throws Exception {
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(true, "ACCreadUserInfoEx", 0L);
        SanList reqUsers = request.newList("Users");
        for (int i = 0; i < szUserName.length; ++i) {
            SanObject reqUser = reqUsers.addObj();
            reqUser.putString("Name", szUserName[i]);
        }
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0 && errorCode != 7000) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 207007: {
                    throw new SJcException();
                }
                case 207008: {
                    throw new SJcException();
                }
                case 208001: {
                    throw new SJcCommunicationErrorException();
                }
            }
            throw new SJcException();
        }
        SanList resUsers = response.getList("Users");
        SJcUserInfoContainer[] clsData = new SJcUserInfoContainer[resUsers.size()];
        for (int user_cnt = 0; user_cnt < resUsers.size(); ++user_cnt) {
            SanObject resUser = resUsers.getObj(user_cnt);
            SanObject userErrorInfo = resUser.getObj("ErrorInfo");
            int userErrorCode = userErrorInfo.getInt("ErrorCode");
            if (userErrorCode != 0) {
                clsData[user_cnt] = null;
                continue;
            }
            clsData[user_cnt] = new SJcUserInfoContainer();
            String name = resUser.getString("Name");
            clsData[user_cnt].setUserName(new String(name));
            int auth = resUser.getInt("Authentication");
            clsData[user_cnt].setAuthPtn(auth);
            clsData[user_cnt].setPassword("");
            SanList userGroups = resUser.getList("UserGroups");
            String[] userGroupNames = new String[userGroups.size()];
            for (int group_cnt = 0; group_cnt < userGroups.size(); ++group_cnt) {
                SanObject userGroup = userGroups.getObj(group_cnt);
                String userGroupName = userGroup.getString("Name");
                userGroupNames[group_cnt] = new String(userGroupName);
            }
            clsData[user_cnt].setGrpName(userGroupNames);
            boolean accountStatus = resUser.getBoolean("AccountStatus");
            clsData[user_cnt].setEnable(accountStatus ? "1" : "0");
            boolean builtin = resUser.getBoolean("Builtin");
            clsData[user_cnt].setType(builtin ? "0" : "1");
        }
        return clsData;
    }

    public static boolean checkPassword(String szUserName, String szPassword) throws Exception {
        boolean bRet = true;
        SJcRmiAccess rmiAccess = new SJcRmiAccess();
        SanRequest request = rmiAccess.getSanRequest(true, "NativeSANauthenticateStorageUser", 0L);
        request.putString("UserName", szUserName);
        request.putString("Password", szPassword);
        SanResponse response = rmiAccess.invoke();
        SanObject errorInfo = response.getObj("ErrorInfo");
        int errorCode = errorInfo.getInt("ErrorCode");
        if (errorCode != 0) {
            int[] messageId = errorInfo.getIntArray("MessageId");
            switch (messageId[1]) {
                case 107095: {
                    bRet = false;
                    break;
                }
                case 107000: {
                    throw new SJcCommunicationErrorException();
                }
                default: {
                    throw new SJcException();
                }
            }
        }
        return bRet;
    }
}

