/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.guidance;

import java.text.MessageFormat;
import java.util.HashMap;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceProcessInterface;

public class SJcGuidanceProcess
implements SJcGuidanceProcessInterface {
    private HashMap guidanceList = new HashMap();
    private SJcLoggerInterface stdLogger = SJcLogUty.getLogger();

    @Override
    public synchronized HashMap getGuidanceList(String venderID, String langType) {
        HashMap listMap;
        this.stdLogger.trace("Guidance", "SJcGuidanceProcess", "getGuidanceList", "start");
        String guidanceKey = venderID + "/" + langType;
        if (this.guidanceList.containsKey(guidanceKey)) {
            listMap = (HashMap)this.guidanceList.get(guidanceKey);
            this.stdLogger.info("Guidance", "SJcGuidanceProcess", "getGuidanceList", "guidanceList.get");
        } else {
            try {
                listMap = (HashMap)SJcFileUty.loadSerialize(SJcConst.GUIDLIST_DIRECTORY, this.getFileName(venderID, langType));
                this.guidanceList.put(guidanceKey, listMap);
            }
            catch (Exception e) {
                this.stdLogger.error("Guidance", "SJcGuidanceProcess", "getGuidanceList", "catchException");
                listMap = new HashMap();
            }
            this.stdLogger.trace("Guidance", "SJcGuidanceProcess", "getGuidanceList", "end");
        }
        return listMap;
    }

    private String getFileName(String venderID, String langType) {
        this.stdLogger.trace("Guidance", "SJcGuidanceProcess", "getFileName", "start");
        MessageFormat format = new MessageFormat("guidlist_{0}_{1}.bin");
        Object[] parameters = new Object[]{venderID, langType};
        String fileName = format.format(parameters);
        this.stdLogger.trace("Guidance", "SJcGuidanceProcess", "getFileName", "end");
        return fileName;
    }
}

