/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller;

import sanproject.sn2.base.system.inf.SJbaseSystemInterface;
import sanproject.sn2.base.system.inf.SJbaseSystemStatusInterface;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrQueueController;
import sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys.SJctrRegularBackupKeyScheduleManager;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.modelrc.SJmoRscMgr;
import sanproject.sn2.sn2com.utility.SJsncVersionCheckUty;

public class SJctrControllerManager
implements SJbaseSystemInterface,
SJbaseSystemStatusInterface {
    private static final int INIT_LOGICAL_ERROR = 107019;
    private int mPhase = -1;
    private boolean mFatal = false;
    private boolean mRetry = false;
    private SJcMessage mError = null;
    private final String className = this.getClass().getSimpleName();
    public static final int OTHER_MGR_WAIT_TIME = 1000;
    public static final String TYPE_RAID = "80";
    public static final String TYPE_HM = "83";
    private static String mSystemVersion = "";
    private static boolean mIsHM = false;
    private static boolean mIsRAID = true;

    @Override
    public void initialize() {
        switch (this.mPhase) {
            case -1: {
                this.mPhase = 1;
                break;
            }
            case 1: {
                SJctrLogUty.warn(this.className, "initialize", "fail : status Starting");
                return;
            }
            default: {
                SJctrLogUty.warn(this.className, "initialize", "fail : invalid status=" + this.mPhase);
                return;
            }
        }
        try {
            this.waitOtherMgrReady(SJmoModelMgr.class);
            this.waitOtherMgrReady(SJdsSupplierMgr.class);
            this.waitOtherMgrReady(SJmoRscMgr.class);
            mIsHM = SJctrControllerManager.chkSystemType(TYPE_HM);
            mIsRAID = SJctrControllerManager.chkSystemType(TYPE_RAID);
            SJctrQueueController queueCtr = SJctrQueueController.getInstance();
            queueCtr.initialize();
            try {
                SJctrRegularBackupKeyScheduleManager regBkMgr = SJctrRegularBackupKeyScheduleManager.getInstance();
                regBkMgr.start();
            }
            catch (Exception e) {
                SJctrLogUty.warn(this.className, "initialize", "SJctrRegularBackupKeyScheduleManager start fail", e);
            }
            this.mPhase = 2;
        }
        catch (Exception e) {
            SJctrLogUty.warn(this.className, "initialize", "fail", e);
            this.mFatal = true;
            String strFuncID = Integer.toString(201);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(107019);
            this.mError = new SJcMessage(strFuncID, strModuleID, strMsgID);
            return;
        }
        SJctrLogUty.trace(this.className, "initialize", "Max Memory=" + Runtime.getRuntime().maxMemory());
    }

    @Override
    public void abort_initialize() {
        SJctrLogUty.info(this.className, "abort_initialize", "status:" + this.mPhase);
        this.finish();
    }

    @Override
    public void finish() {
        switch (this.mPhase) {
            case 1: 
            case 2: {
                this.mPhase = 3;
                break;
            }
            default: {
                SJctrLogUty.warn(this.className, "finish", "fail : invalid status=" + this.mPhase);
                return;
            }
        }
        try {
            SJctrRegularBackupKeyScheduleManager regBkMgr = SJctrRegularBackupKeyScheduleManager.getInstance();
            regBkMgr.stopRunning();
        }
        catch (Exception e) {
            SJctrLogUty.warn(this.className, "finish", "RegularBackupKeyScheduleManager stop fail ", e);
        }
        try {
            SJctrQueueController queueCtr = SJctrQueueController.getInstance();
            queueCtr.finish();
        }
        catch (Exception e) {
            SJctrLogUty.warn(this.className, "finish", "QueueController finish fail ", e);
        }
        this.mPhase = 4;
    }

    @Override
    public void abort_finish() {
        SJctrLogUty.info(this.className, "abort_finish", "status:" + this.mPhase);
        this.finish();
    }

    @Override
    public SJbaseSystemStatusInterface getStatus() {
        return this;
    }

    @Override
    public boolean destroy() {
        return true;
    }

    @Override
    public int getPhase() {
        return this.mPhase;
    }

    @Override
    public boolean isFatal() {
        return this.mFatal;
    }

    @Override
    public boolean isReqRetry() {
        return this.mRetry;
    }

    @Override
    public SJcMessage getErrorCode() {
        return this.mError;
    }

    private synchronized void waitOtherMgrReady(Class manager) {
        boolean flgOthrMgrReady = false;
        SJbaseSystemInterface modelSystem = (SJbaseSystemInterface)SJcSingletonManagerUty.getInstance(manager);
        SJbaseSystemStatusInterface modelStatus = modelSystem.getStatus();
        int modelPhase = modelStatus.getPhase();
        SJctrLogUty.info(SJctrComUtility.class.getSimpleName(), "waitOtherMgrReady", manager.getSimpleName() + ":Status : " + modelPhase);
        while (!flgOthrMgrReady) {
            if (this.getPhase() != 1) {
                String msg = "CtrlMgr was not start and became while ModelMgr was being waited.";
                SJctrLogUty.info(SJctrComUtility.class.getSimpleName(), "waitOtherMgrReady", msg);
                throw new RuntimeException(msg);
            }
            modelStatus = modelSystem.getStatus();
            modelPhase = modelStatus.getPhase();
            flgOthrMgrReady = modelPhase == 2;
            if (flgOthrMgrReady) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                SJctrLogUty.info(SJctrComUtility.class.getSimpleName(), "Wait interrupted.", Integer.toString(40000));
            }
        }
        SJctrLogUty.info(SJctrComUtility.class.getSimpleName(), "waitOtherMgrEnd", manager.getSimpleName() + ":Status : " + modelPhase);
    }

    public static String getSystemVersion() {
        if (mSystemVersion.equals("")) {
            String ver;
            mSystemVersion = ver = SJsncVersionCheckUty.getVersion();
        }
        return mSystemVersion;
    }

    public static boolean isHM() {
        return mIsHM;
    }

    public static boolean isRAID() {
        return mIsRAID;
    }

    public static boolean chkSystemType(String type) {
        String ver = SJctrControllerManager.getSystemVersion();
        String key = "";
        if (ver.equals(TYPE_RAID)) {
            key = TYPE_RAID;
        } else if (ver.equals(TYPE_HM)) {
            key = TYPE_HM;
        } else {
            return false;
        }
        return type.equals(key);
    }
}

