/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import sanproject.serverux.dataimpl.EXDExternalDevice;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDExternalVolumeEx;
import sanproject.serverux.dataimpl.EXDPathGroup;
import sanproject.serverux.dataimpl.EXDSubsystem;
import sanproject.serverux.dataimpl.EXDSubsystemEx;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.data.SJmoMacroMgr;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdProfileInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfoOnPathGroup;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPathGroupInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPhysicalPathInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdProfileInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdVolumeInfoMgr;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrExtUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    public static final String KEY_EXTGRP_MAX_DKC = "EXTGRP_MAX_DKC";
    public static final byte PATHMODE_MULTI = 0;
    public static final byte PATHMODE_SINGLE = 1;
    public static final byte PATHMODE_ACTIVE_STANDBY = 2;
    public static final byte PATHMODE_ACTIVE_STANDBY_LU = 3;
    public static final byte PATHMODE_ALUA = 5;
    public static final short LBM_NORMAL_ROUNDROBIN = 0;
    public static final short LBM_EXTENDED_ROUNDROBIN = 1;
    public static final short LBM_DISABLE = 2;
    public static final String EXTVOL_ATTR_SEPARATOR = ", ";
    public static final int QDEPTH_MIN = 2;
    public static final int QDEPTH_MAX = 128;
    public static final int IOTOV_MIN = 5;
    public static final int IOTOV_MAX = 240;
    public static final int PATHBLKWATCH_MIN = 5;
    public static final int PATHBLKWATCH_MAX = 180;
    public static final int UVM_FB4_MIN = 1;
    public static final int UVM_FB4_MAX = 16384;
    public static final int UVM_PG_MIN = 1;
    public static final int UVM_PG_MAX = 4096;
    public static final int PATHGROUP_EXTERNALPATH_MAX = 8;
    public static final int PORT_PHYSICALPATH_MAX = 2048;
    public static int SUBSYSTEM_MAPVOL_MAX = 63232;
    public static final int PATHGROUP_VOLUME_MAX = 4096;
    public static final int UVM_LDEV_MAX_PG = 2048;
    public static final String NO_VALUEDISPLAY = "-";
    public static final int ST_INVALID = -1;
    public static final int PATHGROUPID_MIN = 0;
    public static int PATHGROUPID_MAX = 63231;
    public static final short DRIVE_TYPE_FC = 0;
    public static final short DRIVE_TYPE_SATA = 1;
    public static final short DRIVE_TYPE_BD = 2;
    public static final short DRIVE_TYPE_SSD = 3;
    public static final String INHERITDRIVE_DISP = "+";
    public static final byte ST_ACTIVE_OPT = -64;
    public static final byte ST_ACTIVE_NONOPT = -128;
    public static final byte ST_ADDING_EXTVOL = 0;
    public static final int GENERIC_PROFILE = 254;
    public static final int INVALID_VALUE = -1;
    public static final byte BIT_ALUA_SUPPORT = 4;
    public static final String GUID_DEPEND_SEL_EXT_VOL = "DEPEND_SEL_EXT_VOL";
    public static final String GUID_ACTIVE_OPT = "ACTIVE_OPT";
    public static final String GUID_ACTIVE_NONOPT = "ACTIVE_NONOPT";
    public static final String GUID_NORMAL = "NORMAL";
    public static final String GUID_HUVM_NOT_RESERV = "NOT_RESERVED";
    public static final String GUID_HUVM_HA_RESERV = "HA_RESERVED";
    public static final int CACHE_MODE_ENABLE = 0;
    public static final int CACHE_MODE_DISABLE = 1;
    public static final int CACHE_MODE_WRITE_SYNC = 2;
    public static final int CACHE_MODE_THROUGH = 3;
    public static final int CACHE_MODE_CHECK = 4;
    public static final int CACHE_MODE_PEND = 5;
    public static final int CACHE_STATUS_NONE = 0;
    public static final int CACHE_STATUS_ROUTINE = 1;
    public static final int CACHE_STATUS_CHANGE = 2;
    public static final int CACHE_STATUS_FAILURE = 3;
    public static final String CACHESTATUS_FORMAT = "(%s)";
    public static final String GUIDE_MIG_VOL = "MANAGE_MIGRATION";
    public static final String GUIDE_WRITE_SYNC = "WRITE_SYNC";
    public static final String GUIDE_THROUGH = "THROUGH";
    public static final String GUIDE_CHKECK = "CHECK";
    public static final String GUIDE_PEND = "PEND";
    public static final String GUIDE_CACHE_STATUS_CHANGING = "STATUS_CHANGING";
    public static final String GUID_MIXED = "MIXED";
    public static final String GUIDE_CACHE_STATUS_ERROR = "ERROR_TITLE";
    private static WeakHashMap<String, WeakReference<String>> strCacheModeMap = new WeakHashMap();
    public static final Set<Byte> DISCOVERY_PORT_ATTR_SET = new HashSet<Byte>();
    private static Object[][] StatusInfo;
    private static Object[][][] DetailStatusInfo;

    public SJctrExtUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    private static void changeMacro() {
        SJmoModelMgr modelMgr = (SJmoModelMgr)SJcSingletonManagerUty.getInstance(SJmoModelMgr.class);
        if (modelMgr == null) {
            SJctrLogUty.warn(SJctrExtUtility.class.getSimpleName(), "changeMacro", "Getting Model manager failed.");
            return;
        }
        SJmoMacroMgr macroMgr = modelMgr.getMacroMgr();
        if (macroMgr == null) {
            SJctrLogUty.warn(SJctrExtUtility.class.getSimpleName(), "changeMacro", "Getting Macro manager failed.");
            return;
        }
        Object obj = null;
        try {
            obj = macroMgr.getMacroObj(KEY_EXTGRP_MAX_DKC);
            if (obj != null) {
                SUBSYSTEM_MAPVOL_MAX = ((Long)obj).intValue();
                PATHGROUPID_MAX = ((Long)obj).intValue() - 1;
            } else {
                SJctrLogUty.warn(SJctrExtUtility.class.getSimpleName(), "changeMacro", "Getting Macro \"EXTGRP_MAX_DKC\" failed.");
            }
        }
        catch (ClassCastException e) {
            SJctrLogUty.warn(SJctrExtUtility.class.getSimpleName(), "changeMacro", "Getting Macro failed from Class Cast Exception.");
        }
    }

    public String toSubSystemName(SJmoExdSubsystemInfo subsystem, SJmoExdProfileInfo profile) {
        String vendor = "?";
        String model = "?";
        String selialId = "?";
        int profileID = -1;
        if (subsystem != null) {
            selialId = subsystem.getRmiExdSubsystemInfo().getSerialId();
            profileID = subsystem.getRmiExdSubsystemInfo().referProfileId();
            if (profileID == 254) {
                EXDSubsystemEx subsystemEx = (EXDSubsystemEx)subsystem.getRmiExdSubsystemInfo();
                vendor = subsystemEx.getVendor();
            }
        }
        if (profile != null) {
            if (profileID != 254) {
                vendor = profile.getRmiExdProfileInfo().getVender();
            }
            model = profile.getRmiExdProfileInfo().getProduct();
        }
        return this.toSubSystemName(vendor, model, selialId);
    }

    public String toSubSystemName(String vendor, String model, String serial) {
        String SEPARATOR = " / ";
        StringBuilder buf = new StringBuilder();
        buf.append(vendor);
        buf.append(" / ");
        buf.append(model);
        buf.append(" / ");
        buf.append(serial);
        return buf.toString();
    }

    public String toPathGroupIDDisplay(int pathGroupID) {
        StringBuffer buf = new StringBuffer();
        String name = this.guidanceHandle.getGuidance("UVM", "EXT_PATHGROUP");
        buf.append(name);
        buf.append(Integer.toString(pathGroupID));
        return buf.toString();
    }

    public int getExternalPathNum(SJmoExdPathGroupInfo pathGroup) {
        int num = 0;
        if (pathGroup != null) {
            int[] pathList = pathGroup.getRmiExdPathGroupInfo().referAllPhysicalPathList();
            for (int index = 0; index < pathList.length; ++index) {
                if (pathList[index] == -1) continue;
                ++num;
            }
        }
        return num;
    }

    public String toBaseEmulationDisplay(SJmoExdVolumeInfo volumeInfo) {
        return this.toBaseEmulationDisplay(volumeInfo.getRmiExdVolumeInfo().getIBaseEmulationType());
    }

    public String toBaseEmulationDisplay(int emu) {
        String ret = this.dataChange.getEmulationTypeName(emu);
        if (ret.equals("N/A")) {
            ret = "?";
        }
        return ret;
    }

    public String toPathModeDisplay(SJmoExdVolumeInfo volumeInfo) {
        return this.toPathModeDisplay(volumeInfo.getRmiExdVolumeInfo().getPathMode());
    }

    public String toPathModeDisplay(int pathMode) {
        String ret = "?";
        switch (pathMode) {
            case 0: {
                ret = this.guidanceHandle.getGuidance("UVM", "PATHMODE_MUTLI");
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                ret = this.guidanceHandle.getGuidance("UVM", "PATHMODE_SINGLE");
                break;
            }
            case 5: {
                ret = this.guidanceHandle.getGuidance("UVM", "PATHMODE_ALUA");
                break;
            }
        }
        return ret;
    }

    public String getCacheModeDisplay(SJmoExdVolumeInfo volumeInfo) {
        return this.getCacheModeDisplay(volumeInfo, true);
    }

    public String getCacheModeDisplay(SJmoExdVolumeInfo volumeInfo, boolean settingFlg) {
        if (volumeInfo == null) {
            return "?";
        }
        EXDExternalVolume exdVolInfo = volumeInfo.getRmiExdVolumeInfo();
        if (!(exdVolInfo instanceof EXDExternalVolumeEx)) {
            return "?";
        }
        EXDExternalVolumeEx volumeInfoEx = (EXDExternalVolumeEx)exdVolInfo;
        StringBuffer ret = new StringBuffer();
        if (volumeInfoEx.isODMAttribute()) {
            switch (volumeInfoEx.getIomodeName()) {
                case 0: {
                    if (settingFlg) {
                        ret.append(this.guidanceHandle.getGuidance("ENABLE"));
                        break;
                    }
                    ret.append(this.guidanceHandle.getGuidance("ENABLED"));
                    break;
                }
                case 1: {
                    if (settingFlg) {
                        ret.append(this.guidanceHandle.getGuidance("DISABLE"));
                        break;
                    }
                    ret.append(this.guidanceHandle.getGuidance("DISABLED"));
                    break;
                }
                case 2: {
                    ret.append(this.guidanceHandle.getGuidance(GUIDE_WRITE_SYNC));
                    break;
                }
                case 3: {
                    ret.append(this.guidanceHandle.getGuidance(GUIDE_THROUGH));
                    break;
                }
                case 4: {
                    ret.append(this.guidanceHandle.getGuidance(GUIDE_CHKECK));
                    break;
                }
                case 5: {
                    ret.append(this.guidanceHandle.getGuidance(GUIDE_PEND));
                    break;
                }
                default: {
                    ret.append("?");
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getCacheModeDisplay", "Cache Mode Invalid");
                }
            }
            switch (volumeInfoEx.getIomodeStatus()) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    ret.append(String.format(CACHESTATUS_FORMAT, this.guidanceHandle.getGuidance(GUIDE_CACHE_STATUS_CHANGING)));
                    break;
                }
                case 3: {
                    ret.append(String.format(CACHESTATUS_FORMAT, this.guidanceHandle.getGuidance(GUIDE_CACHE_STATUS_ERROR)));
                    break;
                }
                default: {
                    ret.append(String.format(CACHESTATUS_FORMAT, "?"));
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "getCacheModeDisplay", "Cache Status Invalid");
                    break;
                }
            }
        } else if (volumeInfo.getRmiExdVolumeInfo().getCacheMode()) {
            if (settingFlg) {
                ret.append(this.guidanceHandle.getGuidance("ENABLE"));
            } else {
                ret.append(this.guidanceHandle.getGuidance("ENABLED"));
            }
        } else if (settingFlg) {
            ret.append(this.guidanceHandle.getGuidance("DISABLE"));
        } else {
            ret.append(this.guidanceHandle.getGuidance("DISABLED"));
        }
        return this.getCache(ret.toString(), strCacheModeMap);
    }

    public String getInflowControlDisplay(SJmoExdVolumeInfo volumeInfo) {
        return this.getInflowControlDisplay(volumeInfo, true);
    }

    public String getInflowControlDisplay(SJmoExdVolumeInfo volumeInfo, boolean settingFlg) {
        String ret = "?";
        if (volumeInfo != null) {
            ret = volumeInfo.getRmiExdVolumeInfo().getInflowControl() ? (settingFlg ? this.guidanceHandle.getGuidance("ENABLE") : this.guidanceHandle.getGuidance("ENABLED")) : (settingFlg ? this.guidanceHandle.getGuidance("DISABLE") : this.guidanceHandle.getGuidance("DISABLED"));
        }
        return ret;
    }

    public int getPriority(SJmoExdPathGroupInfo pathGroupInfo, SJmoExdPhysicalPathInfo physicalPathInfo) {
        int physicalPathId = physicalPathInfo.getRmiExdPhysicalPathInfo().getId();
        return this.getPriority(pathGroupInfo, physicalPathId);
    }

    public int getPriority(SJmoExdPathGroupInfo pathGroup, int physicalPathId) {
        int priority = -1;
        if (physicalPathId != -1) {
            int[] physicalathList = pathGroup.getRmiExdPathGroupInfo().referAllPhysicalPathList();
            for (int index = 0; index < physicalathList.length; ++index) {
                if (physicalathList[index] != physicalPathId) continue;
                priority = index + 1;
                break;
            }
        }
        return priority;
    }

    public int getPriorityDisplay(int value) {
        return value + 1;
    }

    public String getStatusDisplay(int status) {
        String ret = "?";
        String key = "EXT_STATUS_UNKNOWN";
        if (status == -1) {
            ret = this.guidanceHandle.getGuidance("UVM", key);
            return ret;
        }
        if (status < StatusInfo.length) {
            key = (String)StatusInfo[status][1];
        }
        ret = this.guidanceHandle.getGuidance("UVM", key);
        if (key.equals("EXT_STATUS_UNKNOWN")) {
            ret = ret + "(" + "0x" + SJctrComUtility.toHexString(status, 2, true) + ")";
        }
        return ret;
    }

    public String getStatusDisplay(int status, int destage) {
        String ret = this.getStatusDisplay(status);
        if (status == 5) {
            ret = ret + "(" + destage + "%" + ")";
        }
        return ret;
    }

    public String getDetailStatusDisplay(int detailStatus) {
        String ret = "?";
        String key = "EXT_STATUS_UNKNOWN";
        if (detailStatus == -1) {
            ret = this.guidanceHandle.getGuidance("UVM", key);
            return ret;
        }
        int highIndex = (detailStatus & 0xF0) >> 4;
        int lowIndex = detailStatus & 0xF;
        if (highIndex < DetailStatusInfo.length && lowIndex < DetailStatusInfo[highIndex].length) {
            key = (String)DetailStatusInfo[highIndex][lowIndex][1];
        }
        ret = this.guidanceHandle.getGuidance("UVM", key);
        if (key.equals("EXT_STATUS_UNKNOWN")) {
            ret = ret + "(" + "0x" + SJctrComUtility.toHexString(detailStatus, 2, true) + ")";
        }
        return ret;
    }

    public String getForcibleDeletionDisplay(int option) {
        String guid = "NO";
        if (option == 1) {
            guid = "YES";
        }
        return this.guidanceHandle.getGuidance(guid);
    }

    public String getDriveInfoDisplay(SJmoExdVolumeInfo exdvol) {
        StringBuffer buf = new StringBuffer();
        if (exdvol == null) {
            buf.append("?");
        } else {
            EXDExternalDevice exddev = exdvol.getRmiExdVolumeInfo().getExternalDeviceInfo();
            if (exddev.isInheritDrive()) {
                buf.append(INHERITDRIVE_DISP);
            }
            switch (exddev.getDriveType()) {
                case 1: 
                case 2: {
                    buf.append(this.guidanceHandle.getGuidance("SATA"));
                    break;
                }
                case 3: {
                    buf.append(this.guidanceHandle.getGuidance("SSD"));
                    break;
                }
            }
        }
        return buf.toString();
    }

    public List<SJmoLdevDetail> getLdevDetailinPG(SJmoPgIndex pgIndex, List<SJmoLdevDetail> ldevDtlList) {
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>(ldevDtlList.size());
        int fb4 = pgIndex.getFB4();
        int pg = pgIndex.getPG();
        for (SJmoLdevDetail ldevDtl : ldevDtlList) {
            if (ldevDtl.getIFB4() != fb4 || ldevDtl.getIPG() != pg) continue;
            retList.add(ldevDtl);
        }
        retList.trimToSize();
        return retList;
    }

    public List<SJmoExdPathGroupInfo> getPathGroupListPhysicalPath(List<SJmoExdPathGroupInfo> pathGrpList, int physicalPathId) {
        ArrayList<SJmoExdPathGroupInfo> retList = new ArrayList<SJmoExdPathGroupInfo>(pathGrpList.size());
        block0: for (SJmoExdPathGroupInfo pathGrp : pathGrpList) {
            int[] pysicalPathIdList = pathGrp.getRmiExdPathGroupInfo().referAllPhysicalPathList();
            for (int portcnt = 0; portcnt < pysicalPathIdList.length && pysicalPathIdList[portcnt] != -1; ++portcnt) {
                int pathId = pysicalPathIdList[portcnt];
                if (pathId != physicalPathId) continue;
                retList.add(pathGrp);
                continue block0;
            }
        }
        return retList;
    }

    public List<SJmoLdevDetail> getUsableLdevDtlInfo(SJctrResourceGroupUtility rsgUtil, List<SJmoLdevDetail> ldevDetailList) {
        ArrayList<SJmoLdevDetail> retList = new ArrayList<SJmoLdevDetail>(ldevDetailList);
        List<SJmoLdevIndex> unUsableLdevList = rsgUtil.extractImpossibleLdev(ldevDetailList);
        retList.removeAll(unUsableLdevList);
        Collections.sort(retList);
        return retList;
    }

    public List<SJmoExdSubsystemInfo> getUsableSubsystemInfo(SJctrResourceGroupUtility rsgUtil, List<SJmoExdSubsystemInfo> subsystemList, SJmoExdPathGroupInfoMgr pathGrpMgr, SJmoExdPhysicalPathInfoMgr physicalPathMgr, SJmoExdVolumeInfoMgr exdVolMgr) {
        ArrayList<SJmoExdSubsystemInfo> retList = new ArrayList<SJmoExdSubsystemInfo>(subsystemList.size());
        for (SJmoExdSubsystemInfo subsystem : subsystemList) {
            EXDSubsystem rmiSubsystem = subsystem.getRmiExdSubsystemInfo();
            int subsystemId = rmiSubsystem.getId();
            ArrayList pathGroupList = pathGrpMgr.getAlPathGroupInfoOfSubsystemId(subsystemId);
            List<SJmoExdPathGroupInfo> usableGroupList = this.getUsableExdPathGrpInfo(rsgUtil, pathGroupList, physicalPathMgr, exdVolMgr);
            if (usableGroupList.size() == 0) continue;
            retList.add(subsystem);
        }
        Collections.sort(retList);
        return retList;
    }

    public List<SJmoExdPhysicalPathInfo> getUsablePhysicalPathInfo(SJctrResourceGroupUtility rsgUtil, List<SJmoExdPathGroupInfo> exdPathGrpList, SJmoExdPhysicalPathInfoMgr physicalPathMgr) {
        HashSet<SJmoExdPhysicalPathInfo> physicalPathSet = new HashSet<SJmoExdPhysicalPathInfo>(exdPathGrpList.size() * 8);
        for (SJmoExdPathGroupInfo pathGrp : exdPathGrpList) {
            EXDPathGroup rmiPathGrp = pathGrp.getRmiExdPathGroupInfo();
            int[] pysicalPathIdList = rmiPathGrp.referAllPhysicalPathList();
            for (int portcnt = 0; portcnt < pysicalPathIdList.length && pysicalPathIdList[portcnt] != -1; ++portcnt) {
                int physicalPathId = pysicalPathIdList[portcnt];
                SJmoExdPhysicalPathInfo phsicalPathInfo = physicalPathMgr.getExdPhysicalPathInfo(physicalPathId);
                int portId = phsicalPathInfo.getRmiExdPhysicalPathInfo().referInitiatorPortId();
                SJmoPortIndex portindex = new SJmoPortIndex();
                portindex.setSPort((short)portId);
                ArrayList<SJmoPortIndex> portList = new ArrayList<SJmoPortIndex>();
                portList.add(portindex);
                List<SJmoPortIndex> extractPortList = rsgUtil.extractPort(portList);
                if (extractPortList.size() == 0) continue;
                physicalPathSet.add(phsicalPathInfo);
            }
        }
        ArrayList<SJmoExdPhysicalPathInfo> retList = new ArrayList<SJmoExdPhysicalPathInfo>(physicalPathSet);
        Collections.sort(retList);
        return retList;
    }

    public List<SJmoExdPhysicalPathInfo> getAllPhysicalPathInfo(List<SJmoExdPathGroupInfo> exdPathGrpList, SJmoExdPhysicalPathInfoMgr physicalPathMgr) {
        HashSet<SJmoExdPhysicalPathInfo> physicalPathSet = new HashSet<SJmoExdPhysicalPathInfo>(exdPathGrpList.size() * 8);
        for (SJmoExdPathGroupInfo pathGrp : exdPathGrpList) {
            EXDPathGroup rmiPathGrp = pathGrp.getRmiExdPathGroupInfo();
            int[] pysicalPathIdList = rmiPathGrp.referAllPhysicalPathList();
            for (int portcnt = 0; portcnt < pysicalPathIdList.length && pysicalPathIdList[portcnt] != -1; ++portcnt) {
                int physicalPathId = pysicalPathIdList[portcnt];
                SJmoExdPhysicalPathInfo phsicalPathInfo = physicalPathMgr.getExdPhysicalPathInfo(physicalPathId);
                physicalPathSet.add(phsicalPathInfo);
            }
        }
        ArrayList<SJmoExdPhysicalPathInfo> retList = new ArrayList<SJmoExdPhysicalPathInfo>(physicalPathSet);
        Collections.sort(retList);
        return retList;
    }

    public List<SJmoExdPathGroupInfo> getUsableExdPathGrpInfo(SJctrResourceGroupUtility rsgUtil, List<SJmoExdPathGroupInfo> exdPathGrpList, SJmoExdPhysicalPathInfoMgr physicalPathMgr, SJmoExdVolumeInfoMgr exdVolMgr) {
        ArrayList<SJmoExdPathGroupInfo> retList = new ArrayList<SJmoExdPathGroupInfo>(exdPathGrpList.size());
        for (SJmoExdPathGroupInfo pathgrp : exdPathGrpList) {
            ArrayList<SJmoExdPathGroupInfo> pathGrpList = new ArrayList<SJmoExdPathGroupInfo>();
            pathGrpList.add(pathgrp);
            List<SJmoExdPhysicalPathInfo> usablePathList = this.getUsablePhysicalPathInfo(rsgUtil, pathGrpList, physicalPathMgr);
            if (usablePathList.size() != 0) {
                retList.add(pathgrp);
                continue;
            }
            EXDPathGroup rmiPathGrpInfo = pathgrp.getRmiExdPathGroupInfo();
            int pathGrpId = rmiPathGrpInfo.getPathGroupID();
            SJmoExdVolumeInfoOnPathGroup exdVolOnPathGrp = exdVolMgr.getExdVolumeInfoOnPathGroup(pathGrpId);
            ArrayList exdVolList = exdVolOnPathGrp.getAlExdVolumeInfo();
            List<SJmoExdVolumeInfo> usebleExdVolList = this.getUsableExdVolInfo(rsgUtil, exdVolList);
            if (usebleExdVolList.size() == 0) continue;
            retList.add(pathgrp);
        }
        Collections.sort(retList);
        return retList;
    }

    public List<SJmoExdVolumeInfo> getUsableExdVolInfo(SJctrResourceGroupUtility rsgUtil, List<SJmoExdVolumeInfo> exdVolList) {
        ArrayList<SJmoExdVolumeInfo> retList = new ArrayList<SJmoExdVolumeInfo>(exdVolList.size());
        for (SJmoExdVolumeInfo exdVol : exdVolList) {
            EXDExternalVolume rmiExdVol = exdVol.getRmiExdVolumeInfo();
            SJmoPgIndex pgIndex = new SJmoPgIndex();
            pgIndex.setFB4(rmiExdVol.getIFB4());
            pgIndex.setPG(rmiExdVol.getIPG());
            ArrayList<SJmoPgIndex> pgList = new ArrayList<SJmoPgIndex>();
            pgList.add(pgIndex);
            List<SJmoPgIndex> used_Pg = rsgUtil.extractPg(pgList);
            if (used_Pg.size() == 0) continue;
            retList.add(exdVol);
        }
        Collections.sort(retList);
        return retList;
    }

    public List<SJmoExdVolumeInfo> getUsableExdVolInfoonPathGrp(SJctrResourceGroupUtility rsgUtil, List<SJmoExdPathGroupInfo> exdPathGrpList, SJmoExdVolumeInfoMgr exdVolMgr) {
        ArrayList<SJmoExdVolumeInfo> retList = new ArrayList<SJmoExdVolumeInfo>(SUBSYSTEM_MAPVOL_MAX);
        for (SJmoExdPathGroupInfo pathGrp : exdPathGrpList) {
            int pathGrpId = pathGrp.getRmiExdPathGroupInfo().getPathGroupID();
            SJmoExdVolumeInfoOnPathGroup exdVolonPathGrp = exdVolMgr.getExdVolumeInfoOnPathGroup(pathGrpId);
            ArrayList exdVolList = exdVolonPathGrp.getAlExdVolumeInfo();
            List<SJmoExdVolumeInfo> usableexdVolList = this.getUsableExdVolInfo(rsgUtil, exdVolList);
            retList.addAll(usableexdVolList);
        }
        Collections.sort(retList);
        return retList;
    }

    public String getAttribute(SJmoExdVolumeInfo volumeInfo) {
        EXDExternalVolumeEx exdVolEx;
        if (volumeInfo == null) {
            return "?";
        }
        ArrayList<String> strAttrList = new ArrayList<String>();
        EXDExternalVolume exdVol = volumeInfo.getRmiExdVolumeInfo();
        if (exdVol.isODMAttribute()) {
            String attr = this.guidanceHandle.getGuidance("ODM_VOL");
            strAttrList.add(attr);
        }
        if (exdVol instanceof EXDExternalVolumeEx && (exdVolEx = (EXDExternalVolumeEx)exdVol).isDDMAttribute()) {
            String attr = this.guidanceHandle.getGuidance("DATA_DIRECT_MAPPING");
            strAttrList.add(attr);
        }
        return SJctrExtUtility.joinString(EXTVOL_ATTR_SEPARATOR, strAttrList);
    }

    public String getLBMDisplay(short lbm) {
        return this.getLBMDisplay(lbm, true);
    }

    public String getLBMDisplay(short lbm, boolean settingFlg) {
        String ret = "?";
        switch (lbm) {
            case 0: {
                ret = this.guidanceHandle.getGuidance("UVM", "LBM_NORMAL");
                break;
            }
            case 1: {
                ret = this.guidanceHandle.getGuidance("UVM", "LBM_EXTENDED");
                break;
            }
            case 2: {
                ret = settingFlg ? this.guidanceHandle.getGuidance("DISABLE") : this.guidanceHandle.getGuidance("DISABLED");
            }
        }
        return ret;
    }

    public String getALUASettableDisplay(boolean settable) {
        String guid = "NO";
        if (settable) {
            guid = "YES";
        }
        return this.guidanceHandle.getGuidance(guid);
    }

    public String getALUAPermitDisplay(boolean bAluaPermit, boolean settingFlg) {
        String guid = bAluaPermit ? (settingFlg ? "ENABLE" : "ENABLED") : (settingFlg ? "DISABLE" : "DISABLED");
        return this.guidanceHandle.getGuidance(guid);
    }

    public String getAsymmetricAccessStatDisplay(byte pathMode, byte asynmetricState) {
        String ret = "?";
        if (pathMode == 5) {
            if (asynmetricState == -64) {
                ret = this.guidanceHandle.getGuidance("UVM", GUID_ACTIVE_OPT);
            } else if (asynmetricState == -128) {
                ret = this.guidanceHandle.getGuidance("UVM", GUID_ACTIVE_NONOPT);
            } else if (asynmetricState == 0) {
                ret = "";
            }
        } else {
            ret = "";
        }
        return ret;
    }

    public static String joinString(String separator, List<String> strList) {
        StringBuffer buf = new StringBuffer();
        Iterator<String> ite = strList.iterator();
        while (ite.hasNext()) {
            String str = ite.next();
            buf.append(str);
            if (!ite.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static List<SJmoPortIndex> getImpossibleExdPortList(SJmoExdPhysicalPathInfoMgr physicalPathMgr, SJctrResourceGroupUtility rsgUtil) {
        ArrayList physicalPathList = physicalPathMgr.getAlExdPhysicalPathInfo();
        ArrayList<SJmoPortIndex> portList = new ArrayList<SJmoPortIndex>(physicalPathList.size());
        HashSet<Short> portSet = new HashSet<Short>(physicalPathList.size());
        for (SJmoExdPhysicalPathInfo physicalPath : physicalPathList) {
            short portId = (short)physicalPath.getRmiExdPhysicalPathInfo().referInitiatorPortId();
            if (!portSet.add(portId)) continue;
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(portId);
            portList.add(portIndex);
        }
        List<SJmoPortIndex> unUsablePortList = rsgUtil.extractImpossiblePort(portList);
        Collections.sort(unUsablePortList);
        return unUsablePortList;
    }

    public static List<SJmoPgIndex> getImpossibleExdPgList(SJmoExdVolumeInfoMgr exdVolMgr, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJmoPgIndex> pgList = new ArrayList<SJmoPgIndex>(SUBSYSTEM_MAPVOL_MAX);
        for (Object obj : exdVolMgr.getAlExdVolumeInfoOnPathGroup()) {
            SJmoExdVolumeInfoOnPathGroup exdVolOnPathGrp = (SJmoExdVolumeInfoOnPathGroup)obj;
            ArrayList exdVolList = exdVolOnPathGrp.getAlExdVolumeInfo();
            for (SJmoExdVolumeInfo exdVol : exdVolList) {
                int fb4 = exdVol.getRmiExdVolumeInfo().getIFB4();
                int pg = exdVol.getRmiExdVolumeInfo().getIPG();
                SJmoPgIndex pgIndex = new SJmoPgIndex();
                pgIndex.setFB4(fb4);
                pgIndex.setPG(pg);
                pgList.add(pgIndex);
            }
        }
        List<SJmoPgIndex> unUsablePgList = rsgUtil.extractImpossiblePg(pgList);
        Collections.sort(unUsablePgList);
        return unUsablePgList;
    }

    public static SJmoPortDetail getPortDtlFromPhysicalPathInfo(SJmoExdPhysicalPathInfo physicalPath, List<SJmoPortDetail> portDtlList) {
        short portId = (short)physicalPath.getRmiExdPhysicalPathInfo().referInitiatorPortId();
        SJmoPortIndex searchPortIndex = new SJmoPortIndex();
        searchPortIndex.setSPort(portId);
        SJmoPortDetail portDtl = null;
        int search = Collections.binarySearch(portDtlList, searchPortIndex);
        if (search >= 0) {
            portDtl = portDtlList.get(search);
        }
        return portDtl;
    }

    public static SJmoIscsiTargetPathInfo getiSCSITargetPathInfo(SJmoExdPhysicalPathInfo physicalPathInfo, List<SJmoPortIscsiTargetPathInfo> ptiSCSITargetPathList, SJmoExdTargetPortInfoMgr targetPathMgr) {
        SJmoPortIscsiTargetPathInfo ptiSCSITargetPathInfo = SJctrExtUtility.getPortIscsiTargetPathInfo(physicalPathInfo, ptiSCSITargetPathList);
        int itPathIndex = SJctrExtUtility.getIscsiTargetPathIndex(physicalPathInfo, targetPathMgr);
        return SJctrExtUtility.getiSCSITargetPathInfo(ptiSCSITargetPathInfo, itPathIndex);
    }

    public static SJmoIscsiTargetPathInfo getiSCSITargetPathInfo(SJmoPortIscsiTargetPathInfo ptiSCSITargetPathInfo, int itPathIndex) {
        SJmoIscsiTargetPathInfo ret = null;
        if (ptiSCSITargetPathInfo != null && itPathIndex >= 0) {
            for (SJmoIscsiTargetPathInfo itPathInfo : ptiSCSITargetPathInfo.getAlPortIscsiTargetPath()) {
                if (itPathInfo.getITargetPathIndex() != itPathIndex) continue;
                ret = itPathInfo;
                break;
            }
        }
        return ret;
    }

    public static SJmoExDPgInfo getExdPgInfo(SJmoLdevDetail ldev, SJmoExDVirtualPgInfo exVpgInfo) {
        SJmoExDPgInfo exPgInfo = null;
        SJmoPgIndex pg = new SJmoPgIndex();
        pg.setFB4(ldev.getIFB4());
        pg.setPG(ldev.getIPG());
        ArrayList exVpgList = exVpgInfo.getAlVpgForExd();
        if (exVpgList != null && exVpgList.size() != 0) {
            Collections.sort(exVpgList);
            int index = Collections.binarySearch(exVpgList, pg);
            if (index >= 0) {
                exPgInfo = (SJmoExDPgInfo)exVpgList.get(index);
            }
        }
        return exPgInfo;
    }

    public static SJmoExdPathGroupInfo getExdPathGrpInfoFromLdevDetail(SJmoLdevDetail ldev, SJmoExDVirtualPgInfo exVpgInfo, SJmoExdPathGroupInfoMgr exPathGrpInfoMgr) {
        if (exVpgInfo == null || exPathGrpInfoMgr == null) {
            SJctrLogUty.error("SJctrExtUtility", "getExdPathGrpInfoFromLdevDetail", "Argument is null.");
            return null;
        }
        SJmoExdPathGroupInfo exPathGrpInfo = null;
        SJmoExDPgInfo exPgInfo = SJctrExtUtility.getExdPgInfo(ldev, exVpgInfo);
        if (exPgInfo != null) {
            exPathGrpInfo = exPathGrpInfoMgr.getExdPathGroupInfo(exPgInfo.getIPathGroupId());
        }
        return exPathGrpInfo;
    }

    public static SJmoExdSubsystemInfo getExdSubsysInfoFromLdevDetail(SJmoLdevDetail ldev, SJmoExDVirtualPgInfo exVpgInfo, SJmoExdPathGroupInfoMgr exPathGrpInfoMgr, SJmoExdSubsystemInfoMgr exSubsysInfoMgr) {
        if (exVpgInfo == null || exPathGrpInfoMgr == null || exSubsysInfoMgr == null) {
            SJctrLogUty.error("SJctrExtUtility", "getExdSubsysInfoFromLdevDetail", "Argument is null.");
            return null;
        }
        SJmoExdSubsystemInfo exSubsysInfo = null;
        SJmoExdPathGroupInfo exPathGrpInfo = SJctrExtUtility.getExdPathGrpInfoFromLdevDetail(ldev, exVpgInfo, exPathGrpInfoMgr);
        if (exPathGrpInfo != null) {
            exSubsysInfo = exSubsysInfoMgr.getExdSubsystemInfo(exPathGrpInfo.getRmiExdPathGroupInfo().referSubsystemID());
        }
        return exSubsysInfo;
    }

    public static SJmoExdProfileInfo getExdProfileInfoFromLdevDetail(SJmoLdevDetail ldev, SJmoExDVirtualPgInfo exVpgInfo, SJmoExdPathGroupInfoMgr exPathGrpInfoMgr, SJmoExdSubsystemInfoMgr exSubsysInfoMgr, SJmoExdProfileInfoMgr exProfileInfoMgr) {
        if (exVpgInfo == null || exPathGrpInfoMgr == null || exSubsysInfoMgr == null || exProfileInfoMgr == null) {
            SJctrLogUty.error("SJctrExtUtility", "getExdProfileInfoFromLdevDetail", "Argument is null.");
            return null;
        }
        SJmoExdProfileInfo exProfileInfo = null;
        SJmoExdSubsystemInfo exSubsysInfo = SJctrExtUtility.getExdSubsysInfoFromLdevDetail(ldev, exVpgInfo, exPathGrpInfoMgr, exSubsysInfoMgr);
        if (exSubsysInfo != null) {
            exProfileInfo = exProfileInfoMgr.getExdProfileInfo(exSubsysInfo.getRmiExdSubsystemInfo().referProfileId());
        }
        return exProfileInfo;
    }

    public static SJmoPortIscsiTargetPathInfo getPortIscsiTargetPathInfo(SJmoExdPhysicalPathInfo physicalPathInfo, List<SJmoPortIscsiTargetPathInfo> ptiSCSITargetPathList) {
        short portId = (short)physicalPathInfo.getRmiExdPhysicalPathInfo().referInitiatorPortId();
        SJmoPortIndex searchPortIndex = new SJmoPortIndex();
        searchPortIndex.setSPort(portId);
        SJmoPortIscsiTargetPathInfo portItPath = null;
        int search = Collections.binarySearch(ptiSCSITargetPathList, searchPortIndex);
        if (search >= 0) {
            portItPath = ptiSCSITargetPathList.get(search);
        }
        return portItPath;
    }

    public static int getIscsiTargetPathIndex(SJmoExdPhysicalPathInfo physicalPathInfo, SJmoExdTargetPortInfoMgr targetPathMgr) {
        int targetPortId = physicalPathInfo.getRmiExdPhysicalPathInfo().referTargetPortId();
        SJmoExdTargetPortInfo targetPortInfo = targetPathMgr.getExdTargetPortInfo(targetPortId);
        return SJctrExtUtility.getIscsiTargetPathIndex(targetPortInfo);
    }

    public static int getIscsiTargetPathIndex(SJmoExdTargetPortInfo targetPortInfo) {
        int ret = -1;
        if (targetPortInfo != null) {
            String strWwn = targetPortInfo.getRmiExdTargetPortInfo().getDispTargetPortAddress();
            ret = SJctrExtUtility.getIscsiTargetPathIndex(strWwn);
        }
        return ret;
    }

    public static int getIscsiTargetPathIndex(String strWwn) {
        int ret = -1;
        if (strWwn.substring(0, 2).compareToIgnoreCase("FF") == 0) {
            String strIndex = strWwn.substring(2, 8);
            ret = Integer.valueOf(strIndex, 16);
        }
        return ret;
    }

    public static int getIscsiVirtualPortId(String strWwn) {
        int ret = 0;
        String strIndex = strWwn.substring(2, 4);
        ret = Integer.valueOf(strIndex, 16);
        return ret;
    }

    static {
        DISCOVERY_PORT_ATTR_SET.add((byte)6);
        DISCOVERY_PORT_ATTR_SET.add((byte)9);
        SJctrExtUtility.changeMacro();
        StatusInfo = new Object[][]{{0, "EXT_STATUS_UNKNOWN"}, {1, "EXT_STATUS_NORMAL"}, {2, "EXT_STATUS_DISCONNECT"}, {3, "EXT_STATUS_CHECKING"}, {4, "EXT_STATUS_UNKNOWN"}, {5, "EXT_STATUS_DESTAGE"}, {6, "EXT_STATUS_DISCONNECT"}, {7, "EXT_STATUS_DISCONNECT"}, {8, "EXT_STATUS_WARNING"}, {9, "EXT_STATUS_BLOCKADE"}, {10, "EXT_STATUS_DESTAGE_FAILED"}};
        DetailStatusInfo = new Object[][][]{{{0, "EXT_STATUS_UNKNOWN"}, {1, "EXT_STATUS_CHECKING"}, {2, "EXT_STATUS_PORT_CANT_DETECT"}, {3, "EXT_STATUS_BLOCKADE"}, {4, "EXT_STATUS_DEVICE_CHANGED"}, {5, "EXT_STATUS_LDEVSIZE_REDUCED"}, {6, "EXT_STATUS_NOT_READY"}, {7, "EXT_STATUS_ILLIGAL_REQUEST"}, {8, "EXT_STATUS_COMMAND_ABORTED"}, {9, "EXT_STATUS_BUSY"}, {10, "EXT_STATUS_LDEV_RESERVED"}, {11, "EXT_STATUS_RESPONSE_ERROR"}, {12, "EXT_STATUS_TIMEOUT"}, {13, "EXT_STATUS_PORT_INITIATOR"}, {14, "EXT_STATUS_UNKNOWN"}, {15, "EXT_STATUS_PORT_UNKNOWN"}}, {{16, "EXT_STATUS_ILLEGAL_ERROR"}, {17, "EXT_STATUS_TARGET_ERROR"}, {18, "EXT_STATUS_UNAVALABLE"}, {19, "EXT_STATUS_BACK_OFF"}, {20, "EXT_STATUS_DEV_CHK_ERROR"}, {21, "EXT_STATUS_MEDIUM_ERROR"}, {22, "EXT_STATUS_UNKNOWN"}, {23, "EXT_STATUS_UNKNOWN"}, {24, "EXT_STATUS_UNKNOWN"}, {25, "EXT_STATUS_UNKNOWN"}, {26, "EXT_STATUS_UNKNOWN"}, {27, "EXT_STATUS_DESTAGE_FAILED"}}, new Object[0][], new Object[0][], {{64, "EXT_STATUS_NORMAL"}, {65, "EXT_STATUS_STANDBY"}, {66, "EXT_STATUS_PASSIVE"}, {67, "EXT_STATUS_UNKNOWN"}, {68, "EXT_STATUS_NORMAL"}, {69, "EXT_STATUS_PASSIVE"}}, new Object[0][], new Object[0][], new Object[0][], {{128, "EXT_STATUS_DISCONNECT"}}, new Object[0][], new Object[0][], new Object[0][], {{192, "EXT_STATUS_CHECKING"}}};
    }
}

