/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.controller.com.SJctrBackgroundWorkerThread;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrQueueController;
import sanproject.sn2.controller.com.SJctrTask;

public class SJctrMonitorBackgroundThread
extends Thread {
    private final String mClassName;
    private final SJctrTask task;
    private final int resultStatus;
    private final SJctrBackgroundWorkerThread bgWorker;

    public SJctrMonitorBackgroundThread(SJctrBackgroundWorkerThread bgWorker, int resultStatus, SJctrTask task) {
        this.task = task;
        this.resultStatus = resultStatus;
        this.bgWorker = bgWorker;
        String taskId = "???";
        if (task != null) {
            taskId = task.getId();
        }
        this.setName("SJctrMonitorBg=" + taskId);
        this.mClassName = this.getClass().getSimpleName();
    }

    @Override
    public void run() {
        SJctrLogUty.info(this.mClassName, "run", "start");
        try {
            this.preMonitor(this.task);
            int taskStatus = this.task.monitorBackground(this.bgWorker.mAgent, this.resultStatus);
            this.afterMonitor(this.task, taskStatus);
        }
        catch (Exception ex) {
            SJctrLogUty.error(this.mClassName, "run", "Exception.", ex);
            try {
                SJctrBackgroundWorkerThread.afterExceptionTaskFailed(this.task, this.bgWorker.mQueueCtr, ex);
            }
            catch (Exception exEx) {
                SJctrLogUty.error(this.mClassName, "run", "Unknown Exception.", exEx);
            }
        }
        SJctrLogUty.info(this.mClassName, "run", "end");
    }

    void preMonitor(SJctrTask task) {
        SJctrQueueController queue = SJctrQueueController.getInstance();
        try {
            queue.saveTaskControlData(task);
        }
        catch (Exception ex) {
            SJctrLogUty.warn(this.mClassName, "preMonitor", "Failed to save Control file. : ", ex);
        }
        try {
            queue.saveTaskApplyData(task);
        }
        catch (Exception ex) {
            SJctrLogUty.warn(this.mClassName, "preMonitor", "Failed to save Apply Data file. : ", ex);
        }
        try {
            queue.saveTaskResultData(task);
        }
        catch (Exception ex) {
            SJctrLogUty.warn(this.mClassName, "preMonitor", "Failed to save Result Data file. : ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterMonitor(SJctrTask task, int taskStatus) {
        SJctrQueueController queue = SJctrQueueController.getInstance();
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (taskStatus != 258 && queue.isActive()) {
                task.setTaskEnd(taskStatus);
                try {
                    String directroyName = SJctrQueueController.DIR_NAME_QUEUE;
                    String resultFileName = SJctrQueueController.getResultFileName(task.getId());
                    SJcFileUty.saveClass2File(directroyName, resultFileName, task.exportApplyResult());
                }
                catch (Exception e) {
                    SJctrLogUty.warn(this.mClassName, "afterMonitor", "write Result File failed = ", e);
                }
                queue.toHistory(task);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            queue.wakeUpWorkerThread();
            return;
        }
    }
}

