/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.autopoolcfg;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;

public class SJcAutoPoolConfig {
    protected List<List<PoolPolicy>> mPolicyList;
    protected List<PoolPolicy> mPolicyList_HDP;
    protected List<PoolPolicy> mPolicyList_HDT;
    protected Map<Integer, PoolVol> ldev_map;
    protected Map<Integer, PoolVolSetOfPG> pg_map;
    protected PGSet mPGSetTree;
    protected static int mMaxRSGNum = 1024;
    protected static long mlocalCapConverterLBA_KB = 2L;
    protected static long mlocalCapConverterLBA_Cyl = 1740L;
    protected static long mDPPOOL_PageSize = 43008L;
    protected static long mMFDPPOOL_PageSize = 38976L;
    protected static long mMinLdevCapacity = 0x800000L * mlocalCapConverterLBA_KB;
    protected static long mMaxLdevCapacity = 0x180000000L;
    protected static long mMinLdevCapacityMF = 16837632L;
    protected static long mMaxLdevCapacityMF = 1457702400L;
    protected static long mMaxNumofPoolVOLsofPool = 1024L;
    protected static long mMinLdevPages = 195L;
    protected static long mMinLdevPagesMF = 16837632L / mlocalCapConverterLBA_KB / 38976L;
    protected static int mMaxTierNumber = 3;
    protected static long mSystemCapacityOPEN = mDPPOOL_PageSize * 100L * mlocalCapConverterLBA_KB;
    protected static long mSystemCapacityMF = mMFDPPOOL_PageSize * 100L * mlocalCapConverterLBA_KB;
    protected static int mlocalRatiotoInteger = 100;
    static Comparator<PoolVolSetOfPG> PoolVolSetOfPGcomparator = new Comparator<PoolVolSetOfPG>(){

        @Override
        public int compare(PoolVolSetOfPG pg1, PoolVolSetOfPG pg2) {
            int rtn = 0;
            long comparecap = -(pg1.mPoolVolsCap - pg2.mPoolVolsCap);
            rtn = comparecap > 0L ? 1 : (comparecap == 0L ? 0 : -1);
            return rtn;
        }
    };
    int[][][] policytable = new int[][][]{new int[][]{{100, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 100, 0}, {0, 0, 0}, {0, 0, 100}}, new int[][]{{100, 0, 0}, {10, 90, 0}, {2, 36, 62}, {0, 100, 0}, {0, 30, 70}, {0, 0, 100}}, new int[][]{{100, 0, 0}, {10, 90, 0}, {2, 36, 62}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};

    private static <PoolVolSetOfPG> int insertIndexBinarySearch(List<? extends PoolVolSetOfPG> l, PoolVolSetOfPG key, Comparator<? super PoolVolSetOfPG> c) {
        int low = 0;
        int high = l.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            PoolVolSetOfPG midVal = l.get(mid);
            int cmp = c.compare(midVal, key);
            if (cmp <= 0) {
                low = mid + 1;
                continue;
            }
            if (cmp <= 0) continue;
            high = mid - 1;
        }
        return low;
    }

    protected List<List<PoolPolicy>> PolicyList() {
        pooltype[] allpootype;
        ArrayList<List<PoolPolicy>> policylist = new ArrayList<List<PoolPolicy>>(pooltype.getNumOfPoolType());
        int index_pooltype = 0;
        for (pooltype hdphdt : allpootype = pooltype.getAllPoolType()) {
            performancelevel_pool[] allperfofpool;
            ArrayList<PoolPolicy> policylist_pooltype = new ArrayList<PoolPolicy>(performancelevel_pool.getNumOfPerformanceLevelOfPool());
            int[][] policytable_pooltype = this.policytable[hdphdt.getValue()];
            int index_perfofpool = 0;
            for (performancelevel_pool perfofpool : allperfofpool = performancelevel_pool.getAllPerformanceLevelOfPool()) {
                performancelevel_drive[] allperfofdrive;
                int[] policytable_perfofpool = policytable_pooltype[index_perfofpool];
                PoolPolicy hdp_policy = new PoolPolicy();
                hdp_policy.mPoolType = hdphdt;
                hdp_policy.mPerformanceLevelOfPool = perfofpool;
                boolean IsValidPolicy = false;
                int index_perfofdrive = 0;
                for (performancelevel_drive perfofdrve : allperfofdrive = performancelevel_drive.getAllPerformanceLevelOfDrive()) {
                    int policytable_perfofdrive = policytable_perfofpool[index_perfofdrive];
                    if (policytable_perfofdrive != 0) {
                        hdp_policy.mTierRatio.add(policytable_perfofdrive);
                        hdp_policy.mPerformanceLevelOfDriveType.add(perfofdrve);
                        IsValidPolicy = true;
                    }
                    ++index_perfofdrive;
                }
                if (!IsValidPolicy) {
                    hdp_policy = null;
                }
                policylist_pooltype.add(hdp_policy);
                ++index_perfofpool;
            }
            ++index_pooltype;
            policylist.add(policylist_pooltype);
        }
        this.mPolicyList = policylist;
        return this.mPolicyList;
    }

    protected pgpriority getPriorityOfPG(PoolVolSetOfPG poolvolofsetpg) {
        long lThresholdOfFreeSpace = 0L;
        long lMaxldevcap = 0L;
        if (poolvolofsetpg.mSystemTypeOfPG == systemtype.OPEN) {
            lThresholdOfFreeSpace = mMinLdevCapacity;
            lMaxldevcap = mMaxLdevCapacity - mMinLdevCapacity;
        } else if (poolvolofsetpg.mSystemTypeOfPG == systemtype.MF) {
            lThresholdOfFreeSpace = mMinLdevCapacityMF;
            lMaxldevcap = mMaxLdevCapacityMF - mMinLdevCapacityMF;
        }
        long lFreeSpaceCap = poolvolofsetpg.mPGCap - poolvolofsetpg.mPoolVolsCap;
        int iDiffOfLdevtoPoolVolNum = poolvolofsetpg.mLdevsNum - poolvolofsetpg.mPoolVol.size();
        pgpriority pPriority = null;
        if (iDiffOfLdevtoPoolVolNum != 0 || poolvolofsetpg.mLdevsNum > 1024 || !poolvolofsetpg.mIsRSGOfPoolVols) {
            pPriority = poolvolofsetpg.mIsPGScattered ? pgpriority.PRIORITY8 : pgpriority.PRIORITY7;
        } else if (lFreeSpaceCap >= lThresholdOfFreeSpace) {
            pPriority = poolvolofsetpg.mIsPGScattered ? pgpriority.PRIORITY6 : pgpriority.PRIORITY3;
        } else if (poolvolofsetpg.mPoolVol.size() == 1) {
            pPriority = poolvolofsetpg.mIsPGScattered ? pgpriority.PRIORITY4 : pgpriority.PRIORITY1;
        } else {
            int poolvol_counter = 0;
            for (PoolVol poolvol : poolvolofsetpg.mPoolVol) {
                long poolvolcap = poolvol.mLdevDetail.getLLDEVLBASize();
                if (poolvolcap < lMaxldevcap) continue;
                ++poolvol_counter;
            }
            pPriority = poolvolofsetpg.mPoolVol.size() - poolvol_counter <= 1 ? (poolvolofsetpg.mIsPGScattered ? pgpriority.PRIORITY4 : pgpriority.PRIORITY1) : (poolvolofsetpg.mIsPGScattered ? pgpriority.PRIORITY5 : pgpriority.PRIORITY2);
        }
        poolvolofsetpg.mPGPriority = pPriority;
        return pPriority;
    }

    public SJcAutoPoolConfig(List<SJmoLdevDetail> data_open, List<SJmoLdevDetail> data_mf, List<SJmoPgDetail> data_pgdetail, List<SJmoPgLdevInfo> data_pgldev, List<SJmoPgScatteredInfo> data_pgscattered, SJmoRSGgetAllRsgs data_rsg) throws IllegalArgumentException {
        try {
            IllegalArgumentException IAexp_msg;
            ArrayList<SJmoRSGgetRsg> rsgs;
            PoolVol poolvol;
            this.mPolicyList = this.PolicyList();
            int SizeOfldev_map = 0;
            if (data_open == null && data_mf == null || data_open == null && data_mf != null && data_mf.size() == 0 || data_open != null && data_mf == null && data_open.size() == 0 || data_open.size() == 0 && data_mf.size() == 0) {
                String IAmsg = "SJmoLdevDetail=0";
                IllegalArgumentException IAexp_msg2 = new IllegalArgumentException(IAmsg);
                throw IAexp_msg2;
            }
            SizeOfldev_map = data_open == null && data_mf != null ? data_mf.size() : (data_open != null && data_mf == null ? data_open.size() : data_mf.size() + data_open.size());
            if (SizeOfldev_map != 0) {
                this.ldev_map = new LinkedHashMap<Integer, PoolVol>(SizeOfldev_map);
            }
            if (data_open != null) {
                for (SJmoLdevDetail ldev : data_open) {
                    poolvol = new PoolVol(ldev);
                    this.ldev_map.put(ldev.getIndex(), poolvol);
                }
            }
            if (data_mf != null) {
                for (SJmoLdevDetail ldev : data_mf) {
                    poolvol = new PoolVol(ldev);
                    this.ldev_map.put(ldev.getIndex(), poolvol);
                }
            }
            if ((rsgs = data_rsg.getRsgs()).size() == 0) {
                IllegalArgumentException IAexp_msg3 = new IllegalArgumentException();
                throw IAexp_msg3;
            }
            for (SJmoRSGgetRsg rsg : rsgs) {
                ArrayList<SJmoLdevIndex> ldevs = rsg.getLdevs();
                if (ldevs == null) continue;
                for (SJmoLdevIndex rsg_ldev : ldevs) {
                    PoolVol poolvol2 = this.ldev_map.get(rsg_ldev.getIndex());
                    if (poolvol2 == null) continue;
                    poolvol2.mRSGOfLdev = rsg.getRsgInfo().getRsgId();
                }
            }
            int SizeOfpg_map = data_pgdetail.size();
            if (data_pgdetail.size() == 0) {
                IAexp_msg = new IllegalArgumentException();
                throw IAexp_msg;
            }
            this.pg_map = new LinkedHashMap<Integer, PoolVolSetOfPG>(SizeOfpg_map);
            for (SJmoPgDetail pg : data_pgdetail) {
                PoolVolSetOfPG pg_poolvol = new PoolVolSetOfPG(pg);
                this.pg_map.put(pg.getIndex(), pg_poolvol);
            }
            if (data_pgldev.size() == 0) {
                IAexp_msg = new IllegalArgumentException();
                throw IAexp_msg;
            }
            for (SJmoPgLdevInfo pgldev : data_pgldev) {
                PoolVolSetOfPG poolvolsetofpg = this.pg_map.get(pgldev.getIndex());
                ArrayList ldevlist = pgldev.getAlLdevIndex();
                int ldevsnum = ldevlist.size();
                if (ldevsnum == 0) {
                    poolvolsetofpg.mIsUsable = false;
                }
                poolvolsetofpg.mLdevsNum = ldevsnum;
                for (SJmoLdevIndex ldev : ldevlist) {
                    PoolVol poolvol3 = this.ldev_map.get(ldev.getIndex());
                    if (poolvol3 == null) continue;
                    poolvolsetofpg.setPoolVol(poolvol3);
                }
            }
            if (data_pgscattered != null) {
                for (SJmoPgScatteredInfo pgscatt : data_pgscattered) {
                    PoolVolSetOfPG poolvolsetofpg;
                    ArrayList pglist = pgscatt.getAlPgIndex();
                    int pglistsNum = pglist.size();
                    if (pglistsNum == 0 || (poolvolsetofpg = this.pg_map.get(pgscatt.getIndex())) == null) continue;
                    for (SJmoPgIndex pg : pglist) {
                        PoolVolSetOfPG child = this.pg_map.get(pg.getIndex());
                        if (child == null) continue;
                        poolvolsetofpg.setScatteredPGstoParentPG(child);
                    }
                }
            }
            this.mPGSetTree = new PGSet(null);
            this.mPGSetTree.mPGList = new PGSet[systemtype.getNumOfSystemType()];
            Set<Integer> pglist = null;
            if (this.pg_map.size() != 0) {
                pglist = this.pg_map.keySet();
            }
            for (Integer pgindex : pglist) {
                int PG_pgpriority;
                PoolVolSetOfPG poolvolsetofpg = this.pg_map.get(pgindex);
                if (!poolvolsetofpg.mIsUsable || (PG_pgpriority = this.getPriorityOfPG(poolvolsetofpg).getValue()) > pgpriority.mSupportRangeOfPriority) continue;
                this.mPGSetTree.mPoolVolsCap += poolvolsetofpg.mPoolVolsCap;
                int PG_systemtype = poolvolsetofpg.mSystemTypeOfPG.getValue();
                if (this.mPGSetTree.mPGList[PG_systemtype] == null) {
                    this.mPGSetTree.mPGList[PG_systemtype] = new PGSet(this.mPGSetTree);
                    this.mPGSetTree.mPGList[PG_systemtype].mPGList = new PGSet[mMaxRSGNum];
                }
                PGSet PGSet_systemtype = this.mPGSetTree.mPGList[PG_systemtype];
                PGSet_systemtype.mPoolVolsCap += poolvolsetofpg.mPoolVolsCap;
                int PG_RSG = poolvolsetofpg.mRSGOfPG;
                if (PGSet_systemtype.mPGList[PG_RSG] == null) {
                    PGSet_systemtype.mPGList[PG_RSG] = new PGSet(PGSet_systemtype);
                    PGSet_systemtype.mPGList[PG_RSG].mPGList = new PGSet[drivetype.getNumOfDriveType()];
                }
                PGSet PGSet_RSG = PGSet_systemtype.mPGList[PG_RSG];
                PGSet_RSG.mPoolVolsCap += poolvolsetofpg.mPoolVolsCap;
                int PG_drivetype = poolvolsetofpg.mDriveType.getValue();
                if (PGSet_RSG.mPGList[PG_drivetype] == null) {
                    PGSet_RSG.mPGList[PG_drivetype] = new PGSet(PGSet_RSG);
                    PGSet_RSG.mPGList[PG_drivetype].mPGList = new PGSet[raidlevel.getNumOfRAIDLevel()];
                }
                PGSet PGSet_drivetype = PGSet_RSG.mPGList[PG_drivetype];
                PGSet_drivetype.mPoolVolsCap += poolvolsetofpg.mPoolVolsCap;
                int PG_raidlevel = poolvolsetofpg.mRAIDLevel.getValue();
                if (PGSet_drivetype.mPGList[PG_raidlevel] == null) {
                    PGSet_drivetype.mPGList[PG_raidlevel] = new PGSet(PGSet_drivetype);
                    PGSet_drivetype.mPGList[PG_raidlevel].mPGList = new PGSet[pgpriority.mNumOfSupportPGPriprity];
                }
                PGSet PGSet_raidlevel = PGSet_drivetype.mPGList[PG_raidlevel];
                PGSet_raidlevel.mPoolVolsCap += poolvolsetofpg.mPoolVolsCap;
                if (PGSet_raidlevel.mPGList[PG_pgpriority] == null) {
                    PGSet_raidlevel.mPGList[PG_pgpriority] = new PGSet(PGSet_raidlevel);
                }
                PGSet PGSet_pgpriority = PGSet_raidlevel.mPGList[PG_pgpriority];
                PGSet_pgpriority.mPoolVolsCap += poolvolsetofpg.mPoolVolsCap;
                PGSet_pgpriority.setPoolVolSetOfPG(poolvolsetofpg);
                poolvolsetofpg.mPriorityPGList = PGSet_pgpriority;
            }
            if (this.mPGSetTree.mPGList[systemtype.OPEN.getValue()] == null && this.mPGSetTree.mPGList[systemtype.MF.getValue()] == null) {
                String IAmsg = "NO Available Resource by Ease of HDP/HDT Setting";
                IllegalArgumentException IAexp_msg4 = new IllegalArgumentException(IAmsg);
                throw IAexp_msg4;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String ldevdata_open = data_open == null ? "null" : "" + data_open.size();
            String ldevdata_mf = data_mf == null ? "null" : "" + data_mf.size();
            String pgdata = data_pgdetail == null ? "null" : "" + data_pgdetail.size();
            String pgldevdata = data_pgldev == null ? "null" : "" + data_pgldev.size();
            String pgscattdata = data_pgscattered == null ? "null" : "" + data_pgscattered.size();
            String rsgdata = data_rsg == null || data_rsg != null && data_rsg.getRsgs() == null ? "null" : "" + data_rsg.getRsgs().size();
            String exp_msg = "SJmoLdevDetail(OPEN)_" + ldevdata_open + "/" + "SJmoLdevDetail(MF)" + "_" + ldevdata_mf + "/" + "SJmoPgDetail" + "_" + pgdata + "/" + "SJmoPgLdevInfo" + "_" + pgldevdata + "/" + "SJmoPgScatteredInfo" + "_" + pgscattdata + "/" + "SJmoRSGgetRsgs" + "_" + rsgdata;
            IllegalArgumentException exp = new IllegalArgumentException(exp_msg, e);
            throw exp;
        }
    }

    public List<TierInfoSetOfPool> getPoolInfos(systemtype in_systemtype, pooltype in_pooltype, int in_rsg_num, performancelevel_pool in_pool_performance, long in_pool_capacity) {
        ArrayList<TierInfoSetOfPool> TierInfoSetOfPoolList = new ArrayList<TierInfoSetOfPool>();
        ArrayList<List<TierInfo>> tierinfoLists_Pool = new ArrayList<List<TierInfo>>();
        List<TierInfo> tierinfolist = null;
        try {
            if (in_rsg_num < 0 || in_pool_capacity <= 0L) {
                return TierInfoSetOfPoolList;
            }
            List<PoolPolicy> poolpolicy = this.mPolicyList.get(in_pooltype.getValue());
            PoolPolicy policy_ofperformance = poolpolicy.get(in_pool_performance.getValue());
            if (policy_ofperformance == null) {
                return TierInfoSetOfPoolList;
            }
            for (int index = 0; index < policy_ofperformance.mPerformanceLevelOfDriveType.size(); ++index) {
                long tier_capacity = 0L;
                tier_capacity = in_systemtype == systemtype.OPEN ? in_pool_capacity * mlocalCapConverterLBA_KB * (long)policy_ofperformance.mTierRatio.get(index).intValue() / (long)mlocalRatiotoInteger : in_pool_capacity * mlocalCapConverterLBA_Cyl * (long)policy_ofperformance.mTierRatio.get(index).intValue() / (long)mlocalRatiotoInteger;
                if (tier_capacity == 0L) {
                    tier_capacity = 1L;
                }
                if (index == policy_ofperformance.mPerformanceLevelOfDriveType.size() - 1) {
                    tier_capacity = in_systemtype == systemtype.OPEN ? (tier_capacity += mSystemCapacityOPEN) : (tier_capacity += mSystemCapacityMF);
                }
                performancelevel_drive performancelevel_drive2 = policy_ofperformance.mPerformanceLevelOfDriveType.get(index);
                tierinfolist = this.getTierInfo(in_systemtype, in_rsg_num, performancelevel_drive2, tier_capacity);
                tierinfoLists_Pool.add(tierinfolist);
            }
            if (tierinfoLists_Pool.size() != policy_ofperformance.mPerformanceLevelOfDriveType.size()) {
                return TierInfoSetOfPoolList;
            }
            ArrayList iteratorlist = new ArrayList(tierinfoLists_Pool.size());
            ArrayList nextList = new ArrayList(iteratorlist.size());
            for (List list : tierinfoLists_Pool) {
                iteratorlist.add(list.iterator());
            }
            for (Iterator iterator : iteratorlist) {
                nextList.add(iterator.next());
            }
            block5: do {
                TierInfoSetOfPool tierinfo_ofpool = new TierInfoSetOfPool(policy_ofperformance);
                for (TierInfo tmp_tier : nextList) {
                    tierinfo_ofpool.setTierInfo(tmp_tier, in_systemtype);
                }
                if (tierinfo_ofpool.mTiersInfoList.size() != policy_ofperformance.mPerformanceLevelOfDriveType.size()) {
                    return TierInfoSetOfPoolList;
                }
                int n = tierinfo_ofpool.getAllPoolLDEVIndex().size();
                if ((long)n <= mMaxNumofPoolVOLsofPool) {
                    TierInfoSetOfPoolList.add(tierinfo_ofpool);
                }
                for (int index = iteratorlist.size() - 1; index >= 0; --index) {
                    if (((Iterator)iteratorlist.get(index)).hasNext()) {
                        nextList.set(index, ((Iterator)iteratorlist.get(index)).next());
                        continue block5;
                    }
                    if (index != 0) {
                        iteratorlist.set(index, ((List)tierinfoLists_Pool.get(index)).iterator());
                        nextList.set(index, ((Iterator)iteratorlist.get(index)).next());
                        continue;
                    }
                    nextList.set(index, null);
                }
            } while (nextList.get(0) != null);
        }
        catch (Exception e) {
            TierInfoSetOfPoolList.clear();
        }
        return TierInfoSetOfPoolList;
    }

    public List<TierInfo> getTierInfo(systemtype in_systemtype, int in_rsg_num, performancelevel_drive in_performancelevel, long in_tier_capacity) {
        LinkedList<TierInfo> tierinfoList = new LinkedList<TierInfo>();
        try {
            if (in_tier_capacity <= 0L) {
                return tierinfoList;
            }
            drivetype[] drivetypelist = drivetype.getDrivetypeOfPerformanceLevel(in_performancelevel);
            PGSet SelectedPGSet = this.mPGSetTree.mPGList[in_systemtype.getValue()].mPGList[in_rsg_num];
            for (drivetype dt : drivetypelist) {
                int in_drivetype_Index = dt.getValue();
                PGSet in_drivetype = SelectedPGSet.mPGList[in_drivetype_Index];
                if (in_drivetype == null || in_drivetype.mPoolVolsCap < in_tier_capacity) continue;
                for (PGSet in_raidlevel : in_drivetype.mPGList) {
                    if (in_raidlevel == null || in_raidlevel.mPoolVolsCap < in_tier_capacity) continue;
                    long tmp_capcity = in_tier_capacity;
                    TierInfo tierinfo = new TierInfo();
                    tierinfo.mPerfomanceLevelOfDriveType = in_performancelevel;
                    for (int iPriority = 0; iPriority <= pgpriority.mSupportRangeOfPriority; ++iPriority) {
                        PGSet in_pgpriority = in_raidlevel.mPGList[iPriority];
                        if (in_pgpriority == null || in_pgpriority.mPoolVolsCap <= 0L) continue;
                        tierinfo.mCapList[iPriority] = in_pgpriority.mPoolVolsCap;
                        PoolVolSetOfPG tmp_pg = null;
                        for (PoolVolSetOfPG pg : in_pgpriority.mPoolVolSetOfPGList) {
                            if (!pg.mIsUsable) continue;
                            if (tmp_capcity <= pg.mPoolVolsCap) {
                                if (tmp_pg == null || tmp_pg.mPoolVolsCap > pg.mPoolVolsCap) {
                                    tmp_pg = pg;
                                }
                            } else {
                                if (tmp_pg != null) break;
                                tierinfo.mCap += pg.mPoolVolsCap;
                                tierinfo.mPGList.add(pg);
                                int n = iPriority;
                                tierinfo.mUsedCapList[n] = tierinfo.mUsedCapList[n] + pg.mPoolVolsCap;
                                tmp_capcity -= pg.mPoolVolsCap;
                            }
                            if (tmp_capcity > 0L) continue;
                            break;
                        }
                        if (tmp_pg != null) {
                            tierinfo.mCap += tmp_pg.mPoolVolsCap;
                            tierinfo.mPGList.add(tmp_pg);
                            int n = iPriority;
                            tierinfo.mUsedCapList[n] = tierinfo.mUsedCapList[n] + tmp_pg.mPoolVolsCap;
                            tmp_capcity -= tmp_pg.mPoolVolsCap;
                            tmp_pg = null;
                        }
                        if (tmp_capcity <= 0L) break;
                    }
                    if (tmp_capcity > 0L) continue;
                    ListIterator iterator = tierinfoList.listIterator();
                    boolean bIsUpperPriority = false;
                    while (iterator.hasNext()) {
                        int index;
                        TierInfo tmp_tierinfo = (TierInfo)iterator.next();
                        boolean bSameCofiguration = true;
                        for (index = tmp_tierinfo.mUsedCapList.length - 1; index > 0; --index) {
                            if (tierinfo.mUsedCapList[index] < tmp_tierinfo.mUsedCapList[index]) {
                                bIsUpperPriority = true;
                                bSameCofiguration = false;
                                break;
                            }
                            if (tierinfo.mUsedCapList[index] > tmp_tierinfo.mUsedCapList[index]) {
                                bIsUpperPriority = false;
                                bSameCofiguration = false;
                                break;
                            }
                            bSameCofiguration = true;
                        }
                        if (bSameCofiguration) {
                            for (index = 0; index < tmp_tierinfo.mCapList.length; ++index) {
                                if (tierinfo.mCapList[index] >= tmp_tierinfo.mCapList[index]) continue;
                                bIsUpperPriority = true;
                                break;
                            }
                        }
                        if (!bIsUpperPriority) continue;
                        tierinfoList.add(iterator.previousIndex(), tierinfo);
                        break;
                    }
                    if (bIsUpperPriority) continue;
                    tierinfoList.add(tierinfo);
                }
            }
        }
        catch (Exception e) {
            tierinfoList.clear();
        }
        return tierinfoList;
    }

    public void setAddPoolVol(List<SJmoLdevIndex> LdevIndex_list) {
        boolean mIsChangeUnusable = false;
        if (LdevIndex_list != null) {
            for (SJmoLdevIndex ldevindex : LdevIndex_list) {
                this.setPoolVoltoPoolVolSetOfPG(ldevindex, mIsChangeUnusable);
            }
        }
    }

    public void setRemovePoolVol(List<SJmoLdevIndex> LdevIndex_list) {
        boolean mIsChangeUsable = true;
        if (LdevIndex_list != null) {
            for (SJmoLdevIndex ldevindex : LdevIndex_list) {
                this.setPoolVoltoPoolVolSetOfPG(ldevindex, mIsChangeUsable);
            }
        }
    }

    public void setAddPoolVol(SJmoLdevIndex LdevIndex) {
        boolean mIsChangeUnusable = false;
        if (LdevIndex != null) {
            this.setPoolVoltoPoolVolSetOfPG(LdevIndex, mIsChangeUnusable);
        }
    }

    public void setRemovePoolVol(SJmoLdevIndex LdevIndex) {
        boolean mIsChangeUsable = true;
        if (LdevIndex != null) {
            this.setPoolVoltoPoolVolSetOfPG(LdevIndex, mIsChangeUsable);
        }
    }

    protected void setPoolVoltoPoolVolSetOfPG(SJmoLdevIndex LdevIndex, boolean IsUsable) {
        PoolVol poolvolinfo = null;
        if (LdevIndex != null && (poolvolinfo = this.ldev_map.get(LdevIndex.getIndex())) != null && (IsUsable && !poolvolinfo.mIsUsable || !IsUsable && poolvolinfo.mIsUsable)) {
            poolvolinfo.mIsUsable = IsUsable;
            PoolVolSetOfPG poolvolsetofpg = poolvolinfo.mPoolVolSetOfPG;
            if (poolvolsetofpg != null && poolvolsetofpg.mPGPriority.mValue <= pgpriority.mSupportRangeOfPriority) {
                poolvolsetofpg.setRenewPoolVolSetOfPG(poolvolinfo, IsUsable);
                if (!IsUsable && poolvolsetofpg.mPoolVol.size() == poolvolsetofpg.mUsablePoolVolsNum + 1 || IsUsable && poolvolsetofpg.mPoolVol.size() == poolvolsetofpg.mUsablePoolVolsNum) {
                    poolvolsetofpg.mPriorityPGList.setRenewPGSet(poolvolsetofpg, poolvolinfo, IsUsable);
                }
            }
        }
    }

    public List<Integer> getAvailableRSGList(systemtype in_systemtype, pooltype in_pooltype) {
        ArrayList<Integer> AvailableRSG = new ArrayList<Integer>();
        int rsg_num = 0;
        PGSet systemtype_PGSet = this.mPGSetTree.mPGList[in_systemtype.getValue()];
        if (systemtype_PGSet == null) {
            return AvailableRSG;
        }
        for (PGSet rsg_pgset : systemtype_PGSet.mPGList) {
            if (rsg_pgset != null && in_pooltype.mValue == pooltype.HRT.mValue && (rsg_pgset.mPGList[drivetype.SSD.mValue] == null || rsg_pgset.mPGList[((drivetype)drivetype.SSD).mValue].mPoolVolsCap == 0L)) {
                rsg_pgset = null;
            }
            if (rsg_pgset != null && rsg_pgset.mPoolVolsCap > 0L) {
                AvailableRSG.add(rsg_num);
            }
            ++rsg_num;
        }
        return AvailableRSG;
    }

    public List<performancelevel_pool> getAvailablePerformanceOfPool(systemtype in_systemtype, int in_rsg_num, pooltype in_pooltype) {
        ArrayList<performancelevel_pool> AvailablePerformanceOfPool = new ArrayList<performancelevel_pool>(performancelevel_pool.getNumOfPerformanceLevelOfPool());
        if (in_rsg_num < 0 || in_rsg_num > mMaxRSGNum) {
            return AvailablePerformanceOfPool;
        }
        List<performancelevel_drive> availableperf_drive = this.getAvailablePerformanceOfDrive(in_systemtype, in_rsg_num, in_pooltype);
        if (availableperf_drive == null) {
            return AvailablePerformanceOfPool;
        }
        if (availableperf_drive.size() == performancelevel_drive.getNumOfPerformanceLevelOfDrive()) {
            List<PoolPolicy> policylist = this.mPolicyList.get(in_pooltype.getValue());
            for (PoolPolicy poolperf : policylist) {
                if (poolperf == null) continue;
                AvailablePerformanceOfPool.add(poolperf.mPerformanceLevelOfPool);
            }
            return AvailablePerformanceOfPool;
        }
        List<PoolPolicy> policylist = this.mPolicyList.get(in_pooltype.getValue());
        if (policylist != null) {
            for (int index = 0; index < policylist.size(); ++index) {
                PoolPolicy policy = policylist.get(index);
                if (policy == null) continue;
                int count = 0;
                for (performancelevel_drive driveperf_policy : policy.mPerformanceLevelOfDriveType) {
                    for (performancelevel_drive driveperf : availableperf_drive) {
                        if (driveperf_policy != driveperf || ++count != policy.mPerformanceLevelOfDriveType.size()) continue;
                        AvailablePerformanceOfPool.add(policy.mPerformanceLevelOfPool);
                    }
                }
            }
        }
        return AvailablePerformanceOfPool;
    }

    protected List<performancelevel_drive> getAvailablePerformanceOfDrive(systemtype in_systemtype, int in_rsg_num, pooltype in_pooltype) {
        performancelevel_drive[] allperf_drive;
        ArrayList<performancelevel_drive> AvailablePerformanceOfDrive = new ArrayList<performancelevel_drive>();
        if (in_rsg_num < 0 || in_rsg_num > mMaxRSGNum) {
            return AvailablePerformanceOfDrive;
        }
        PGSet performancelevel_PGSet = this.mPGSetTree.mPGList[in_systemtype.getValue()].mPGList[in_rsg_num];
        if (performancelevel_PGSet == null || performancelevel_PGSet.mPGList == null) {
            return AvailablePerformanceOfDrive;
        }
        block0: for (performancelevel_drive driveperf : allperf_drive = performancelevel_drive.getAllPerformanceLevelOfDrive()) {
            drivetype[] _drivetypeofperf;
            for (drivetype _dt : _drivetypeofperf = drivetype.getDrivetypeOfPerformanceLevel(driveperf)) {
                if (performancelevel_PGSet.mPGList[_dt.getValue()] == null || performancelevel_PGSet.mPGList[_dt.getValue()].mPoolVolsCap <= 0L) continue;
                AvailablePerformanceOfDrive.add(driveperf);
                continue block0;
            }
        }
        return AvailablePerformanceOfDrive;
    }

    public List<LimitsOfCapacity> getAvailableLimitsOfCapacity(systemtype in_systemtype, int in_rsg_num, pooltype in_pooltype, List<performancelevel_pool> in_performancelevel) {
        ArrayList<LimitsOfCapacity> AvailableLimitsOfCapacityList = new ArrayList<LimitsOfCapacity>();
        try {
            performancelevel_drive[] allperf_drive;
            long[] MaxCaps = new long[mMaxTierNumber];
            long systemcapacity = 0L;
            systemcapacity = in_systemtype == systemtype.OPEN ? mSystemCapacityOPEN : mSystemCapacityMF;
            PGSet rsg_PGSet = this.mPGSetTree.mPGList[in_systemtype.getValue()].mPGList[in_rsg_num];
            for (performancelevel_drive driveperf : allperf_drive = performancelevel_drive.getAllPerformanceLevelOfDrive()) {
                long MaxCapOfPGSet = 0L;
                PGSet Max_PGSet = null;
                for (drivetype _drivetype : drivetype.getDrivetypeOfPerformanceLevel(driveperf)) {
                    PGSet drivetype_PGSet = rsg_PGSet.mPGList[_drivetype.getValue()];
                    if (drivetype_PGSet == null || drivetype_PGSet.mPoolVolsCap <= 0L) continue;
                    for (int index = 0; index < raidlevel.getNumOfRAIDLevel(); ++index) {
                        PGSet raidlevel_PGSet = drivetype_PGSet.mPGList[index];
                        if (raidlevel_PGSet == null || raidlevel_PGSet.mPoolVolsCap <= 0L) continue;
                        long PGSetCap_raidlevel = raidlevel_PGSet.mPoolVolsCap;
                        PGSet PGSet_PGSet = raidlevel_PGSet;
                        if (MaxCapOfPGSet == 0L) {
                            MaxCapOfPGSet = PGSetCap_raidlevel;
                        }
                        if (PGSetCap_raidlevel < MaxCapOfPGSet) continue;
                        MaxCapOfPGSet = PGSetCap_raidlevel;
                        Max_PGSet = PGSet_PGSet;
                    }
                }
                long poolpages = 0L;
                byte dp = 2;
                boolean managepage = false;
                if (Max_PGSet != null && MaxCapOfPGSet != 0L) {
                    poolpages = SJctrPoolUtility.getCreatePoolPages(dp, in_systemtype.getValue(), Max_PGSet.getLdevDetail(), managepage);
                    long poolcapacity = 0L;
                    poolcapacity = in_systemtype == systemtype.OPEN ? poolpages * mDPPOOL_PageSize * mlocalCapConverterLBA_KB : poolpages * mMFDPPOOL_PageSize * mlocalCapConverterLBA_KB;
                    MaxCapOfPGSet = poolcapacity;
                }
                MaxCaps[driveperf.getValue()] = MaxCapOfPGSet;
            }
            List<PoolPolicy> policylist = this.mPolicyList.get(in_pooltype.getValue());
            for (performancelevel_pool poolperf : in_performancelevel) {
                PoolPolicy policy = policylist.get(poolperf.getValue());
                if (policy == null) continue;
                LimitsOfCapacity AvailableLimitsOfCapacity = new LimitsOfCapacity();
                AvailableLimitsOfCapacity.mPerformanceOfPool = poolperf;
                int tiernum = policy.mPerformanceLevelOfDriveType.size();
                int index = 0;
                long tmp_ = 0L;
                for (performancelevel_drive perfofpool : policy.mPerformanceLevelOfDriveType) {
                    long syscap = 0L;
                    if (index == tiernum - 1) {
                        syscap = systemcapacity;
                    }
                    long tmp_ratio = (MaxCaps[perfofpool.getValue()] - syscap) * (long)mlocalRatiotoInteger / (long)policy.mTierRatio.get(index).intValue();
                    if (index == 0) {
                        tmp_ = tmp_ratio;
                        ++index;
                        continue;
                    }
                    if (index <= 0) continue;
                    if (tmp_ratio < tmp_) {
                        tmp_ = tmp_ratio;
                    }
                    ++index;
                }
                long uppercap = 0L;
                long lowercap = 0L;
                if (in_systemtype == systemtype.OPEN) {
                    uppercap = tmp_ / mlocalCapConverterLBA_KB;
                    lowercap = (mMinLdevPages * mDPPOOL_PageSize * mlocalCapConverterLBA_KB * (long)tiernum - mSystemCapacityOPEN) / mlocalCapConverterLBA_KB;
                } else {
                    uppercap = tmp_ / mlocalCapConverterLBA_Cyl;
                    lowercap = (mMinLdevPagesMF * mMFDPPOOL_PageSize * mlocalCapConverterLBA_KB * (long)tiernum - mSystemCapacityMF) / mlocalCapConverterLBA_Cyl;
                }
                AvailableLimitsOfCapacity.mUpperLimit = uppercap;
                AvailableLimitsOfCapacity.mLowerLimit = lowercap;
                if (AvailableLimitsOfCapacity.mUpperLimit < AvailableLimitsOfCapacity.mLowerLimit) {
                    AvailableLimitsOfCapacity = new LimitsOfCapacity();
                }
                AvailableLimitsOfCapacityList.add(AvailableLimitsOfCapacity);
            }
        }
        catch (Exception e) {
            LimitsOfCapacity exp_AvailableLimitsOfCapacity = new LimitsOfCapacity();
            AvailableLimitsOfCapacityList.clear();
            exp_AvailableLimitsOfCapacity.mUpperLimit = 0L;
            exp_AvailableLimitsOfCapacity.mLowerLimit = 0L;
            AvailableLimitsOfCapacityList.add(exp_AvailableLimitsOfCapacity);
        }
        return AvailableLimitsOfCapacityList;
    }

    public class LimitsOfCapacity {
        long mUpperLimit = 0L;
        long mLowerLimit = 0L;
        performancelevel_pool mPerformanceOfPool = null;

        LimitsOfCapacity() {
        }

        public long getUpperLimit() {
            return this.mUpperLimit;
        }

        public long getLowerLimit() {
            return this.mLowerLimit;
        }
    }

    public class TierInfoSetOfPool {
        List<TierInfo> mTiersInfoList;
        List<Integer> mTierRatio;
        PoolPolicy mPoolPolicy;
        long mTotalCap;
        long mAvailableUseTotalCap;
        int mTiernum;
        long lPoolPages;

        public TierInfoSetOfPool(PoolPolicy poolpolicy) {
            if (poolpolicy == null) {
                return;
            }
            this.mPoolPolicy = poolpolicy;
            this.mTiernum = poolpolicy.mPerformanceLevelOfDriveType.size();
            this.mTiersInfoList = new ArrayList<TierInfo>(this.mTiernum);
            this.mTierRatio = new ArrayList<Integer>(this.mTiernum);
            this.mTotalCap = 0L;
            this.lPoolPages = 0L;
        }

        public void setTierInfo(TierInfo tierinfo, systemtype in_systemtype) {
            if (tierinfo == null || tierinfo.mCap == 0L || this.mTiernum == 0) {
                return;
            }
            this.mTiersInfoList.add(tierinfo);
            this.mTotalCap += tierinfo.mCap;
            if (this.mTiersInfoList.size() == this.mTiernum) {
                int ratioadj = 0;
                int index = 0;
                int tierratio = 0;
                for (TierInfo tierinfo_list : this.mTiersInfoList) {
                    if (index != this.mTiernum - 1) {
                        tierratio = (int)((double)tierinfo_list.mCap / (double)this.mTotalCap * (double)mlocalRatiotoInteger);
                        ratioadj += tierratio;
                    } else {
                        tierratio = mlocalRatiotoInteger - ratioadj;
                    }
                    ++index;
                    this.mTierRatio.add(tierratio);
                }
                long poolpages = 0L;
                byte dp = 2;
                for (TierInfo tmpTierInfo : this.mTiersInfoList) {
                    boolean managepage = tmpTierInfo == tierinfo;
                    poolpages += SJctrPoolUtility.getCreatePoolPages(dp, in_systemtype.getValue(), tmpTierInfo.getLdevDetail(), managepage);
                }
                this.lPoolPages = poolpages;
                long poolcapacity = 0L;
                poolcapacity = in_systemtype == systemtype.OPEN ? poolpages * mDPPOOL_PageSize : poolpages * mMFDPPOOL_PageSize * mlocalCapConverterLBA_KB / mlocalCapConverterLBA_Cyl;
                this.mAvailableUseTotalCap = poolcapacity;
            }
        }

        public long getTotalPoolPages() {
            return this.lPoolPages;
        }

        public long getTotalCapa() {
            return this.mAvailableUseTotalCap;
        }

        public List<Integer> getTierRatio() {
            return this.mTierRatio;
        }

        public List<TierInfo> getTierList() {
            if (this.mTiersInfoList == null) {
                ArrayList<TierInfo> clearlist = new ArrayList<TierInfo>();
                return clearlist;
            }
            return this.mTiersInfoList;
        }

        public List<SJmoLdevIndex> getAllPoolLDEVIndex() {
            ArrayList<SJmoLdevIndex> ldevindex_list = new ArrayList<SJmoLdevIndex>();
            if (this.mTiersInfoList == null) {
                return ldevindex_list;
            }
            for (TierInfo tierinfo : this.mTiersInfoList) {
                ldevindex_list.addAll(tierinfo.getLdevIndex());
            }
            return ldevindex_list;
        }
    }

    public class TierInfo {
        long mCap;
        List<PoolVolSetOfPG> mPGList = new ArrayList<PoolVolSetOfPG>();
        long[] mCapList = new long[pgpriority.mSupportRangeOfPriority + 1];
        long[] mUsedCapList = new long[pgpriority.mSupportRangeOfPriority + 1];
        performancelevel_drive mPerfomanceLevelOfDriveType;

        public List<SJmoLdevIndex> getLdevIndex() {
            ArrayList<SJmoLdevIndex> ldevlist = new ArrayList<SJmoLdevIndex>();
            if (this.mPGList == null) {
                return ldevlist;
            }
            for (PoolVolSetOfPG pg : this.mPGList) {
                for (PoolVol poolvol : pg.mPoolVol) {
                    ldevlist.add(poolvol.mLdevDetail);
                }
            }
            return ldevlist;
        }

        public List<SJmoLdevDetail> getLdevDetail() {
            ArrayList<SJmoLdevDetail> ldevlist = new ArrayList<SJmoLdevDetail>();
            if (this.mPGList == null) {
                return ldevlist;
            }
            for (PoolVolSetOfPG pg : this.mPGList) {
                for (PoolVol poolvol : pg.mPoolVol) {
                    ldevlist.add(poolvol.mLdevDetail);
                }
            }
            return ldevlist;
        }

        public List<drivetype> getDriveTypeOfTier() {
            ArrayList<drivetype> drivetypeoftier = new ArrayList<drivetype>();
            if (this.mPGList == null) {
                return drivetypeoftier;
            }
            drivetypeoftier.add(this.mPGList.get((int)0).mDriveType);
            return drivetypeoftier;
        }

        public List<raidlevel> getRAIDLevelOfTier() {
            ArrayList<raidlevel> raidleveloftier = new ArrayList<raidlevel>();
            if (this.mPGList == null) {
                return raidleveloftier;
            }
            raidleveloftier.add(this.mPGList.get((int)0).mRAIDLevel);
            return raidleveloftier;
        }
    }

    class PoolVol {
        boolean mIsUsable = true;
        int mRSGOfLdev;
        SJmoLdevDetail mLdevDetail;
        PoolVolSetOfPG mPoolVolSetOfPG;

        PoolVol(SJmoLdevDetail ldevdetail) {
            this.mLdevDetail = ldevdetail;
        }
    }

    class PoolVolSetOfPG {
        systemtype mSystemTypeOfPG;
        int mRSGOfPG;
        drivetype mDriveType;
        raidlevel mRAIDLevel;
        pgpriority mPGPriority;
        PGSet mPriorityPGList;
        long mPGCap;
        int mLdevsNum;
        long mPoolVolsCap;
        int mUsablePoolVolsNum;
        SJmoPgDetail mPgDetail;
        boolean mIsRSGOfPoolVols;
        boolean mIsUsable;
        long mPGCapOfpgScattered;
        int mLdevsNumOfpgScattered;
        long mPoolVolsCapOfpgScattered;
        int mUsablePoolVolsNumOfpgScattered;
        PoolVolSetOfPG mPgDetailOfpgScattered_Parent;
        List<PoolVolSetOfPG> mPgDetailsOfpgScattered;
        boolean mIsPGScattered;
        List<PoolVol> mPoolVol;

        PoolVolSetOfPG(SJmoPgDetail pgdetail) {
            this.mPGCap = pgdetail.getPGLBASize();
            this.mSystemTypeOfPG = systemtype.getSystemType(pgdetail);
            this.mRSGOfPG = -1;
            this.mDriveType = drivetype.getDriveType(pgdetail);
            this.mRAIDLevel = raidlevel.getRAIDLevel(pgdetail);
            this.mLdevsNum = 0;
            this.mPoolVolsCap = 0L;
            this.mUsablePoolVolsNum = 0;
            this.mPgDetail = pgdetail;
            this.mIsRSGOfPoolVols = true;
            this.mIsUsable = true;
            this.mPGCapOfpgScattered = 0L;
            this.mLdevsNumOfpgScattered = 0;
            this.mPoolVolsCapOfpgScattered = 0L;
            this.mUsablePoolVolsNumOfpgScattered = 0;
            this.mPgDetailOfpgScattered_Parent = null;
            this.mPgDetailsOfpgScattered = null;
            this.mIsPGScattered = false;
            this.mPoolVol = new ArrayList<PoolVol>();
            if (this.mPGCap <= 0L || this.mSystemTypeOfPG == null || this.mDriveType == null || this.mRAIDLevel == null) {
                this.mIsUsable = false;
            }
        }

        void setPoolVol(PoolVol poolvol) {
            this.mPoolVolsCap += poolvol.mLdevDetail.getLLDEVLBASize();
            if (poolvol.mLdevDetail.getLLDEVLBASize() <= 0L) {
                this.mIsUsable = false;
            }
            this.mPoolVol.add(poolvol);
            ++this.mUsablePoolVolsNum;
            poolvol.mPoolVolSetOfPG = this;
            if (this.mIsRSGOfPoolVols) {
                if (this.mPoolVol.size() == 1) {
                    this.mRSGOfPG = poolvol.mRSGOfLdev;
                } else if (this.mRSGOfPG != poolvol.mRSGOfLdev) {
                    this.mIsRSGOfPoolVols = false;
                    this.mRSGOfPG = -1;
                }
            }
        }

        void setScatteredPGstoParentPG(PoolVolSetOfPG poolvolsetofpg) {
            if (this.mPgDetailsOfpgScattered == null && !this.mIsPGScattered) {
                this.mPgDetailsOfpgScattered = new ArrayList<PoolVolSetOfPG>();
                this.mPGCapOfpgScattered += this.mPGCap;
                this.mLdevsNumOfpgScattered += this.mLdevsNum;
                this.mPoolVolsCapOfpgScattered += this.mPoolVolsCap;
                this.mUsablePoolVolsNumOfpgScattered += this.mUsablePoolVolsNum;
                this.mIsPGScattered = true;
            }
            if (poolvolsetofpg.mIsPGScattered) {
                String IAmsg = "Repeated Data";
                IllegalArgumentException IAexp_msg = new IllegalArgumentException(IAmsg);
                throw IAexp_msg;
            }
            this.mPgDetailsOfpgScattered.add(poolvolsetofpg);
            poolvolsetofpg.mPgDetailOfpgScattered_Parent = this;
            poolvolsetofpg.mIsPGScattered = true;
            this.mPGCapOfpgScattered += poolvolsetofpg.mPGCap;
            this.mLdevsNumOfpgScattered += poolvolsetofpg.mLdevsNum;
            this.mPoolVolsCapOfpgScattered += poolvolsetofpg.mPoolVolsCap;
            this.mUsablePoolVolsNumOfpgScattered += poolvolsetofpg.mUsablePoolVolsNum;
        }

        void setRenewPoolVolSetOfPG(PoolVol poolvol, boolean IsUsable) {
            int mark = IsUsable ? 1 : -1;
            this.mUsablePoolVolsNum += mark;
            this.mPoolVolsCap += poolvol.mLdevDetail.getLLDEVLBASize() * (long)mark;
            if (poolvol.mIsUsable) {
                if (this.mUsablePoolVolsNum != this.mPoolVol.size()) {
                    return;
                }
                this.mIsUsable = IsUsable;
            } else {
                this.mIsUsable = IsUsable;
            }
            if (this.mIsPGScattered) {
                if (this.mPgDetailsOfpgScattered != null) {
                    this.mPoolVolsCapOfpgScattered += poolvol.mLdevDetail.getLLDEVLBASize() * (long)mark;
                    this.mUsablePoolVolsNumOfpgScattered += mark;
                } else if (this.mPgDetailOfpgScattered_Parent != null) {
                    this.mPgDetailOfpgScattered_Parent.mPoolVolsCapOfpgScattered += poolvol.mLdevDetail.getLLDEVLBASize() * (long)mark;
                    this.mPgDetailOfpgScattered_Parent.mUsablePoolVolsNumOfpgScattered += mark;
                }
            }
        }
    }

    class PGSet {
        PGSet mParent;
        long mPoolVolsCap;
        PGSet[] mPGList;
        List<PoolVolSetOfPG> mPoolVolSetOfPGList;

        PGSet(PGSet _parent) {
            this.mParent = _parent;
            this.mPoolVolsCap = 0L;
        }

        void setPoolVolSetOfPG(PoolVolSetOfPG _pg) {
            if (this.mPoolVolSetOfPGList == null) {
                this.mPoolVolSetOfPGList = new LinkedList<PoolVolSetOfPG>();
                this.mPoolVolSetOfPGList.add(_pg);
            } else {
                int insertIndex = SJcAutoPoolConfig.insertIndexBinarySearch(this.mPoolVolSetOfPGList, _pg, PoolVolSetOfPGcomparator);
                this.mPoolVolSetOfPGList.add(insertIndex, _pg);
            }
        }

        List<SJmoLdevDetail> getLdevDetail() {
            ArrayList<SJmoLdevDetail> ldevlist = new ArrayList<SJmoLdevDetail>();
            if (this.mPGList == null) {
                return ldevlist;
            }
            for (PGSet pgset_priority : this.mPGList) {
                if (pgset_priority == null) continue;
                for (PoolVolSetOfPG pg : pgset_priority.mPoolVolSetOfPGList) {
                    if (pg == null || !pg.mIsUsable) continue;
                    for (PoolVol poolvol : pg.mPoolVol) {
                        if (!poolvol.mIsUsable) continue;
                        ldevlist.add(poolvol.mLdevDetail);
                    }
                }
            }
            return ldevlist;
        }

        long getMinPGCap() {
            long MinCapOfPG = 0L;
            int lastindex = this.mPoolVolSetOfPGList.size() - 1;
            ListIterator<PoolVolSetOfPG> iterator = this.mPoolVolSetOfPGList.listIterator(lastindex);
            PoolVolSetOfPG previous_pg = null;
            previous_pg = iterator.next();
            if (this.mPoolVolsCap > 0L) {
                while (iterator.hasPrevious() && !previous_pg.mIsUsable) {
                    previous_pg = iterator.previous();
                }
                if (previous_pg != null) {
                    MinCapOfPG = previous_pg.mPGCap;
                }
            }
            return MinCapOfPG;
        }

        void setRenewPGSet(PoolVolSetOfPG poolvolsetofpg, PoolVol poolvol, boolean IsUsable) {
            this.mPoolVolsCap = IsUsable ? (this.mPoolVolsCap += poolvolsetofpg.mPoolVolsCap) : (this.mPoolVolsCap -= poolvolsetofpg.mPoolVolsCap + poolvol.mLdevDetail.getLLDEVLBASize());
            if (this.mParent != null) {
                this.mParent.setRenewPGSet(poolvolsetofpg, poolvol, IsUsable);
            }
        }
    }

    public class PoolPolicy {
        pooltype mPoolType;
        performancelevel_pool mPerformanceLevelOfPool;
        List<Integer> mTierRatio = new ArrayList<Integer>(mMaxTierNumber);
        List<performancelevel_drive> mPerformanceLevelOfDriveType = new ArrayList<performancelevel_drive>(mMaxTierNumber);
    }

    public static enum performancelevel_pool {
        HIGHEST(0),
        HIGH(1),
        BALANCED(2),
        MIDDLE(3),
        LOW(4),
        LOWEST(5);

        private int mValue;
        private static int mNumOfperformancelevelOfPool;

        private performancelevel_pool(int _index) {
            this.mValue = _index;
        }

        public int getValue() {
            return this.mValue;
        }

        public static int getNumOfPerformanceLevelOfPool() {
            return mNumOfperformancelevelOfPool;
        }

        public static performancelevel_pool[] getAllPerformanceLevelOfPool() {
            performancelevel_pool[] all_poolperformance = new performancelevel_pool[performancelevel_pool.getNumOfPerformanceLevelOfPool()];
            Class<performancelevel_pool> pool_class = performancelevel_pool.class;
            all_poolperformance = (performancelevel_pool[])pool_class.getEnumConstants();
            return all_poolperformance;
        }

        static {
            mNumOfperformancelevelOfPool = performancelevel_pool.values().length;
        }
    }

    public static enum performancelevel_drive {
        HIGH(0),
        MIDDLE(1),
        LOW(2);

        private int mValue;
        private static int mNumOfperformancelevelOfDrive;

        private performancelevel_drive(int _index) {
            this.mValue = _index;
        }

        public int getValue() {
            return this.mValue;
        }

        public static int getNumOfPerformanceLevelOfDrive() {
            return mNumOfperformancelevelOfDrive;
        }

        public static performancelevel_drive[] getAllPerformanceLevelOfDrive() {
            performancelevel_drive[] all_driveperformance = new performancelevel_drive[performancelevel_drive.getNumOfPerformanceLevelOfDrive()];
            Class<performancelevel_drive> drive_class = performancelevel_drive.class;
            all_driveperformance = (performancelevel_drive[])drive_class.getEnumConstants();
            return all_driveperformance;
        }

        static {
            mNumOfperformancelevelOfDrive = performancelevel_drive.values().length;
        }
    }

    public static enum pgpriority {
        PRIORITY1(0),
        PRIORITY2(1),
        PRIORITY3(2),
        PRIORITY4(3),
        PRIORITY5(4),
        PRIORITY6(5),
        PRIORITY7(6),
        PRIORITY8(7);

        private int mValue;
        private static int mNumOfPGPriprity;
        protected static int mSupportRangeOfPriority;
        private static int mNumOfSupportPGPriprity;

        private pgpriority(int _index) {
            this.mValue = _index;
        }

        public int getValue() {
            return this.mValue;
        }

        public static int getNumOfPGPriority() {
            return mNumOfPGPriprity;
        }

        static {
            mNumOfPGPriprity = pgpriority.values().length;
            mSupportRangeOfPriority = PRIORITY6.getValue();
            mNumOfSupportPGPriprity = mSupportRangeOfPriority + 1;
        }
    }

    public static enum raidlevel {
        RAID1_2D2D(0, 8194),
        RAID5_3D1P(1, 8197),
        RAID5_7D1P(2, 8198),
        RAID6_6D2P(3, 8199),
        RAID6_14D2P(4, 8200),
        RAID5_4D1P(5, 8202),
        RAID5_6D1P(6, 8196),
        RAID6_12D2P(7, 8208);

        private int mValue;
        private int mRaidLevel;
        private static int mNumOfRAIDLevel;
        static Map<Integer, raidlevel> POOLUTIL2AUTOPOOLCFG_RAIDLEVEL;

        private raidlevel(int _index, int _raidLevel) {
            this.mValue = _index;
            this.mRaidLevel = _raidLevel;
        }

        public int getValue() {
            return this.mValue;
        }

        public int getRaidLevel() {
            return this.mRaidLevel;
        }

        public static int getNumOfRAIDLevel() {
            return mNumOfRAIDLevel;
        }

        public static raidlevel getRAIDLevel(SJmoPgDetail pgdetail) {
            int iRAIDLevel = pgdetail.getRaidLevel();
            return POOLUTIL2AUTOPOOLCFG_RAIDLEVEL.get(iRAIDLevel);
        }

        static {
            mNumOfRAIDLevel = raidlevel.values().length;
            POOLUTIL2AUTOPOOLCFG_RAIDLEVEL = new HashMap<Integer, raidlevel>(){
                {
                    this.put(8194, RAID1_2D2D);
                    this.put(8197, RAID5_3D1P);
                    this.put(8202, RAID5_4D1P);
                    this.put(8196, RAID5_6D1P);
                    this.put(8198, RAID5_7D1P);
                    this.put(8199, RAID6_6D2P);
                    this.put(8208, RAID6_12D2P);
                    this.put(8200, RAID6_14D2P);
                }
            };
        }
    }

    public static enum drivetype {
        SSD(0),
        SAS15K(1),
        SAS10K(2),
        SAS7_2K(3),
        SATA(4);

        private int mValue;
        private static int mNumOfDriveType;

        private drivetype(int _index) {
            this.mValue = _index;
        }

        public int getValue() {
            return this.mValue;
        }

        public static int getNumOfDriveType() {
            return mNumOfDriveType;
        }

        public static drivetype getDriveType(SJmoPgDetail pgdetail) {
            byte bDriveType = pgdetail.getDriveType();
            int iHddpm = pgdetail.getHDDrpm();
            drivetype dDriveTypeHddrpm = null;
            dDriveTypeHddrpm = bDriveType == 5 || bDriveType == 9 ? SSD : (bDriveType == 0 && iHddpm == 15000 ? SAS15K : (bDriveType == 0 && iHddpm == 10000 ? SAS10K : (bDriveType == 0 && iHddpm == 7200 ? SAS7_2K : (bDriveType == 1 ? SATA : null))));
            return dDriveTypeHddrpm;
        }

        public static drivetype[] getDrivetypeOfPerformanceLevel(performancelevel_drive in_performancelevel) {
            drivetype[] drivetypeofperflevel = null;
            if (in_performancelevel == performancelevel_drive.HIGH) {
                drivetypeofperflevel = new drivetype[]{SSD};
            } else if (in_performancelevel == performancelevel_drive.MIDDLE) {
                drivetypeofperflevel = new drivetype[]{SAS15K, SAS10K};
            } else if (in_performancelevel == performancelevel_drive.LOW) {
                drivetypeofperflevel = new drivetype[]{SAS7_2K, SATA};
            }
            return drivetypeofperflevel;
        }

        static {
            mNumOfDriveType = drivetype.values().length;
        }
    }

    public static enum pooltype {
        HDP(0),
        HDT(1),
        HRT(2);

        private int mValue;
        private static int mNumOfPoolType;

        private pooltype(int _index) {
            this.mValue = _index;
        }

        public int getValue() {
            return this.mValue;
        }

        public static int getNumOfPoolType() {
            return mNumOfPoolType;
        }

        public static pooltype[] getAllPoolType() {
            pooltype[] all_pooltype = new pooltype[pooltype.getNumOfPoolType()];
            Class<pooltype> pooltype_class = pooltype.class;
            all_pooltype = (pooltype[])pooltype_class.getEnumConstants();
            return all_pooltype;
        }

        static {
            mNumOfPoolType = pooltype.values().length;
        }
    }

    public static enum systemtype {
        OPEN(0),
        MF(1);

        private int mValue;
        private static int mNumOfSystemType;

        private systemtype(int _index) {
            this.mValue = _index;
        }

        public int getValue() {
            return this.mValue;
        }

        public static int getNumOfSystemType() {
            return mNumOfSystemType;
        }

        public static systemtype getSystemType(SJmoPgDetail pgdetail) {
            int iBaseEmulation = pgdetail.getBaseEmulationType();
            systemtype sSystemtType = null;
            if ((iBaseEmulation & 0xF00) == 512) {
                sSystemtType = OPEN;
            } else if ((iBaseEmulation & 0x90) == 144) {
                sSystemtType = MF;
            }
            return sSystemtType;
        }

        static {
            mNumOfSystemType = systemtype.values().length;
        }
    }
}

