/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrVVolUsedCapacityColumnFromPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoTierInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrVVolTier1UsedCapacityColumnFromPortLunTableKey
extends SJctrVVolUsedCapacityColumnFromPortLunTableKey {
    protected Map<Object, Object> modelDataMap = null;

    public SJctrVVolTier1UsedCapacityColumnFromPortLunTableKey(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("TIER1"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
        alList.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        int ldevDetailIndex;
        ArrayList<SJmoLdevIndex> retList = new ArrayList<SJmoLdevIndex>();
        SJctrPortLunTableKey tableKey = (SJctrPortLunTableKey)index;
        SJmoPortLunDetail portLuDetail = tableKey.getPortLunDetail();
        List<?> ldevDetailList = modelData.get(SJmoGetLdevDetail.class);
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        ldevIndex.setSLdkc(portLuDetail.getSLDKC());
        ldevIndex.setSCu(portLuDetail.getSCU());
        ldevIndex.setSLdev(portLuDetail.getSLDEV());
        if (this.modelDataMap == null) {
            this.modelDataMap = new HashMap<Object, Object>(this.getTable().getRowCount());
        }
        if ((ldevDetailIndex = Collections.binarySearch(ldevDetailList, ldevIndex)) >= 0) {
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(ldevDetailIndex);
            if (ldevDetail.getbAouVvol()) {
                List<?> dpvolList = modelData.get(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
                int dpVolDetailIndex = Collections.binarySearch(dpvolList, ldevDetail);
                if (dpVolDetailIndex >= 0) {
                    SJmoHDPRelation hdpRelData = (SJmoHDPRelation)dpvolList.get(dpVolDetailIndex);
                    List<?> poolDetailList = modelData.get(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
                    SJmoPoolIndex poolIdx = new SJmoPoolIndex();
                    poolIdx.setPoolId(hdpRelData.getIPoolId());
                    int poolDetailIndex = Collections.binarySearch(poolDetailList, poolIdx);
                    if (poolDetailIndex >= 0) {
                        boolean tierFlg;
                        SJmoPoolDetail poolDetail = (SJmoPoolDetail)poolDetailList.get(poolDetailIndex);
                        boolean bl = tierFlg = 0 != (poolDetail.getITierControlInfo() & 0x80);
                        if (tierFlg) {
                            retList.add(hdpRelData);
                            this.modelDataMap.put(index, hdpRelData);
                        } else {
                            retList.add(ldevDetail);
                            this.modelDataMap.put(index, ldevDetail);
                        }
                    }
                }
            } else {
                retList.add(ldevDetail);
                this.modelDataMap.put(index, ldevDetail);
            }
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        if (dataList != null && dataList.size() != 0) {
            Object toDispData = dataList.get(0);
            if (toDispData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelation = (SJmoHDPRelation)toDispData;
                String strCapaUnit = this.getUnitSelect();
                SJctrComUtility comUtil = this.getTable().getComUtility();
                strRtn = comUtil.getPoolUtility().toLUNTierUsedCapacityDisplay(hdpRelation, 1, strCapaUnit, comUtil);
            } else if (toDispData instanceof SJmoLdevDetail) {
                strRtn = SJctrPoolUtility.HAIFUN_STR;
            }
        }
        return strRtn;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long lRtn = -2L;
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        Object modelData = this.modelDataMap.get(primaryKeyObj);
        if (modelData != null) {
            if (modelData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelationData = (SJmoHDPRelation)modelData;
                long lPageSize = hdpRelationData.getLPageCapa();
                ArrayList<SJmoTierInfo> tierInfoList = hdpRelationData.getAlDpVolTierInfo();
                for (SJmoTierInfo tierInfo : tierInfoList) {
                    if (tierInfo.getSTierNum() != 1) continue;
                    long lTierUse = tierInfo.getLUseTier();
                    long lTierUseCapa = lPageSize * lTierUse;
                    lRtn = this.getTable().getComUtility().getCapacityUtility().valueOf(lTierUseCapa, SJctrCapacityUtility.UNIT.KB);
                    break;
                }
            } else if (modelData instanceof SJmoLdevDetail) {
                lRtn = SJctrPoolUtility.HAIFUN_NUM;
            }
        }
        return lRtn;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        long lRtn = -2L;
        Object primaryKeyObj = this.getPrimaryKeyObject(dat);
        Object modelData = this.modelDataMap.get(primaryKeyObj);
        if (modelData != null) {
            if (modelData instanceof SJmoHDPRelation) {
                SJmoHDPRelation hdpRelData = (SJmoHDPRelation)modelData;
                ArrayList<SJmoTierInfo> tierInfoList = hdpRelData.getAlDpVolTierInfo();
                for (SJmoTierInfo tierInfo : tierInfoList) {
                    if (tierInfo.getSTierNum() != 1) continue;
                    lRtn = tierInfo.getLUseTier();
                    break;
                }
            } else if (modelData instanceof SJmoLdevDetail) {
                lRtn = SJctrPoolUtility.HAIFUN_NUM;
            }
        }
        return lRtn;
    }
}

