/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.com.SJctrRemoteReplicationTargetPathInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUPathInfo;

public class SJctrRemoteTCPPortNumColumnFromRemotePathInfo
extends SJctrColumn {
    public SJctrRemoteTCPPortNumColumnFromRemotePathInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("TCP_PORT_NUMBER"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>(0);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJctrRemoteReplicationTargetPathInfo> retList = new ArrayList<SJctrRemoteReplicationTargetPathInfo>();
        SJmoRemoteReplicationRCUPathInfo rcuPathInfo = (SJmoRemoteReplicationRCUPathInfo)index;
        List<?> remotePathInfList = modelData.get(SJctrRemoteReplicationTargetPathInfo.class);
        if (remotePathInfList == null || remotePathInfList.isEmpty()) {
            return retList;
        }
        for (SJctrRemoteReplicationTargetPathInfo remotePathInfo : remotePathInfList) {
            if (remotePathInfo.getSPort() != rcuPathInfo.getSPort() || remotePathInfo.getRemotePortId() != rcuPathInfo.getIRCUPortNo()) continue;
            retList.add(remotePathInfo);
            break;
        }
        return retList;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long tcpNum = -1L;
        String tcpNumString = (String)dat.get(this.getMyFullPathKey());
        try {
            tcpNum = Long.parseLong(tcpNumString);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return tcpNum;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrRemoteReplicationTargetPathInfo pathInfo;
        String ret = "?";
        if (dataList != null && dataList.size() > 0 && (pathInfo = (SJctrRemoteReplicationTargetPathInfo)dataList.get(0)) != null) {
            if (pathInfo.getPortType() == 1) {
                int tcpPortNum = pathInfo.getITcpPortNumber();
                if (tcpPortNum != -1) {
                    ret = String.valueOf(tcpPortNum);
                }
            } else if (pathInfo.getPortType() == 0) {
                ret = "-";
            }
        }
        return ret;
    }
}

