/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.report;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.topwindow.report.SJctrReportInfoData;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;

public class SJctrColumnSubmittedTime
extends SJctrColumn {
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public SJctrColumnSubmittedTime(String key) {
        super(key);
    }

    @Override
    public int getSortType() {
        return 0;
    }

    @Override
    public int getFilterType() {
        return 8;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrReportInfoData reportinf = (SJctrReportInfoData)dataList.get(0);
        return reportinf.getSubmitTimeToString();
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        return new ArrayList<Class<? extends SJmoGetKind_IF>>(0);
    }

    @Override
    protected Comparator<Object> createObjectComparator() {
        return super.createObjectComparator();
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.setLabel(util.getGuidance("COMMON", "SUBMITTED_TIME"));
        super.initGuidance(util);
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long retValue = 0L;
        try {
            SJctrReportInfoData info = (SJctrReportInfoData)this.getPrimaryKeyObject(dat);
            String dateStr = info.getSubmitTimeToString();
            if (dateStr.length() > 0) {
                Date date = this.dateFormatter.parse(dateStr);
                retValue = date.getTime();
            }
        }
        catch (ParseException e) {
            this.getTable().getLogUty().putlog("getNumber", "DateFormat: yyyy/mm/dd hh:mm:ss", e, 30000);
        }
        return retValue;
    }
}

