/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.model;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrSelectableDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrEventListener;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrItemStateLintener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;

public class SJctrRadioButtonGroupDataModel
extends SJctrSimpleDataModel {
    private Integer allState;
    private final Set<String> radioButtonKey = new LinkedHashSet<String>();
    private String selection;

    public SJctrRadioButtonGroupDataModel() {
        this.initListener();
    }

    public void add(String key) {
        this.add(key, null);
    }

    public void add(String key, String label) {
        SJctrSelectableDataObject selectable = this.createRadioButton(label);
        ((SJctrDataObject)this.getManageData()).setData(key, selectable);
        this.radioButtonKey.add(key);
    }

    public void addItemSelectListener(SJctrItemSelectListener listener) {
        this.addEventListener(listener);
    }

    @Override
    public void addItemStateChangeLintener(SJctrItemStateLintener listener) {
        super.addItemStateChangeLintener(listener);
    }

    public String getSelect() {
        return this.selection;
    }

    public boolean isEnable(String key) {
        boolean result = false;
        SJctrSelectableDataObject selectable = this.getRadioButton(key);
        if (selectable != null) {
            result = SJctrSelectableDataModel.isEnable(selectable);
        }
        return result;
    }

    public boolean isSelect(String key) {
        boolean result = false;
        if (this.selection != null) {
            result = this.selection.equals(key);
        }
        return result;
    }

    public boolean isVisible(String key) {
        boolean result = false;
        SJctrSelectableDataObject selectable = this.getRadioButton(key);
        if (selectable != null) {
            result = SJctrSelectableDataModel.isVisible(selectable);
        }
        return result;
    }

    public void setEnable(boolean flg) {
        Integer state = flg ? SJctrSelectableDataObject.VISIBLE_ACTIVE : SJctrSelectableDataObject.VISIBLE_INACTIVE;
        this.setState(state);
    }

    public void setEnable(String key, boolean flg) {
        Integer state = flg ? SJctrSelectableDataObject.VISIBLE_ACTIVE : SJctrSelectableDataObject.VISIBLE_INACTIVE;
        this.setState(key, state);
    }

    public void setSelect(String key) {
        boolean newResult;
        SJctrSelectableDataObject oldSelectable;
        boolean oldResult;
        SJctrSelectableDataObject newSelectable = this.getRadioButton(key);
        if (newSelectable == null) {
            return;
        }
        if (this.selection != null && !this.selection.equals(key) && (oldResult = SJctrSelectableDataModel.setSelect(oldSelectable = this.getRadioButton(this.selection), false))) {
            this.fireItemSelected();
        }
        if (newResult = SJctrSelectableDataModel.setSelect(newSelectable, true)) {
            this.selection = key;
            this.fireItemSelected();
        }
    }

    public void setState(Integer state) {
        this.allState = state;
        for (String key : this.radioButtonKey) {
            Object data = ((SJctrDataObject)this.getManageData()).getData(key);
            if (!(data instanceof SJctrSelectableDataObject)) continue;
            SJctrSelectableDataObject selectable = (SJctrSelectableDataObject)data;
            SJctrSelectableDataModel.setState(selectable, this.allState);
        }
    }

    public void setState(String key, Integer state) {
        SJctrSelectableDataObject selectable = this.getRadioButton(key);
        if (selectable != null) {
            SJctrSelectableDataModel.setState(selectable, state);
        }
    }

    public void setVisible(boolean flg) {
        Integer state = flg ? SJctrSelectableDataObject.VISIBLE_ACTIVE : SJctrSelectableDataObject.VISIBLE_INVISIBLE;
        this.setState(state);
    }

    public void setVisible(String key, boolean flg) {
        Integer state = flg ? SJctrSelectableDataObject.VISIBLE_ACTIVE : SJctrSelectableDataObject.VISIBLE_INVISIBLE;
        this.setState(key, state);
    }

    protected void fireItemSelected() {
        SJctrItemSelectEvent<SJctrSelectableDataObject> event = null;
        this.setDirty();
        for (SJctrEventListener listener : this.getEventListeners()) {
            if (!(listener instanceof SJctrItemSelectListener)) continue;
            if (event == null) {
                SJctrSelectableDataObject selectable = this.getRadioButton(this.selection);
                boolean selectFlg = SJctrSelectableDataModel.isSelect(selectable);
                event = new SJctrItemSelectEvent<SJctrSelectableDataObject>(this, selectable, selectFlg);
            }
            ((SJctrItemSelectListener)listener).selectChanged(event);
        }
    }

    @Override
    protected void fireItemStateChanged() {
        super.fireItemStateChanged();
    }

    private SJctrSelectableDataObject createRadioButton(String label) {
        SJctrSelectableDataObject selectable = new SJctrSelectableDataObject();
        SJctrSelectableDataModel.setState(selectable, SJctrSelectableDataObject.VISIBLE_ACTIVE);
        SJctrSelectableDataModel.setSelect(selectable, false);
        if (label != null) {
            selectable.label(label);
        }
        return selectable;
    }

    private SJctrSelectableDataObject getRadioButton(String key) {
        Object data;
        SJctrSelectableDataObject retData = null;
        if (this.radioButtonKey.contains(key) && (data = ((SJctrDataObject)this.getManageData()).getData(key)) instanceof SJctrSelectableDataObject) {
            retData = (SJctrSelectableDataObject)data;
        }
        return retData;
    }

    private void initListener() {
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrDataObject) {
                    SJctrRadioButtonGroupDataModel.this.setSelectAction((SJctrDataObject)setObject);
                }
            }
        });
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                if (setObject instanceof SJctrDataObject) {
                    SJctrRadioButtonGroupDataModel.this.setVisibleAction((SJctrDataObject)setObject);
                }
            }
        });
    }

    private void setSelectAction(SJctrDataObject setObject) {
        for (Map.Entry<String, Object> entry : setObject.getDataMap().entrySet()) {
            SJctrSelectableDataObject input;
            Object value = entry.getValue();
            if (!(value instanceof SJctrSelectableDataObject) || !SJctrSelectableDataModel.isSelect(input = (SJctrSelectableDataObject)value)) continue;
            this.setSelect(entry.getKey());
        }
    }

    private void setVisibleAction(SJctrDataObject setObject) {
        for (Map.Entry<String, Object> entry : setObject.getDataMap().entrySet()) {
            SJctrSelectableDataObject sel;
            Object value = entry.getValue();
            if (!(value instanceof SJctrSelectableDataObject) || !(sel = (SJctrSelectableDataObject)value).getDataMap().containsKey("COM_VISIBLE")) continue;
            this.setState(entry.getKey(), sel.visible());
        }
    }

    @Override
    public void setOwnControlData(HashMap<String, Object> controlData) {
        Object obj = controlData.get("COM_SELECTED");
        if (obj instanceof String) {
            String select = (String)obj;
            this.setSelect(select);
        } else {
            this.dataRestoreFailed("COM_SELECTED", obj);
        }
    }

    @Override
    public HashMap<String, Object> getOwnControlData() {
        HashMap<String, Object> controlData = new HashMap<String, Object>();
        String select = this.getSelect();
        controlData.put("COM_SELECTED", select);
        return controlData;
    }
}

