/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.account.usergroups.users;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcUserGroupInfoUty;
import sanproject.sn2.com.utility.account.SJcUserGroupInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.account.SJctrAuthorizeAccountModify;
import sanproject.sn2.controller.topwindow.account.usergroups.SJctrUserGrpSelectDC;
import sanproject.sn2.controller.topwindow.account.usergroups.SJctrUserGrpSummaryModel;
import sanproject.sn2.controller.topwindow.account.usergroups.users.SJctrUserGrpUsersActionMenuModel;
import sanproject.sn2.controller.topwindow.account.usergroups.users.SJctrUserGrpUsersTableModel;
import sanproject.sn2.controller.wizard.account.addusers.SJctrAddUsersSelectData;
import sanproject.sn2.controller.wizard.account.changepwd.SJctrChangePwdSelectData;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountInfoUty;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoUtility;
import sanproject.sn2.controller.wizard.account.createuser.SJctrCreateUserSelectData;
import sanproject.sn2.controller.wizard.account.deleteusers.SJctrDeleteUsersSelectData;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserSelectData;
import sanproject.sn2.controller.wizard.account.removeusers.SJctrRemoveUsersSelectData;

public class SJctrUserGrpUsersDC
extends SJctrUserGrpSelectDC {
    public static final int DISP_ID = 9475;
    public static final String COM_TABLE = "COM_TABLE";
    public static final String COM_SUMMARY = "COM_SUMMARY";
    public static final String COM_ACTION_MENU = "COM_ACTION_MENU";
    public static final int DEVICE_REGISTRATION_USERNAME_NUMBER = 0;
    public static final int DEVICE_REGISTRATION_USERNAME_ARRANGEMENT_SIZE = 1;

    private void initDataModel() {
        this.addDataObjectModel(COM_SUMMARY, new SJctrUserGrpSummaryModel());
        this.addDataObjectModel(COM_TABLE, new SJctrUserGrpUsersTableModel());
        this.addDataObjectModel(COM_ACTION_MENU, new SJctrUserGrpUsersActionMenuModel());
    }

    public SJctrUserGrpUsersDC() throws SJcException {
        super(9475);
        this.initDataModel();
        this.initListener();
    }

    private void initListener() {
        this.addMessageEventListener(USERGRP_USERS_NOTIFY_STATE.MAKE_CREATEUSER, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrUserGrpUsersDC.this.makeCreateUser(event, dstModel);
            }
        });
        this.addMessageEventListener(USERGRP_USERS_NOTIFY_STATE.MAKE_CHANGEPWD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrUserGrpUsersDC.this.makeChangePwd(event, dstModel);
            }
        });
        this.addMessageEventListener(USERGRP_USERS_NOTIFY_STATE.MAKE_EDITUSER, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrUserGrpUsersDC.this.makeEditUser(event, dstModel);
            }
        });
        this.addMessageEventListener(USERGRP_USERS_NOTIFY_STATE.MAKE_ADDUSERS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrUserGrpUsersDC.this.makeAddUsers(event, dstModel);
            }
        });
        this.addMessageEventListener(USERGRP_USERS_NOTIFY_STATE.MAKE_DELETEUSERS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrUserGrpUsersDC.this.makeDeleteUsers(event, dstModel);
            }
        });
        this.addMessageEventListener(USERGRP_USERS_NOTIFY_STATE.MAKE_REMOVEUSERS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrUserGrpUsersDC.this.makeRemoveUsers(event, dstModel);
            }
        });
    }

    private void makeCreateUser(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String strLogSubTitle = "makeCreateUser";
        this.getLogUty().putlog(strLogSubTitle, "start");
        ArrayList<SJctrCreateUserSelectData> selectList = new ArrayList<SJctrCreateUserSelectData>(1);
        SJctrCreateUserSelectData selectData = new SJctrCreateUserSelectData();
        String userGrpName = this.getUserGrpName();
        if (userGrpName == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is Empty.", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrUserGrpInfoDetail userGrpInfoDetail = new SJctrUserGrpInfoDetail();
        userGrpInfoDetail.setGroupName(userGrpName);
        selectData.setUserGrpInfoDetail(userGrpInfoDetail);
        selectList.add(selectData);
        HashMap param = new HashMap();
        param.put(SJctrAccountDataMacro.WIZARD_CREATEUSER_SELECT_DATA.getName(), selectList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrAccountDataMacro.SUB_WIZARD_CREATEUSER, param);
        this.addUpdateDisp(wizardRelated);
        this.getLogUty().putlog(strLogSubTitle, "end");
    }

    private void makeChangePwd(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String strLogSubTitle = "makeChangePwd";
        this.getLogUty().putlog(strLogSubTitle, "start");
        ArrayList<SJctrChangePwdSelectData> selectList = new ArrayList<SJctrChangePwdSelectData>(1);
        SJctrChangePwdSelectData selectData = new SJctrChangePwdSelectData();
        SJctrUserController uc = this.getOwner();
        String myUserID = uc.getUserSession().getUserName();
        if (myUserID == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]userID is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        boolean bTargetUser = false;
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        SJctrUserInfoDetail userInfoDetail = null;
        SJctrAuthorizeContainer authorizeContainer = this.getOwner().getAuthorizeContainer();
        SJctrAuthorizeAccountModify authorize = new SJctrAuthorizeAccountModify();
        authorize.setContainer(authorizeContainer);
        if (authorize.chkRole()) {
            if (selectedRowList.size() > 1) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]select row data = " + selectedRowList.size(), null, 40000);
                SJctrError err = new SJctrError(2, 22, 105224);
                SJcException exception = err.createException();
                throw exception;
            }
            if (selectedRowList.size() == 1) {
                if (!(selectedRowList.get(0) instanceof SJctrUserInfoDetail)) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]select row data is illegal class.", null, 40000);
                    SJctrError err = new SJctrError(2, 22, 107010);
                    SJcException exception = err.createException();
                    throw exception;
                }
                userInfoDetail = (SJctrUserInfoDetail)selectedRowList.get(0);
                String selectedUserID = userInfoDetail.getUserName();
                if (selectedUserID == null) {
                    this.getLogUty().putlog(strLogSubTitle, "[Logic Error]userID is Empty", null, 40000);
                    SJctrError err = new SJctrError(2, 22, 107010);
                    SJcException exception = err.createException();
                    throw exception;
                }
                bTargetUser = selectedUserID.equals(myUserID);
            } else {
                userInfoDetail = new SJctrUserInfoDetail();
                userInfoDetail.setUserName(myUserID);
                bTargetUser = true;
            }
        } else {
            userInfoDetail = new SJctrUserInfoDetail();
            userInfoDetail.setUserName(myUserID);
            bTargetUser = true;
        }
        selectData.setUserInfoDetail(userInfoDetail);
        selectData.setTargetUser(bTargetUser);
        selectList.add(selectData);
        HashMap param = new HashMap();
        param.put(SJctrAccountDataMacro.WIZARD_CHANGEPASSWORD_SELECT_DATA.getName(), selectList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrAccountDataMacro.SUB_WIZARD_CHANGEPWD, param);
        this.addUpdateDisp(wizardRelated);
        String userName = userInfoDetail.getUserName();
        if (userName.equals(SJcEnvUty.getManageUserName())) {
            String[] msgArg = new String[]{userName};
            SJctrRelatedDispDataObject related = SJctrAccountInfoUty.createOkMsgDialog(205422, null, this, msgArg, null);
            this.addUpdateDisp(related);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
    }

    private void makeEditUser(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String strLogSubTitle = "makeEditUser";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() != 1) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]select row data = " + selectedRowList.size(), null, 40000);
            SJctrError err = new SJctrError(2, 22, 105223);
            SJcException exception = err.createException();
            throw exception;
        }
        ArrayList<SJctrEditUserSelectData> selectList = new ArrayList<SJctrEditUserSelectData>(1);
        SJctrEditUserSelectData selectData = new SJctrEditUserSelectData();
        if (!(selectedRowList.get(0) instanceof SJctrUserInfoDetail)) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]select row data is illegal class.", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrUserInfoDetail userInfoDetail = (SJctrUserInfoDetail)selectedRowList.get(0);
        String userID = userInfoDetail.getUserName();
        boolean bRet = false;
        try {
            bRet = SJctrUserInfoUtility.isExistUser(userID, this);
        }
        catch (SJcCommunicationErrorException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Communication Error]isExistUser() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
            SJctrError err = new SJctrError(201, 22, 208003);
            SJcException exception = err.createException();
            throw exception;
        }
        catch (SJcException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]isExistUser() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        if (!bRet) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]No Exist User (" + userID + ")", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107012);
            SJcException exception = err.createException();
            throw exception;
        }
        String[] userIDs = new String[]{userID};
        Map<String, SJctrUserInfoDetail> userInfoDetailMap = null;
        try {
            userInfoDetailMap = SJctrAccountInfoUty.getUserInfoDetailList(userIDs, this);
        }
        catch (SJcCommunicationErrorException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getUserInfoDetailList() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
            SJctrError err = new SJctrError(201, 22, 208003);
            SJcException exception = err.createException();
            throw exception;
        }
        catch (SJcException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getUserInfoDetailList() is failed (" + e.getClass().getSimpleName() + ")", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        selectData.setUserInfoDetail(userInfoDetailMap.get(userID));
        selectList.add(selectData);
        HashMap param = new HashMap();
        param.put(SJctrAccountDataMacro.WIZARD_EDITUSER_SELECT_DATA.getName(), selectList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrAccountDataMacro.SUB_WIZARD_EDITUSER, param);
        this.addUpdateDisp(wizardRelated);
        if (userID.equals(SJcEnvUty.getManageUserName())) {
            String[] msgArg = new String[]{userID};
            SJctrRelatedDispDataObject related = SJctrAccountInfoUty.createOkMsgDialog(205422, null, this, msgArg, null);
            this.addUpdateDisp(related);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
    }

    private void makeAddUsers(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String strLogSubTitle = "makeAddUsers";
        this.getLogUty().putlog(strLogSubTitle, "start");
        ArrayList<SJctrAddUsersSelectData> selectList = new ArrayList<SJctrAddUsersSelectData>();
        SJctrAddUsersSelectData selectData = new SJctrAddUsersSelectData();
        String[] userGrpName = new String[]{this.getUserGrpName()};
        if (userGrpName != null) {
            try {
                SJcUserGroupInfoContainer[] userGrpInfo = SJcUserGroupInfoUty.getUserGroupInfo(userGrpName);
                SJctrUserGrpInfoDetail userGrpInfoDetail = new SJctrUserGrpInfoDetail(userGrpInfo[0]);
                ArrayList<SJctrUserGrpInfoDetail> list = new ArrayList<SJctrUserGrpInfoDetail>();
                list.add(userGrpInfoDetail);
                selectData.setUserGrpInfoDetailList(list);
                selectList.add(selectData);
                HashMap param = new HashMap();
                param.put(SJctrAccountDataMacro.WIZARD_ADDUSERS_SELECT_DATA.getName(), selectList);
                SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrAccountDataMacro.SUB_WIZARD_ADDUSERS, param);
                this.addUpdateDisp(wizardRelated);
            }
            catch (SJcCommunicationErrorException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getUserGroupInfo() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
                SJctrError err = new SJctrError(201, 22, 208003);
                SJcException exception = err.createException();
                throw exception;
            }
        } else {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]User Group Name is Empty.", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
    }

    private void makeDeleteUsers(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        String strLogSubTitle = "makeDeleteUsers";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        String userName = "?";
        if (selectedRowList.size() < 1) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]select row data = " + selectedRowList.size());
            SJctrError err = new SJctrError(2, 22, 105225);
            SJcException exception = err.createException();
            throw exception;
        }
        ArrayList<SJctrDeleteUsersSelectData> selectList = new ArrayList<SJctrDeleteUsersSelectData>(1);
        SJctrDeleteUsersSelectData selectData = new SJctrDeleteUsersSelectData();
        ArrayList<SJctrUserInfoDetail> selectUserList = new ArrayList<SJctrUserInfoDetail>();
        boolean registrationFlg = false;
        for (Object selectRow : selectedRowList) {
            if (!(selectRow instanceof SJctrUserInfoDetail)) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]select row data is illegal class.");
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrUserInfoDetail userInfoDetail = (SJctrUserInfoDetail)selectRow;
            selectUserList.add(userInfoDetail);
            if (!userInfoDetail.getUserName().equals(SJcEnvUty.getManageUserName())) continue;
            registrationFlg = true;
            userName = userInfoDetail.getUserName();
        }
        selectData.setUserInfoDetailList(selectUserList);
        selectList.add(selectData);
        HashMap param = new HashMap();
        param.put(SJctrAccountDataMacro.WIZARD_DELETEUSERS_SELECT_DATA.getName(), selectList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrAccountDataMacro.SUB_WIZARD_DELETEUSERS, param);
        this.addUpdateDisp(wizardRelated);
        if (registrationFlg) {
            String[] msgArg = new String[]{userName};
            SJctrRelatedDispDataObject related = SJctrAccountInfoUty.createOkMsgDialog(205422, null, this, msgArg, null);
            this.addUpdateDisp(related);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
    }

    private void makeRemoveUsers(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJcException exception;
        SJctrError err;
        String strLogSubTitle = "makeRemoveUsers";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(COM_TABLE);
        if (table == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]table data is null");
            SJctrError err2 = new SJctrError(2, 22, 107010);
            SJcException exception2 = err2.createException();
            throw exception2;
        }
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]selected row data is null");
            SJctrError err3 = new SJctrError(2, 22, 107010);
            SJcException exception3 = err3.createException();
            throw exception3;
        }
        if (selectedRowList.size() < 1) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]select row data = " + selectedRowList.size());
            SJctrError err4 = new SJctrError(2, 22, 105225);
            SJcException exception4 = err4.createException();
            throw exception4;
        }
        ArrayList<SJctrRemoveUsersSelectData> selectList = new ArrayList<SJctrRemoveUsersSelectData>(1);
        SJctrRemoveUsersSelectData selectData = new SJctrRemoveUsersSelectData();
        ArrayList<SJctrUserInfoDetail> selectUserList = new ArrayList<SJctrUserInfoDetail>();
        ArrayList<SJctrUserGrpInfoDetail> selectUserGrpList = new ArrayList<SJctrUserGrpInfoDetail>();
        for (Object selectRow : selectedRowList) {
            if (!(selectRow instanceof SJctrUserInfoDetail)) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]select row data is illegal class.");
                err = new SJctrError(2, 22, 107010);
                exception = err.createException();
                throw exception;
            }
            SJctrUserInfoDetail userInfoDetail = (SJctrUserInfoDetail)selectRow;
            if (userInfoDetail == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]users' detail data is null.");
                SJctrError err5 = new SJctrError(2, 22, 107011);
                SJcException exception5 = err5.createException();
                throw exception5;
            }
            selectUserList.add(userInfoDetail);
            String userGroupName = this.getUserGrpName();
            if (userGroupName == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]user group name is null.");
                SJctrError err6 = new SJctrError(2, 22, 107010);
                SJcException exception6 = err6.createException();
                throw exception6;
            }
            SJctrUserGrpInfoDetail userGrpInfo = new SJctrUserGrpInfoDetail();
            userGrpInfo.setGroupName(userGroupName);
            selectUserGrpList.add(userGrpInfo);
        }
        selectData.setUserInfoDetailList(selectUserList);
        selectData.setUserGrpInfoDetailList(selectUserGrpList);
        selectList.add(selectData);
        HashMap param = new HashMap();
        param.put(SJctrAccountDataMacro.WIZARD_REMOVEUSERS_SELECT_DATA.getName(), selectList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrAccountDataMacro.SUB_WIZARD_REMOVEUSERS, param);
        if (wizardRelated == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]SJctrRelatedDispDataObject is null.");
            err = new SJctrError(2, 22, 107010);
            exception = err.createException();
            throw exception;
        }
        this.addUpdateDisp(wizardRelated);
        this.getLogUty().putlog(strLogSubTitle, "end");
    }

    public static enum USERGRP_USERS_NOTIFY_STATE implements SJctrNotifyState
    {
        MAKE_CREATEUSER,
        MAKE_CHANGEPWD,
        MAKE_EDITUSER,
        MAKE_ADDUSERS,
        MAKE_DELETEUSERS,
        MAKE_REMOVEUSERS;

    }
}

