/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.BASEgetDkcLockList;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.topwindow.base.SJctrResourceLockTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;

public class SJctrLockSystemColumnFromResourceLockTableKey
extends SJctrColumn {
    public static final String KEY_SYSTEM = "SYSTEM";
    public static final String LOC_SN = "LOC_SN";
    public static final String LOC_SVP = "LOC_SVP";
    public static final String LOC_RM = "LOC_RM";
    public static final String LOC_RMI_UP = "LOC_RMI_UP";
    public static final String LOC_SMI_S = "LOC_SMI_S";
    private static final String BAR = "-";
    private static final int ACCESS_TYPE_DEFAULT = 0;
    public static final int ACCESS_TYPE_SN = 1;
    public static final int ACCESS_TYPE_SVP = 3;
    public static final int ACCESS_TYPE_RM = 4;
    public static final int ACCESS_TYPE_RMI_UP = 17;
    public static final int ACCESS_TYPE_SMI_S = 49;
    private static int[] mStatusTable = new int[]{0, 1, 3, 4, 17, 49};
    private String[] mSystemNameTable;

    public SJctrLockSystemColumnFromResourceLockTableKey(String key) {
        super(key);
        this.setPartsId(KEY_SYSTEM);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance(KEY_SYSTEM));
        String strSN = util.getGuidance(LOC_SN);
        String strSVP = util.getGuidance(LOC_SVP);
        String strRM = util.getGuidance(LOC_RM);
        String strRMI_UP = util.getGuidance(LOC_RMI_UP);
        String strSMI_S = util.getGuidance(LOC_SMI_S);
        String[] strSystemNameTable = new String[]{"?", strSN, strSVP, strRM, strRMI_UP, strSMI_S};
        this.mSystemNameTable = strSystemNameTable;
    }

    @Override
    public int getFilterType() {
        return 3;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<SJctrResourceLockTableKey> list = new ArrayList<SJctrResourceLockTableKey>();
        list.add((SJctrResourceLockTableKey)index);
        return list;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public String toDispString(List<?> datalist) {
        SJctrResourceLockTableKey tabledata = (SJctrResourceLockTableKey)datalist.get(0);
        BASEgetDkcLockList lockInfo = tabledata.getLockInfo();
        if (lockInfo == null) {
            return BAR;
        }
        int accessType = lockInfo.getIAccessType();
        String strSystem = this.getSystemName(accessType);
        return strSystem;
    }

    private int indexOfStatus(int status) {
        int ret = Arrays.binarySearch((int[])mStatusTable, (int)status);
        if (ret < 0) {
            this.getTable().getDataController().getLogUty().putlog("indexOfStatus", "Unknown status:" + status, 40000);
            ret = 0;
        }
        return ret;
    }

    String getSystemName(int status) {
        int index = this.indexOfStatus(status);
        return this.mSystemNameTable[index];
    }
}

