/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import sanproject.serverux.dataimpl.BASEgetDkcLockList;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.base.SJctrOperationLockStatus;
import sanproject.sn2.controller.topwindow.base.SJctrResourceLockDC;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrResourceLockSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_STATUS = "COM_STATUS";
    public static final String KEY_LOCKUSER = "COM_LOCKUSER";
    public static final String KEY_LOCKSTART = "COM_LOCKSTART";
    public static final String KEY_LOCKED = "COM_LOCKED";
    public static final String KEY_UNLOCKED = "COM_UNLOCKED";
    private static final String STS_LOCKED = "STS_LOCKED";
    private static final String STS_MPCLOCKED = "STS_MP_LOCKED";
    private String labelLocked = "";
    private static final String labelBar = "-";
    private static SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private SJctrOperationLockStatus operationLock = null;
    private SJmoRSGgetAllRsgs rsgData = null;
    public static final int STS_DKC_UNLOCK = 1;
    public static final int STS_DKC_LOCK = 9;
    private int statusDkcLock = 1;

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.labelLocked = util.getGuidance(STS_LOCKED);
    }

    @Override
    public Object getDataObject(SJctrDataObject inputObject) {
        SJctrResourceLockDC resourceLockDc = (SJctrResourceLockDC)this.getDataController();
        this.getResourceLockPropertiesData();
        this.makeSummaryData();
        SJctrButtonDataModel buttonData = resourceLockDc.getUnLockButtonModel();
        buttonData.setEnable(resourceLockDc.getAuthority(this.statusDkcLock));
        buttonData.isDirty();
        return super.getDataObject(inputObject);
    }

    private void getResourceLockPropertiesData() {
        SJctrDataController dc = this.getDataController();
        this.operationLock = ((SJctrResourceLockDC)dc).getOperationLockStatus();
        this.rsgData = ((SJctrResourceLockDC)dc).getRsgData();
    }

    protected void makeSummaryData() {
        SJctrDataController dc = this.getDataController();
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(dc.getOwner(), this.rsgData);
        List<SJmoRSGgetRsg> rsgList = rsgUtil.extractRsg();
        int numRsg = rsgList.size();
        BASEgetDkcLockList[] dkcLock = this.operationLock.getResourceLockInfo();
        BASEgetDkcLockList sysLock = this.operationLock.getSystemLockInfo();
        BASEgetDkcLockList svpLock = this.operationLock.getSVPLockInfo();
        int numLock = 0;
        if (dkcLock == null || dkcLock.length == 0) {
            numLock = 0;
        } else {
            for (BASEgetDkcLockList lock : dkcLock) {
                int rsgId = lock.getIResourceId();
                if (!this.isContainsResourceId(rsgList, rsgId)) continue;
                ++numLock;
            }
        }
        int numUnlock = numRsg - numLock;
        String status = labelBar;
        String lockUser = labelBar;
        String lockStart = labelBar;
        Date lockTime = null;
        if (sysLock != null) {
            status = this.labelLocked;
            lockUser = sysLock.getStrUsername();
            lockTime = sysLock.getLockTime();
            lockStart = simpleDate.format(lockTime);
            numLock = numRsg;
            numUnlock = 0;
        } else if (svpLock != null && numLock == 0) {
            status = this.labelLocked;
        }
        Object viewdata = this.getManageData();
        ((SJctrDataObject)viewdata).setData(KEY_STATUS, status);
        ((SJctrDataObject)viewdata).setData(KEY_LOCKUSER, lockUser);
        ((SJctrDataObject)viewdata).setData(KEY_LOCKSTART, lockStart);
        ((SJctrDataObject)viewdata).setData(KEY_LOCKED, Integer.toString(numLock));
        ((SJctrDataObject)viewdata).setData(KEY_UNLOCKED, Integer.toString(numUnlock));
    }

    private boolean isContainsResourceId(List<SJmoRSGgetRsg> rsgList, int rsgId) {
        boolean ret = false;
        for (SJmoRSGgetRsg rsg : rsgList) {
            int id = rsg.getRsgInfo().getRsgId();
            if (id != rsgId) continue;
            ret = true;
        }
        return ret;
    }
}

