/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrMenuDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.base.SJctrAccordionTreeModel;
import sanproject.sn2.controller.topwindow.base.SJctrCrumbTrailModel;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;

public class SJctrViewHistoryModel
extends SJctrSimpleDataModel {
    public static final String KEY_HISTORY_NEXT = "COM_HISTORY_NEXT";
    public static final String KEY_HISTORY_BACK = "COM_HISTORY_BACK";
    public static final String KEY_VISIBLE = "COM_VISIBLE";
    public static final String KEY_TOOLTIP = "COM_TOOLTIP";
    public static final String KEY_HISTORY_NAME = "COM_HISTORY_NAME";
    public static final String KEY_HISTORY_KEY = "COM_HISTORY_KEY";
    public static final String KEY_HISTORY_TREEKEY = "COM_HISTORY_TREEKEY";
    public static final String KEY_HISTORY_SELECTED = "COM_HISTORY_SELECTED";
    private static final String KEY_CRUMB = "COM_CRUMB";
    private static final Integer ACTIVE = SJctrSelectableDataObject.VISIBLE_ACTIVE;
    private static final Integer INACTIVE = SJctrSelectableDataObject.VISIBLE_INACTIVE;
    private static final int VIEW_HISTORY_INDEX_MAX = 9;
    private static final int VIEW_HISTORY_INDEX_MIN = 0;
    private static final String DELIMITER_KEY = "\t";
    private static final String DELIMITER_STRING = " > ";
    private static final String STR_UNKNOWN = "?";
    private ArrayList<HashMap<String, Object>> historyList = new ArrayList(10);
    private boolean flgAddHistorySkip = false;
    private boolean flgRefresh = false;
    private int oldIndex = 0;

    public SJctrViewHistoryModel() {
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrButtonDataModel nextButton = new SJctrButtonDataModel(){

            @Override
            public Object getDataObject(SJctrDataObject inputObject) {
                Object nextButtonData = this.getManageData();
                int currentIndex = SJctrViewHistoryModel.this.getCurrentHistoryIndex();
                int nextIndex = SJctrViewHistoryModel.this.getNextHistoryIndex();
                String nextName = "";
                int nextVisible = INACTIVE;
                if (currentIndex != nextIndex) {
                    HashMap nextMap = (HashMap)SJctrViewHistoryModel.this.historyList.get(nextIndex);
                    if (nextMap.containsKey(SJctrViewHistoryModel.KEY_HISTORY_NAME)) {
                        nextName = (String)nextMap.get(SJctrViewHistoryModel.KEY_HISTORY_NAME);
                    } else {
                        nextName = SJctrViewHistoryModel.STR_UNKNOWN;
                        this.getLogUty().putlog("makeDataObject", "COM_HISTORY_NAME is not contains.Index=" + nextIndex);
                    }
                    nextVisible = ACTIVE;
                }
                ((SJctrDataObject)nextButtonData).setData(SJctrViewHistoryModel.KEY_TOOLTIP, nextName);
                ((SJctrDataObject)nextButtonData).setData(SJctrViewHistoryModel.KEY_VISIBLE, nextVisible);
                return super.getDataObject(inputObject);
            }
        };
        nextButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrViewHistoryModel.this.getLogUty().putlog("selectChanged", "nextButton selected.");
                SJctrViewHistoryModel.this.setAddHistorySkip(true);
                int nextIndex = SJctrViewHistoryModel.this.getNextHistoryIndex();
                SJctrViewHistoryModel.this.setCurrentHistoryIndex(nextIndex);
                SJctrViewHistoryModel.this.goViewHistory();
            }
        });
        this.addDataModel(KEY_HISTORY_NEXT, nextButton);
        SJctrButtonDataModel backButton = new SJctrButtonDataModel(){

            @Override
            public Object getDataObject(SJctrDataObject inputObject) {
                Object backButtonData = this.getManageData();
                int currentIndex = SJctrViewHistoryModel.this.getCurrentHistoryIndex();
                int backIndex = SJctrViewHistoryModel.this.getBackHistoryIndex();
                String backName = "";
                int backVisible = INACTIVE;
                if (currentIndex != backIndex) {
                    HashMap backMap = (HashMap)SJctrViewHistoryModel.this.historyList.get(backIndex);
                    if (backMap.containsKey(SJctrViewHistoryModel.KEY_HISTORY_NAME)) {
                        backName = (String)backMap.get(SJctrViewHistoryModel.KEY_HISTORY_NAME);
                    } else {
                        backName = SJctrViewHistoryModel.STR_UNKNOWN;
                        this.getLogUty().putlog("makeDataObject", "COM_HISTORY_NAME is not contains.Index=" + backIndex);
                    }
                    backVisible = ACTIVE;
                }
                ((SJctrDataObject)backButtonData).setData(SJctrViewHistoryModel.KEY_TOOLTIP, backName);
                ((SJctrDataObject)backButtonData).setData(SJctrViewHistoryModel.KEY_VISIBLE, backVisible);
                return super.getDataObject(inputObject);
            }
        };
        backButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrViewHistoryModel.this.getLogUty().putlog("selectChanged", "backButton selected.");
                SJctrViewHistoryModel.this.setAddHistorySkip(true);
                int backIndex = SJctrViewHistoryModel.this.getBackHistoryIndex();
                SJctrViewHistoryModel.this.setCurrentHistoryIndex(backIndex);
                SJctrViewHistoryModel.this.goViewHistory();
            }
        });
        this.addDataModel(KEY_HISTORY_BACK, backButton);
    }

    @Override
    public Object getDataObject(SJctrDataObject inputObject) {
        this.getHistoryName();
        return super.getDataObject(inputObject);
    }

    private int getCurrentHistoryIndex() {
        int ret = 0;
        int historySize = this.historyList.size();
        if (historySize == 0) {
            return ret;
        }
        for (int i = historySize - 1; i >= 0; --i) {
            HashMap<String, Object> historyMap = this.historyList.get(i);
            if (!historyMap.containsKey(KEY_HISTORY_SELECTED) || !((Boolean)historyMap.get(KEY_HISTORY_SELECTED)).booleanValue()) continue;
            ret = i;
            break;
        }
        return ret;
    }

    private int getNextHistoryIndex() {
        int ret = this.getCurrentHistoryIndex();
        if (ret >= 9) {
            return ret;
        }
        int historySize = this.historyList.size();
        if (historySize == 0) {
            this.getLogUty().putlog("getNextHistoryIndex", "historySize=0");
            return ret;
        }
        if (ret >= historySize - 1) {
            return ret;
        }
        return ++ret;
    }

    private int getBackHistoryIndex() {
        int ret = this.getCurrentHistoryIndex();
        if (ret <= 0) {
            return ret;
        }
        int historySize = this.historyList.size();
        if (historySize == 0) {
            this.getLogUty().putlog("getBackHistoryIndex", "historySize=0");
            return ret;
        }
        return --ret;
    }

    private void setCurrentHistoryIndex(int currentIndex) {
        if (currentIndex < 0 || currentIndex > 9) {
            this.getLogUty().putlog("setCurrentHistoryIndex", "currentIndex=" + currentIndex);
            return;
        }
        int historySize = this.historyList.size();
        if (historySize == 0) {
            this.getLogUty().putlog("setCurrentHistoryIndex", "historySize=0");
            return;
        }
        if (currentIndex >= historySize) {
            this.getLogUty().putlog("setCurrentHistoryIndex", "currentIndex=" + currentIndex + ",historySize=" + historySize);
            return;
        }
        this.oldIndex = this.getCurrentHistoryIndex();
        for (HashMap<String, Object> historyMap : this.historyList) {
            historyMap.put(KEY_HISTORY_SELECTED, Boolean.FALSE);
        }
        HashMap<String, Object> historyMap = this.historyList.get(currentIndex);
        historyMap.put(KEY_HISTORY_SELECTED, Boolean.TRUE);
        this.historyList.set(currentIndex, historyMap);
    }

    public void goViewHistory() {
        int currentIndex = this.getCurrentHistoryIndex();
        int historySize = this.historyList.size();
        String currentKey = "";
        String currentTreeKey = "";
        if (historySize == 0) {
            this.getLogUty().putlog("goViewHistory", "historySize=0");
            return;
        }
        HashMap<String, Object> historyMap = this.historyList.get(currentIndex);
        if (historyMap.containsKey(KEY_HISTORY_KEY)) {
            currentKey = (String)historyMap.get(KEY_HISTORY_KEY);
        }
        if (historyMap.containsKey(KEY_HISTORY_TREEKEY) && (currentTreeKey = (String)historyMap.get(KEY_HISTORY_TREEKEY)) == null) {
            this.getLogUty().putlog("goViewHistory", "currentTreeKey is null:currentIndex=" + currentIndex + ",currentKey=" + currentKey + ",currentTreeKey=" + currentTreeKey);
            return;
        }
        this.getLogUty().putlog("goViewHistory", "currentIndex=" + currentIndex + ",currentKey=" + currentKey + ",currentTreeKey=" + currentTreeKey);
        this.setAddHistorySkip(true);
        SJctrTopWindowDC topDC = this.getDataController().getTopWindow();
        SJctrAccordionTreeModel tree = (SJctrAccordionTreeModel)topDC.getDataObjectModel(currentTreeKey);
        tree.refreshSelectionforViewHistory(currentKey);
    }

    public void addViewHistory(String historyKey) {
        String treeKey;
        String currentKey;
        HashMap<String, Object> currentMap;
        int currentIndex = this.getCurrentHistoryIndex();
        int historySize = this.historyList.size();
        if (this.flgRefresh) {
            this.flgRefresh = false;
            return;
        }
        if (historySize > 0 && (currentMap = this.historyList.get(currentIndex)).containsKey(KEY_HISTORY_KEY) && historyKey.equals(currentKey = (String)currentMap.get(KEY_HISTORY_KEY))) {
            this.getLogUty().putlog("addViewHistory", "DuplicateKey:currentIndex=" + currentIndex + ",historyKey=" + historyKey);
            return;
        }
        if (currentIndex < 9) {
            for (int i = historySize - 1; i > currentIndex; --i) {
                this.historyList.remove(i);
            }
        }
        if ((historySize = this.historyList.size()) > 9) {
            this.historyList.remove(0);
        }
        if ((treeKey = this.getDataController().getTopWindow().getActiveAccordionTreeKey()) == null) {
            this.getLogUty().putlog("addViewHistory", "ActiveAccordionTreeKey is null");
            return;
        }
        HashMap<String, String> currentMap2 = new HashMap<String, String>();
        currentMap2.put(KEY_HISTORY_KEY, historyKey);
        currentMap2.put(KEY_HISTORY_TREEKEY, treeKey);
        this.historyList.add(currentMap2);
        if (this.historyList.size() == 1) {
            currentIndex = 0;
        } else if (++currentIndex > 9) {
            currentIndex = 9;
        }
        this.setCurrentHistoryIndex(currentIndex);
        this.getLogUty().putlog("addViewHistory", "addKey:currentIndex=" + currentIndex + ",historyKey=" + historyKey + ",historyTreeKey=" + treeKey);
    }

    public void replaceViewHistory(String historyKey) {
        String currentKey;
        int currentIndex = this.getCurrentHistoryIndex();
        int historySize = this.historyList.size();
        if (historySize == 0) {
            return;
        }
        HashMap<String, Object> currentMap = this.historyList.get(currentIndex);
        String treeKey = this.getDataController().getTopWindow().getActiveAccordionTreeKey();
        if (treeKey == null) {
            this.getLogUty().putlog("replaceViewHistory", "ActiveAccordionTreeKey is null");
            return;
        }
        if (currentMap.containsKey(KEY_HISTORY_KEY) && historyKey.equals(currentKey = (String)currentMap.get(KEY_HISTORY_KEY))) {
            return;
        }
        currentMap.put(KEY_HISTORY_KEY, historyKey);
        currentMap.put(KEY_HISTORY_TREEKEY, treeKey);
        currentMap.remove(KEY_HISTORY_NAME);
        this.historyList.set(currentIndex, currentMap);
        this.getLogUty().putlog("replaceViewHistory", "replayceKey:currentIndex=" + currentIndex + ",historyKey=" + historyKey + ",historyTreeKey=" + treeKey);
        this.setCurrentHistoryIndex(currentIndex);
    }

    public void delDuplicateViewHistory() {
        HashMap<String, Object> backMap;
        HashMap<String, Object> nextMap;
        int currentIndex = this.getCurrentHistoryIndex();
        int historySize = this.historyList.size();
        String currentKey = "";
        HashMap<String, Object> currentMap = this.historyList.get(currentIndex);
        if (currentMap.containsKey(KEY_HISTORY_KEY)) {
            currentKey = (String)currentMap.get(KEY_HISTORY_KEY);
        }
        int nextIndex = currentIndex + 1;
        String nextKey = "";
        if (nextIndex < historySize && (nextMap = this.historyList.get(nextIndex)).containsKey(KEY_HISTORY_KEY) && currentKey.equals(nextKey = (String)nextMap.get(KEY_HISTORY_KEY))) {
            this.historyList.remove(nextIndex);
            this.getLogUty().putlog("delDuplicateViewHistory", "deleteKey:Index=" + nextIndex + ",historyKey=" + nextKey);
        }
        int backIndex = currentIndex - 1;
        String backKey = "";
        if (backIndex >= 0 && (backMap = this.historyList.get(backIndex)).containsKey(KEY_HISTORY_KEY) && currentKey.equals(backKey = (String)backMap.get(KEY_HISTORY_KEY))) {
            this.historyList.remove(backIndex);
            this.getLogUty().putlog("delDuplicateViewHistory", "deleteKey:Index=" + backIndex + ",historyKey=" + backKey);
        }
    }

    public void removeCurrentHistory() {
        int targetIndex = this.getCurrentHistoryIndex();
        this.setCurrentHistoryIndex(this.oldIndex);
        if (targetIndex <= this.historyList.size() - 1) {
            HashMap<String, Object> targetMap = this.historyList.get(targetIndex);
            String targetKey = "";
            if (targetMap.containsKey(KEY_HISTORY_KEY)) {
                targetKey = (String)targetMap.get(KEY_HISTORY_KEY);
            }
            this.getLogUty().putlog("removeCurrentHistory", "removeKey:Index=" + targetIndex + ",historyKey=" + targetKey);
            this.historyList.remove(targetIndex);
        } else {
            this.getLogUty().putlog("removeCurrentHistory", "faild:targetIndex=" + targetIndex + ",oldIndex=" + this.oldIndex);
        }
    }

    private void getHistoryName() {
        int currentIndex = this.getCurrentHistoryIndex();
        if (this.historyList.size() == 0) {
            this.getLogUty().putlog("getHistoryName", "historySize=0");
            return;
        }
        HashMap<String, Object> currentMap = this.historyList.get(currentIndex);
        if (currentMap.containsKey(KEY_HISTORY_NAME)) {
            return;
        }
        SJctrTopWindowDC topDC = this.getDataController().getTopWindow();
        SJctrCrumbTrailModel crumb = (SJctrCrumbTrailModel)topDC.getDataObjectModel(KEY_CRUMB);
        if (crumb == null) {
            this.getLogUty().putlog("getHistoryName", "crumb is null");
            return;
        }
        String dispName = STR_UNKNOWN;
        StringBuilder displayName = new StringBuilder();
        ArrayList<String> itemList = new ArrayList<String>(crumb.getItemMap().keySet());
        Collections.sort(itemList);
        for (String name : itemList) {
            HashMap<String, Object> item = crumb.getItem(name);
            String label = SJctrMenuDataModel.Item.getLabel(item);
            displayName.append(label);
            displayName.append(DELIMITER_KEY);
        }
        if (itemList.size() > 0) {
            displayName = displayName.delete(displayName.length() - DELIMITER_KEY.length(), displayName.length());
        }
        dispName = displayName.toString();
        dispName = dispName.replace(DELIMITER_KEY, DELIMITER_STRING);
        currentMap.put(KEY_HISTORY_NAME, dispName);
        this.historyList.set(currentIndex, currentMap);
    }

    public boolean getAddHistorySkip() {
        return this.flgAddHistorySkip;
    }

    public void setAddHistorySkip(boolean flg) {
        this.flgAddHistorySkip = flg;
    }

    @Override
    protected void clearModelData() {
        this.flgRefresh = true;
    }
}

