/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.port.hostgroup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrALUAUsedColumnFromPortHostGroupTableKey;
import sanproject.sn2.controller.com.column.SJctrAluaAsymmetricAccessStateColumnFromPortHostGroupTableKey;
import sanproject.sn2.controller.com.column.SJctrHGNameColumnCellObject;
import sanproject.sn2.controller.com.column.SJctrHostGroupIdColumnFromPortHostGroupTableKey;
import sanproject.sn2.controller.com.column.SJctrHostGroupNameSingleColumnFromPortHostGroupTableKey;
import sanproject.sn2.controller.com.column.SJctrHostModeColumnFromPortHostGroupTableKey;
import sanproject.sn2.controller.com.column.SJctrHostNumColumnFromPortHostGroupTableKey;
import sanproject.sn2.controller.com.column.SJctrLunNumColumnFromPortHostGroupTableKey;
import sanproject.sn2.controller.com.column.SJctrPortHgHostLinkAction;
import sanproject.sn2.controller.com.column.SJctrPortNameColumnFromPortHostGroupTableKey;
import sanproject.sn2.controller.com.column.SJctrPortSecuritySwitchColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrVirtualStorageSystemColumnFromPortHostGroupTableKey;
import sanproject.sn2.controller.com.column.rsg.SJctrRsgColumnFromPortHostGroupTableKey;
import sanproject.sn2.controller.com.comparator.SJctrHostGroupNameComparator;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.topwindow.port.port.SJctrPortSelectDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrPortHostGroupsTableModel
extends SJctrTableDataModel {
    public static final String KEY_COL_PT_NAME = "COM_COL_PTNAME";
    public static final String KEY_COL_HG_NAME = "COM_COL_HGNAME";
    public static final String KEY_COL_HG_ID = "COM_COL_HGID";
    public static final String KEY_COL_PT_SECU = "COM_COL_PTSECU";
    public static final String KEY_COL_HOSTMODE = "COM_COL_HOSTMODE";
    public static final String KEY_COL_LUNUM = "COM_COL_LUNUM";
    public static final String KEY_COL_HTNUM = "COM_COL_HTNUM";
    public static final String KEY_COL_ALUAUSED = "COM_COL_ALUAUSED";
    public static final String KEY_COL_ALUASTATE = "COM_COL_ALUASTATE";
    public static final String KEY_COL_RSG = "COM_COL_RSGNAME";
    public static final String KEY_COL_VSS = "COM_COL_VSS";
    public static final String GUID_VSS = "VDKC";
    private boolean initiatorFlg = false;
    private static final SJctrHostGroupNameComparator hgComp = new SJctrHostGroupNameComparator();

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        List<?> ret = super.getBasicDataList(cls);
        SJctrDataController dataController = this.getDataController();
        SJctrUserController uc = dataController.getOwner();
        List<?> rsgDetailList = dataController.getModelData(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null) {
            ret = new ArrayList(0);
            return ret;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        if (cls.isAssignableFrom(SJmoGetPortHostGroupInfo.class)) {
            List<?> ptHgInfoList = ret;
            int portCnt = ptHgInfoList.size();
            ret = new ArrayList(portCnt * SJctrPortUtility.PORT_HOSTGROUP_MAX);
            SJctrDataController dc = this.getDataController();
            if (dc instanceof SJctrPortSelectDC) {
                SJctrPortSelectDC ptSelDc = (SJctrPortSelectDC)dc;
                short selectPort = ptSelDc.getSelectPort();
                SJmoPortHostGroupInfo ptHgInfo = null;
                for (SJmoPortHostGroupInfo ptHg : ptHgInfoList) {
                    if (ptHg.getSPort() != selectPort) continue;
                    ptHgInfo = ptHg;
                    break;
                }
                if (ptHgInfo != null) {
                    ArrayList hgList = ptHgInfo.getAlPortHostGroup();
                    List<SJmoGetPortAttributeInfo> portAttrList = super.getBasicDataList(SJmoGetPortAttributeInfo.class);
                    int search = Collections.binarySearch(portAttrList, ptHgInfo);
                    if (search >= 0) {
                        SJmoPortAttributeInfo portAttrInfo = (SJmoPortAttributeInfo)((Object)portAttrList.get(search));
                        if (portAttrInfo.getByPortKind() == 5) {
                            this.initiatorFlg = true;
                        }
                    } else {
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "getBasicDataList", "SJmoPortAttributeInfo not found.");
                    }
                    if (this.initiatorFlg) {
                        int rsgId = rsgUtil.getRsgId(ptHgInfo);
                        boolean ptRsgFlg = rsgUtil.chkResourceGroup(rsgId);
                        if (ptRsgFlg && !hgList.isEmpty()) {
                            SJmoHostGroupInfo defHgInfo = (SJmoHostGroupInfo)hgList.get(0);
                            SJctrPortHostGroupTableKey data = new SJctrPortHostGroupTableKey(ptHgInfo, defHgInfo);
                            try {
                                SJmoHostGroupInfo hgInfoClone = (SJmoHostGroupInfo)defHgInfo.clone();
                                hgInfoClone.setAlHostGroupWwn(new ArrayList(0));
                                data = new SJctrPortHostGroupTableKey(ptHgInfo, hgInfoClone);
                            }
                            catch (CloneNotSupportedException e) {
                                // empty catch block
                            }
                            ((ArrayList)ret).add(data);
                        }
                    } else {
                        for (SJmoHostGroupInfo hgInfo : hgList) {
                            hgIndex.setSPort(hgInfo.getSPort());
                            hgIndex.setSHostGroup(hgInfo.getSHostGroup());
                            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                            if (!rsgFlg) continue;
                            SJctrPortHostGroupTableKey data = new SJctrPortHostGroupTableKey(ptHgInfo, hgInfo);
                            ((ArrayList)ret).add(data);
                        }
                    }
                }
            }
            ((ArrayList)ret).trimToSize();
            Collections.sort(ret, hgComp);
        }
        return ret;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrPortNameColumnFromPortHostGroupTableKey(KEY_COL_PT_NAME));
        SJctrHostGroupNameSingleColumnFromPortHostGroupTableKey hostGroupName = new SJctrHostGroupNameSingleColumnFromPortHostGroupTableKey(KEY_COL_HG_NAME);
        SJctrHGNameColumnCellObject cellObj = new SJctrHGNameColumnCellObject();
        SJctrPortHgHostLinkAction linkAction = new SJctrPortHgHostLinkAction();
        hostGroupName.setCellObj(cellObj);
        hostGroupName.setItemInfo(3);
        hostGroupName.setLinkAction(linkAction);
        this.addColumn(hostGroupName);
        SJctrHostGroupIdColumnFromPortHostGroupTableKey hgId = new SJctrHostGroupIdColumnFromPortHostGroupTableKey(KEY_COL_HG_ID);
        hgId.setShowColumnDefault(false, false);
        this.addColumn(hgId);
        this.addColumn(new SJctrHostModeColumnFromPortHostGroupTableKey(KEY_COL_HOSTMODE));
        this.addColumn(new SJctrPortSecuritySwitchColumnFromPortLunTableKey(KEY_COL_PT_SECU));
        this.addColumn(new SJctrHostNumColumnFromPortHostGroupTableKey(KEY_COL_HTNUM));
        this.addColumn(new SJctrLunNumColumnFromPortHostGroupTableKey(KEY_COL_LUNUM));
        SJctrALUAUsedColumnFromPortHostGroupTableKey aluaUsed = new SJctrALUAUsedColumnFromPortHostGroupTableKey(KEY_COL_ALUAUSED);
        aluaUsed.setShowColumnDefault(false, false);
        this.addColumn(aluaUsed);
        SJctrAluaAsymmetricAccessStateColumnFromPortHostGroupTableKey aluaState = new SJctrAluaAsymmetricAccessStateColumnFromPortHostGroupTableKey(KEY_COL_ALUASTATE);
        aluaState.setShowColumnDefault(false, false);
        this.addColumn(aluaState);
        this.addColumn(new SJctrRsgColumnFromPortHostGroupTableKey(KEY_COL_RSG));
        SJctrVirtualStorageSystemColumnFromPortHostGroupTableKey vssStorageColInfo = new SJctrVirtualStorageSystemColumnFromPortHostGroupTableKey(KEY_COL_VSS);
        vssStorageColInfo.setPartsId(GUID_VSS);
        vssStorageColInfo.setShowColumnDefault(false, false);
        this.addColumn(vssStorageColInfo);
        this.setPrimaryColumn(KEY_COL_HG_NAME);
        this.setPrimaryClass(SJmoGetPortHostGroupInfo.class);
    }

    @Override
    protected void setModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        super.setModelData(models);
        Set<SJctrGetDirectWrapper> key = models.keySet();
        for (SJctrGetDirectWrapper wrapper : key) {
            Class<? extends SJmoGetKind_IF> cls = wrapper.getKindClass();
            if (!cls.equals(SJmoGetPortAttributeInfo.class)) continue;
            List<?> dataList = models.get(wrapper);
            if (dataList == null) {
                dataList = new ArrayList(0);
            }
            this.setBasicData(cls, dataList);
        }
    }
}

