/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.addresourcegroups;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.account.addresourcegroups.SJctrAddResourceGrpsConfirmAssignedGrpsTableModel;
import sanproject.sn2.controller.wizard.account.addresourcegroups.SJctrAddResourceGrpsConfirmUnassignedGrpsTableModel;
import sanproject.sn2.controller.wizard.account.addresourcegroups.SJctrAddResourceGrpsConfirmUserGrpTableModel;
import sanproject.sn2.controller.wizard.account.addresourcegroups.SJctrAddResourceGrpsData;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgUserInfo;
import sanproject.sn2.controller.wizard.account.rsg.rsgproperties.SJctrRsgPropertiesDialogDC;

public class SJctrAddResourceGrpsConfirmDC
extends SJctrConfirmDataController {
    protected static final int DISP_ID = 17830223;
    private static final String COM_TABLE_USERGRP = "COM_TABLE_UG";
    private static final String COM_TABLE_ASSIGNED_GRPS = "COM_TABLE_ASSIGNED_RSG";
    private static final String COM_TABLE_UNASSIGNED_GRPS = "COM_TABLE_UNASSIGNED_RSG";

    public SJctrAddResourceGrpsConfirmDC() {
        super(17830223);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        String strLogSubTitle = "checkStartData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_DATA);
        if (!this.checkContactData(dat, SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPSEX_DATA)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrAddResourceGrpsData addResourceGrpsData = (SJctrAddResourceGrpsData)dat.get(0);
        List<SJctrRsgUserInfo> rsgUserInfoList = addResourceGrpsData.getRsgUserInfoList();
        if (rsgUserInfoList == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (RsgUserInfo) is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    private void initDataModel() {
        this.addDataObjectModel(COM_TABLE_USERGRP, new SJctrAddResourceGrpsConfirmUserGrpTableModel());
        this.addDataObjectModel(COM_TABLE_ASSIGNED_GRPS, new SJctrAddResourceGrpsConfirmAssignedGrpsTableModel());
        this.addDataObjectModel(COM_TABLE_UNASSIGNED_GRPS, new SJctrAddResourceGrpsConfirmUnassignedGrpsTableModel());
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap map = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_SELECT_DATA);
        map.put(SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_SELECT_DATA, confirmDataList);
        confirmDataList = this.getCache(SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_DATA);
        map.put(SJctrAccountDataMacro.WIZARD_ADDRESOURCEGRPS_DATA, confirmDataList);
        Map<String, List<?>> result = SJctrConfirmDataController.mapkeyClassToString(map);
        return result;
    }

    public boolean checkContactData(List<?> dat, Class<?> cls) {
        String strLogSubTitle = "checkContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        if (dat == null || dat.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            return false;
        }
        Object obj = dat.get(0);
        if (obj == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + cls.getSimpleName() + ") is Empty", null, 40000);
            return false;
        }
        if (!obj.getClass().equals(cls)) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            return false;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_MSG.DETAIL_ASSIGNED, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrAddResourceGrpsConfirmDC.this.getDataObjectModel(SJctrAddResourceGrpsConfirmDC.COM_TABLE_ASSIGNED_GRPS);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
                SJctrAddResourceGrpsConfirmDC.this.makeRsgProperty(selectedRows);
            }
        });
        this.addMessageEventListener(SELECT_MSG.DETAIL_UNASSIGNED, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrAddResourceGrpsConfirmDC.this.getDataObjectModel(SJctrAddResourceGrpsConfirmDC.COM_TABLE_UNASSIGNED_GRPS);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
                SJctrAddResourceGrpsConfirmDC.this.makeRsgProperty(selectedRows);
            }
        });
    }

    private void makeRsgProperty(List<Object> selectRows) {
        HashMap param = new HashMap();
        param.put(SJctrRsgInfo.class.getName(), selectRows);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrRsgPropertiesDialogDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    public static enum SELECT_MSG implements SJctrNotifyState
    {
        DETAIL_ASSIGNED,
        DETAIL_UNASSIGNED;

    }
}

