/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.createuser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.SJcUserInfoUty;
import sanproject.sn2.com.utility.account.SJcAccountConst;
import sanproject.sn2.controller.com.SJctrAuditLogData;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDefaultAuditLogData;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrUserGrpInfoDetailUtility;
import sanproject.sn2.controller.com.SJctrUserInfoDetailUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.account.com.SJctrAccAdtLogData;
import sanproject.sn2.controller.wizard.account.com.SJctrAccAdtLogUty;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.account.createuser.SJctrCreateUserAC;
import sanproject.sn2.controller.wizard.account.createuser.SJctrCreateUserData;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;

public class SJctrCreateUserSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "CREATE_USER";
    private static final Class<?> CONFIRM_DC = SJctrAccountDataMacro.WIZARD_CREATEUSER_CONFIRM_DC;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        String strLogTitle = this.getClass().getSimpleName();
        String strLogSubTitle = "constructConfirmData";
        SJctrLogUty logUty = wizard.getLogUty();
        logUty.setTitle(strLogTitle);
        Class[] paramClass = new Class[]{String.class, Integer.TYPE, String.class, String[].class, Integer.TYPE};
        logUty.putlog(strLogSubTitle, "start");
        SJctrUserController uc = wizard.getOwner();
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrCreateUserAC ac = new SJctrCreateUserAC();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(wizard.getClass());
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        List<?> param = dc.getProxy().getCache(SJctrAccountDataMacro.WIZARD_CREATEUSER_DATA);
        if (param == null || param.isEmpty()) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        Object obj = param.get(0);
        if (obj == null) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_CREATEUSER_DATA.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        if (!(obj instanceof SJctrCreateUserData)) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrCreateUserData createUserData = (SJctrCreateUserData)obj;
        SJctrUserInfoDetail userInfoDetail = createUserData.getUserInfoDetail();
        if (userInfoDetail == null) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.CLASS_USER_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrUserGrpInfoDetail userGrpInfoDetail = createUserData.getUserGrpInfoDetail();
        if (userGrpInfoDetail == null) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.CLASS_USER_GRP_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        String strUserID = userInfoDetail.getUserName();
        int iAuthServ = userInfoDetail.getAuthPtn();
        String strPwd = userInfoDetail.getPassword();
        String[] strUserGrpNames = new String[]{userGrpInfoDetail.getGroupName()};
        int iAccount = userInfoDetail.getEnable() ? SJcAccountConst.INT_USERENABLE_ON : SJcAccountConst.INT_USERENABLE_OFF;
        ArrayList<Object> paramList = new ArrayList<Object>();
        Object[] params = null;
        paramList.add(strUserID);
        paramList.add(iAuthServ);
        paramList.add(SJcSecureUty.encryptStrToStr(strPwd));
        paramList.add(strUserGrpNames);
        paramList.add(iAccount);
        params = paramList.toArray(new Object[0]);
        Class<SJcUserInfoUty> cls = SJcUserInfoUty.class;
        boolean[] encrypt = new boolean[]{false, false, true, false, false};
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KEY_METHOD_NAME", "createUser");
        map.put("KEY_PARAM_CLASS", paramClass);
        map.put("KEY_OBJECT", cls);
        map.put("KEY_PARAM", params);
        map.put("KEY_ENCRYPT", encrypt);
        ArrayList<Map<String, Object>> applyData = new ArrayList<Map<String, Object>>();
        applyData.add(map);
        ac.setApplyList(applyData);
        SJctrAccAdtLogData adtLogData = this.makeAdtLogData(logUty, (SJbaseUserSession)wizard.getOwner().getUserSession(), wizard.getOwner().getComUtility(), createUserData);
        ac.setAdtLogData(adtLogData);
        wizard.addConfirmData(ac, related);
        logUty.putlog(strLogSubTitle, "end");
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{SJctrAccountDataMacro.WIZARD_CREATEUSER_DC};
        return clsList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    private SJctrAccAdtLogData makeAdtLogData(SJctrLogUty logUty, SJbaseUserSession userSession, SJctrComUtility comUty, SJctrCreateUserData createUserData) {
        String strLogSubTitle = "makeAdtLogData";
        SJctrAccAdtLogData adtLogData = new SJctrAccAdtLogData();
        try {
            adtLogData = SJctrAccAdtLogUty.makeAccAdtLogData(logUty, userSession, comUty.getGuidance("ACCOUNT", "ADT_CREATE_USER"));
            adtLogData.setDetailList(this.makeAdtDetailList(comUty, createUserData));
            if (!adtLogData.getDetailList().isEmpty()) {
                adtLogData.setStrFooter(comUty.getGuidance("ACCOUNT", "ADT_USER_NUM"));
            }
            adtLogData.setStrNormalEnd(comUty.getGuidance("ADT_NORMAL_END"));
            adtLogData.setStrError(comUty.getGuidance("ADT_ERROR"));
        }
        catch (Exception e) {
            if (logUty != null) {
                logUty.putlog(strLogSubTitle, "[Logic Error]makeAdtLogData() is failed.", e, 40000);
            }
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        return adtLogData;
    }

    private List<SJctrAuditLogData> makeAdtDetailList(SJctrComUtility util, SJctrCreateUserData createUserData) {
        ArrayList<SJctrAuditLogData> detailList = new ArrayList<SJctrAuditLogData>();
        SJctrUserInfoDetailUtility userInfoDetailUty = util.getUserInfoDetailUtility();
        SJctrUserGrpInfoDetailUtility userGrpInfoDetailUty = util.getUserGrpInfoDetailUtility();
        ArrayList<String> partsIDList = new ArrayList<String>();
        partsIDList.add("ADT_USER_ID");
        partsIDList.add("ADT_ACC");
        partsIDList.add("ADT_AUTH");
        partsIDList.add("ADT_GRP_NAME");
        partsIDList.add("ADT_RESULT");
        SJctrUserInfoDetail[] userInfo_array = new SJctrUserInfoDetail[]{createUserData.getUserInfoDetail()};
        SJctrUserGrpInfoDetail[] userGrpInfo_array = new SJctrUserGrpInfoDetail[]{createUserData.getUserGrpInfoDetail()};
        for (int i = 0; i < userInfo_array.length; ++i) {
            SJctrDefaultAuditLogData adtData = new SJctrDefaultAuditLogData();
            adtData.setKeys(partsIDList);
            adtData.setScrID(new ArrayList<String>(0));
            adtData.setTitle("ADT_USER_ID", util.getGuidance("ACCOUNT", "ADT_USER_ID"));
            adtData.setValue("ADT_USER_ID", userInfoDetailUty.toUserIDDisplay(userInfo_array[i]));
            adtData.setTitle("ADT_ACC", util.getGuidance("ACCOUNT", "ADT_ACC"));
            adtData.setValue("ADT_ACC", userInfoDetailUty.toUserAccountAdtDisplay(userInfo_array[i]));
            adtData.setTitle("ADT_AUTH", util.getGuidance("ACCOUNT", "ADT_AUTH"));
            adtData.setValue("ADT_AUTH", userInfoDetailUty.toUserAuthAdtDisplay(userInfo_array[i]));
            adtData.setTitle("ADT_GRP_NAME", util.getGuidance("ACCOUNT", "ADT_GRP_NAME"));
            adtData.setValue("ADT_GRP_NAME", userGrpInfoDetailUty.toUserGrpNameDisplay(userGrpInfo_array[i]));
            adtData.setTitle("ADT_RESULT", util.getGuidance("ADT_RESULT"));
            adtData.setValue("ADT_RESULT", util.getGuidance("ADT_NORMAL_END"));
            detailList.add(adtData);
        }
        return detailList;
    }
}

