/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.deleteusers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcAccountConst;
import sanproject.sn2.com.utility.account.exception.SJcCommunicationErrorException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountInfoUty;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.account.deleteusers.SJctrDeleteUsersConfirmTableModel;
import sanproject.sn2.controller.wizard.account.deleteusers.SJctrDeleteUsersSelectData;

public class SJctrDeleteUsersConfirmDC
extends SJctrConfirmDataController {
    protected static final int DISP_ID = 17870949;
    private static final String COM_TABLE_SEL_USER_65 = "COM_TABLE_SEL_USER_65";

    public SJctrDeleteUsersConfirmDC() {
        super(17870949);
        this.initDataModel();
    }

    @Override
    public boolean checkStartData() {
        String strLogSubTitle = "checkStartData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        boolean result = true;
        SJctrError errInfo = null;
        List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_DELETEUSERS_SELECT_DATA);
        if (!this.checkContactData(dat)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrDeleteUsersSelectData deleteUsersSelectData = (SJctrDeleteUsersSelectData)dat.get(0);
        List<SJctrUserInfoDetail> userInfoDetailList = deleteUsersSelectData.getUserInfoDetailList();
        if (userInfoDetailList == null || userInfoDetailList.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (User Info Detail List) is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        int userNum = userInfoDetailList.size();
        String[] userIDs = new String[userNum];
        for (int i = 0; i < userNum; ++i) {
            userIDs[i] = userInfoDetailList.get(i).getUserName();
        }
        Map<String, SJctrUserInfoDetail> userInfoDetailMap = null;
        try {
            userInfoDetailMap = SJctrAccountInfoUty.getUserInfoDetailList(userIDs, this);
        }
        catch (SJcCommunicationErrorException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Communication Error]getUserInfoDetailList() is failed(" + e.getClass().getSimpleName() + ")", null, 40000);
            SJctrError err = new SJctrError(201, 22, 208003);
            SJcException exception = err.createException();
            throw exception;
        }
        catch (SJcException e) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getUserInfoDetailList() is failed (" + e.getClass().getSimpleName() + ")", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(userNum);
        boolean bRet = false;
        for (int i = 0; i < userNum; ++i) {
            SJctrUserController uc;
            String myUserID;
            SJctrErrorColumnData errData;
            SJctrError error;
            bRet = false;
            String userID = userIDs[i];
            SJctrUserInfoDetail userInfoDetail = userInfoDetailMap.get(userID);
            if (userInfoDetail == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]userInfo is null(" + userID + ")", null, 40000);
                result = false;
                error = new SJctrError(2, 22, 107013);
                if (errInfo == null) {
                    errInfo = error;
                }
                if (errInfo.getError() == 107013) {
                    errData = new SJctrErrorColumnData(userInfoDetailList.get(i), error);
                    errList.add(errData);
                    continue;
                }
            }
            if (userInfoDetail.getType() != SJcAccountConst.INT_USERTYPE_USER) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Select User is Built-in", null, 40000);
                result = false;
                error = new SJctrError(2, 22, 106053);
                if (errInfo == null) {
                    errInfo = error;
                }
                if (errInfo.getError() == 106053) {
                    errData = new SJctrErrorColumnData(userInfoDetail, error);
                    errList.add(errData);
                    continue;
                }
            }
            if ((myUserID = (uc = this.getOwner()).getUserSession().getUserName()) == null || userID == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]userID is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            if (!myUserID.equals(userID)) continue;
            this.getLogUty().putlog(strLogSubTitle, "[Error]Select My UserID", null, 40000);
            SJctrError err = new SJctrError(2, 22, 106054);
            SJcException exception = err.createException();
            throw exception;
        }
        if (!result) {
            SJctrDataController parentDC = this.getWizardWindow().getParentDC();
            SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel("COM_TABLE");
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        ArrayList<SJctrUserInfoDetail> availableUserlist = new ArrayList<SJctrUserInfoDetail>();
        for (String strUserID : userIDs) {
            availableUserlist.add(userInfoDetailMap.get(strUserID));
        }
        SJctrDeleteUsersSelectData deleteUsersData = new SJctrDeleteUsersSelectData();
        deleteUsersData.setUserInfoDetailList(availableUserlist);
        ArrayList<SJctrDeleteUsersSelectData> list = new ArrayList<SJctrDeleteUsersSelectData>();
        list.add(deleteUsersData);
        this.putCache(SJctrAccountDataMacro.WIZARD_DELETEUSERS_SELECT_DATA, list);
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    private void initDataModel() {
        this.addDataObjectModel(COM_TABLE_SEL_USER_65, new SJctrDeleteUsersConfirmTableModel());
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap map = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrAccountDataMacro.WIZARD_DELETEUSERS_SELECT_DATA);
        map.put(SJctrAccountDataMacro.WIZARD_DELETEUSERS_SELECT_DATA, confirmDataList);
        Map<String, List<?>> result = SJctrConfirmDataController.mapkeyClassToString(map);
        return result;
    }

    public boolean checkContactData(List<?> dat) {
        String strLogSubTitle = "checkContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        if (dat == null || dat.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            return false;
        }
        Object obj = dat.get(0);
        if (obj == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_DELETEUSERS_SELECT_DATA.getSimpleName() + ") is Empty", null, 40000);
            return false;
        }
        if (!(obj instanceof SJctrDeleteUsersSelectData)) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            return false;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    @Override
    public void getConfirmWithStatus(List<Object> destErrorList) throws SJcException {
        String strLogSubTitle = "getConfirmWithStatus";
        try {
            this.getLogUty().putlog(strLogSubTitle, "start");
            List cfrmErrorList = (List)destErrorList.get(0);
            List applyErrorList = (List)cfrmErrorList.get(0);
            List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_DELETEUSERS_SELECT_DATA);
            SJctrDeleteUsersSelectData delUsersData = (SJctrDeleteUsersSelectData)dat.get(0);
            List<SJctrUserInfoDetail> userInfoDetailList = delUsersData.getUserInfoDetailList();
            ArrayList<SJctrUserInfoDetail> err_userInfoList = new ArrayList<SJctrUserInfoDetail>();
            ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>();
            for (int i = 0; i < userInfoDetailList.size(); ++i) {
                if (((SJctrError)applyErrorList.get(i)).getError() == 0) continue;
                SJctrUserInfoDetail userInfoDetail = userInfoDetailList.get(i);
                err_userInfoList.add(userInfoDetail);
                SJctrError err = new SJctrError(((SJctrError)applyErrorList.get(i)).getFunc(), ((SJctrError)applyErrorList.get(i)).getModule(), ((SJctrError)applyErrorList.get(i)).getError());
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(userInfoDetail, err);
                errList.add(errColumn);
            }
            delUsersData.setUserInfoDetailList(err_userInfoList);
            ArrayList<SJctrDeleteUsersSelectData> list = new ArrayList<SJctrDeleteUsersSelectData>();
            list.add(delUsersData);
            this.getProxy().putCache(SJctrAccountDataMacro.WIZARD_DELETEUSERS_SELECT_DATA, list);
            SJctrDeleteUsersConfirmTableModel table = (SJctrDeleteUsersConfirmTableModel)this.getDataObjectModel(COM_TABLE_SEL_USER_65);
            table.makeDataModel();
            SJctrErrorTableModel errTable = new SJctrErrorTableModel();
            this.addDataObjectModel(COM_TABLE_SEL_USER_65, errTable);
            errTable.initialize(table, errList, new SJctrErrorColumnDataComparator());
            this.getLogUty().putlog(strLogSubTitle, "end");
        }
        catch (Exception e) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]getConfirmWithStatus is failed", e, 40000);
            throw new SJcException();
        }
    }
}

