/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.extauth.setupkerberos;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.account.extauth.setupkerberos.SJctrKerberosServerConfirmData;
import sanproject.sn2.controller.wizard.account.extauth.setupkerberos.SJctrKerberosServerConfirmTableModel;

public class SJctrKerberosServerConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 16826447;
    private static final String KEY_TABLE = "COM_TABLE";
    public static int RESULT_NORMAL = 0;
    public static int KERBEROS_NOT_FOUND_PARAM = 107005;

    public SJctrKerberosServerConfirmDC() throws SJcException {
        super(16826447);
        this.initDataModel();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        List<?> confirmDataList = this.getCache(SJctrKerberosServerConfirmData.KERBEROS_SERVER_CONFIRM_DATA);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            errorCode = KERBEROS_NOT_FOUND_PARAM;
        } else if (!(confirmDataList.get(0) instanceof SJctrKerberosServerConfirmData)) {
            errorCode = KERBEROS_NOT_FOUND_PARAM;
        }
        SJctrKerberosServerConfirmData confirmData = null;
        if (errorCode == RESULT_NORMAL) {
            confirmData = (SJctrKerberosServerConfirmData)confirmDataList.get(0);
        }
        if (errorCode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(2, 22, errorCode);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    private void initDataModel() {
        SJctrKerberosServerConfirmTableModel confirmTable = new SJctrKerberosServerConfirmTableModel();
        this.addDataObjectModel(KEY_TABLE, confirmTable);
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap map = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrKerberosServerConfirmData.KERBEROS_SERVER_CONFIRM_DATA);
        map.put(SJctrKerberosServerConfirmData.KERBEROS_SERVER_CONFIRM_DATA, confirmDataList);
        Map<String, List<?>> result = SJctrConfirmDataController.mapkeyClassToString(map);
        return result;
    }

    @Override
    public void getConfirmWithStatus(List<Object> destErrorList) throws SJcException {
        SJctrKerberosServerConfirmData confirmData = (SJctrKerberosServerConfirmData)this.getCache(SJctrKerberosServerConfirmData.KERBEROS_SERVER_CONFIRM_DATA).get(0);
        SJctrKerberosServerConfirmTableModel table = (SJctrKerberosServerConfirmTableModel)this.getDataObjectModel(KEY_TABLE);
        ArrayList confirmList = new ArrayList();
        table.setBasicData(SJctrKerberosServerConfirmData.KERBEROS_SERVER_CONFIRM_DATA, confirmList);
        table.makeDataModel();
        List tempList = (List)destErrorList.get(0);
        List errList = (List)tempList.get(0);
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(1);
        SJctrError err = (SJctrError)errList.get(0);
        SJctrErrorColumnData errColumn = new SJctrErrorColumnData(confirmData.getServerInfo(), err);
        errColumnList.add(errColumn);
        SJctrErrorColumnDataComparator COMPARATOR = new SJctrErrorColumnDataComparator();
        SJctrErrorTableModel errTable = new SJctrErrorTableModel();
        this.addDataObjectModel(KEY_TABLE, errTable);
        errTable.initialize(table, errColumnList, COMPARATOR);
    }
}

