/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.assignSDs.cntl;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.forcibly.com.SJctrForciblyAC;
import sanproject.sn2.model.data.device.SJmoPdevDetail;

public class SJctrAssignSDsAC
extends SJctrForciblyAC {
    private static final long serialVersionUID = -2945835158971652431L;
    private List<SJmoPdevDetail> assignedPdevList;
    private List<SJmoPdevDetail> releasedPdevList;
    private List<SJmoPdevDetail> allPdevList;
    private List<SJctrError> resultData = new ArrayList<SJctrError>();

    public SJctrAssignSDsAC(List<SJmoPdevDetail> assignedPdevList, List<SJmoPdevDetail> releasedPdevList) {
        this.assignedPdevList = assignedPdevList;
        this.releasedPdevList = releasedPdevList;
        this.allPdevList = new ArrayList<SJmoPdevDetail>();
        this.allPdevList.addAll(assignedPdevList);
        this.allPdevList.addAll(releasedPdevList);
    }

    @Override
    public int getLeadTime() {
        return 65;
    }

    public ArrayList<SanRequest> getSetList() {
        ArrayList<SanRequest> list = new ArrayList<SanRequest>();
        try {
            SanObject drive;
            SanRequest request = this.newRequest("MNTupdateSpareDrives");
            SanList drives = request.newList("Drives");
            StringBuffer bufAssign = new StringBuffer();
            StringBuffer bufRelease = new StringBuffer();
            for (SJmoPdevDetail pdev : this.assignedPdevList) {
                drive = drives.addObj();
                drive.putIntArray("Id", new int[]{pdev.getCDEV(), pdev.getRDEV()});
                drive.putBoolean("Spare", true);
                if (bufAssign.length() > 0) {
                    bufAssign.append(",");
                }
                bufAssign.append(pdev.getKey());
            }
            for (SJmoPdevDetail pdev : this.releasedPdevList) {
                drive = drives.addObj();
                drive.putIntArray("Id", new int[]{pdev.getCDEV(), pdev.getRDEV()});
                drive.putBoolean("Spare", false);
                if (bufRelease.length() > 0) {
                    bufRelease.append(",");
                }
                bufRelease.append(pdev.getKey());
            }
            list.add(request);
            SJctrLogUty.info(this.getClass().getSimpleName(), "getSetList", "Assign PDEV:" + bufAssign.toString());
            SJctrLogUty.info(this.getClass().getSimpleName(), "getSetList", "Release PDEV:" + bufRelease.toString());
        }
        catch (SanDataException e) {
            SJctrError error = SJctrParityGroupUtility.createPgInternalError();
            this.setError(error);
            SJctrLogUty.error(this.getClass().getSimpleName(), "getSetList", "Failed to build set list", e);
        }
        return list;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        try {
            if (resultObject == null) {
                return;
            }
            SanResponse response = (SanResponse)resultObject;
            SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(response);
            if (errorInfo.getErrorCode() != 0) {
                SJctrError error = errorInfo.createError();
                this.setError(error);
                SanList drives = response.getList("Drives");
                for (SanObject drive : drives) {
                    int[] driveId = drive.getIntArray("Id");
                    boolean find = false;
                    for (SJmoPdevDetail pdev : this.allPdevList) {
                        if (pdev.getCDEV() != driveId[0] || pdev.getRDEV() != driveId[1]) continue;
                        SanObject driveErrorInfo = drive.getObj("ErrorInfo");
                        SJctrError createError = new SJctrKeyValueErrorInfo(driveErrorInfo).createError();
                        this.resultData.add(createError);
                        find = true;
                        break;
                    }
                    if (find) continue;
                    this.resultData.add(new SJctrError(error.getFunc(), error.getModule(), 0));
                }
            }
        }
        catch (SanDataException e) {
            SJctrError error = SJctrParityGroupUtility.createPgInternalError();
            this.setError(error);
            SJctrLogUty.error(this.getClass().getSimpleName(), "setApplyResult", "Failed to build result list", e);
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }
}

