/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.assignSDs.cntl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPdevUtility;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.arraygroup.assignSDs.model.SJctrAssignSDsDrivesTableModel;
import sanproject.sn2.controller.wizard.arraygroup.assignSDs.model.SJctrAssignSDsSelectData;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilPdev;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.modelrc.util.SJmoRscUtilPdev;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;

public class SJctrAssignSDsDC
extends SJctrWizardDataController {
    public static final int DISP_ID = 17832321;
    public static final Class KEY_CLASS_PDEV_UTIL = SJmoGetRscUtilPdev.class;
    private SJctrAssignSDsDrivesTableModel availableDrvsTable;
    private SJctrAssignSDsDrivesTableModel selectedDrvsTable;

    public SJctrAssignSDsDC() {
        super(17832321);
        this.initDataModel();
    }

    protected void initDataModel() {
        this.initTableModel();
        this.initButtonModel();
        this.initListener();
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initTableModel() {
        this.availableDrvsTable = new SJctrAssignSDsDrivesTableModel();
        this.addDataObjectModel("COM_AVAILABLE_DRIVES_TBL", this.availableDrvsTable);
        this.selectedDrvsTable = new SJctrAssignSDsDrivesTableModel();
        this.addDataObjectModel("COM_SELECTED_DRIVES_TBL", this.selectedDrvsTable);
    }

    private void initListener() {
        this.addMessageEventListener(State.ADD, new AddActionListener());
        this.addMessageEventListener(State.REMOVE, new RemoveActionListener());
    }

    private void initButtonModel() {
        SJctrButtonDataModel button = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_ADD", button);
        button.setRollBackCheck(true);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAssignSDsDC.this.fireMessageEvent(State.ADD);
            }
        });
        button = new SJctrButtonDataModel();
        this.addDataObjectModel("COM_REMOVE", button);
        button.setRollBackCheck(true);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrAssignSDsDC.this.fireMessageEvent(State.REMOVE);
            }
        });
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("PG", "ASSIGN_SDS");
    }

    @Override
    public boolean checkConstructData() {
        ArrayList<SJmoPdevDetail> target = new ArrayList<SJmoPdevDetail>();
        SJmoRscUtilPdev pdevUtil = this.getRscPdevUty();
        SJctrAssignSDsSelectData data = this.getSelectedPdevListFromCache();
        if (data == null) {
            List pdevDetails = this.getCachedData(SJmoGetPdevDetail.class);
            for (int i = 0; i < pdevDetails.size(); ++i) {
                SJmoPdevDetail pd = (SJmoPdevDetail)pdevDetails.get(i);
                if (0 != pdevUtil.chkCRID(pd)) continue;
                target.add(pd);
            }
        } else {
            for (SJmoPdevDetail pdev : data.getTargetPdevDetails()) {
                if (!SJctrPdevUtility.isSpareDriveKind(pdev) && !SJctrPdevUtility.isFreeDriveKind(pdev)) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "including non-spare/non-free drives");
                    throw SJctrParityGroupUtility.createPgException(206193);
                }
                if (!SJctrPdevUtility.isNormalStatus(pdev) && SJctrPdevUtility.isFreeDriveKind(pdev)) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "including status is not Normal/non-free drives");
                    throw SJctrParityGroupUtility.createPgException(206177);
                }
                if (SJctrPdevUtility.isReservedStatus(pdev)) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "including status is Reserved");
                    throw SJctrParityGroupUtility.createPgException(206177);
                }
                if (0 == pdevUtil.chkCRID(pdev)) continue;
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "including reserved by task");
                throw SJctrParityGroupUtility.createPgException(206177);
            }
            target.addAll(data.getTargetPdevDetails());
        }
        ArrayList<SJmoPdevDetail> available = new ArrayList<SJmoPdevDetail>();
        ArrayList<SJmoPdevDetail> selected = new ArrayList<SJmoPdevDetail>();
        for (SJmoPdevDetail pdev : target) {
            if (SJctrPdevUtility.isNormalStatus(pdev) && SJctrPdevUtility.isFreeDriveKind(pdev)) {
                available.add(pdev);
                continue;
            }
            if (SJctrPdevUtility.isReservedStatus(pdev) || !SJctrPdevUtility.isSpareDriveKind(pdev)) continue;
            selected.add(pdev);
        }
        this.availableDrvsTable.refreshData(available);
        this.availableDrvsTable.setDirty();
        this.selectedDrvsTable.refreshData(selected);
        this.selectedDrvsTable.setDirty();
        this.putCache("KEY_NEW_SPARE_DRIVE", new ArrayList());
        this.putCache("KEY_REMOVAL_SPARE_DRIVE", new ArrayList());
        return true;
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        this.updateButton();
    }

    protected void updateButton() {
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (this.canGoToNext()) {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, true);
        } else {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
        }
        footer.setDirtyAll();
    }

    protected boolean canGoToNext() {
        List newSdList = this.getCacheData("KEY_NEW_SPARE_DRIVE");
        List remSdList = this.getCacheData("KEY_REMOVAL_SPARE_DRIVE");
        return !newSdList.isEmpty() || !remSdList.isEmpty();
    }

    private int getMaxNumOfSpare() {
        int maxNumOfSpare = 64;
        int productModel = SJsncProductModelUty.getProductModel();
        if (productModel == 20) {
            maxNumOfSpare = 16;
        } else if (productModel == 40) {
            maxNumOfSpare = 32;
        } else if (productModel == 60) {
            maxNumOfSpare = 64;
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getMaxNumOfSpare", "unsupported model");
            throw SJctrParityGroupUtility.createPgException(206194);
        }
        return maxNumOfSpare;
    }

    private <T> List<T> getCachedData(Class<?> clazz) {
        return this.getCache(clazz);
    }

    private SJctrAssignSDsSelectData getSelectedPdevListFromCache() {
        List<?> data = this.getCache(SJctrAssignSDsSelectData.class);
        if (data == null || data.isEmpty()) {
            return null;
        }
        SJctrAssignSDsSelectData selectedData = (SJctrAssignSDsSelectData)data.get(0);
        return selectedData;
    }

    @Override
    public boolean checkEndData() {
        return true;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(this.createGetDirectWrapper(new SJmoGetPdevDetail()));
        set.add(this.createGetDirectWrapper(new SJmoGetRscUtilPdev()));
        return set;
    }

    private SJctrGetDirectWrapper createGetDirectWrapper(SJmoGetKind_IF kind) {
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        return new SJctrGetDirectWrapper(direct);
    }

    private <T> List<T> getCacheData(String key) {
        return new ArrayList(this.getCache(key));
    }

    private SJmoRscUtilPdev getRscPdevUty() {
        List<?> wkPDEVList = this.getCache(KEY_CLASS_PDEV_UTIL);
        SJmoRscUtilPdev wkPdev = (SJmoRscUtilPdev)wkPDEVList.get(0);
        return wkPdev;
    }

    private void refreshRsvData() {
        List<?> assigned = this.getProxy().getCache("KEY_NEW_SPARE_DRIVE");
        List<?> released = this.getProxy().getCache("KEY_REMOVAL_SPARE_DRIVE");
        List<?> pdevUtilList = this.getCache(KEY_CLASS_PDEV_UTIL);
        SJmoRscUtilPdev rscPdev = (SJmoRscUtilPdev)pdevUtilList.get(0);
        SJctrAssignSDsSelectData data = this.getSelectedPdevListFromCache();
        if (data != null) {
            ArrayList list = (ArrayList)data.getTargetPdevDetails();
            ArrayList<ArrayList> storePdevRscList = new ArrayList<ArrayList>();
            storePdevRscList.add(list);
            rscPdev.delRsvData(storePdevRscList);
        } else {
            rscPdev.clearRsvData();
        }
        this.resetRscUtil();
        ArrayList pdevList = new ArrayList();
        pdevList.addAll(assigned);
        pdevList.addAll(released);
        for (int i = 0; i < pdevList.size(); ++i) {
            ((SJmoPdevDetail)pdevList.get(i)).setIDataMode(2);
        }
        ArrayList storePdevRscList = new ArrayList();
        storePdevRscList.add(pdevList);
        rscPdev.setRsvData(storePdevRscList);
        pdevUtilList = new ArrayList();
        pdevUtilList.add(rscPdev);
        this.putCache(KEY_CLASS_PDEV_UTIL, pdevUtilList);
    }

    private class RemoveActionListener
    implements SJctrMessageEventListener {
        private RemoveActionListener() {
        }

        @Override
        public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
            List<Object> removeSelectedRowData = SJctrAssignSDsDC.this.selectedDrvsTable.removeSelectedRowData();
            SJctrAssignSDsDC.this.availableDrvsTable.addRowDataTop(removeSelectedRowData);
            List newSdList = SJctrAssignSDsDC.this.getCacheData("KEY_NEW_SPARE_DRIVE");
            List remSdList = SJctrAssignSDsDC.this.getCacheData("KEY_REMOVAL_SPARE_DRIVE");
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object obj : removeSelectedRowData) {
                if (!newSdList.contains(obj)) {
                    list.add(obj);
                    continue;
                }
                remSdList.remove(obj);
            }
            newSdList.removeAll(removeSelectedRowData);
            remSdList.addAll(list);
            SJctrAssignSDsDC.this.putCache("KEY_NEW_SPARE_DRIVE", newSdList);
            SJctrAssignSDsDC.this.putCache("KEY_REMOVAL_SPARE_DRIVE", remSdList);
            SJctrAssignSDsDC.this.refreshRsvData();
            SJctrAssignSDsDC.this.updateFooter();
            SJctrAssignSDsDC.this.setDirtyAll();
        }
    }

    private class AddActionListener
    implements SJctrMessageEventListener {
        private AddActionListener() {
        }

        @Override
        public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
            List<Object> selectedRowData = SJctrAssignSDsDC.this.availableDrvsTable.getSelectedRowData();
            int maxNumOfSpare = SJctrAssignSDsDC.this.getMaxNumOfSpare();
            if (SJctrAssignSDsDC.this.selectedDrvsTable.getRowCount() + selectedRowData.size() > maxNumOfSpare) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "doMessageAction", "over max number of spare drives");
                throw SJctrParityGroupUtility.createPgException(206178);
            }
            selectedRowData = SJctrAssignSDsDC.this.availableDrvsTable.removeSelectedRowData();
            SJctrAssignSDsDC.this.selectedDrvsTable.addRowDataTop(selectedRowData);
            List newSdList = SJctrAssignSDsDC.this.getCacheData("KEY_NEW_SPARE_DRIVE");
            List remSdList = SJctrAssignSDsDC.this.getCacheData("KEY_REMOVAL_SPARE_DRIVE");
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object obj : selectedRowData) {
                if (!remSdList.contains(obj)) {
                    list.add(obj);
                    continue;
                }
                newSdList.remove(obj);
            }
            newSdList.addAll(list);
            remSdList.removeAll(selectedRowData);
            SJctrAssignSDsDC.this.putCache("KEY_NEW_SPARE_DRIVE", newSdList);
            SJctrAssignSDsDC.this.putCache("KEY_REMOVAL_SPARE_DRIVE", remSdList);
            SJctrAssignSDsDC.this.refreshRsvData();
            SJctrAssignSDsDC.this.updateFooter();
            SJctrAssignSDsDC.this.setDirtyAll();
        }
    }

    private static enum State implements SJctrNotifyState
    {
        ADD,
        REMOVE;

    }
}

