/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.createpgs.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPdevUtility;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.SJctrSelectedPGData;
import sanproject.sn2.controller.wizard.arraygroup.createpgs.column.SJctrPGTableStringColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;

public class SJctrCreatePGsSelectedPGsTableModel
extends SJctrTableDataModel {
    private List<SJctrSelectedPGData> list = new ArrayList<SJctrSelectedPGData>();

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        return new ArrayList<SJmoSearchTerm_IF>();
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    protected void setControllerData() {
        super.setControllerData();
        this.setBasicData(SJctrSelectedPGData.class, this.list);
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_ARYGRP", "AG_ID"));
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_DRIVEKIND", "DRIVE_KIND"));
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_RAIDLEV", "RAID_LEVEL"));
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_CLPR", "CLPR"));
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_ENCRIPTION", "ENCRYPTION"));
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_VIRTUALIZATION_MODE", "COMPRESSION_MODE"));
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_COPYBACKMODE", "COPY_BACK_MODE"));
        this.addColumn(new SJctrPGTableStringColumn("COM_COL_DRIVETYPE", "DRIVE_CODE"));
        this.setPrimaryColumn("COM_COL_ARYGRP");
        this.setPrimaryClass(SJctrSelectedPGData.class);
    }

    public void refreshData(Map<Integer, SJctrParityGroupUtility.ScatteredPgInfo> candidates) {
        SJctrLdevUtility ldevUtil = this.getComUtility().getLdevUtility();
        SJctrPdevUtility pdevUtil = this.getComUtility().getPdevUtility();
        String enabled = this.getComUtility().getGuidance("ENABLE");
        String disabled = this.getComUtility().getGuidance("DISABLE");
        this.list.clear();
        ArrayList<String> dbglist = new ArrayList<String>();
        for (SJctrParityGroupUtility.ScatteredPgInfo pginfo : candidates.values()) {
            boolean concatenatedPg = pginfo.isConcatenatedPg();
            Iterator<SJctrParityGroupUtility.PgPdevInfo> i$ = pginfo.getPgPdevs().iterator();
            if (!i$.hasNext()) continue;
            SJctrParityGroupUtility.PgPdevInfo pgPdevInfo = i$.next();
            SJmoPgDetail pg = pgPdevInfo.getPg();
            SJmoPdevDetail pdev = pgPdevInfo.getPdevs().get(0);
            SJctrParityGroupUtility.RaidLevel raidLevel = SJctrParityGroupUtility.RaidLevel.findByRmiValue(pg.getRaidLevel());
            SJctrSelectedPGData data = new SJctrSelectedPGData();
            data.setPgDetail(pg);
            data.setPgId(ldevUtil.toArrayGroupDisplay(pg));
            data.setRaidLevel(raidLevel.getDisplayName() + (concatenatedPg ? "*" + pginfo.getPgPdevs().size() : ""));
            data.setDriveTypeCode(pdev.getHDDKind());
            data.setDriveKind(pdevUtil.getStrDriveKind(pdev));
            data.setDriveTypeRpm(pdevUtil.getStrDriveTypeRPM(pdev));
            data.setClpr(ldevUtil.toClprDisplay(pginfo.getClpr()));
            data.setEncryption(pgPdevInfo.getEnc().getEncrypt() == 1 ? enabled : disabled);
            String vmText = "-";
            if (pg.getBVirtSupport()) {
                vmText = pg.getBVirtMode() ? enabled : disabled;
            }
            data.setVirtMode(vmText);
            data.setCopyBackMode(pg.getCopybackMode() == SJctrParityGroupUtility.RMI_VALUE_COPYBACK_ENABLED ? enabled : disabled);
            this.list.add(data);
            String dbenc = enabled == data.getEncryption() ? "E" : "D";
            String dbvm = "-";
            if (data.getVirtMode() == enabled) {
                dbvm = "E";
            } else if (data.getVirtMode() == disabled) {
                dbvm = "D";
            }
            String dbcbm = enabled == data.getCopyBackMode() ? "E" : "D";
            dbglist.add(data.getPgId() + dbenc + dbvm + dbcbm);
        }
        SJctrLogUty.info(this.getClass().getSimpleName(), "refreshData", "Selected PGs:" + dbglist);
        this.doRefresh();
    }
}

