/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevSecurityInfo;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoThinProvisioningVolumesStatus;

public class SJctrCVSCheck
implements SJctrCVSMacro {
    public static boolean checkLUSE(List<SJmoLdevDetail> ldevDetail, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJmoLdevDetail ldev : ldevDetail) {
            if (ldev.getSLUSEEmlCount() == 1) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 105139);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkLUSE", "LUSE found");
        }
        return bRet;
    }

    public static boolean checkPath(List<SJmoLdevDetail> ldevDetail, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJmoLdevDetail ldev : ldevDetail) {
            if (ldev.getILUPathNumber() == 0) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 105135);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkPath", "Path found");
        }
        return bRet;
    }

    public static boolean checkVM(List<SJmoLdevDetail> ldevDetail, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJmoLdevDetail ldev : ldevDetail) {
            if (!ldev.getbHIHSMReserve()) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 105138);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkVM", "Volume Migration found");
        }
        return bRet;
    }

    public static boolean checkLdevSec(List<SJmoLdevDetail> ldevDetail, List ldevSec, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJmoLdevDetail ldev : ldevDetail) {
            SJmoLdevIndex ldevIndex = SJctrCVSUtility.createLdevIndex(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev());
            int iLdevIndex = Collections.binarySearch(ldevSec, ldevIndex);
            if (iLdevIndex >= 0) {
                SJmoLdevSecurityInfo ldevSecInfo = (SJmoLdevSecurityInfo)ldevSec.get(iLdevIndex);
                if (ldevSecInfo.getByLdevSecurity() != 1) continue;
                bRet = false;
                SJctrError error = new SJctrError(30, 22, 105137);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
                errColumnList.add(errColumn);
                continue;
            }
            bRet = false;
            SJctrLogUty.error("SJctrCVSCheck", "checkLdevSec", "LDEV Security Not found");
            SJctrCVSUtility.output_Error(30, 22, 105248);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkLdevSec", "LDEV Security found");
        }
        return bRet;
    }

    public static boolean checkAttribute(List<SJmoLdevDetail> ldevDetail, List ldevGuard, ArrayList<SJctrErrorColumnData> errColumnList, SJctrComCVSUtility cvsUty) {
        boolean bRet = true;
        String checkOPENorMain = "";
        for (SJmoLdevDetail ldev : ldevDetail) {
            SJmoLdevIndex ldevIndex = SJctrCVSUtility.createLdevIndex(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev());
            checkOPENorMain = cvsUty.getEmulationTypeName(ldev.getIEmulationType());
            int iLdevIndex = Collections.binarySearch(ldevGuard, ldevIndex);
            if (iLdevIndex >= 0) {
                SJmoLdevGuardInfo ldevGuardInf = (SJmoLdevGuardInfo)ldevGuard.get(iLdevIndex);
                if ((byte)(ldevGuardInf.getByLdevGuardStatus() & 0xC3) == -128) continue;
                bRet = false;
                SJctrError error = new SJctrError(30, 22, 105143);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
                errColumnList.add(errColumn);
                continue;
            }
            bRet = false;
            SJctrLogUty.error("SJctrCVSCheck", "checkAttribute", "ldevGuard Not found");
            SJctrCVSUtility.output_Error(30, 22, 105248);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkAttribute", "Not Read/Write found");
        }
        return bRet;
    }

    public static boolean checkPool(List<SJmoLdevDetail> ldevDetail, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJmoLdevDetail ldev : ldevDetail) {
            if (!ldev.getbPoolVol()) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 105136);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkPool", "Pool Volume found");
        }
        return bRet;
    }

    public static boolean checkJNL(List<SJmoLdevDetail> ldevDetail, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJmoLdevDetail ldev : ldevDetail) {
            if (!ldev.getbJNLVolume()) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 105141);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkJNL", "JNL Volume found");
        }
        return bRet;
    }

    public static boolean checkRemotecmd(List<SJmoLdevDetail> ldevDetail, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJmoLdevDetail ldev : ldevDetail) {
            if (!ldev.getbRmtComDev()) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 105140);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkRemotecmd", "Remote command Devices found");
        }
        return bRet;
    }

    public static boolean checkLockVol(List<SJmoLdevDetail> ldevDetail, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJmoLdevDetail ldev : ldevDetail) {
            if (!ldev.getBLockVolume()) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 105142);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkLockVol", "Lock Volume found");
        }
        return bRet;
    }

    public static boolean checkFDM(List<SJmoLdevDetail> ldevDetail, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJmoLdevDetail ldev : ldevDetail) {
            if (ldev.getByVolumeType() != 4) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 105145);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkFDM", "FICON DM Found");
        }
        return bRet;
    }

    public static boolean checkOpenLM(List<SJmoLdevDetail> ldevDetail, ArrayList<SJctrErrorColumnData> errColumnList, SJctrComCVSUtility cvsUty) {
        boolean bRet = true;
        String CheckOPENLM = "";
        for (SJmoLdevDetail ldev : ldevDetail) {
            CheckOPENLM = cvsUty.getEmulationTypeName(ldev.getIEmulationType());
            if (!CheckOPENLM.equals("OPEN-L") && !CheckOPENLM.equals("OPEN-M")) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 105144);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkOpenLM", "OPEN-L or OPEN-M found");
        }
        return bRet;
    }

    public static boolean checkLdevNameTotal(String sFixedstring, String sStartatstring, int iSize) {
        boolean bRet = true;
        int iLength = 0;
        int istart = 0;
        if (sStartatstring.length() > 0) {
            iLength = sStartatstring.length();
            istart = Integer.parseInt(sStartatstring);
        }
        String finalLDEVNumber = "";
        finalLDEVNumber = SJctrComUtility.toPaddingZeroString(istart + (iSize - 1), iLength);
        String sChangeLDEVName = "";
        if (sFixedstring != null && sFixedstring != "") {
            sChangeLDEVName = sChangeLDEVName + sFixedstring;
        }
        if (iLength > 0) {
            sChangeLDEVName = sChangeLDEVName + finalLDEVNumber;
        }
        if (sChangeLDEVName.length() > 32) {
            bRet = false;
            SJctrLogUty.error("SJctrCVSCheck", "checkLdevNameTotal", "LDEVName Total Over");
            SJctrCVSUtility.output_Error(30, 22, 205163);
        }
        return bRet;
    }

    public static boolean checkLdevNameString(String sFixedstring, String sStartatstring) {
        boolean bRet = true;
        for (char c : cannotUseChar) {
            int iFixednum = sFixedstring.indexOf(c);
            int iStartatnum = sStartatstring.indexOf(c);
            if (iFixednum == -1 && iStartatnum == -1) continue;
            bRet = false;
            break;
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkLdevNameString", "LDEVName cannotUseChar");
            SJctrCVSUtility.output_Error(30, 22, 105175);
        }
        return bRet;
    }

    public static boolean checkLdevNameStartat(String sStartatstring) {
        boolean bRet = true;
        for (int i = 0; i < sStartatstring.length(); ++i) {
            String sStr = sStartatstring.substring(i, i + 1);
            if (!sStr.matches("\\D")) continue;
            bRet = false;
            SJctrLogUty.error("SJctrCVSCheck", "checkLdevNameStartat", "char found");
            SJctrCVSUtility.output_Error(30, 22, 105176);
        }
        return bRet;
    }

    public static boolean checkLdevNameNumber(String sStartatstring, int iSize) {
        boolean bRet = true;
        if (sStartatstring != "") {
            int istart = 0;
            try {
                istart = Integer.parseInt(sStartatstring);
            }
            catch (Exception e) {
                SJctrLogUty.error("SJctrCVSCheck", "checkLdevNameNumber", "Conversion error of istart form sStartatstring ");
                SJctrCVSUtility.output_Error(30, 22, 205163);
            }
            int istartMax = 0;
            istartMax = istart + (iSize - 1);
            String finalLDEVNumber = "";
            if (sStartatstring.length() > 0) {
                finalLDEVNumber = SJctrComUtility.toPaddingZeroString(istartMax, sStartatstring.length());
            }
            if (finalLDEVNumber.length() > 9) {
                bRet = false;
                SJctrLogUty.error("SJctrCVSCheck", "checkLdevNameNumber", "Conversion error of istart form sStartatstring ");
                SJctrCVSUtility.output_Error(30, 22, 205163);
            }
        }
        return bRet;
    }

    public static boolean checkODM(List<SJmoLdevDetail> ldevDetail, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJmoLdevDetail ldev : ldevDetail) {
            if (!ldev.getbOdmVol()) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 105445);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        return bRet;
    }

    public static boolean checkFPTVol(List<SJmoLdevDetail> ldevDetail, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJmoLdevDetail ldev : ldevDetail) {
            if (ldev.getByVolumeType() != 3 || !ldev.getBFPTVol()) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 205220);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkFPTVol", "FPT Volume found");
        }
        return bRet;
    }

    public static boolean checkDRDVol(List<SJctrLDEVDetail> ldevList, List hdpRelationList, List dpVolStatusList, ArrayList<SJctrErrorColumnData> errColumnList) {
        boolean bRet = true;
        for (SJctrLDEVDetail ldev : ldevList) {
            int ldevIndex;
            if (ldev.getByVolumeType() != 3 || (ldevIndex = Collections.binarySearch(hdpRelationList, ldev)) < 0) continue;
            SJmoHDPRelation dpVolUsed = (SJmoHDPRelation)hdpRelationList.get(ldevIndex);
            int statusIndex = Collections.binarySearch(dpVolStatusList, ldev);
            if (statusIndex < 0) continue;
            SJmoThinProvisioningVolumesStatus status = (SJmoThinProvisioningVolumesStatus)dpVolStatusList.get(statusIndex);
            ldev.setDPVolStatus(status);
            if (0L >= dpVolUsed.getLDPVolUsed() || ldev.getIDataSavingStatus() == 0 || ldev.getIDataSavingStatus() == 1) continue;
            bRet = false;
            SJctrError error = new SJctrError(30, 22, 205228);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldev, error);
            errColumnList.add(errColumn);
        }
        if (!bRet) {
            SJctrLogUty.error("SJctrCVSCheck", "checkDRDVol", "DRD Volume found");
        }
        return bRet;
    }

    public static ArrayList<SJctrErrorColumnData> chkDRDRole(ArrayList aryLdevList, SJcRoleResourceContainer roleRscContainer) {
        ArrayList<SJctrErrorColumnData> rtn = new ArrayList<SJctrErrorColumnData>();
        if (!(roleRscContainer.checkAuthority(51) && roleRscContainer.checkAuthority(71) && roleRscContainer.checkAuthority(49))) {
            for (int i = 0; i < aryLdevList.size(); ++i) {
                SJctrLDEVDetail LDEVInf = (SJctrLDEVDetail)aryLdevList.get(i);
                if (!LDEVInf.chkAshyncTargetDelLdev_DRD()) continue;
                SJctrError error = new SJctrError(30, 22, 205224);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(LDEVInf, error);
                rtn.add(errColumn);
            }
        }
        return rtn;
    }

    public static ArrayList<SJctrErrorColumnData> chkdelDrdFpt(ArrayList aryLdevList, List HDPRelationbyPoolList, List ldevDetailList, List LDEVStatusList) {
        ArrayList<SJctrErrorColumnData> rtn = new ArrayList<SJctrErrorColumnData>();
        for (int i = 0; i < aryLdevList.size(); ++i) {
            int relIndex;
            SJctrLDEVDetail LDEVInf = (SJctrLDEVDetail)aryLdevList.get(i);
            if (LDEVInf.getSDataSaving() != 2 || (relIndex = Collections.binarySearch(HDPRelationbyPoolList, LDEVInf.getPoolIndex())) < 0) continue;
            SJmoHDPRelationByPool relPool = (SJmoHDPRelationByPool)HDPRelationbyPoolList.get(relIndex);
            ArrayList dpVolInfoList = relPool.getAlDPVOLInfo();
            for (int iDPVolInfo = 0; iDPVolInfo < dpVolInfoList.size(); ++iDPVolInfo) {
                SJmoLdevStatusInfo status;
                int statusIndex;
                SJmoLdevDetail ldevDetail;
                SJmoHDPRelation rel = (SJmoHDPRelation)dpVolInfoList.get(iDPVolInfo);
                int ldevIndex = Collections.binarySearch(ldevDetailList, rel);
                if (ldevIndex < 0 || !(ldevDetail = (SJmoLdevDetail)ldevDetailList.get(ldevIndex)).getBFPTVol() || (statusIndex = Collections.binarySearch(LDEVStatusList, rel)) < 0 || (status = (SJmoLdevStatusInfo)LDEVStatusList.get(statusIndex)).getLDEVStatus() != 2) continue;
                SJctrError error = new SJctrError(30, 22, 205231);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(LDEVInf, error);
                rtn.add(errColumn);
            }
        }
        return rtn;
    }

    public static ArrayList<SJctrErrorColumnData> chkdelDrdInconsistent(ArrayList aryLdevList) {
        ArrayList<SJctrErrorColumnData> rtn = new ArrayList<SJctrErrorColumnData>();
        for (int i = 0; i < aryLdevList.size(); ++i) {
            SJctrLDEVDetail LDEVInf = (SJctrLDEVDetail)aryLdevList.get(i);
            if (LDEVInf.getIDataSavingStatus() != 6) continue;
            SJctrError error = new SJctrError(30, 22, 205232);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(LDEVInf, error);
            rtn.add(errColumn);
        }
        return rtn;
    }

    public static ArrayList<SJctrErrorColumnData> chkdelDrdDisabling(ArrayList aryLdevList) {
        ArrayList<SJctrErrorColumnData> rtn = new ArrayList<SJctrErrorColumnData>();
        for (int i = 0; i < aryLdevList.size(); ++i) {
            SJctrLDEVDetail LDEVInf = (SJctrLDEVDetail)aryLdevList.get(i);
            if (LDEVInf.getIDataSavingStatus() != 3 || LDEVInf.getLUsedpage() > 0L) continue;
            SJctrError error = new SJctrError(30, 22, 205233);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(LDEVInf, error);
            rtn.add(errColumn);
        }
        return rtn;
    }
}

