/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.createldevs.basic.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.com.SJctrCreateLDEVsDef;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrFreeDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrBasicPhysicalSummaryModel
extends SJctrSimpleDataModel
implements SJctrCreateLDEVsDef,
SJctrCVSMacro {
    @Override
    public void makeDataObject() {
        List<?> FreeList = this.getDataController().getProxy().getCache("SEL_KEY_FREEDETAIL");
        SJctrUserController uc = this.getDataController().getOwner();
        SJctrLdevUtility ldevUtil = uc.getComUtility().getLdevUtility();
        SJctrFreeDetail free = (SJctrFreeDetail)FreeList.get(0);
        Object summaryData = this.getManageData();
        SJctrPGDetail targetPG = free.getPGDetail().getTopPGDetail();
        ((SJctrDataObject)summaryData).setData("COM_ARYGRP", ldevUtil.toArrayGroupDisplay(targetPG));
        String strRaidLevel = "";
        strRaidLevel = ldevUtil.toRaidLevelDisplay(free.getPGDetail());
        if (targetPG.getPGScatteredList().size() > 0) {
            strRaidLevel = strRaidLevel + "*" + (targetPG.getPGScatteredList().size() + 1);
        }
        ((SJctrDataObject)summaryData).setData("COM_RAIDLEV", strRaidLevel);
        ((SJctrDataObject)summaryData).setData("COM_CAP", this.getCapacitySize(targetPG));
        ((SJctrDataObject)summaryData).setData("COM_PHYSICAL_CAPA", this.getBasicUsableCapacitySize(targetPG));
        String DriveTypeRpm = targetPG.getStrDriveTypeRPM(uc.getComUtility());
        ((SJctrDataObject)summaryData).setData("COM_DRIVERPM", DriveTypeRpm);
        String SubSystem = "-";
        ((SJctrDataObject)summaryData).setData("COM_VMS", targetPG.getSubSystemData());
        List<?> rsgList = this.getDataController().getProxy().getCache(KEY_CLASS_GETRSGDETAIL);
        ((SJctrDataObject)summaryData).setData("COM_RSG", this.getRsgList(targetPG));
    }

    private String getRsgList(SJmoPgIndex pgindex) {
        String rtn = "-";
        List<?> allRsgList = this.getDataController().getProxy().getCache(KEY_CLASS_GETRSGDETAIL);
        SJmoRSGgetAllRsgs allRsg = (SJmoRSGgetAllRsgs)allRsgList.get(0);
        ArrayList<SJmoRSGgetRsg> rsgList = allRsg.getRsgs();
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getDataController().getOwner(), (SJmoRSGgetAllRsgs)allRsgList.get(0));
        for (int i = 0; i < rsgList.size(); ++i) {
            SJmoRSGgetRsg rsg = rsgList.get(i);
            int Index = Collections.binarySearch(rsg.getVdevs(), pgindex);
            if (Index >= 0) {
                rtn = rsg.getRsgInfo().getRsgName() + "(" + rsg.getRsgInfo().getRsgId() + ")";
                break;
            }
            String strpgindex = pgindex.getIndexKey();
            List<?> pgDetails = this.getDataController().getProxy().getCache("KEY_SELECT_PG_DETAIL");
            if (pgDetails == null) continue;
            for (int j = 0; j < pgDetails.size(); ++j) {
                SJmoPgDetail pgDetail = (SJmoPgDetail)pgDetails.get(j);
                if (!strpgindex.equals(pgDetail.getIndexKey()) || !rsgUtil.chkResourceGroup(rsg.getRsgInfo().getRsgId())) continue;
                rtn = rsg.getRsgInfo().getRsgName() + "(" + rsg.getRsgInfo().getRsgId() + ")";
                return rtn;
            }
        }
        return rtn;
    }

    private String getBasicUsableCapacitySize(SJctrPGDetail pg) {
        if (pg.getBVirtSupport()) {
            long lTotalCap = pg.getBasicUsableCapacity();
            String strTotalCap = this.getCapacity(lTotalCap, pg.getBaseEmulationType());
            return strTotalCap;
        }
        return "-";
    }

    private String getCapacitySize(SJctrPGDetail pg) {
        ArrayList freeList = pg.getAllFreeData();
        long lFreeCap = 0L;
        long lTotalCap = pg.getAllTotalLBA();
        for (int i = 0; i < freeList.size(); ++i) {
            SJctrFreeDetail free = (SJctrFreeDetail)freeList.get(i);
            lFreeCap += free.getRemainingTotalLBA();
        }
        String strFreeCap = this.getCapacity(lFreeCap, pg.getBaseEmulationType());
        String strTotalCap = this.getCapacity(lTotalCap, pg.getBaseEmulationType());
        return strFreeCap + "/" + strTotalCap;
    }

    private String getCapacity(long lCap, int iEmu) {
        String strEmuType = this.getComUtility().getCVSUtility().getEmulationTypeName(iEmu);
        SJctrCapacityUtility.UNIT unit = null;
        unit = this.getComUtility().getCVSUtility().isOpen(strEmuType) ? this.getComUtility().getCapacityUtility().getUnit(lCap) : SJctrCVSUtility.getUnit("CYL");
        SJctrCapacityUtility util = this.getComUtility().getCapacityUtility();
        StringBuilder buf = new StringBuilder(util.toString(lCap, unit, iEmu));
        buf.append(" ");
        buf.append(util.getUnitString(unit));
        return buf.toString();
    }
}

