/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.formatpg;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import sanproject.common.Robj_interface_CVSgetLDEVFormatProgInfo;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrRMIgetLDEVFormatProgInfo;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.controller.wizard.forcibly.com.SJctrForciblyAC;
import sanproject.sn2.datasupplier.SJdsSupplierException;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public class SJctrFormatPGAC
extends SJctrForciblyAC
implements SJctrCVSMacro {
    public static final int PROGRESS_NOPROGRESS = 0;
    List<SJctrPGDetail> PGInfo = new ArrayList<SJctrPGDetail>();

    public SJctrFormatPGAC() {
        this.async = true;
    }

    public void setApplyList(List<SJctrPGDetail> PGList) {
        this.PGInfo = PGList;
    }

    @Override
    public int getLeadTime() {
        return SJctrComCVSUtility.getPGFormatLeadTime(this.PGInfo);
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>();
        applyList.add(this.createPGFormat());
        return applyList;
    }

    private SanRequest createPGFormat() {
        SanRequest request = null;
        try {
            request = this.newRequest("MNTstartParityGroupsFormat");
            SanList pglist = request.newList("ParityGroups");
            for (int i = 0; i < this.PGInfo.size(); ++i) {
                SJctrPGDetail pgDetail = this.PGInfo.get(i);
                SanObject pg = pglist.addObj();
                int[] pgIndex = new int[]{pgDetail.getFB4(), pgDetail.getPG()};
                pg.putIntArray("Id", pgIndex);
            }
        }
        catch (SanDataException e) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
            SJctrLogUty.error(this.getClass().getSimpleName(), "setApplyResult", "Failed to build result list", e);
        }
        catch (SJdsSupplierException ex) {
            throw ex;
        }
        return request;
    }

    @Override
    public SJctrError monitorBackground() {
        SJctrError rtn = new SJctrError(201, 22, 0);
        boolean loop = true;
        while (loop) {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception ex) {
                loop = false;
            }
            try {
                if (!this.isPauseMonitor()) {
                    int iFormatProg = this.getFormatData();
                    if (iFormatProg == -1) {
                        rtn = new SJctrError(30, 22, 105194);
                        loop = false;
                        continue;
                    }
                    if (iFormatProg == 100) {
                        loop = false;
                        this.setProgress(iFormatProg);
                        continue;
                    }
                    this.setProgress(iFormatProg);
                    continue;
                }
                rtn = new SJctrError(201, 22, -1);
                loop = false;
            }
            catch (SJmoException ex) {
                if (SJctrComUtility.checkSVPException(ex)) continue;
                loop = false;
                throw ex;
            }
        }
        return rtn;
    }

    private int getFormatData() {
        int rtn = -1;
        ArrayList<SJmoGetDirect> listDirect = new ArrayList<SJmoGetDirect>();
        SJctrRMIgetLDEVFormatProgInfo kind = new SJctrRMIgetLDEVFormatProgInfo();
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        listDirect.add(direct);
        SJmoGetAgent agent = SJmoModelMgr.getModelMgr().getDataAgent();
        List getList = agent.getDataInf(listDirect);
        List throughRmiList = (List)getList.get(0);
        SJmoThroughRmiData throughRmi = (SJmoThroughRmiData)throughRmiList.get(0);
        Robj_interface_CVSgetLDEVFormatProgInfo FormatProg = (Robj_interface_CVSgetLDEVFormatProgInfo)throughRmi.getObjRmi();
        int wkFormatFlg = FormatProg.getNFormatFlag();
        if (wkFormatFlg == 1) {
            rtn = FormatProg.getNProg();
            if (rtn == 100) {
                rtn = 99;
            }
        } else if (FormatProg.getNErrCode() == 0) {
            rtn = 100;
        }
        return rtn;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        if (resultObject instanceof SanResponse) {
            try {
                SanResponse kvResponse = (SanResponse)resultObject;
                SanObject kvErrorInfo = kvResponse.getObj("ErrorInfo");
                SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(kvErrorInfo);
                if (kvResponse.errorCode() != 0) {
                    SJctrError error = errorInfo.createError();
                    this.setError(error);
                }
            }
            catch (SanDataException ex) {
                SJctrError error = new SJctrError(33, 5, 1049);
                this.setError(error);
                SJctrLogUty.error(this.getClass().getSimpleName(), "setApplyResult", "Failed to build result list", ex);
            }
        }
    }
}

