/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.formatpg;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrArrayGroupIndexComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.arraygroup.com.SJctrArrayGroupUtility;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPhysicalLdevDetail;
import sanproject.sn2.controller.wizard.cvs.formatpg.SJctrFormatPGConfirmData;
import sanproject.sn2.controller.wizard.cvs.formatpg.SJctrFormatPGTableModel;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDetail;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrFormatPGConfirmDC
extends SJctrConfirmDataController
implements SJctrCVSMacro {
    public static final int DISP_ID = 17871172;
    public static final String KEY_TABLE = "COM_TABLE";
    public static final Class<?> KEY_CLASS_FORMAT_PG = SJmoLdevIndex.class;
    ArrayList<SJmoPgIndex> originFormatPGIndex = new ArrayList();
    public ArrayList<SJmoPgDetail> originPgDtlList = new ArrayList();
    public static final String TITLE = "FMT_PG";
    private SJctrRelatedDispDataObject _WarningMsg = null;

    public SJctrFormatPGConfirmDC() throws SJcException {
        super(17871172);
        this.initDataModel();
        this.addDataObjectModel("COM_CHILD", new SJctrSimpleDataModel(){

            @Override
            public Object getDataObject(SJctrDataObject inputObject) {
                ArrayList<SJctrRelatedDispDataObject> retList = new ArrayList<SJctrRelatedDispDataObject>();
                if (SJctrFormatPGConfirmDC.this._WarningMsg != null) {
                    retList.add(SJctrFormatPGConfirmDC.this._WarningMsg);
                    SJctrFormatPGConfirmDC.this._WarningMsg = null;
                }
                return retList;
            }
        });
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    protected void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrFormatPGTableModel());
    }

    public boolean checkPreStartData() {
        boolean rtn = true;
        this.originFormatPGIndex = new ArrayList();
        List<?> targetList = this.getWizardWindow().getCache("KEY_SELECT_PG_INDEX");
        if (targetList == null) {
            rtn = false;
        } else if (targetList.size() == 0) {
            rtn = false;
        }
        if (rtn) {
            ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>();
            for (int i = 0; i < targetList.size(); ++i) {
                SJmoPgIndex pgIndex = (SJmoPgIndex)targetList.get(i);
                String pgType = SJctrArrayGroupUtility.createFolderName(pgIndex.getFB4());
                if (pgType != "INTERNAL") {
                    SJctrError err = new SJctrError(30, 22, 205125);
                    SJctrErrorColumnData errColumn = new SJctrErrorColumnData(pgIndex, err);
                    errList.add(errColumn);
                }
                this.originFormatPGIndex.add(pgIndex);
            }
            if (errList.size() > 0) {
                this.output_errorList(errList);
            }
            Collections.sort(this.originFormatPGIndex, (Comparator)new SJctrArrayGroupIndexComparator());
            rtn = this.checkPreConstructData();
        }
        return rtn;
    }

    private boolean checkPreConstructData() {
        SJctrResourceGroupUtility rsgUtil;
        ArrayList<SJctrErrorColumnData> rsgpg_Err;
        boolean rtn = true;
        List<SJmoPgDetail> pgDtlList = this.getWizardWindow().getCache(SJmoGetPgDetail.class);
        List<SJmoLdevDetail> ldevDtlList = this.getWizardWindow().getCache(SJmoGetLdevDetail.class);
        List<SJmoVdevDetail> vdevDtlList = this.getWizardWindow().getCache(SJmoGetVdevDetail.class);
        List<SJmoPgScatteredInfo> pgScList = this.getWizardWindow().getCache(SJmoGetPgScatteredInfo.class);
        ArrayList<SJctrPGDetail> pgCtlList = new ArrayList<SJctrPGDetail>();
        List<?> rsgDetailList = this.getWizardWindow().getCache(KEY_CLASS_GETRSGDETAIL);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            this.getLogUty().putlog("getLDEVDetail", "rsgDetailList not found", null, 40000);
            SJctrCVSUtility.output_Error(30, 22, 105248);
        }
        if ((rsgpg_Err = SJctrCVSUtility.checkRSGPGtoPG(this.originFormatPGIndex, rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0)))).size() > 0) {
            this.output_errorList(rsgpg_Err);
        }
        Collections.sort(pgDtlList);
        ArrayList<SJctrErrorColumnData> noldev_Err = new ArrayList<SJctrErrorColumnData>();
        ArrayList<SJctrErrorColumnData> pg_Err = new ArrayList<SJctrErrorColumnData>();
        for (int i = 0; i < this.originFormatPGIndex.size(); ++i) {
            SJmoPgIndex pgIndex = this.originFormatPGIndex.get(i);
            SJctrPGDetail ctrPgDetail = new SJctrPGDetail();
            int index = Collections.binarySearch(pgDtlList, (Object)pgIndex);
            if (index >= 0) {
                if (pg_Err.size() > 0) continue;
                ctrPgDetail.setPGDetail((SJmoPgDetail)pgDtlList.get(index));
                ctrPgDetail.setPGScatteredList(pgScList);
                ctrPgDetail.setBasicDataList(pgDtlList, vdevDtlList, ldevDtlList, null);
                boolean bLdevExist = false;
                ArrayList phList = ctrPgDetail.getAllPhysicalLocation();
                for (SJctrPhysicalLdevDetail physical : phList) {
                    if (!physical.isVolume()) continue;
                    bLdevExist = true;
                    break;
                }
                if (!bLdevExist) {
                    SJctrError error = new SJctrError(30, 22, 205124);
                    SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ctrPgDetail, error);
                    noldev_Err.add(errColumn);
                }
                pgCtlList.add(ctrPgDetail);
                continue;
            }
            SJctrError error = SJctrParityGroupUtility.createPgError(205155);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(pgIndex, error);
            pg_Err.add(errColumn);
        }
        if (pg_Err.size() > 0) {
            this.output_errorList(pg_Err);
        } else if (noldev_Err.size() > 0) {
            this.output_errorList(noldev_Err);
        }
        if (pgCtlList.size() > 0) {
            this.checkLdevsOnPg(pgCtlList, rsgUtil);
            SJctrFormatPGConfirmData confirmData = new SJctrFormatPGConfirmData();
            confirmData.setPgDetailList(pgCtlList);
            ArrayList<SJctrFormatPGConfirmData> confirmDataList = new ArrayList<SJctrFormatPGConfirmData>();
            confirmDataList.add(confirmData);
            this.getWizardWindow().putCache(SJctrFormatPGConfirmData.class, confirmDataList);
        } else {
            rtn = false;
        }
        return rtn;
    }

    private void checkLdevsOnPg(List<SJctrPGDetail> pgDtlList, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJctrErrorColumnData> normal_Err = new ArrayList<SJctrErrorColumnData>();
        ArrayList<SJctrErrorColumnData> pool_Err = new ArrayList<SJctrErrorColumnData>();
        ArrayList jnl_Err = new ArrayList();
        ArrayList lock_Err = new ArrayList();
        ArrayList<SJctrErrorColumnData> rsg_Err = new ArrayList<SJctrErrorColumnData>();
        ArrayList<SJctrErrorColumnData> sysrsg_Err = new ArrayList<SJctrErrorColumnData>();
        ArrayList<SJctrErrorColumnData> ldevGuard_Err = new ArrayList<SJctrErrorColumnData>();
        ArrayList<SJctrErrorColumnData> odm_Err = new ArrayList<SJctrErrorColumnData>();
        List<?> ldevStatusList = this.getWizardWindow().getCache(KEY_CLASS_GETLDEVSTATUS);
        List<?> ldevGuardList = this.getWizardWindow().getCache(KEY_CLASS_GETLDEVGUARD);
        if (ldevGuardList == null) {
            this.getLogUty().putlog("getLDEVDetail", "LDEVGuardList not found", null, 40000);
            SJctrCVSUtility.output_Error(30, 22, 105248);
        }
        SJmoLdevGuardInfo ldevGuard = null;
        SJmoLdevStatusInfo ldev = new SJmoLdevStatusInfo();
        for (int i = 0; i < pgDtlList.size(); ++i) {
            SJctrPGDetail ctrPgDetail = pgDtlList.get(i);
            ArrayList phLdevList = ctrPgDetail.getAllPhysicalLocation();
            ArrayList<SJmoLdevDetail> wkLdevList = new ArrayList<SJmoLdevDetail>();
            for (int k = 0; k < phLdevList.size(); ++k) {
                if (!((SJctrPhysicalLdevDetail)phLdevList.get(k)).isVolume()) continue;
                wkLdevList.add((SJmoLdevDetail)phLdevList.get(k));
            }
            List<SJmoPgScatteredInfo> scList = this.getWizardWindow().getCache(SJmoGetPgScatteredInfo.class);
            ArrayList<SJctrErrorColumnData> wkrsg_Err = SJctrCVSUtility.checkRSGLDEVDetailtoPGColumn(wkLdevList, rsgUtil, scList);
            if (wkrsg_Err.size() > 0) {
                rsg_Err.addAll(wkrsg_Err);
            }
            if (rsg_Err.size() > 0 || (sysrsg_Err = SJctrCVSUtility.checkSysRSGLDEVtoPGScattered(wkLdevList, rsgUtil, scList)).size() > 0) continue;
            for (int j = 0; j < phLdevList.size(); ++j) {
                SJctrErrorColumnData errColumn;
                SJctrError error;
                int ldevGuardIndex;
                SJctrPhysicalLdevDetail detail = (SJctrPhysicalLdevDetail)phLdevList.get(j);
                if (!detail.isVolume()) continue;
                SJctrPhysicalLdevDetail index = detail;
                SJctrLDEVDetail detailList = new SJctrLDEVDetail();
                int indexCnt = Collections.binarySearch(ldevStatusList, (Object)index);
                if (indexCnt >= 0) {
                    ldev = (SJmoLdevStatusInfo)ldevStatusList.get(indexCnt);
                }
                if ((ldevGuardIndex = Collections.binarySearch(ldevGuardList, (Object)index)) >= 0) {
                    ldevGuard = (SJmoLdevGuardInfo)ldevGuardList.get(ldevGuardIndex);
                }
                if (detail.getbOdmVol()) {
                    error = new SJctrError(30, 22, 105446);
                    errColumn = new SJctrErrorColumnData(ctrPgDetail, error);
                    odm_Err.add(errColumn);
                }
                if (odm_Err.size() > 0) continue;
                if (ldevGuard != null && (byte)(ldevGuard.getByLdevGuardStatus() & 0xC3) != -128) {
                    error = new SJctrError(30, 22, 205122);
                    errColumn = new SJctrErrorColumnData(ctrPgDetail, error);
                    ldevGuard_Err.add(errColumn);
                }
                if (ldevGuard_Err.size() > 0) continue;
                if (detail.getbPoolVol()) {
                    error = new SJctrError(30, 22, 105439);
                    errColumn = new SJctrErrorColumnData(ctrPgDetail, error);
                    if (!SJctrCVSUtility.chkBaseRole(this.getWizardWindow())) {
                        pool_Err.add(errColumn);
                    }
                }
                if (pool_Err.size() > 0 || ldev.getLDEVStatus() == 2) continue;
                error = new SJctrError(30, 22, 105437);
                errColumn = new SJctrErrorColumnData(ctrPgDetail, error);
                normal_Err.add(errColumn);
            }
        }
        if (rsg_Err.size() > 0) {
            this.output_errorList(rsg_Err);
        } else if (sysrsg_Err.size() > 0) {
            this.output_errorList(sysrsg_Err);
        } else if (odm_Err.size() > 0) {
            this.output_errorList(odm_Err);
        } else if (ldevGuard_Err.size() > 0) {
            this.output_errorList(ldevGuard_Err);
        } else if (pool_Err.size() > 0) {
            this.output_errorList(pool_Err);
        } else if (normal_Err.size() > 0) {
            this.output_errorList(normal_Err);
        }
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap map = new HashMap();
        List<?> confirmDataList = this.getWizardWindow().getCache(SJctrFormatPGConfirmData.class);
        map.put(SJctrFormatPGConfirmData.class, confirmDataList);
        Map<String, List<?>> result = SJctrConfirmDataController.mapkeyClassToString(map);
        return result;
    }

    private void output_errorList(ArrayList<SJctrErrorColumnData> errColumnList) {
        SJctrWizardWindowDC wizard = this.getWizardWindow();
        SJctrRelatedDispDataObject errDisp = wizard.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController uc = this.getWizardWindow().getOwner();
        SJctrErrorDataController errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
        errDC.setParameter(this.getWizardWindow().getParentDC().getDataObjectModel(KEY_TABLE), errColumnList);
        SJctrErrorColumnData errColumnData = errColumnList.get(0);
        SJctrError error = errColumnData.getError();
        SJctrError errorExp = new SJctrError(error.getFunc(), error.getModule(), error.getError());
        SJcException exp = errorExp.createException();
        exp.setErrDisp(errDisp);
        throw exp;
    }

    public void chkForciblyMsg() {
        List<?> confirmDataList = this.getCache(SJctrFormatPGConfirmData.class);
        SJctrFormatPGConfirmData confirmData = (SJctrFormatPGConfirmData)confirmDataList.get(0);
        ArrayList pgList = (ArrayList)confirmData.getPgDetailList();
        ArrayList errColumnList = SJctrComCVSUtility.chkPgList(this, pgList, 201);
        if (errColumnList.size() > 0) {
            SJctrErrorTableModel errTable = new SJctrErrorTableModel();
            this.addDataObjectModel("COM_ERRTABLE", errTable);
            errTable.addRowData(errColumnList);
            this._WarningMsg = SJctrCVSUtility.createOkCancelMsgDialogEx(205211, null, this, this.getDataObjectModel("COM_ERRTABLE"), errColumnList);
        }
    }
}

