/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.unbindslus;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrUnbindLdevInfo;
import sanproject.sn2.controller.wizard.cvs.unbindslus.SJctrUnbindOperationError;
import sanproject.sn2.controller.wizard.cvs.unbindslus.SJctrUnbindSlusConfirmData;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrUnbindSlusAC
extends SJctrApplyController {
    private static final long serialVersionUID = 1418194988686764215L;
    private static final int UNBIND_ID = 0;
    private static final int ERROR_MSG_INDEX_ERROR_CODE = 1;
    protected List<SJctrUnbindLdevInfo> applyInfo = new ArrayList<SJctrUnbindLdevInfo>();
    protected Map<Integer, List<SJmoPortLunDetail>> portLunMap = new HashMap<Integer, List<SJmoPortLunDetail>>();
    List<SJctrError> resultData = null;
    private static final int UNBIND_BASE_TIME = 2;
    private static final int UNBIND_PROCESSESD_NUMBER = 2048;

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    public void setApplyData(SJctrUnbindSlusConfirmData confirmData) {
        this.applyInfo = confirmData.getUnbindAluLdevsInfo();
        this.portLunMap = confirmData.getPortLunMap();
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        SJdsSupplierAgent supplierAgent = SJdsSupplierMgr.getSupplierMgr().getAgent();
        SanRequest sanRequest = supplierAgent.newRequest("VVOLexecBindingOperation");
        try {
            SanList reqBindList = sanRequest.newList("BindingOperations");
            for (SJctrUnbindLdevInfo aluLdev : this.applyInfo) {
                for (byte[] slu : aluLdev.getBindSluIdList()) {
                    SanObject bindingOperation = reqBindList.addObj();
                    SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                    ldevIndex.setLdevIndex(aluLdev.getSLdkc(), aluLdev.getSCu(), aluLdev.getSLdev());
                    List<SJmoPortLunDetail> portLunDetailList = this.portLunMap.get(ldevIndex.getIndex());
                    SJmoPortLunDetail unbindPortLunDetai = portLunDetailList.get(0);
                    bindingOperation.putInt("Operation", 0);
                    bindingOperation.putInt("Port", (int)unbindPortLunDetai.getSPort());
                    bindingOperation.putInt("HostGroup", (int)unbindPortLunDetai.getSHostGroup());
                    bindingOperation.putInt("Lun", (int)unbindPortLunDetai.getSLUN());
                    SanObject aluObj = bindingOperation.newObj("Alu");
                    aluObj.putByteArray("Id", aluLdev.getAluId());
                    SanObject sluObj = bindingOperation.newObj("Slu");
                    sluObj.putByteArray("Id", slu);
                }
            }
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error("SJctrUnbindSlusAC", "getSetList", "The error occurred during request parameter generation processing of Key-Value." + sdEx.getMessage());
            SJctrError err = new SJctrError(30, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        applyList.add(sanRequest);
        return applyList;
    }

    private void setDetailError(SanResponse resultObject) throws SanDataException {
        SanList unbindList = resultObject.getList("BindingOperations");
        HashMap<byte[], SJctrUnbindOperationError> aluErrMap = new HashMap<byte[], SJctrUnbindOperationError>();
        if (null == unbindList) {
            SJctrLogUty.info(this.title, "setDetailError", "unbindList is null.");
        } else {
            for (SanObject result : unbindList) {
                SanObject errInfo = result.getObj("ErrorInfo");
                int[] errMsgId = errInfo.getIntArray("MessageId");
                if (0 == errMsgId[1]) continue;
                SJctrUnbindLdevInfo unbindLdevInfo = new SJctrUnbindLdevInfo();
                SanObject aluInfo = result.getObj("Alu");
                unbindLdevInfo.setAluId(aluInfo.getByteArray("Id"));
                if (null != aluErrMap.get(unbindLdevInfo.getAluId())) continue;
                SanObject aluLdevInfo = aluInfo.getObj("Ldev");
                int[] aluLdevId = aluLdevInfo.getIntArray("Id");
                unbindLdevInfo.setLdevIndex((short)aluLdevId[0], (short)aluLdevId[1], (short)aluLdevId[2]);
                SJctrUnbindOperationError unbindError = new SJctrUnbindOperationError(errMsgId, unbindLdevInfo);
                this.resultData.add(unbindError);
                aluErrMap.put(unbindLdevInfo.getAluId(), unbindError);
            }
        }
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        SJctrError error = new SJctrError(30, 22, 0);
        this.resultData = new ArrayList<SJctrError>();
        try {
            if (!(resultObject instanceof SanResponse)) {
                error.setError(107001);
                this.setError(error);
            } else {
                this.setRepError((SanResponse)resultObject, error);
                if (SJctrCVSUtility.chkSanresponseDetailErr((SanResponse)resultObject)) {
                    this.setDetailError((SanResponse)resultObject);
                }
            }
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error(this.title, "setApplyResult", "The error occurred during generating SJctrError from SanResponse." + sdEx.getMessage());
            error = SJctrError.parseError((Exception)((Object)sdEx));
            this.setError(error);
        }
    }

    private void setRepError(SanResponse resultObject, SJctrError error) throws SanDataException {
        SanObject errInfo = resultObject.getObj("ErrorInfo");
        int[] errMsgId = errInfo.getIntArray("MessageId");
        if (0 != errMsgId[1]) {
            SJctrUnbindOperationError unbindError = new SJctrUnbindOperationError(errMsgId);
            error = unbindError;
        }
        this.setError(error);
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        if (this.resultData != null && this.resultData.size() > 0) {
            rtn = true;
        }
        return rtn;
    }

    @Override
    public int getLeadTime() {
        int readTime = 0;
        int listSize = this.applyInfo.size();
        if (listSize < 2048 && 0 != this.applyInfo.size()) {
            readTime = 1;
        } else {
            readTime = listSize / 2048;
            if (0 != listSize % 2048) {
                ++readTime;
            }
        }
        return readTime * 2;
    }
}

