/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editalert.com;

import java.util.ArrayList;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrIpAddrUtility;

public class SJctrIPv6ShortAddressChanger {
    private static final String DELIMITER = ":";
    private static final String ZERO_FIELD = "0";
    private static final String STR_EMPTY = "";
    private static final int MAX_FIELD_COUNT = 8;

    public static String getIPv6ShortAddr(String addr) throws SJcException {
        int fieldCount = SJctrIPv6ShortAddressChanger.getFieldCount(addr = new SJctrIpAddrUtility.IPv6().toRegularWithUsableCheck(addr));
        if (fieldCount < 8) {
            addr = SJctrIPv6ShortAddressChanger.getClearedAddr(addr, fieldCount);
        }
        return SJctrIPv6ShortAddressChanger.getShortAddr(addr);
    }

    private static int getFieldCount(String addr) {
        String[] splitAddr = addr.split(DELIMITER);
        int count = 0;
        for (String field : splitAddr) {
            if (STR_EMPTY.equals(field)) continue;
            ++count;
        }
        return count;
    }

    private static String getClearedAddr(String addr, int fieldCount) {
        StringBuilder sb = new StringBuilder(ZERO_FIELD);
        for (int i = fieldCount + 1; i < 8; ++i) {
            sb.append(":0");
        }
        String inserted = sb.toString();
        StringBuilder insertSb = new StringBuilder();
        if (addr.startsWith(DELIMITER)) {
            insertSb.append(inserted);
            insertSb.append(DELIMITER);
        } else if (addr.endsWith(DELIMITER)) {
            insertSb.append(DELIMITER);
            insertSb.append(inserted);
        } else {
            insertSb.append(DELIMITER);
            insertSb.append(inserted);
            insertSb.append(DELIMITER);
        }
        return addr.replaceFirst("::", insertSb.toString());
    }

    private static String getShortAddr(String addr) {
        int i;
        ArrayList<String> addrList = new ArrayList<String>();
        String[] split = addr.split(DELIMITER);
        for (int i2 = 0; i2 < 8; ++i2) {
            addrList.add(split[i2]);
        }
        int startIndex = 0;
        int deleteCount = 0;
        int tmpIndex = 0;
        int tmpCount = 0;
        boolean isCounting = false;
        for (i = 0; i < 8; ++i) {
            if (ZERO_FIELD.equals(addrList.get(i))) {
                if (isCounting) {
                    ++tmpCount;
                    continue;
                }
                isCounting = true;
                tmpIndex = i;
                tmpCount = 1;
                continue;
            }
            if (!isCounting) continue;
            if (deleteCount < tmpCount) {
                startIndex = tmpIndex;
                deleteCount = tmpCount;
            }
            isCounting = false;
        }
        if (deleteCount < tmpCount) {
            startIndex = tmpIndex;
            deleteCount = tmpCount;
        }
        if (deleteCount > 1) {
            for (i = 0; i < deleteCount; ++i) {
                addrList.remove(startIndex);
            }
            if (startIndex == 0 || startIndex == addrList.size()) {
                addrList.add(startIndex, DELIMITER);
            } else {
                addrList.add(startIndex, STR_EMPTY);
            }
        }
        int fieldSize = addrList.size() - 1;
        StringBuilder sb = new StringBuilder();
        for (int i3 = 0; i3 < fieldSize; ++i3) {
            sb.append((String)addrList.get(i3));
            sb.append(DELIMITER);
        }
        sb.append((String)addrList.get(fieldSize));
        return sb.toString();
    }
}

