/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.chgtrap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrIpAddrUtility;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertDef;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertUtility;
import sanproject.sn2.controller.wizard.editalert.com.SJctrIPv6ShortAddressChanger;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.model.SJctrChangeSNMPTrapCommunityModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.model.SJctrChangeSNMPTrapIPAddressModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.model.SJctrSNMPDialogData;
import sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.model.SJctrSNMPTableRowData;

public class SJctrChangeSNMPTrapsDialogDC
extends SJctrDialogDataController
implements SJctrEditAlertDef {
    private SJctrChangeSNMPTrapIPAddressModel ipModel;
    private SJctrChangeSNMPTrapCommunityModel commModel;

    @Override
    public String getDispName() {
        return this.getOwner().getComUtility().getGuidance("CHANGE_SNMP_TRAPS");
    }

    public SJctrChangeSNMPTrapsDialogDC() throws SJcException {
        super(33595513);
        this.initDataModel();
    }

    private void initDataModel() {
        this.ipModel = new SJctrChangeSNMPTrapIPAddressModel();
        this.addDataObjectModel("COM_TRAP_IP", this.ipModel);
        this.commModel = new SJctrChangeSNMPTrapCommunityModel();
        this.addDataObjectModel("COM_COMMUNITY", this.commModel);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    @Override
    public boolean checkStartData() {
        SJctrSNMPDialogData dialogData = this.getDialogData();
        this.ipModel.updateDataModel();
        ArrayList<String> comboList = new ArrayList<String>();
        List<Object> selectedList = dialogData.getSelectedList();
        for (Map.Entry<String, Map<String, Integer>> entry : dialogData.getTrapTableData().entrySet()) {
            comboList.add(entry.getKey());
        }
        SJctrSNMPTableRowData row = (SJctrSNMPTableRowData)selectedList.get(0);
        for (int i = 0; i < selectedList.size() && "-".equals((row = (SJctrSNMPTableRowData)selectedList.get(i)).getIP()); ++i) {
        }
        switch (dialogData.getSelectedType()) {
            case SINGLE: {
                this.ipModel.initAddress(row.getIP());
                this.commModel.updateComboList(comboList);
                this.commModel.setComboSelection(row.getCommunity());
                break;
            }
            case MULTI_COMMUNITY: {
                this.ipModel.initAddress(row.getIP());
                this.commModel.setEnableAll(false);
                break;
            }
            default: {
                this.ipModel.setEnableAll(false);
                this.commModel.updateComboList(comboList);
                this.commModel.setComboSelection(row.getCommunity());
            }
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        this.ipModel.chkData();
        this.commModel.chkData();
        boolean isIPChecked = this.ipModel.isChecked();
        boolean isCommChecked = this.commModel.isChecked();
        if (isIPChecked && !isCommChecked) {
            this.updateTableWithIPChecked();
        } else if (!isIPChecked && isCommChecked) {
            this.updateTableWithCommunityChecked();
        } else {
            this.updateTableWithBothChecked();
        }
        return true;
    }

    private boolean updateTableWithIPChecked() {
        SJctrSNMPTableRowData row;
        SJctrSNMPDialogData dialogData = this.getDialogData();
        List<Object> selectedList = dialogData.getSelectedList();
        Map<String, Map<String, Integer>> trapMap = dialogData.getTrapTableData();
        int type = this.ipModel.getRadioSelection();
        String chgAddr = this.getRegularAddress(this.ipModel.getAddressText(), type);
        for (Object obj : selectedList) {
            row = (SJctrSNMPTableRowData)obj;
            String community = row.getCommunity();
            Map<String, Integer> addrMap = trapMap.get(community);
            if (!addrMap.containsKey(chgAddr)) continue;
            SJctrEditAlertUtility.errorMsg(3, 22, 205026);
        }
        for (Object obj : selectedList) {
            row = (SJctrSNMPTableRowData)obj;
            Map<String, Integer> addrMap = trapMap.get(row.getCommunity());
            addrMap.remove(row.getIP());
            addrMap.put(chgAddr, type);
        }
        return true;
    }

    private boolean updateTableWithCommunityChecked() {
        SJctrSNMPTableRowData row;
        Map<String, Integer> addrMap;
        String chgComm;
        SJctrSNMPDialogData dialogData = this.getDialogData();
        List<Object> selectedList = dialogData.getSelectedList();
        Map<String, Map<String, Integer>> trapMap = dialogData.getTrapTableData();
        if (!trapMap.containsKey(chgComm = this.commModel.getComboSelection())) {
            if (trapMap.size() == 32) {
                SJctrEditAlertUtility.errorMsg(3, 22, 205025);
            }
            trapMap.put(chgComm, new HashMap());
        } else {
            addrMap = trapMap.get(chgComm);
            if (addrMap.size() + selectedList.size() > 32) {
                SJctrEditAlertUtility.errorMsg(3, 22, 205028);
            }
            for (Object obj : selectedList) {
                row = (SJctrSNMPTableRowData)obj;
                String addr = row.getIP();
                if (!addrMap.containsKey(addr)) continue;
                SJctrEditAlertUtility.errorMsg(3, 22, 205026);
            }
        }
        addrMap = trapMap.get(chgComm);
        for (Object obj : selectedList) {
            row = (SJctrSNMPTableRowData)obj;
            Map<String, Integer> preAddrMap = trapMap.get(row.getCommunity());
            String addr = row.getIP();
            int type = preAddrMap.get(addr);
            preAddrMap.remove(addr);
            addrMap.put(addr, type);
        }
        return true;
    }

    private boolean updateTableWithBothChecked() {
        Map<String, Integer> addrMap;
        SJctrSNMPDialogData dialogData = this.getDialogData();
        List<Object> selectedList = dialogData.getSelectedList();
        Map<String, Map<String, Integer>> trapMap = dialogData.getTrapTableData();
        String chgComm = this.commModel.getComboSelection();
        int chgType = this.ipModel.getRadioSelection();
        String chgAddr = this.getRegularAddress(this.ipModel.getAddressText(), chgType);
        if (!trapMap.containsKey(chgComm)) {
            if (trapMap.size() == 32) {
                SJctrEditAlertUtility.errorMsg(3, 22, 205025);
            }
            addrMap = new HashMap<String, Integer>();
            trapMap.put(chgComm, addrMap);
        } else {
            addrMap = trapMap.get(chgComm);
            if (addrMap.size() == 32) {
                SJctrEditAlertUtility.errorMsg(3, 22, 205028);
            }
            if (addrMap.containsKey(chgAddr)) {
                SJctrEditAlertUtility.errorMsg(3, 22, 205026);
            }
        }
        SJctrSNMPTableRowData row = (SJctrSNMPTableRowData)selectedList.get(0);
        Map<String, Integer> preAddrMap = trapMap.get(row.getCommunity());
        String addr = row.getIP();
        preAddrMap.remove(addr);
        addrMap.put(chgAddr, chgType);
        return true;
    }

    private String getRegularAddress(String addr, int type) {
        if (addr == null || addr.length() == 0) {
            return "";
        }
        if (type == 4) {
            return new SJctrIpAddrUtility.IPv4().toRegular(addr);
        }
        return SJctrIPv6ShortAddressChanger.getIPv6ShortAddr(addr);
    }

    private SJctrSNMPDialogData getDialogData() {
        List<?> dataList = this.getCache("COM_DIALOG_DATA");
        if (dataList == null) {
            SJctrEditAlertUtility.errorMsg(3, 22, 107025);
        }
        return (SJctrSNMPDialogData)dataList.get(0);
    }
}

