/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.com;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.utility.Logger.SJcAuditLogApplyElemCon;
import sanproject.sn2.com.utility.Logger.SJcAuditLogApplyMultiLineElemCon;
import sanproject.sn2.com.utility.Logger.SJcAuditLogSubApplyElemCon;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.controller.com.SJctrAuditLogData;
import sanproject.sn2.controller.com.SJctrDefaultAuditLogData;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrGuidanceOfLangType;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;

public abstract class SJctrEncryptionAuditLog
implements Serializable,
SJctrGuidIdDefinition,
SJctrEncryptionKeyDef {
    private static final long serialVersionUID = 1L;
    private Map<String, String> TitleGuideMap = null;
    private Map<String, String> DataGuideMap = null;
    private HashMap<String, String> addition = null;
    private List<SJctrAuditLogData> detailAuth = new ArrayList<SJctrAuditLogData>();
    private List<SJctrAuditLogData> detailAuthSub = new ArrayList<SJctrAuditLogData>();

    protected abstract String getFuncName();

    protected abstract String getOperationName();

    protected abstract String[][] getBaseKey();

    protected String[][] getBaseKeyForSub() {
        return new String[0][0];
    }

    protected abstract String[][] getHeadKey();

    protected String[][] getHeadKeyForSub() {
        return new String[0][0];
    }

    protected abstract String[][] getDataKey();

    protected abstract String getNumOfName();

    protected String getNumOfNameForSub() {
        return "";
    }

    public SJctrEncryptionAuditLog(SJbaseUserSession userSession) {
        SJctrGuidanceOfLangType guidance = new SJctrGuidanceOfLangType("EN");
        this.TitleGuideMap = new HashMap<String, String>();
        this.TitleGuideMap.putAll(guidance.getGuidance(this.getBaseKey()));
        this.TitleGuideMap.putAll(guidance.getGuidance(this.getHeadKey()));
        this.TitleGuideMap.putAll(guidance.getGuidance(this.getHeadKeyForSub()));
        this.DataGuideMap = new HashMap<String, String>();
        this.DataGuideMap = guidance.getGuidance(this.getDataKey());
        this.setAdditionData(userSession);
    }

    public SJctrEncryptionAuditLog(SJctrEncryptionAuditLog audit) {
        this.setTitleGuideMap(audit.getTitleGuideMap());
        this.setDataGuideMap(audit.getDataGuideMap());
        this.setAddition(audit.getAddition());
    }

    private void setAdditionData(SJbaseUserSession userSession) {
        this.addition = new HashMap();
        this.addition.put("SN2_AUDITLOG_ADD_LOGTYPE", "USER");
        this.addition.put("SN2_AUDITLOG_ADD_USER", userSession.getUserName());
        this.addition.put("SN2_AUDITLOG_ADD_HOST", SJcSessionUty.getIPAddress(userSession));
        this.addition.put("SN2_AUDITLOG_ADD_LOGID", Integer.toString(userSession.getSessionIdentificationID()));
        String strExtIFID = null;
        strExtIFID = userSession.getLoginType().equals("SVP") ? Integer.toString(5) : Integer.toString(4);
        this.addition.put("SN2_AUDITLOG_ADD_EXTIF", strExtIFID);
    }

    public SJcAuditLogApplyElemCon createElemCon() {
        SJcAuditLogApplyElemCon elemCon = new SJcAuditLogApplyElemCon();
        elemCon.setFunctionName(this.getFuncName());
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", this.getOperationName());
        String opeName = this.TitleGuideMap.get(key);
        elemCon.setOperationName(opeName);
        elemCon.setOperationParameter("");
        elemCon.setAdditionalInfo(this.addition);
        elemCon.setAdtDetailList(this.detailAuth);
        elemCon.setOperationResult("Success");
        elemCon.setOperationErrorCode(null);
        elemCon.setStrNormalEnd("ADT_NORMAL_END");
        elemCon.setStrError("ADT_ERROR");
        elemCon.setFooter(this.getFooter());
        return elemCon;
    }

    public SJcAuditLogApplyMultiLineElemCon createMultiLineElemCon() {
        SJcAuditLogApplyMultiLineElemCon elemCon = new SJcAuditLogApplyMultiLineElemCon();
        elemCon.setFunctionName(this.getFuncName());
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", this.getOperationName());
        String opeName = this.TitleGuideMap.get(key);
        elemCon.setOperationName(opeName);
        elemCon.setOperationParameter("");
        elemCon.setAdditionalInfo(this.addition);
        elemCon.setAdtDetailList(this.detailAuth);
        elemCon.setAdtDetailListSub(this.detailAuthSub);
        elemCon.setOperationResult("Success");
        elemCon.setOperationErrorCode(null);
        elemCon.setStrNormalEnd("ADT_NORMAL_END");
        elemCon.setStrError("ADT_ERROR");
        elemCon.setFooter(this.getFooter());
        elemCon.setFooterSub(this.getFooterForSub());
        return elemCon;
    }

    public SJcAuditLogSubApplyElemCon createElemCon_Sub() {
        SJcAuditLogSubApplyElemCon elemCon_Sub = new SJcAuditLogSubApplyElemCon();
        elemCon_Sub.setFunctionName(this.getFuncName());
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", this.getOperationName());
        String opeName = this.TitleGuideMap.get(key);
        elemCon_Sub.setOperationName(opeName);
        elemCon_Sub.setOperationParameter("");
        elemCon_Sub.setAdditionalInfo(this.addition);
        elemCon_Sub.setAdtDetailList(this.detailAuth);
        elemCon_Sub.setOperationResult("Success");
        elemCon_Sub.setOperationErrorCode(null);
        elemCon_Sub.setStrNormalEnd("ADT_NORMAL_END");
        elemCon_Sub.setStrError("ADT_ERROR");
        elemCon_Sub.setFooter(this.getFooter());
        return elemCon_Sub;
    }

    public void setPrintData(Object info) {
        List<String> keyList = this.getHedKeyList();
        List<List<String>> dataList = this.getDetailData(info);
        ArrayList<String> wkKeyList = new ArrayList<String>();
        if (dataList != null && dataList.size() > 0) {
            List<String> data = dataList.get(0);
            for (int i = 0; i < data.size(); ++i) {
                wkKeyList.add(keyList.get(i));
            }
        }
        for (int i = 0; i < dataList.size(); ++i) {
            List<String> data = dataList.get(i);
            SJctrDefaultAuditLogData adtData = new SJctrDefaultAuditLogData();
            adtData.setKeys(wkKeyList);
            adtData.setScrID(new ArrayList<String>(0));
            for (int j = 0; j < data.size(); ++j) {
                String strKey = this.getHeadKey()[j][1];
                String strHead = this.getTitleGuidance(this.getHeadKey()[j][0], this.getHeadKey()[j][1]);
                String strValue = data.get(j);
                adtData.setTitle(strKey, strHead);
                adtData.setValue(strKey, strValue);
            }
            this.detailAuth.add(adtData);
        }
    }

    public void setPrintDataForSub(Object info) {
        List<String> keyList = this.getHedKeyForSubList();
        List<List<String>> dataList = this.getDetailDataForSub(info);
        ArrayList<String> wkKeyList = new ArrayList<String>();
        if (dataList != null && dataList.size() > 0) {
            List<String> data = dataList.get(0);
            for (int i = 0; i < data.size(); ++i) {
                wkKeyList.add(keyList.get(i));
            }
        }
        for (int i = 0; i < dataList.size(); ++i) {
            List<String> data = dataList.get(i);
            SJctrDefaultAuditLogData adtData = new SJctrDefaultAuditLogData();
            adtData.setKeys(wkKeyList);
            adtData.setScrID(new ArrayList<String>(0));
            for (int j = 0; j < data.size(); ++j) {
                String strKey = this.getHeadKeyForSub()[j][1];
                String strHead = this.getTitleGuidance(this.getHeadKeyForSub()[j][0], this.getHeadKeyForSub()[j][1]);
                String strValue = data.get(j);
                adtData.setTitle(strKey, strHead);
                adtData.setValue(strKey, strValue);
            }
            this.detailAuthSub.add(adtData);
        }
    }

    private List<String> getHedKeyList() {
        ArrayList<String> rtn = new ArrayList<String>();
        if (this.getHeadKey() != null && this.getHeadKey().length > 0) {
            for (int index = 0; index < this.getHeadKey().length; ++index) {
                String key = this.getHeadKey()[index][1];
                rtn.add(key);
            }
        }
        return rtn;
    }

    private List<String> getHedKeyForSubList() {
        ArrayList<String> rtn = new ArrayList<String>();
        if (this.getHeadKeyForSub() != null && this.getHeadKeyForSub().length > 0) {
            for (int index = 0; index < this.getHeadKeyForSub().length; ++index) {
                String key = this.getHeadKeyForSub()[index][1];
                rtn.add(key);
            }
        }
        return rtn;
    }

    protected List<List<String>> getDetailData(Object info) {
        return new ArrayList<List<String>>();
    }

    protected List<List<String>> getDetailDataForSub(Object info) {
        return new ArrayList<List<String>>();
    }

    private String getFooter() {
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", this.getNumOfName());
        return this.TitleGuideMap.get(key);
    }

    private String getFooterForSub() {
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", this.getNumOfNameForSub());
        return this.TitleGuideMap.get(key);
    }

    protected String getDataGuidance(String strFuncKey, String strGuidKey) {
        String key = SJctrGuidanceOfLangType.makeGuidanceKey(strFuncKey, strGuidKey);
        String rtn = "";
        if (this.DataGuideMap != null) {
            rtn = this.DataGuideMap.get(key);
        }
        return rtn;
    }

    private String getTitleGuidance(String strFunkKey, String strGuidKey) {
        String key = SJctrGuidanceOfLangType.makeGuidanceKey(strFunkKey, strGuidKey);
        String rtn = "";
        if (this.TitleGuideMap != null) {
            rtn = this.TitleGuideMap.get(key);
        }
        return rtn;
    }

    public Map<String, String> getTitleGuideMap() {
        return this.TitleGuideMap;
    }

    public void setTitleGuideMap(Map<String, String> titleGuideMap) {
        this.TitleGuideMap = titleGuideMap;
    }

    public Map<String, String> getDataGuideMap() {
        return this.DataGuideMap;
    }

    public void setDataGuideMap(Map<String, String> dataGuideMap) {
        this.DataGuideMap = dataGuideMap;
    }

    public HashMap<String, String> getAddition() {
        return this.addition;
    }

    public void setAddition(HashMap<String, String> addition) {
        this.addition = addition;
    }
}

