/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.createkeys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncKeysBaseDC;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.createkeys.SJctrCreateKeysSubWizard;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyGenerationInfo;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyInfo;
import sanproject.sn2.model.data.system.manager.SJmoEncryptionKeyInfoMgr;

public class SJctrCreateKeysDC
extends SJctrEncKeysBaseDC
implements SJctrEncryptionKeyDef {
    private SJmoEncryptionKeyInfoMgr m_keyInfo;

    public SJctrCreateKeysDC() throws SJcException {
        super(17830769);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("CREATEKEY");
    }

    private void initDataModel() {
        SJctrTextBoxDataModel textModel = new SJctrTextBoxDataModel();
        this.addDataObjectModel("COM_NUM_OF_KEYS", textModel);
        SJctrFooterDataModel footerModel = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", footerModel);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(SJctrEncryptionKeysUtility.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR));
        set.add(SJctrEncryptionKeysUtility.createModelDirect(KEY_CLASS_SUBSYSTEM_INFO));
        return set;
    }

    @Override
    public boolean checkStartData() {
        return true;
    }

    @Override
    public boolean checkConstructData() {
        SJmoEncryptionKeyInfoMgr mgr;
        boolean rtn = true;
        List<SJmoEncryptionKeyInfoMgr> mgrs = this.getCache(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR);
        this.m_keyInfo = mgr = (SJmoEncryptionKeyInfoMgr)mgrs.get(0);
        SJmoEncryptionKeyGenerationInfo chkPolicy = mgr.getGenerationInfo();
        if (chkPolicy.getIEncKeyGenerationInfo() <= -1) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
            return false;
        }
        if (chkPolicy.getIEncKeyGenerationInfo() == 0) {
            SJctrEncryptionKeysUtility.createErrorDialog(105493);
            return false;
        }
        SJctrEncryptionKeysUtility.chkKekKey(mgrs);
        ArrayList chkKeyList = mgr.getAlEncryptionKeyInfoDEK();
        if (chkKeyList.size() >= SJctrEncryptionKeysUtility.INT_TEXT_MAX) {
            SJctrEncryptionKeysUtility.createErrorDialog(105504);
            return false;
        }
        SJctrTextBoxDataModel textData = (SJctrTextBoxDataModel)this.getDataObjectModel("COM_NUM_OF_KEYS");
        textData.setMin(Integer.toString(1));
        textData.setMax(Integer.toString(SJctrEncryptionKeysUtility.INT_TEXT_MAX - chkKeyList.size()));
        textData.setValue(Integer.toString(1));
        return rtn;
    }

    @Override
    protected void checkEncryptionKey(SJmoEncryptionKeyInfo checkTarget, List<?> allEncryptions, List<SJmoEncryptionKeyInfo> selectedEncryptions, List<SJctrErrorColumnData> errorList) {
        int index = Collections.binarySearch(allEncryptions, checkTarget);
        if (index < 0) {
            this.getLogUty().putlog("checkCreateEncryptionKeys", "Data: " + checkTarget, 40000);
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        SJmoEncryptionKeyInfo info = (SJmoEncryptionKeyInfo)allEncryptions.get(index);
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, true);
    }

    @Override
    public boolean preNextEvent(SJctrMessageEvent msgEvent, SJctrDataObjectModel<?> dstModel) {
        this.selectFinish(false);
        if (!SJctrEncryptionKeysUtility.kmsServerIsEnabled()) {
            SJctrEncryptionKeysUtility.createErrorDialog(105470);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkFinishData(SJctrMessageEvent msgEvent, SJctrDataObjectModel<?> dstModel) {
        this.selectFinish(true);
        return false;
    }

    @Override
    public boolean checkEndData() {
        boolean bChkFlg = true;
        SJctrTextBoxDataModel textData = (SJctrTextBoxDataModel)this.getDataObjectModel("COM_NUM_OF_KEYS");
        String keyNum = textData.getValue();
        ArrayList<String> confList = new ArrayList<String>();
        confList.add(keyNum);
        this.putCache("KEY_CREATE_KEYS", confList);
        this.chkFinishBtn(false);
        return bChkFlg;
    }

    public void chkFinishBtn(boolean bFlg) {
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = this.getDataObjectModel("COM_FOOTER");
        SJctrFooterDataModel footer = (SJctrFooterDataModel)dataModel;
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(bFlg);
        SJctrButtonDataModel NextButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.NEXT);
        NextButton.setChangeCheck(bFlg);
    }

    private void selectFinish(boolean bFinish) {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject relatedDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(relatedDisp);
        Class<? extends SJctrSubWizard> subWiz = dc.getSubWizard(this);
        SJctrCreateKeysSubWizard sub = (SJctrCreateKeysSubWizard)dc.getSubWizard(subWiz);
        sub.setBFiish(bFinish);
    }
}

