/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.backupkeys.ctrl;

import java.util.ArrayList;
import sanproject.serverux.dataimpl.SetEncryptionKeyBackup_IN;
import sanproject.serverux.dataimpl.SetEncryptionKeyBackup_OUT;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.SJcAuditLogApplyElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.wizard.encryption.com.SJctrCreateKMSInfo;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLogUty;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.kmip.backupkeys.ctrl.SJctrBackupKeysToServerAuditLog;
import sanproject.sn2.kms.common.SJkmsBackupInfo;
import sanproject.sn2.kms.common.SJkmsCreateInfo;
import sanproject.sn2.kms.exception.SJkmsCommunicationException;
import sanproject.sn2.kms.util.SJkmsCommunicationUty;
import sanproject.sn2.kms.util.SJkmsPasswordUty;

public class SJctrBackupKeysToServerAC
extends SJctrApplyController
implements SJctrEncryptionKeyDef {
    private String product_Num = "";
    private SJkmsBackupInfo backup_Info = null;
    private byte[] passwd = null;
    private SJctrBackupKeysToServerAuditLog adtLog = null;
    private SJctrEncryptionAuditLogUty.SJctrBackRestoreAuditLog backRestAudit = null;

    public SJctrBackupKeysToServerAC(String productNum, SJkmsBackupInfo backupInfo) {
        this.product_Num = productNum;
        this.backup_Info = backupInfo;
    }

    @Override
    public ArrayList<?> getSetList() {
        SetEncryptionKeyBackup_IN backup_Pass = new SetEncryptionKeyBackup_IN();
        ArrayList<SetEncryptionKeyBackup_IN> setList = new ArrayList<SetEncryptionKeyBackup_IN>();
        SJkmsCreateInfo kmsData = new SJkmsCreateInfo();
        SJctrCreateKMSInfo data = new SJctrCreateKMSInfo();
        try {
            kmsData = SJkmsPasswordUty.getPassword(this.product_Num);
        }
        catch (SJcException ex) {
            data = this.setCreateKMSInfo(null, ex);
            this.createAuditLog(ex, data);
            throw ex;
        }
        data = this.setCreateKMSInfo(kmsData, null);
        this.createAuditLog(null, data);
        this.passwd = kmsData.getCreateDataDEK();
        String Str_pass = "";
        Str_pass = SJkmsPasswordUty.convertPasswordtoStr(this.passwd);
        backup_Pass.setStrPassword(Str_pass);
        setList.add(backup_Pass);
        return setList;
    }

    @Override
    public int getLeadTime() {
        int iLeadTime = 15;
        return iLeadTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setApplyResult(Object reslutObject) {
        SetEncryptionKeyBackup_OUT out = null;
        out = (SetEncryptionKeyBackup_OUT)reslutObject;
        byte[] backupData = null;
        backupData = out.getByKeyData();
        String taskName = null;
        taskName = super.getTaskName();
        this.backup_Info.setBackupDataDEK(backupData);
        this.backup_Info.setBackuptaskName(taskName);
        this.backup_Info.setBackupDataPASSWD(this.passwd);
        SJkmsBackupInfo result = null;
        SJkmsCommunicationException error = null;
        try {
            result = SJkmsCommunicationUty.backup(this.product_Num, this.backup_Info);
        }
        catch (SJkmsCommunicationException e) {
            error = e;
            result = this.backup_Info;
            result.setUUID("-");
        }
        finally {
            SJcAuditLogApplyElemCon elemCon = SJctrEncryptionAuditLogUty.putEncKeysAuditoLog(SJctrEncryptionAuditLogUty.EncryptionOperation.BACKUPKEYS_TO_SERVER, taskName, result, this.backRestAudit, (SJcException)error);
            SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
            adtLogger.putLog(elemCon);
            if (error != null) {
                super.setError(SJctrError.parseError(error));
                throw error;
            }
            super.setError(new SJctrError(0, 0, 0));
        }
    }

    private SJctrCreateKMSInfo setCreateKMSInfo(SJkmsCreateInfo data, SJcException err) {
        SJctrCreateKMSInfo info = new SJctrCreateKMSInfo();
        if (data != null) {
            info.setStrUuid(data.getUUID());
        }
        if (err != null) {
            int md_ID = Integer.parseInt(err.getMsg().getModuleID());
            info.setStrResult("(" + err.getMsg().getFunctionID() + SJctrComUtility.toPaddingZeroString(md_ID, 2) + "-" + err.getMsg().getMsgID() + ")");
            String[] errMSG = err.getMsg().getMeansure_argument();
            String errServ_Msg = SJctrEncryptionKeysUtility.getErrMsg(errMSG);
            info.setStrServ_Reply(errServ_Msg);
        }
        return info;
    }

    public void setAdtLog(SJctrBackupKeysToServerAuditLog adtLog) {
        this.adtLog = adtLog;
    }

    public void setBackRestAdtLog(SJctrEncryptionAuditLogUty.SJctrBackRestoreAuditLog backRestAudit) {
        this.backRestAudit = backRestAudit;
    }

    private void createAuditLog(SJcException err, SJctrCreateKMSInfo data) {
        SJcLogUty.getLogger().info("[ENC]", "SJctrBackupKeystoServerAC", "createAuditLog", "AuditLog Output start.");
        SJcAuditLoggerInterface SJcLogger2 = SJcLogUty.getAuditLogger();
        this.adtLog.setPrintData(data);
        SJcAuditLogApplyElemCon adtLogCont_IF = this.adtLog.createElemCon();
        adtLogCont_IF.setTaskName(this.getTaskName());
        String resultInfo = "Success";
        SJcMessage errMsg = null;
        if (err != null && err.getMsg() != null) {
            resultInfo = "Error";
            errMsg = err.getMsg();
        }
        adtLogCont_IF.setOperationResult(resultInfo);
        adtLogCont_IF.setOperationErrorCode(errMsg);
        SJcLogger2.putLog(adtLogCont_IF);
        SJcLogUty.getLogger().info("[ENC]", "SJctrBackupKeystoServerAC", "createAuditLog", "AuditLog Output end.");
    }
}

