/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.delbackserver;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.SJcAuditLogApplyElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLog;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.kmip.delbackserver.SJctrDeleteBackupServerAuditLog;
import sanproject.sn2.controller.wizard.encryption.kmip.delbackserver.SJctrDeleteBackupServerConfirmData;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.kms.common.SJkmsDeleteInfo;
import sanproject.sn2.kms.util.SJkmsCommunicationUty;

public class SJctrDeleteBackupServerAC
extends SJctrApplyController
implements SJctrEncryptionKeyDef {
    private static final long serialVersionUID = 7324552140215026716L;
    public SJctrDeleteBackupServerConfirmData confirmData;
    private SJctrEncryptionAuditLog adtLog;
    private List<SJctrError> resultData = null;
    private SJctrError result = new SJctrError(0, 0, 0);

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SJctrDeleteBackupServerConfirmData> rtn = new ArrayList<SJctrDeleteBackupServerConfirmData>();
        rtn.add(this.confirmData);
        return rtn;
    }

    public void setAdtLog(SJctrDeleteBackupServerAuditLog adtLog) {
        this.adtLog = adtLog;
    }

    @Override
    public int getLeadTime() {
        int iSize_1 = this.confirmData.getUuidList().size();
        int iSize_2 = (iSize_1 - iSize_1 / 2) / 30 * 15;
        int leadTime = iSize_2 + iSize_1 / 30 + 5;
        return leadTime;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        ArrayList<?> setList = this.getSetList();
        SJctrDeleteBackupServerConfirmData conData = (SJctrDeleteBackupServerConfirmData)setList.get(0);
        ArrayList<SJkmsDeleteInfo> delList = new ArrayList();
        try {
            delList = SJkmsCommunicationUty.delete(conData.getStrProductCode(), conData.getUuidList());
        }
        catch (SJcException ex) {
            SJcLogUty.getLogger().info("[ENC]", "[DELBACK AC]", "Exception", ex.toString());
            SJcMessage msg = ex.getMsg();
            List<String> uuidList = conData.getUuidList();
            for (int i = 0; i < uuidList.size(); ++i) {
                SJkmsDeleteInfo del = new SJkmsDeleteInfo();
                del.setUUID(uuidList.get(i));
                del.setMsg(msg);
                delList.add(del);
            }
        }
        conData.setDelList(delList);
        this.setApplyResult(conData);
        this.createAuditLog(this.result, conData);
        this.setError(this.result);
    }

    @Override
    protected void setApplyResult(Object wkConData) {
        SJctrDeleteBackupServerConfirmData confData = (SJctrDeleteBackupServerConfirmData)wkConData;
        this.resultData = confData.getErrList();
        if (this.resultData.size() > 0) {
            this.result = this.resultData.get(0);
        }
        for (int i = 0; i < this.resultData.size(); ++i) {
            SJctrError err = this.resultData.get(i);
            if (err.getError() == 0) continue;
            this.result = err;
            break;
        }
    }

    private void createAuditLog(SJctrError result, SJctrDeleteBackupServerConfirmData conData) {
        SJcLogUty.getLogger().info("[ENC]", "SJctrDeleteBackupServerAC", "createAuditLog", "AuditLog Output start.");
        SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
        this.adtLog.setPrintData(conData);
        SJcAuditLogApplyElemCon adtLogCont_IF = this.adtLog.createElemCon();
        adtLogCont_IF.setTaskName(this.getTaskName());
        String adtResult = "Success";
        SJcMessage adtMessage = null;
        if (result.getError() != 0) {
            adtResult = "Error";
            adtMessage = result.createException().getMsg();
            adtMessage.setModuleID(SJctrComUtility.toPaddingZeroString(result.getModule(), 2));
        }
        adtLogCont_IF.setOperationResult(adtResult);
        adtLogCont_IF.setOperationErrorCode(adtMessage);
        adtLogger.putLog(adtLogCont_IF);
        SJcLogUty.getLogger().info("[ENC]", "SJctrDeleteBackupServerAC", "createAuditLog", "AuditLog Output end.");
    }

    public void setWizardSetData(SJctrDeleteBackupServerConfirmData confirmData) {
        this.confirmData = confirmData;
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public boolean hasApplyResult() {
        return true;
    }
}

