/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.delbackserver;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLog;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.kmip.delbackserver.SJctrDeleteBackupServerConfirmData;
import sanproject.sn2.kms.common.SJkmsDeleteInfo;
import sanproject.sn2.kms.common.SJkmsReferInfo;

public class SJctrDeleteBackupServerAuditLog
extends SJctrEncryptionAuditLog
implements SJctrEncryptionKeyDef {
    private static final long serialVersionUID = -634644793333761789L;

    public SJctrDeleteBackupServerAuditLog(SJbaseUserSession userSession) {
        super(userSession);
    }

    @Override
    protected String getFuncName() {
        return "ADT_FC_ENC";
    }

    @Override
    protected String getOperationName() {
        return "ADT_TITLE_DELBACKSERVER";
    }

    @Override
    protected String[][] getBaseKey() {
        String[][] rtn = new String[][]{{"COMMON", "ADT_TITLE_DELBACKSERVER"}, {"COMMON", "ADT_NUM_OF_KEYS"}};
        return rtn;
    }

    @Override
    protected String[][] getHeadKey() {
        String[][] rtn = new String[][]{{"COMMON", "UUID"}, {"COMMON", "BACKUP_DATE"}, {"COMMON", "DESCRIPT"}, {"COMMON", "ADT_RESULT"}, {"COMMON", "ADT_SERVER_REPRY"}};
        return rtn;
    }

    @Override
    protected String[][] getDataKey() {
        String[][] rtn = new String[][]{{"COMMON", "ADT_NORMAL_END"}, {"COMMON", "ADT_ERROR"}};
        return rtn;
    }

    @Override
    protected String getNumOfName() {
        return "ADT_NUM_OF_KEYS";
    }

    @Override
    protected List<List<String>> getDetailData(Object wkInfo) {
        ArrayList<List<String>> rtn = new ArrayList<List<String>>();
        SJctrDeleteBackupServerConfirmData data = (SJctrDeleteBackupServerConfirmData)wkInfo;
        List<SJkmsReferInfo> infoList = data.getreferList();
        List<SJkmsDeleteInfo> delList = data.getDelList();
        for (int i = 0; i < infoList.size(); ++i) {
            ArrayList<String> strDataList = new ArrayList<String>();
            SJkmsReferInfo info = infoList.get(i);
            strDataList.add(info.getUUID());
            SimpleDateFormat sdfKeyCreateDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            strDataList.add(new String(sdfKeyCreateDate.format(info.getBackupDate())));
            strDataList.add(info.getBackupComment());
            SJkmsDeleteInfo del = delList.get(i);
            if (del.getMsg() == null) {
                strDataList.add(this.getDataGuidance("COMMON", "ADT_NORMAL_END"));
                strDataList.add("-");
            } else {
                int iModuleID = Integer.parseInt(del.getMsg().getModuleID());
                strDataList.add(this.getDataGuidance("COMMON", "ADT_ERROR") + "(" + del.getMsg().getFunctionID() + SJctrComUtility.toPaddingZeroString(iModuleID, 2) + "-" + del.getMsg().getMsgID() + ")");
                String[] str = del.getMsg().getMeansure_argument();
                if (str != null) {
                    if (str.length > 0) {
                        if (str.length > 1) {
                            strDataList.add(str[0] + " " + str[1]);
                        } else {
                            strDataList.add(str[0]);
                        }
                    }
                } else {
                    strDataList.add("-");
                }
            }
            rtn.add(strDataList);
        }
        return rtn;
    }
}

