/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys.SJctrRegularBackupKey;
import sanproject.sn2.kms.common.SJkmsConfiguration;
import sanproject.sn2.kms.common.SJkmsKmipConfiguration;
import sanproject.sn2.kms.util.SJkmsConfigUty;

public class SJctrRegularBackupKeyScheduleManager
extends Thread {
    private final String className = this.getClass().getSimpleName();
    private static SJctrRegularBackupKeyScheduleManager myselfInstance = null;
    private String regularBackupScheduleMemory = "";
    private ArrayList<ThreadAndTaskSet> threadAndTaskSetList = new ArrayList();
    private boolean continuationFlg = true;
    private String errLogMemory = "";
    private Calendar errLogCal = null;
    private boolean nextDayScheduleMakedFlg = false;
    private Calendar roopTimeCal = Calendar.getInstance();
    private Calendar beforeRoopTimeCal = Calendar.getInstance();
    private final int WAIT_TIME_MILLISEC = 300000;

    private SJctrRegularBackupKeyScheduleManager() {
    }

    public static synchronized SJctrRegularBackupKeyScheduleManager getInstance() {
        if (myselfInstance == null) {
            myselfInstance = new SJctrRegularBackupKeyScheduleManager();
        }
        return myselfInstance;
    }

    @Override
    public void run() {
        SJctrLogUty.info(this.className, "run", "Start");
        try {
            this.action();
            this.timerClear();
        }
        catch (Exception e) {
            SJctrLogUty.info(this.className, "run", "Exception", e);
        }
        SJctrLogUty.info(this.className, "run", "End");
    }

    private void action() {
        this.continuationFlg = true;
        while (this.continuationFlg) {
            this.roopTimeCal = Calendar.getInstance();
            String strType = SJkmsConfigUty.getType();
            if (!strType.equals("kmip")) {
                this.timerClear();
                this.logPrint("action", "Server is not set up", LogPrintMode.INFO);
                this.beforeRoopTimeCal = (Calendar)this.roopTimeCal.clone();
                this.threadSleep();
                continue;
            }
            List<SJkmsConfiguration> confList = SJkmsConfigUty.getConfiguration(strType);
            if (confList == null || confList.size() <= 0) {
                this.timerClear();
                this.logPrint("action", "Unable to get configuration", LogPrintMode.WARN);
                this.beforeRoopTimeCal = (Calendar)this.roopTimeCal.clone();
                this.threadSleep();
                continue;
            }
            SJkmsKmipConfiguration conf = (SJkmsKmipConfiguration)confList.get(0);
            if (!conf.getRegularbackupEnabled() || conf.getRegularbackupSchedule() == null || conf.getRegularbackupSchedule().length() == 0) {
                this.timerClear();
                this.logPrint("action", "Schedule Configuration is invalid or not set", LogPrintMode.INFO);
                this.beforeRoopTimeCal = (Calendar)this.roopTimeCal.clone();
                this.threadSleep();
                continue;
            }
            Object[] scheduleTimes = conf.getRegularbackupSchedule().split(",");
            if (!this.isScheduleFormatCheck((String[])scheduleTimes)) {
                this.timerClear();
                this.logPrint("action", "ScheduleTime value is invalid", LogPrintMode.ERROR);
                this.beforeRoopTimeCal = (Calendar)this.roopTimeCal.clone();
                this.threadSleep();
                continue;
            }
            if (!conf.getRegularbackupSchedule().equals(this.regularBackupScheduleMemory) || this.roopTimeCal.compareTo(this.beforeRoopTimeCal) < 0) {
                SJctrLogUty.info(this.className, "action", "Schedule reflesh or time returned");
                this.timerClear();
                if (this.roopTimeCal.compareTo(this.beforeRoopTimeCal) > 0 && this.roopTimeCal.get(11) != this.beforeRoopTimeCal.get(11) && Arrays.asList((Object[])scheduleTimes).contains(String.format("%02d", this.roopTimeCal.get(11)))) {
                    this.timerOneSet(this.roopTimeCal.get(11));
                }
                this.timerAllSet((String[])scheduleTimes, TimerAllSetMode.FORTODAY);
                this.timerAllSet((String[])scheduleTimes, TimerAllSetMode.FORNEXTDAY);
                this.regularBackupScheduleMemory = conf.getRegularbackupSchedule();
                this.beforeRoopTimeCal = (Calendar)this.roopTimeCal.clone();
                this.threadSleep();
                continue;
            }
            if (!this.taskStartCheck()) {
                SJctrLogUty.warn(this.className, "action", "Job not work");
                boolean notStartNowTaskFlg = false;
                for (ThreadAndTaskSet ins : this.threadAndTaskSetList) {
                    if (!this.ymdhFormat(ins.taskStartCal).equals(this.ymdhFormat(this.roopTimeCal)) || ins.timerTaskRegBkKey.getiRunMethodState() != SJctrRegularBackupKey.RUN_METHOD_STATE.PRESTART) continue;
                    notStartNowTaskFlg = true;
                    break;
                }
                this.timerClear();
                if (notStartNowTaskFlg) {
                    this.timerOneSet(this.roopTimeCal.get(11));
                }
                this.timerAllSet((String[])scheduleTimes, TimerAllSetMode.FORTODAY);
                this.timerAllSet((String[])scheduleTimes, TimerAllSetMode.FORNEXTDAY);
                this.regularBackupScheduleMemory = conf.getRegularbackupSchedule();
                this.beforeRoopTimeCal = (Calendar)this.roopTimeCal.clone();
                this.threadSleep();
                continue;
            }
            if (this.roopTimeCal.get(11) >= 23 && !this.nextDayScheduleMakedFlg) {
                SJctrLogUty.info(this.className, "action", "Make job For 23 hour");
                this.adjustTimerListFor23hour();
                this.timerAllSet((String[])scheduleTimes, TimerAllSetMode.FORNEXTDAY);
                this.beforeRoopTimeCal = (Calendar)this.roopTimeCal.clone();
                this.threadSleep();
                continue;
            }
            if (this.nextDayScheduleMakedFlg && this.roopTimeCal.get(11) < 23) {
                SJctrLogUty.info(this.className, "action", "Nextdayflg reset");
                this.nextDayScheduleMakedFlg = false;
                this.beforeRoopTimeCal = (Calendar)this.roopTimeCal.clone();
                this.threadSleep();
                continue;
            }
            this.errLogMemory = "";
            this.errLogCal = null;
            this.beforeRoopTimeCal = (Calendar)this.roopTimeCal.clone();
            this.threadSleep();
        }
    }

    private void timerClear() {
        for (ThreadAndTaskSet ins : this.threadAndTaskSetList) {
            ins.timer.cancel();
            SJctrLogUty.info(this.className, "timerClear", "job Cancel_" + ins.taskStartCal.getTime().toString());
        }
        this.threadAndTaskSetList.clear();
        this.regularBackupScheduleMemory = "";
    }

    private void threadSleep() {
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException e) {
            SJctrLogUty.error(this.className, "threadSleep", "Thread interrupted");
        }
    }

    private void timerAllSet(String[] scheduleTimes, TimerAllSetMode mode) {
        for (int i = 0; i < scheduleTimes.length; ++i) {
            Calendar taskCal = (Calendar)this.roopTimeCal.clone();
            if (mode == TimerAllSetMode.FORNEXTDAY) {
                taskCal.set(5, this.roopTimeCal.get(5) + 1);
                taskCal.set(11, Integer.parseInt(scheduleTimes[i]));
                taskCal.set(12, 0);
                taskCal.set(13, 0);
            }
            if (mode == TimerAllSetMode.FORTODAY) {
                if (taskCal.get(11) >= Integer.parseInt(scheduleTimes[i])) continue;
                taskCal.set(11, Integer.parseInt(scheduleTimes[i]));
                taskCal.set(12, 0);
                taskCal.set(13, 0);
            }
            if (this.threadDuplicationCheck(taskCal)) continue;
            Timer timer = new Timer("RegularBackupKeySchedule_" + taskCal.getTime().toString());
            SJctrRegularBackupKey timerTask = new SJctrRegularBackupKey();
            timer.schedule((TimerTask)timerTask, taskCal.getTime());
            ThreadAndTaskSet ins = new ThreadAndTaskSet();
            ins.taskStartCal = taskCal;
            ins.timer = timer;
            ins.timerTaskRegBkKey = timerTask;
            this.threadAndTaskSetList.add(ins);
            SJctrLogUty.info(this.className, "timerAllSet", "Job Make_" + taskCal.getTime().toString());
        }
        if (mode == TimerAllSetMode.FORNEXTDAY) {
            this.nextDayScheduleMakedFlg = true;
        }
        this.errLogMemory = "";
        this.errLogCal = null;
    }

    private void timerOneSet(int scheduleTime) {
        Calendar taskCal = (Calendar)this.roopTimeCal.clone();
        taskCal.set(11, scheduleTime);
        taskCal.set(12, 0);
        taskCal.set(13, 0);
        Timer timer = new Timer("RegularBackupKeySchedule_" + taskCal.getTime().toString());
        SJctrRegularBackupKey timerTask = new SJctrRegularBackupKey();
        timer.schedule((TimerTask)timerTask, taskCal.getTime());
        ThreadAndTaskSet ins = new ThreadAndTaskSet();
        ins.taskStartCal = taskCal;
        ins.timer = timer;
        ins.timerTaskRegBkKey = timerTask;
        this.threadAndTaskSetList.add(ins);
        SJctrLogUty.info(this.className, "timerOneSet", "Job Make_" + taskCal.getTime().toString());
    }

    private boolean threadDuplicationCheck(Calendar taskCal) {
        for (ThreadAndTaskSet threadAndTaskSet : this.threadAndTaskSetList) {
            Calendar compareCal = (Calendar)threadAndTaskSet.taskStartCal.clone();
            String compareCalYMDH = "";
            compareCalYMDH = compareCalYMDH + compareCal.get(1);
            compareCalYMDH = compareCalYMDH + String.format("%02d", compareCal.get(2) + 1);
            compareCalYMDH = compareCalYMDH + String.format("%02d", compareCal.get(5));
            compareCalYMDH = compareCalYMDH + String.format("%02d", compareCal.get(11));
            String taskCalYMDH = "";
            taskCalYMDH = taskCalYMDH + taskCal.get(1);
            taskCalYMDH = taskCalYMDH + String.format("%02d", taskCal.get(2) + 1);
            taskCalYMDH = taskCalYMDH + String.format("%02d", taskCal.get(5));
            if (!compareCalYMDH.equals(taskCalYMDH = taskCalYMDH + String.format("%02d", taskCal.get(11)))) continue;
            return true;
        }
        return false;
    }

    private String ymdhFormat(Calendar cal) {
        String str = "";
        str = str + cal.get(1);
        str = str + String.format("%02d", cal.get(2) + 1);
        str = str + String.format("%02d", cal.get(5));
        str = str + String.format("%02d", cal.get(11));
        return str;
    }

    public boolean waitTaskCheck() {
        for (ThreadAndTaskSet ins : this.threadAndTaskSetList) {
            if (!ins.timerTaskRegBkKey.isbWaitState()) continue;
            return true;
        }
        return false;
    }

    private void logPrint(String methodName, String message, LogPrintMode logMode) {
        boolean printFlg = false;
        if (this.errLogCal == null || this.errLogMemory == null || this.errLogMemory.length() == 0) {
            printFlg = true;
        } else if (this.errLogCal != null) {
            Calendar errLogNextDayCal = (Calendar)this.errLogCal.clone();
            errLogNextDayCal.add(5, 1);
            if (this.roopTimeCal.compareTo(errLogNextDayCal) > 0 || !this.errLogMemory.equals(message) || this.roopTimeCal.compareTo(this.beforeRoopTimeCal) < 0) {
                printFlg = true;
            }
        }
        if (printFlg) {
            switch (logMode) {
                case INFO: {
                    SJctrLogUty.info(this.className, methodName, message);
                    break;
                }
                case WARN: {
                    SJctrLogUty.warn(this.className, methodName, message);
                    break;
                }
                case ERROR: {
                    SJctrLogUty.error(this.className, methodName, message);
                }
            }
            this.errLogCal = Calendar.getInstance();
            this.errLogMemory = message;
        }
    }

    public void stopRunning() {
        this.continuationFlg = false;
        this.interrupt();
    }

    private void adjustTimerListFor23hour() {
        for (int i = 0; i < this.threadAndTaskSetList.size(); ++i) {
            ThreadAndTaskSet ins = this.threadAndTaskSetList.get(i);
            if (ins.timerTaskRegBkKey.getiRunMethodState() != SJctrRegularBackupKey.RUN_METHOD_STATE.FINISHED) continue;
            SJctrLogUty.info(this.className, "adjustTimerListFor23hour", "Job Cancel_" + ins.taskStartCal.getTime().toString());
            ins.timer.cancel();
            this.threadAndTaskSetList.remove(i);
            --i;
        }
    }

    private boolean taskStartCheck() {
        Calendar rtcal5SecAfter = (Calendar)this.roopTimeCal.clone();
        rtcal5SecAfter.add(13, -5);
        for (ThreadAndTaskSet ins : this.threadAndTaskSetList) {
            if (rtcal5SecAfter.compareTo(ins.taskStartCal) <= 0 || ins.timerTaskRegBkKey.getiRunMethodState() != SJctrRegularBackupKey.RUN_METHOD_STATE.PRESTART) continue;
            return false;
        }
        return true;
    }

    public boolean isNowTimeScheduleCheck() {
        String strType = SJkmsConfigUty.getType();
        if (!strType.equals("kmip")) {
            return false;
        }
        List<SJkmsConfiguration> confList = SJkmsConfigUty.getConfiguration(strType);
        if (confList == null || confList.size() <= 0) {
            return false;
        }
        SJkmsKmipConfiguration conf = (SJkmsKmipConfiguration)confList.get(0);
        if (!conf.getRegularbackupEnabled() || conf.getRegularbackupSchedule() == null || conf.getRegularbackupSchedule().length() == 0) {
            return false;
        }
        String[] scheduleTimes = conf.getRegularbackupSchedule().split(",");
        if (this.isScheduleFormatCheck(scheduleTimes)) {
            for (String scheduleTime : scheduleTimes) {
                if (Calendar.getInstance().get(11) != Integer.parseInt(scheduleTime)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isScheduleFormatCheck(String[] scheduleTimes) {
        ArrayList<String> scheduleTimesForCheck = new ArrayList<String>();
        for (String scheduleTime : scheduleTimes) {
            try {
                if (Integer.parseInt(scheduleTime) < 0 || 23 < Integer.parseInt(scheduleTime)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            for (String scheduleTimeForCheck : scheduleTimesForCheck) {
                if (!scheduleTime.equals(scheduleTimeForCheck)) continue;
                return false;
            }
            scheduleTimesForCheck.add(scheduleTime);
        }
        return true;
    }

    private class ThreadAndTaskSet {
        Calendar taskStartCal;
        Timer timer;
        SJctrRegularBackupKey timerTaskRegBkKey;

        private ThreadAndTaskSet() {
        }
    }

    private static enum LogPrintMode {
        INFO,
        WARN,
        ERROR;

    }

    private static enum TimerAllSetMode {
        FORTODAY,
        FORNEXTDAY;

    }
}

