/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import sanproject.serverux.dataimpl.SetEncryptionKeyBackup_IN;
import sanproject.serverux.dataimpl.SetEncryptionKeyBackup_OUT;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.SJcAuditLogApplyElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLogUty;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.kmip.delbackserver.SJctrDeleteBackupServerConfirmData;
import sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys.SJctrRegularDeleteBackupServerAuditLog;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.kms.common.SJkmsBackupInfo;
import sanproject.sn2.kms.common.SJkmsCreateInfo;
import sanproject.sn2.kms.common.SJkmsDeleteInfo;
import sanproject.sn2.kms.common.SJkmsReferInfo;
import sanproject.sn2.kms.exception.SJkmsCommunicationException;
import sanproject.sn2.kms.util.SJkmsCommunicationUty;
import sanproject.sn2.kms.util.SJkmsPasswordUty;

public class SJctrRegularBackupKeysToServerAC
extends SJctrApplyController
implements SJctrEncryptionKeyDef {
    private String product_Num = "";
    private SJkmsBackupInfo backup_Info = null;
    private byte[] passwd = null;
    private SJctrEncryptionAuditLogUty.SJctrBackRestoreAuditLog backRestAudit = null;
    private SJctrRegularDeleteBackupServerAuditLog regularDeleteAdtLog = null;
    private SJctrError result = new SJctrError(0, 0, 0);
    private SJkmsBackupInfo backup_ResultInfo = null;

    public SJctrRegularBackupKeysToServerAC(String productNum, SJkmsBackupInfo backupInfo) {
        this.product_Num = productNum;
        this.backup_Info = backupInfo;
    }

    @Override
    public ArrayList<?> getSetList() {
        SetEncryptionKeyBackup_IN backup_Pass = new SetEncryptionKeyBackup_IN();
        ArrayList<SetEncryptionKeyBackup_IN> setList = new ArrayList<SetEncryptionKeyBackup_IN>();
        SJkmsCreateInfo kmsData = new SJkmsCreateInfo();
        try {
            kmsData = SJkmsPasswordUty.getPassword(this.product_Num);
        }
        catch (SJcException ex) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getSetList", "failed getPassword.");
            throw ex;
        }
        this.passwd = kmsData.getCreateDataDEK();
        String Str_pass = "";
        Str_pass = SJkmsPasswordUty.convertPasswordtoStr(this.passwd);
        backup_Pass.setStrPassword(Str_pass);
        setList.add(backup_Pass);
        return setList;
    }

    public void setRegularDeleteAdtLog(SJctrRegularDeleteBackupServerAuditLog adtLog) {
        this.regularDeleteAdtLog = adtLog;
    }

    @Override
    public int getLeadTime() {
        int iBackupLeadTime = 15;
        int iSize_1 = 1;
        int iSize_2 = (iSize_1 - iSize_1 / 2) / 30 * 15;
        int iDeleteLeadTime = iSize_2 + iSize_1 / 30 + 5;
        return iBackupLeadTime + iDeleteLeadTime;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        boolean errorFlg = false;
        SJctrError error = null;
        if (!this.backup_Info.getKmipModeFlg()) {
            errorFlg = true;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "applyStart", "Illigal Server Type");
            error = new SJctrError(101, 22, 206336);
            this.setError(error);
        }
        if (!this.backup_Info.getBackupUserEnabledFlg()) {
            errorFlg = true;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "applyStart", "Illigal User");
            if (error == null) {
                error = new SJctrError(101, 22, 206337);
                this.setError(error);
            }
        }
        if (!this.backup_Info.getUserRole()) {
            errorFlg = true;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "applyStart", "Illigal Role");
            if (error == null) {
                error = new SJctrError(101, 22, 206338);
                this.setError(error);
            }
        }
        if (!this.backup_Info.getBackupLisence()) {
            errorFlg = true;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "applyStart", "License Error Encryption License Key");
            if (error == null) {
                error = new SJctrError(101, 22, 206339);
                this.setError(error);
            }
        }
        if (!errorFlg) {
            super.applyStart(supplier);
        } else {
            String taskName = null;
            taskName = super.getTaskName();
            SJkmsBackupInfo backupResult = this.backup_Info;
            backupResult.setUUID("-");
            SJcException preChkError = error.createException();
            SJcAuditLogApplyElemCon elemCon = SJctrEncryptionAuditLogUty.putEncKeysAuditoLog(SJctrEncryptionAuditLogUty.EncryptionOperation.REGULARBACKUPKEYS_TO_SERVER, taskName, backupResult, this.backRestAudit, preChkError);
            SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
            adtLogger.putLog(elemCon);
        }
    }

    @Override
    protected void setApplyResult(Object reslutObject) {
        SetEncryptionKeyBackup_OUT out = null;
        out = (SetEncryptionKeyBackup_OUT)reslutObject;
        byte[] backupData = null;
        backupData = out.getByKeyData();
        this.executeRegularBackup(backupData);
        this.executeRegularDelete();
    }

    public void setBackRestAdtLog(SJctrEncryptionAuditLogUty.SJctrBackRestoreAuditLog backRestAudit) {
        this.backRestAudit = backRestAudit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRegularBackup(byte[] backupData) {
        String taskName = null;
        taskName = super.getTaskName();
        this.backup_Info.setBackupDataDEK(backupData);
        this.backup_Info.setBackuptaskName(taskName);
        this.backup_Info.setBackupDataPASSWD(this.passwd);
        this.backup_Info.setRegularBackup(true);
        SJkmsBackupInfo backupResult = null;
        SJkmsCommunicationException error = null;
        try {
            backupResult = SJkmsCommunicationUty.backup(this.product_Num, this.backup_Info);
        }
        catch (SJkmsCommunicationException e) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "executeRegularBackup", "regular backup failed.");
            error = e;
            backupResult = this.backup_Info;
            backupResult.setUUID("-");
        }
        finally {
            this.backup_ResultInfo = backupResult;
            SJcAuditLogApplyElemCon elemCon = SJctrEncryptionAuditLogUty.putEncKeysAuditoLog(SJctrEncryptionAuditLogUty.EncryptionOperation.REGULARBACKUPKEYS_TO_SERVER, taskName, backupResult, this.backRestAudit, (SJcException)error);
            SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
            adtLogger.putLog(elemCon);
            if (error != null) {
                super.setError(SJctrError.parseError(error));
                throw error;
            }
            super.setError(new SJctrError(0, 0, 0));
        }
    }

    private void executeRegularDelete() {
        SJctrDeleteBackupServerConfirmData conData = new SJctrDeleteBackupServerConfirmData();
        ArrayList<SJkmsReferInfo> referList = new ArrayList<SJkmsReferInfo>();
        List<Object> delList = new ArrayList();
        SJcException delException = null;
        try {
            List<Object> referListWk = new ArrayList();
            referListWk = SJkmsCommunicationUty.refer(this.product_Num);
            delList = SJkmsCommunicationUty.deleteRegularBackup(this.product_Num, this.backup_ResultInfo);
            for (SJkmsDeleteInfo sJkmsDeleteInfo : delList) {
                for (SJkmsReferInfo sJkmsReferInfo : referListWk) {
                    if (!sJkmsDeleteInfo.getUUID().contains(sJkmsReferInfo.getUUID())) continue;
                    referList.add(sJkmsReferInfo);
                }
            }
        }
        catch (SJcException ex) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "executeRegularDelete", "regular delete failed.");
            delException = ex;
            SJcMessage msg = delException.getMsg();
            SJkmsReferInfo sJkmsReferInfo = new SJkmsReferInfo();
            sJkmsReferInfo.setUUID("?");
            sJkmsReferInfo.setBackupComment("?");
            Date date = new Date();
            sJkmsReferInfo.setBackupDate(date);
            sJkmsReferInfo.setRegularBackup(true);
            referList.add(sJkmsReferInfo);
            SJkmsDeleteInfo sJkmsDeleteInfo = new SJkmsDeleteInfo();
            sJkmsDeleteInfo.setUUID("?");
            sJkmsDeleteInfo.setMsg(msg);
            delList.add(sJkmsDeleteInfo);
        }
        conData.setreferList(referList);
        conData.setDelList(delList);
        for (SJctrError err : conData.getErrList()) {
            if (err.getError() == 0) continue;
            this.result = err;
            break;
        }
        this.createRegularDeleteAuditLog(this.result, conData);
        if (delException != null) {
            throw delException;
        }
    }

    private void createRegularDeleteAuditLog(SJctrError result, SJctrDeleteBackupServerConfirmData conData) {
        SJcLogUty.getLogger().info("[ENC]", "SJctrRegularBackupKeysToServerAC", "createRegularDeleteAuditLog", "AuditLog Output start.");
        SJcAuditLoggerInterface adtLogger = SJcLogUty.getAuditLogger();
        this.regularDeleteAdtLog.setPrintData(conData);
        SJcAuditLogApplyElemCon adtLogCont_IF = this.regularDeleteAdtLog.createElemCon();
        adtLogCont_IF.setTaskName(this.getTaskName());
        String adtResult = "Success";
        SJcMessage adtMessage = null;
        if (result.getError() != 0) {
            adtResult = "Error";
            adtMessage = result.createException().getMsg();
            adtMessage.setModuleID(SJctrComUtility.toPaddingZeroString(result.getModule(), 2));
        }
        adtLogCont_IF.setOperationResult(adtResult);
        adtLogCont_IF.setOperationErrorCode(adtMessage);
        adtLogger.putLog(adtLogCont_IF);
        SJcLogUty.getLogger().info("[ENC]", "SJctrRegularBackupKeysToServerAC", "createRegularDeleteAuditLog", "AuditLog Output end.");
    }
}

