/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLogUty;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.kmip.backupkeys.SJctrBackupKeysToServerSubWizard;
import sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys.SJctrRegularBackupKeysToServerAC;
import sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys.SJctrRegularDeleteBackupServerAuditLog;
import sanproject.sn2.kms.common.SJkmsBackupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetEncryptionKeyInfoMgr;
import sanproject.sn2.model.data.system.manager.SJmoEncryptionKeyInfoMgr;

public class SJctrRegularBackupKeysToServerSubWizard
extends SJctrBackupKeysToServerSubWizard
implements SJctrEncryptionKeyDef {
    private static final SimpleDateFormat AUTO_TASKNAME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'_'hh:mm aaa", Locale.ENGLISH);

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", "REGULAR_BACKUP_KEYS_TO_SERVER");
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> retSet = new HashSet<SJctrGetDirectWrapper>();
        retSet.add(SJctrEncryptionKeysUtility.createModelDirect(SJmoGetEncryptionKeyInfoMgr.class));
        return retSet;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        SJctrUserController uc = wizard.getOwner();
        SJctrRelatedDispDataObject confirmDo = uc.getRelatedDispData(KEY_CLASS_BACKUPKEYSRV_CONFIRM_DC);
        SJctrRegularBackupKeysToServerAC ac = this.createApplyController(uc);
        ac.setBackRestAdtLog(new SJctrEncryptionAuditLogUty.SJctrBackRestoreAuditLog((SJbaseUserSession)uc.getUserSession()));
        SJctrRegularDeleteBackupServerAuditLog adtLog = new SJctrRegularDeleteBackupServerAuditLog((SJbaseUserSession)uc.getUserSession());
        ac.setRegularDeleteAdtLog(adtLog);
        SJctrTask task = wizard.getTask();
        task.setName(SJctrTask.createDefaultTaskName(this.getTaskNameGuidance().getGuidanceEN()));
        wizard.addConfirmData(ac, confirmDo);
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    public static String createComment(String comment) {
        StringBuilder buf = new StringBuilder();
        buf.append(comment.replace(" ", ""));
        buf.append(AUTO_TASKNAME_FORMAT.format(new Date()));
        String defTaskName = buf.toString();
        return defTaskName;
    }

    private boolean isKMIPModeEnable(SJctrWizardWindowDC dc) {
        SJmoEncryptionKeyInfoMgr mgr;
        int iGene;
        boolean rtn = false;
        List<?> encList = dc.getCache(SJmoGetEncryptionKeyInfoMgr.class);
        if (encList == null || encList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "action", "get encryption key info faild.");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        if ((iGene = (mgr = (SJmoEncryptionKeyInfoMgr)encList.get(0)).getGenerationInfo().getIEncKeyGenerationInfo()) == 4 || iGene == 5) {
            rtn = true;
        }
        return rtn;
    }

    private SJctrRegularBackupKeysToServerAC createApplyController(SJctrUserController uc) {
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        SJkmsBackupInfo backupInfo = new SJkmsBackupInfo();
        String comment = SJctrRegularBackupKeysToServerSubWizard.createComment("RegularBackup_");
        backupInfo.setBackupComment(comment);
        ArrayList<SJkmsBackupInfo> commentList = new ArrayList<SJkmsBackupInfo>();
        commentList.add(backupInfo);
        dc.getProxy().putCache("COM_DESCRIPTION", commentList);
        backupInfo.setKmipModeFlg(this.isKMIPModeEnable(dc));
        if (uc.getAuthorizeContainer() != null) {
            backupInfo.setUserEnabled(true);
            backupInfo.setUserRole(SJctrEncryptionKeysUtility.isRegularBackupAuthEnabled(uc));
            SJctrLicenseContainer licenseContainer = uc.getAuthorizeContainer().getLisenceContainer();
            boolean lisence = licenseContainer.checkPP(SJctrLicenseContainer.PPID_ENCRYPTION);
            backupInfo.setBackupLisence(lisence);
        }
        String strNo = SJcProductUty.getSerialNumber();
        SJctrRegularBackupKeysToServerAC ac = new SJctrRegularBackupKeysToServerAC(strNo, backupInfo);
        return ac;
    }
}

