/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.addhosts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.column.SJctrAssignedHGNameColumnFromPortHGWwnTableKey;
import sanproject.sn2.controller.com.column.SJctrHostNameColumnFromPortHostGroupWwnTableKey;
import sanproject.sn2.controller.com.column.SJctrHostWwnColumnFromPortHostGroupWwnTableKey;
import sanproject.sn2.controller.com.column.SJctrNewHostColumnFromAddHostsTableKey;
import sanproject.sn2.controller.com.column.SJctrPortNameColumnFromAddHostsTableKey;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.lunm.addhosts.SJctrAddHostsDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrAddHostsTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrModelDataCheck;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortWwnInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;

public class SJctrAvailableHostsTableModel
extends SJctrTableDataModel {
    public static final String KEY_COL_PTNAME = "COM_COL_PTNAME";
    public static final String KEY_COL_HTNAME = "COM_COL_HTNAME";
    public static final String KEY_COL_HTWWN = "COM_COL_HTWWN";
    public static final String KEY_COL_HGNAME = "COM_COL_HGNAME";
    public static final String KEY_COL_HTNEW = "COM_COL_HTNEW";
    public static final String KEY_BUTTON_GROUP = "COM_BUTTON_GROUP";
    public static final String KEY_ADDNEWHOST = "COM_ADDNEWHOST";
    public static final int AVAILABLE_DEFAULT_SIZE = 100;
    private HashSet<String> usedWwn = new HashSet(100);
    private HashSet<String> usedNickname = new HashSet(100);

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        ArrayList<SJctrAddHostsTableKey> retList = new ArrayList<SJctrAddHostsTableKey>(100);
        ArrayList<SJmoWwn> availableWwnList = new ArrayList<SJmoWwn>(100);
        this.getUsedWwnData(this.usedWwn, this.usedNickname);
        this.collectPortHostGroupInfoWwn(this.usedWwn, this.usedNickname, retList, availableWwnList);
        this.collectLoginWwn(this.usedWwn, this.usedNickname, retList, availableWwnList);
        Collections.sort(retList);
        SJctrAddHostsDC dc = (SJctrAddHostsDC)this.getDataController();
        dc.availableWwnList = availableWwnList;
        return retList;
    }

    private void getUsedWwnData(HashSet<String> usedWwn, HashSet<String> usedNickname) {
        List<SJctrPortHostGroupTableKey> ctrPtHgIdx = this.getDataController().getProxy().getCache("KEY_CLASS_PORTHGINDEX");
        List<SJmoPortHostGroupInfo> mdlAllPtHg = this.getDataController().getProxy().getCache(SJctrAddHostsDC.KEY_CLASS_MPORTHG);
        SJctrModelDataCheck.getUsedWwnData(ctrPtHgIdx, mdlAllPtHg, usedWwn, usedNickname);
    }

    private void collectPortHostGroupInfoWwn(HashSet<String> usedWwn, HashSet<String> usedNickname, List<SJctrAddHostsTableKey> retList, List<SJmoWwn> availableWwnList) {
        List<?> mdlAllPtHg = this.getDataController().getProxy().getCache(SJctrAddHostsDC.KEY_CLASS_MPORTHG);
        if (mdlAllPtHg == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "collectPortHostGroupInfoWwn", "SJmoGetPortHostGroupInto Not Found in the Cache.");
            mdlAllPtHg = new ArrayList();
        }
        for (SJmoPortHostGroupInfo mdlPtHg : mdlAllPtHg) {
            for (SJmoHostGroupInfo mdlHg : mdlPtHg.getAlPortHostGroup()) {
                for (SJmoWwn mdlPtHgWwn : mdlHg.getAlHostGroupWwn()) {
                    String wwnStr = SJctrComUtility.toWWNDisplay(mdlPtHgWwn);
                    String nickName = mdlPtHgWwn.getStrWWNNickName();
                    if (usedWwn.contains(wwnStr) || usedNickname.contains(nickName)) continue;
                    SJctrAddHostsTableKey hostKey = new SJctrAddHostsTableKey(mdlPtHg, mdlHg, mdlPtHgWwn, false);
                    retList.add(hostKey);
                    availableWwnList.add(mdlPtHgWwn);
                }
            }
        }
    }

    private void collectLoginWwn(HashSet<String> usedWwn, HashSet<String> usedNickname, List<SJctrAddHostsTableKey> retList, List<SJmoWwn> availableWwnList) {
        HashSet<String> portWwnSet = new HashSet<String>(retList.size() * 4 / 3 + 1);
        for (SJctrAddHostsTableKey addHostsKey : retList) {
            String portWwnKey = this.makePortWwnString(addHostsKey);
            portWwnSet.add(portWwnKey);
        }
        List<?> mdlAllPtWwn = this.getDataController().getProxy().getCache(SJctrAddHostsDC.KEY_CLASS_MPORTWWN);
        if (mdlAllPtWwn == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "collectLoginWwn", "SJmoGetPortWwnInfo Not Found in the Cache.");
            mdlAllPtWwn = new ArrayList();
        }
        for (SJmoPortWwnInfo mdlPtWwn : mdlAllPtWwn) {
            for (SJmoWwn mdlLoginWwn : mdlPtWwn.getAlPortWwn()) {
                String wwnStr = SJctrComUtility.toWWNDisplay(mdlLoginWwn);
                String nickName = mdlLoginWwn.getStrWWNNickName();
                if (usedWwn.contains(wwnStr) || usedNickname.contains(nickName)) continue;
                short port = mdlPtWwn.getSPort();
                SJmoPortHostGroupInfo newPtHgInfo = new SJmoPortHostGroupInfo();
                newPtHgInfo.setSPort(port);
                SJmoHostGroupInfo newHgInfo = new SJmoHostGroupInfo();
                SJctrAddHostsTableKey hostKey = new SJctrAddHostsTableKey(newPtHgInfo, newHgInfo, mdlLoginWwn, false);
                String portWwnKey = this.makePortWwnString(hostKey);
                if (portWwnSet.contains(portWwnKey)) continue;
                retList.add(hostKey);
                availableWwnList.add(mdlLoginWwn);
            }
        }
    }

    private String makePortWwnString(SJctrAddHostsTableKey addHostsKey) {
        SJmoPortHostGroupInfo portHg = addHostsKey.getPortHostGroupInfo();
        SJmoWwn wwnInfo = addHostsKey.getWwnInfo();
        return SJctrComUtility.toPaddingZeroString(portHg.getSPort(), 5) + SJctrComUtility.toWWNDisplay(wwnInfo);
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        SJmoGetRange_IF ret = null;
        return ret;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrPortNameColumnFromAddHostsTableKey(KEY_COL_PTNAME));
        this.addColumn(new SJctrHostWwnColumnFromPortHostGroupWwnTableKey(KEY_COL_HTWWN));
        this.addColumn(new SJctrHostNameColumnFromPortHostGroupWwnTableKey(KEY_COL_HTNAME));
        this.addColumn(new SJctrAssignedHGNameColumnFromPortHGWwnTableKey(KEY_COL_HGNAME));
        this.addColumn(new SJctrNewHostColumnFromAddHostsTableKey(KEY_COL_HTNEW));
        SJctrSimpleDataModel buttonGroup = new SJctrSimpleDataModel();
        SJctrButtonDataModel detail = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        this.fireMessageEvent(SJctrAddHostsDC.NOTIFY_ADD_HOSTS.ADD_NEW_HOST);
                    }
                });
            }
        };
        buttonGroup.addDataModel(KEY_ADDNEWHOST, detail);
        this.addDataModel(KEY_BUTTON_GROUP, buttonGroup);
    }

    public HashSet<String> getUsedWwn() {
        return this.usedWwn;
    }

    public HashSet<String> getUsedNickname() {
        return this.usedNickname;
    }

    public void setUsedWwn(HashSet<String> usedWwn) {
        this.usedWwn = usedWwn;
    }

    public void setUsedNickName(HashSet<String> usedNickname) {
        this.usedNickname = usedNickname;
    }
}

