/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.lunm.com.SJctrAddHostsTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;

public class SJctrModelDataCheck {
    public static final String THIS_CLASS_NAME = "SJctrModelDataCheck";
    public static final int EC_CANNOT_ADD_SAME_WWN = 105022;
    public static final int EC_CANNOT_ADD_SAME_NICKNAME = 105023;

    private SJctrModelDataCheck() {
    }

    public static boolean checkEquipPortHG(List<SJctrPortHostGroupTableKey> targetList, List<SJmoPortHostGroupInfo> cacheList, List<SJctrPortHostGroupTableKey> replacePtHgList, List<SJctrError> errList) {
        boolean ret = true;
        if (cacheList == null) {
            SJctrLogUty.warn(THIS_CLASS_NAME, "checkEquipPortHG", "SJmoGetPortHostGroupInfo Not Found in the Cache.");
            return false;
        }
        for (int index = 0; index < targetList.size(); ++index) {
            SJctrPortHostGroupTableKey onePtHgKey = targetList.get(index);
            boolean includeInfo = false;
            int searchRet = Collections.binarySearch(cacheList, onePtHgKey.getPortHostGroupInfo());
            if (searchRet < 0) {
                ret = false;
                SJctrError errElement = errList.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(106501);
                SJctrLogUty.warn(THIS_CLASS_NAME, "checkEquipPortHG", "Not Found port#=" + onePtHgKey.getPortHostGroupInfo().getSPort());
                continue;
            }
            SJmoPortHostGroupInfo onePortHg = cacheList.get(searchRet);
            ArrayList hgList = onePortHg.getAlPortHostGroup();
            for (SJmoHostGroupInfo oneHg : hgList) {
                if (oneHg.getSHostGroup() != onePtHgKey.getHostGroupInfo().getSHostGroup()) continue;
                SJctrPortHostGroupTableKey newPortHgKey = new SJctrPortHostGroupTableKey(onePortHg, oneHg);
                replacePtHgList.add(newPortHgKey);
                includeInfo = true;
                break;
            }
            if (includeInfo) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(106502);
            SJctrLogUty.warn(THIS_CLASS_NAME, "checkEquipPortHG", "Port# = " + onePtHgKey.getPortHostGroupInfo().getSPort() + ", HostGroup # = " + onePtHgKey.getHostGroupInfo().getSHostGroup() + " Not Found.");
        }
        return ret;
    }

    public static boolean checkEquipPortIT(List<SJctrPortHostGroupTableKey> targetList, List<SJmoPortIscsiTargetInfo> cacheList, List<SJctrPortHostGroupTableKey> replacePtTarList, List<SJctrError> errList) {
        boolean ret = true;
        if (cacheList == null) {
            SJctrLogUty.warn(THIS_CLASS_NAME, "checkEquipPortIT", "SJmoPortIscsiTargetInfo Not Found in the Cache.");
            return false;
        }
        for (int index = 0; index < targetList.size(); ++index) {
            SJctrPortHostGroupTableKey onePtTarKey = targetList.get(index);
            boolean includeInfo = false;
            int searchRet = Collections.binarySearch(cacheList, onePtTarKey.getPortIscsiTargetInfo());
            if (searchRet < 0) {
                ret = false;
                SJctrError errElement = errList.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(106501);
                SJctrLogUty.warn(THIS_CLASS_NAME, "checkEquipPortIT", "Not Found port#=" + onePtTarKey.getPortIscsiTargetInfo().getSPort());
                continue;
            }
            SJmoPortIscsiTargetInfo onePortTar = cacheList.get(searchRet);
            ArrayList<SJmoIscsiTargetInfo> tarList = onePortTar.getAlPortIscsiTarget();
            for (SJmoIscsiTargetInfo oneTar : tarList) {
                if (oneTar.getSIscsiTarget() != onePtTarKey.getIscsiTargetInfo().getSIscsiTarget()) continue;
                SJctrPortHostGroupTableKey newPortHgKey = new SJctrPortHostGroupTableKey(onePortTar, oneTar);
                replacePtTarList.add(newPortHgKey);
                includeInfo = true;
                break;
            }
            if (includeInfo) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(206521);
            SJctrLogUty.warn(THIS_CLASS_NAME, "checkEquipPortIT", "Port# = " + onePtTarKey.getPortIscsiTargetInfo().getSPort() + ", iSCSI Target # = " + onePtTarKey.getIscsiTargetInfo().getSIscsiTarget() + " Not Found.");
        }
        return ret;
    }

    public static boolean checkPortAttribute(List<SJctrPortHostGroupTableKey> targetList, List<SJmoPortAttributeInfo> cacheList, List<SJctrError> errList) {
        boolean ret = true;
        if (cacheList == null) {
            SJctrLogUty.warn(THIS_CLASS_NAME, "checkPortAttribute", "SJmoGetPortAttributeInfo Not Found in the Cache.");
            return false;
        }
        for (int index = 0; index < targetList.size(); ++index) {
            SJctrPortHostGroupTableKey onePtHgKey = targetList.get(index);
            int searchRet = -1;
            int sPort = -1;
            if (onePtHgKey.isFibre()) {
                searchRet = Collections.binarySearch(cacheList, onePtHgKey.getPortHostGroupInfo());
                sPort = onePtHgKey.getPortHostGroupInfo().getSPort();
            } else {
                searchRet = Collections.binarySearch(cacheList, onePtHgKey.getPortIscsiTargetInfo());
                sPort = onePtHgKey.getPortIscsiTargetInfo().getSPort();
            }
            if (searchRet < 0) {
                SJctrLogUty.info(THIS_CLASS_NAME, "checkPortAttribute", "Skipped Port#= " + sPort);
                continue;
            }
            SJmoPortAttributeInfo onePortAttr = cacheList.get(searchRet);
            byte portKind = onePortAttr.getByPortKind();
            if (portKind == 3 || portKind == 4 || portKind == 9) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(105019);
            SJctrLogUty.warn(THIS_CLASS_NAME, "checkPortAttribute", "Port# = " + onePortAttr.getSPort() + ", Attribute = " + portKind);
        }
        return ret;
    }

    public static boolean checkContainsWwn(List<SJmoWwn> chkWwnList, List<String> blockWwnStrList, List<SJctrError> errList) {
        boolean ret = true;
        Collections.sort(blockWwnStrList);
        for (int index = 0; index < chkWwnList.size(); ++index) {
            SJmoWwn chkWwn = chkWwnList.get(index);
            String wwnStr = SJctrComUtility.toWWNDisplay(chkWwn);
            int objIndex = Collections.binarySearch(blockWwnStrList, wwnStr);
            if (objIndex < 0) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(105024);
            SJctrLogUty.warn(THIS_CLASS_NAME, "checkContainsWwn", "Conflict WWN = " + wwnStr);
        }
        return ret;
    }

    public static boolean checkContainsWwnNickname(List<SJmoWwn> chkWwnNicknameList, List<String> blockWwnNicknameList, List<SJctrError> errList) {
        boolean ret = true;
        Collections.sort(blockWwnNicknameList);
        for (int index = 0; index < chkWwnNicknameList.size(); ++index) {
            int objIndex;
            SJmoWwn chkWwn = chkWwnNicknameList.get(index);
            String wwnStr = chkWwn.getStrWWNNickName();
            if (wwnStr.length() == 0 || (objIndex = Collections.binarySearch(blockWwnNicknameList, wwnStr)) < 0) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(105025);
            SJctrLogUty.warn(THIS_CLASS_NAME, "checkContainsWwnNickname", "Conflict WWN-Nickname = " + wwnStr);
        }
        return ret;
    }

    public static boolean isSameHBAWWN(List<SJctrAddHostsTableKey> tableKey, List<SJctrError> errList) {
        boolean ret = false;
        HashSet<String> wwnSet = new HashSet<String>(tableKey.size() * 4 / 3 + 1);
        for (int index = 0; index < tableKey.size(); ++index) {
            SJctrAddHostsTableKey selectedAddHostsData = tableKey.get(index);
            SJmoWwn wwn = selectedAddHostsData.getWwnInfo();
            String wwnStr = SJctrComUtility.toWWNDisplay(wwn);
            if (wwnSet.contains(wwnStr)) {
                ret = true;
                SJctrError errElement = errList.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(105022);
                SJctrLogUty.warn(THIS_CLASS_NAME, "isSameHBAWWN", "Conflict WWN = " + wwnStr);
                continue;
            }
            wwnSet.add(wwnStr);
        }
        return ret;
    }

    public static boolean isSameNickname(List<SJctrAddHostsTableKey> tableKey, List<SJctrError> errList) {
        boolean ret = false;
        HashSet<String> nicknameSet = new HashSet<String>(tableKey.size() * 4 / 3 + 1);
        for (int index = 0; index < tableKey.size(); ++index) {
            SJctrAddHostsTableKey selectedAddHostsData = tableKey.get(index);
            SJmoWwn wwn = selectedAddHostsData.getWwnInfo();
            String nickname = wwn.getStrWWNNickName();
            if (nickname.length() == 0) continue;
            if (nicknameSet.contains(nickname)) {
                ret = true;
                SJctrError errElement = errList.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(105023);
                SJctrLogUty.warn(THIS_CLASS_NAME, "isSameNickname", "Conflict Nickname = " + nickname);
                continue;
            }
            nicknameSet.add(nickname);
        }
        return ret;
    }

    public static void getUsedWwnData(List<SJctrPortHostGroupTableKey> ctrPtHgIdx, List<SJmoPortHostGroupInfo> mdlAllPtHg, HashSet<String> usedWwn, HashSet<String> usedNickName) {
        if (ctrPtHgIdx == null) {
            SJctrLogUty.warn(THIS_CLASS_NAME, "getUsedWwnData", "Port-HostGroup-index Not Found in the Cache.");
            ctrPtHgIdx = new ArrayList<SJctrPortHostGroupTableKey>();
        }
        if (mdlAllPtHg == null) {
            SJctrLogUty.warn(THIS_CLASS_NAME, "getUsedWwnData", "SJmoGetPortHostGroupInto Not Found in the Cache.");
            mdlAllPtHg = new ArrayList<SJmoPortHostGroupInfo>();
        }
        for (SJctrPortHostGroupTableKey ctrCarryPtHg : ctrPtHgIdx) {
            int searchRet = Collections.binarySearch(mdlAllPtHg, ctrCarryPtHg.getPortHostGroupInfo());
            if (searchRet < 0) {
                SJctrLogUty.warn(THIS_CLASS_NAME, "getUsedWwnData", "Not Found port#=" + ctrCarryPtHg.getPortHostGroupInfo().getSPort());
                continue;
            }
            SJmoPortHostGroupInfo mdlAllHg = mdlAllPtHg.get(searchRet);
            for (SJmoHostGroupInfo mdlHg : mdlAllHg.getAlPortHostGroup()) {
                for (SJmoWwn ctrCarryWwn : mdlHg.getAlHostGroupWwn()) {
                    String wwnStr = SJctrComUtility.toWWNDisplay(ctrCarryWwn);
                    usedWwn.add(wwnStr);
                    if (ctrCarryWwn.getStrWWNNickName().length() == 0) continue;
                    usedNickName.add(ctrCarryWwn.getStrWWNNickName());
                }
            }
        }
    }

    public static void getUsedIscsiNameData(List<SJctrPortHostGroupTableKey> ctrPtItIdx, List<SJmoPortIscsiTargetInfo> mdlAllPtIt, HashSet<String> usedIscsiName, HashSet<String> usedNickName) {
        if (ctrPtItIdx == null) {
            SJctrLogUty.warn(THIS_CLASS_NAME, "getUsedIscsiNameData", "Port-IscsiTarget-index Not Found in the Cache.");
            ctrPtItIdx = new ArrayList<SJctrPortHostGroupTableKey>();
        }
        if (mdlAllPtIt == null) {
            SJctrLogUty.warn(THIS_CLASS_NAME, "getUsedIscsiNameData", "SJmoGetPortIscsiTargetInto Not Found in the Cache.");
            mdlAllPtIt = new ArrayList<SJmoPortIscsiTargetInfo>();
        }
        for (SJctrPortHostGroupTableKey ctrCarryPtHg : ctrPtItIdx) {
            SJmoIscsiTargetInfo mdlIt = ctrCarryPtHg.getIscsiTargetInfo();
            for (SJmoIscsiName ctrCarryIscsiName : mdlIt.getAlIscsiName()) {
                usedIscsiName.add(ctrCarryIscsiName.getStrIscsiName());
                if (ctrCarryIscsiName.getStrIscsiNickName().length() == 0) continue;
                usedNickName.add(ctrCarryIscsiName.getStrIscsiNickName());
            }
        }
    }

    public static boolean isSameHBAIscsiName(List<SJctrAddHostsTableKey> tableKey, List<SJctrError> errList) {
        boolean ret = false;
        HashSet<String> iscsiNameSet = new HashSet<String>(tableKey.size() * 4 / 3 + 1);
        for (int index = 0; index < tableKey.size(); ++index) {
            SJctrAddHostsTableKey selectedAddHostsData = tableKey.get(index);
            SJmoIscsiName iscsiName = selectedAddHostsData.getIscsiNameInfo();
            String iscsiNameStr = iscsiName.getStrIscsiName();
            if (iscsiNameSet.contains(iscsiNameStr)) {
                ret = true;
                SJctrError errElement = errList.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(205106);
                SJctrLogUty.warn(THIS_CLASS_NAME, "isSameHBAIscsiName", "Conflict IscsiName = " + iscsiNameStr);
                continue;
            }
            iscsiNameSet.add(iscsiNameStr);
        }
        return ret;
    }

    public static boolean isSameIscsiNickname(List<SJctrAddHostsTableKey> tableKey, List<SJctrError> errList) {
        boolean ret = false;
        HashSet<String> nicknameSet = new HashSet<String>(tableKey.size() * 4 / 3 + 1);
        for (int index = 0; index < tableKey.size(); ++index) {
            SJctrAddHostsTableKey selectedAddHostsData = tableKey.get(index);
            SJmoIscsiName iscsiName = selectedAddHostsData.getIscsiNameInfo();
            String iscsiNickname = iscsiName.getStrIscsiNickName();
            if (iscsiNickname.length() == 0) continue;
            if (nicknameSet.contains(iscsiNickname)) {
                ret = true;
                SJctrError errElement = errList.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(105023);
                SJctrLogUty.warn(THIS_CLASS_NAME, "isSameIscsiNickname", "Conflict Nickname = " + iscsiNickname);
                continue;
            }
            nicknameSet.add(iscsiNickname);
        }
        return ret;
    }

    public static boolean checkContainsIscsiName(List<SJmoIscsiName> chkIscsiNameList, List<String> blockIscsiNameStrList, List<SJctrError> errList) {
        boolean ret = true;
        Collections.sort(blockIscsiNameStrList);
        for (int index = 0; index < chkIscsiNameList.size(); ++index) {
            SJmoIscsiName chkIscsiName = chkIscsiNameList.get(index);
            String iscsiNameStr = chkIscsiName.getStrIscsiName();
            int objIndex = Collections.binarySearch(blockIscsiNameStrList, iscsiNameStr);
            if (objIndex < 0) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(205105);
            SJctrLogUty.warn(THIS_CLASS_NAME, "checkContainsIscsiName", "Conflict IscsiName = " + iscsiNameStr);
        }
        return ret;
    }

    public static boolean checkContainsIscsiNickname(List<SJmoIscsiName> chkIscsiNicknameList, List<String> blockIscsiNicknameList, List<SJctrError> errList) {
        boolean ret = true;
        Collections.sort(blockIscsiNicknameList);
        for (int index = 0; index < chkIscsiNicknameList.size(); ++index) {
            int objIndex;
            SJmoIscsiName chkIscsiName = chkIscsiNicknameList.get(index);
            String iscsiNameStr = chkIscsiName.getStrIscsiNickName();
            if (iscsiNameStr.length() == 0 || (objIndex = Collections.binarySearch(blockIscsiNicknameList, iscsiNameStr)) < 0) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(105025);
            SJctrLogUty.warn(THIS_CLASS_NAME, "checkContainsIscsiNickname", "Conflict IscsiNickname = " + iscsiNameStr);
        }
        return ret;
    }
}

