/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.comdialog;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.comdialog.SJctrIscsiNameRadioButtonGroupModel;
import sanproject.sn2.controller.wizard.lunm.edithostiscsi.SJctrHbaIscsiNameDataModel;
import sanproject.sn2.model.data.lu.SJmoIscsiName;

public class SJctrAddNewIscsiHostsDialogDC
extends SJctrDialogDataController {
    public static final String KEY_RADIO_ISCSINAME = "COM_HBA_ISCSI_RDO";
    private static String KEY_HBAISCSINAMEINF = "COM_HBAISCSIINF";
    public static final String KEY_TEXTBOX_HBA_ISCSI_NAME = "COM_HBA_ISCSI_NAME";
    public static final String KEY_TEXTBOX_HOSTNAME = "COM_HOSTNAME";
    public static final String GUIDKEY_HBA_ISCSI_IQN_MAX_CHAR = "ISCSI_IQN_SET_MAX_CHAR";
    public static final String GUIDKEY_HBA_ISCSI_EUI_MAX_CHAR = "ISCSI_EUI_SET_MAX_CHAR";
    public static final String GUIDKEY_ISCSI_HOST_NAME_MAX_CHAR = "DISP_ISCSI_HOST_NAME_MAX_CHAR";
    public static final String GUIDKEY_IQN = "IQN3";
    public static final String GUIDKEY_EUI = "EUI3";
    public static final String KEY_ISCSINAME_DIALOG_IN = "KEY_ISCSI_DIALOG_IN";
    public static final String KEY_ISCSINAME_DIALOG_OUT = "KEY_ISCSI_NAME_DIALOG_OUT";
    public static final String KEY_AVAILABLE_ISCSINAME = "KEY_AVAILABLE_ISCSI_NAME";
    public static final String KEY_BLOCK_ISCSINAMESTRING = "KEY_BLOCK_ISCSISTRING";
    public static final String KEY_BLOCK_NICKNAME = "KEY_BLOCK_NICKNAME";
    private static final int DISP_ID = 0x200A002;
    private static final String KEY_DISP_ID = "KEY_SEL_ISCSI_EXIT_DISP_ID";
    private static int ERR_CONFLICT_AVAILABLE_ISCSINAME = 105049;
    private static int ERR_CONFLICT_EXISTING_ISCSINAME = 205142;
    private static int ERR_CONFLICT_EXISTING_ISCSINICKNAME = 105051;

    public SJctrAddNewIscsiHostsDialogDC() throws SJcException {
        super(0x200A002);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_HBAISCSINAMEINF, new SJctrHbaIscsiNameDataModel());
        this.addDataObjectModel(KEY_TEXTBOX_HOSTNAME, new SJctrTextBoxDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_OKCANCEL));
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_MSG.ISCSINAME, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddNewIscsiHostsDialogDC.this.changeIscsiNameRadio(event, dstModel);
            }
        });
    }

    private void changeIscsiNameRadio(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrIscsiNameRadioButtonGroupModel rdoIscsiName = (SJctrIscsiNameRadioButtonGroupModel)this.getDataObjectModel(KEY_RADIO_ISCSINAME);
        SJctrTextBoxDataModel txtIscsiName = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TEXTBOX_HBA_ISCSI_NAME);
        txtIscsiName.setValue("");
        if (rdoIscsiName.isSelectedIqn()) {
            txtIscsiName.setLabel(this.getComUtility().getGuidance(GUIDKEY_HBA_ISCSI_IQN_MAX_CHAR));
        } else {
            txtIscsiName.setLabel(this.getComUtility().getGuidance(GUIDKEY_HBA_ISCSI_EUI_MAX_CHAR));
        }
        this.setDirtyAll();
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrTextBoxDataModel txtHostName = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TEXTBOX_HOSTNAME);
        txtHostName.setLabel(util.getGuidance("LUNM", GUIDKEY_ISCSI_HOST_NAME_MAX_CHAR));
    }

    @Override
    public boolean checkConstructData() {
        SJmoIscsiName targetIscsiName;
        boolean ret = true;
        SJctrHbaIscsiNameDataModel hbaIscsiNameDataModel = (SJctrHbaIscsiNameDataModel)this.getDataObjectModel(KEY_HBAISCSINAMEINF);
        List<SJmoIscsiName> targetList = this.getCache(KEY_ISCSINAME_DIALOG_IN);
        if (targetList == null || targetList.size() == 0) {
            hbaIscsiNameDataModel.setSelectRadioIqn();
            return ret;
        }
        if (this.isAllSameHBAIscsiName(targetList)) {
            SJctrComUtility comUtil = this.getComUtility();
            targetIscsiName = targetList.get(0);
            StringBuffer strIscsiName = new StringBuffer(targetIscsiName.getStrIscsiName());
            String strIscsiNameHead = strIscsiName.substring(0, 4);
            strIscsiName.delete(0, 4);
            if (strIscsiNameHead.equals(comUtil.getGuidance(GUIDKEY_IQN))) {
                hbaIscsiNameDataModel.setSelectRadioIqn();
                hbaIscsiNameDataModel.setTextboxValue(strIscsiName.toString());
            } else if (strIscsiNameHead.equals(comUtil.getGuidance(GUIDKEY_EUI))) {
                hbaIscsiNameDataModel.setSelectRadioEui();
                hbaIscsiNameDataModel.setTextboxValue(strIscsiName.toString());
            }
        }
        if (this.isAllSameHostName(targetList)) {
            SJctrTextBoxDataModel hostName = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TEXTBOX_HOSTNAME);
            targetIscsiName = targetList.get(0);
            hostName.setValue(targetIscsiName.getStrIscsiNickName());
        }
        return ret;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        SJctrError headErr = new SJctrError(0, 0, 0);
        SJmoIscsiName retIscsiName = new SJmoIscsiName();
        SJctrHbaIscsiNameDataModel hbaIscsiNameDataModel = (SJctrHbaIscsiNameDataModel)this.getDataObjectModel(KEY_HBAISCSINAMEINF);
        SJctrTextBoxDataModel txtHostName = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_TEXTBOX_HOSTNAME);
        String strIscsiName = hbaIscsiNameDataModel.getTextboxValue();
        String strTargetIscsiName = "";
        String strHostName = txtHostName.getValue();
        String strRdoSelected = "";
        if (hbaIscsiNameDataModel.isSelectedIqn()) {
            strRdoSelected = this.getComUtility().getGuidance(GUIDKEY_IQN);
            strTargetIscsiName = strIscsiName.toLowerCase();
        } else if (hbaIscsiNameDataModel.isSelectedEui()) {
            strRdoSelected = this.getComUtility().getGuidance(GUIDKEY_EUI);
            strTargetIscsiName = strIscsiName.toUpperCase();
        } else {
            ret = false;
        }
        retIscsiName.setStrIscsiName(strRdoSelected + strTargetIscsiName);
        retIscsiName.setStrIscsiNickName(strHostName);
        if (ret) {
            ret = this.checkSameIscsiName(retIscsiName, headErr);
        }
        if (ret) {
            ret = this.checkExistingIscsiName(retIscsiName, headErr);
        }
        if (ret) {
            ret = this.checkExistingIscsiNickName(retIscsiName, headErr);
        }
        if (!ret) {
            SJcException exp = headErr.createException();
            throw exp;
        }
        ArrayList<SJmoIscsiName> outList = new ArrayList<SJmoIscsiName>();
        outList.add(retIscsiName);
        this.putCache(KEY_ISCSINAME_DIALOG_OUT, outList);
        ArrayList<Integer> dispIdList = new ArrayList<Integer>();
        dispIdList.add(0x200A002);
        this.putCache(KEY_DISP_ID, dispIdList);
        return ret;
    }

    private boolean isAllSameHBAIscsiName(List<SJmoIscsiName> targetList) {
        boolean ret = true;
        SJmoIscsiName base = targetList.get(0);
        String baseStr = base.getStrIscsiName();
        for (SJmoIscsiName check : targetList) {
            String chkStr = check.getStrIscsiName();
            if (baseStr.equals(chkStr)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private boolean isAllSameHostName(List<SJmoIscsiName> targetList) {
        boolean ret = true;
        SJmoIscsiName base = targetList.get(0);
        String baseStr = base.getStrIscsiNickName();
        for (SJmoIscsiName check : targetList) {
            String chkStr = check.getStrIscsiNickName();
            if (baseStr.equals(chkStr)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private boolean checkSameIscsiName(SJmoIscsiName iscsiName, SJctrError err) {
        boolean ret = true;
        String strIscsiName = iscsiName.getStrIscsiName();
        String strNickName = iscsiName.getStrIscsiNickName();
        List<?> blockIscsiNameList = this.getCache(KEY_AVAILABLE_ISCSINAME);
        if (blockIscsiNameList == null) {
            blockIscsiNameList = new ArrayList();
        }
        for (SJmoIscsiName blockIscsiName : blockIscsiNameList) {
            String chkIscsiName = blockIscsiName.getStrIscsiName();
            String chkNickName = blockIscsiName.getStrIscsiNickName();
            if (!chkIscsiName.equals(strIscsiName) || !chkNickName.equals(strNickName)) continue;
            ret = false;
            err.setFunc(10);
            err.setModule(22);
            err.setError(ERR_CONFLICT_AVAILABLE_ISCSINAME);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkSameIscsiName", "Conflict IscsiName = (iSCSI Name:" + strIscsiName + ") (iSCSI Nickname:" + strNickName + ")");
            break;
        }
        return ret;
    }

    private boolean checkExistingIscsiName(SJmoIscsiName retIscsiName, SJctrError err) {
        String retIscsiNameStr;
        boolean ret = true;
        List<?> blockIscsiNameList = this.getCache(KEY_BLOCK_ISCSINAMESTRING);
        if (blockIscsiNameList == null) {
            blockIscsiNameList = new ArrayList();
        }
        if (blockIscsiNameList.contains(retIscsiNameStr = retIscsiName.getStrIscsiName())) {
            ret = false;
            err.setFunc(10);
            err.setModule(22);
            err.setError(ERR_CONFLICT_EXISTING_ISCSINAME);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkExistingIscsiName", "Conflict IscsiName = " + retIscsiNameStr);
        }
        return ret;
    }

    private boolean checkExistingIscsiNickName(SJmoIscsiName retIscsiName, SJctrError err) {
        boolean ret = true;
        String chkNickName = retIscsiName.getStrIscsiNickName();
        if (chkNickName.length() == 0) {
            return true;
        }
        List<?> blockNickname = this.getCache(KEY_BLOCK_NICKNAME);
        if (blockNickname == null) {
            blockNickname = new ArrayList();
        }
        if (blockNickname.contains(chkNickName)) {
            ret = false;
            err.setFunc(10);
            err.setModule(22);
            err.setError(ERR_CONFLICT_EXISTING_ISCSINICKNAME);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkExistingIscsiNickName", "Conflict IscsiName-Nickname = " + chkNickName);
        }
        return ret;
    }

    public static enum SELECT_MSG implements SJctrNotifyState
    {
        ISCSINAME;

    }
}

