/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.edithgs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertyDC;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertySelectData;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrConfirmTableModel;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrEditHGConfirmData;
import sanproject.sn2.model.data.device.SJmoPortDetail;

public class SJctrEditHGConfirmDC
extends SJctrConfirmDataController {
    protected static final int DISP_ID = 0x110001F;
    public static final int EC_NOT_SELECT_DETAIL_DATA = 105040;
    public static final int EC_TOO_MANY_SELECT_DETAIL_DATA = 105041;
    public static final int EC_DETAIL_MODEL_NOT_FOUND = 107004;
    public static final String KEY_TABLE = "COM_TABLE";

    public SJctrEditHGConfirmDC() throws SJcException {
        super(0x110001F);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, new SJctrConfirmTableModel());
    }

    private void initListener() {
        this.addMessageEventListener(NOTIFY_EDIT_HG_CONFIRM.DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel targetTable = (SJctrTableDataModel)SJctrEditHGConfirmDC.this.getDataObjectModel(SJctrEditHGConfirmDC.KEY_TABLE);
                List<Object> selectedRows = targetTable.getSelectedRowData();
                if (selectedRows.size() == 0) {
                    SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "Port isn't selected.");
                    SJctrError err = new SJctrError(10, 22, 105040);
                    SJcException exp = err.createException();
                    throw exp;
                }
                if (selectedRows.size() > 1) {
                    SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "too many Port is selected. Num = " + selectedRows.size());
                    SJctrError err = new SJctrError(10, 22, 105041);
                    SJcException exp = err.createException();
                    throw exp;
                }
                List<?> confirmDataList = SJctrEditHGConfirmDC.this.getCache("SJctrEditHGConfirmData");
                if (confirmDataList == null || confirmDataList.size() == 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "confirmDataList Not Found.");
                    SJctrError err = new SJctrError(10, 22, 107004);
                    SJcException exp = err.createException();
                    throw exp;
                }
                SJctrEditHGConfirmData confirmData = (SJctrEditHGConfirmData)confirmDataList.get(0);
                List<SJmoPortDetail> ptDtList = confirmData.getPortDetailList();
                if (ptDtList == null || ptDtList.size() == 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "PortDetailList Not Found.");
                    SJctrError err = new SJctrError(10, 22, 107004);
                    SJcException exp = err.createException();
                    throw exp;
                }
                SJctrPortHostGroupTableKey selectPtHg = (SJctrPortHostGroupTableKey)selectedRows.get(0);
                int index = Collections.binarySearch(ptDtList, selectPtHg.getPortHostGroupInfo());
                if (index < 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "Port# Not Found in SJmoPortDetail Class.");
                    SJctrError err = new SJctrError(10, 22, 107004);
                    SJcException exp = err.createException();
                    throw exp;
                }
                SJctrHGPropertySelectData dialogData = new SJctrHGPropertySelectData();
                dialogData.setData(ptDtList.get(index), selectPtHg.getHostGroupInfo());
                ArrayList<SJctrHGPropertySelectData> dialogList = new ArrayList<SJctrHGPropertySelectData>();
                dialogList.add(dialogData);
                HashMap map = new HashMap();
                map.put("HG_PROPERTY_SELECT_DATA", dialogList);
                if (confirmData.getPortAttributeList() != null) {
                    map.put("CONFIRM_PORTATTR", confirmData.getPortAttributeList());
                } else {
                    map.put("CONFIRM_PORTATTR", new ArrayList());
                }
                if (confirmData.getAllRsgList() != null) {
                    map.put("CONFIRM_RSG", confirmData.getAllRsgList());
                } else {
                    map.put("CONFIRM_RSG", new ArrayList());
                }
                SJctrRelatedDispDataObject relatedObj = SJctrEditHGConfirmDC.this.createDialog(SJctrHGPropertyDC.class, map);
                SJctrEditHGConfirmDC.this.addUpdateDisp(relatedObj);
            }
        });
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap map = new HashMap();
        List<?> confirmDataList = this.getCache("SJctrEditHGConfirmData");
        map.put("SJctrEditHGConfirmData", confirmDataList);
        return map;
    }

    public static enum NOTIFY_EDIT_HG_CONFIRM implements SJctrNotifyState
    {
        DETAIL;

    }
}

