/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.edithgs;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import sanproject.common.Robj_interface_DKCgetSystemOption;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrHostModeOptionNameColumnFromHostModeOptionTableKey;
import sanproject.sn2.controller.com.column.SJctrHostModeOptionNumberColumnFromHostModeOptionTableKey;
import sanproject.sn2.controller.com.column.SJctrHostModeOptionSetFromHostModeOptionTableKey;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.base.SJctrGetSystemOption;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrHostModeOptionTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public class SJctrHostModeOptTableModel
extends SJctrTableDataModel {
    public static final String KEY_COL_HMONO = "COM_COL_HMONO";
    public static final String KEY_COL_HMONAME = "COM_COL_HMONAME";
    @Deprecated
    public static final String KEY_COL_HMOENABLE = "COM_COL_HMOENABLE";
    public static final String KEY_COL_HMOSTATE = "COM_COL_HMOSTATE";
    public static final String KEY_SEL_CHKBOX = "COM_SEL_CHKBOX";
    public static final String KEY_BUTTON_GROUP = "COM_BUTTON_GROUP";
    public static final String KEY_ENABLE = "COM_ENABLE";
    public static final String KEY_DISABLE = "COM_DISABLE";
    public static final String HOST_MODE_OPTION_RESERVE = "Reserved";
    private BitSet btOption = new BitSet(128);
    private BitSet btAllOrOption = new BitSet(128);
    public static int HGOPT_ERR1 = 109201;
    public static int HGOPT_ERR2 = 109202;
    public static int HGOPT_ERR_OPT_ENABLE = 105422;
    private boolean initiatorFlg;
    byte mHostmode;

    public SJctrHostModeOptTableModel() {
        this.initListener();
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        return null;
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        Map<Class<?>, List<?>> map = this.getBasicDataMap();
        ArrayList<SJctrHostModeOptionTableKey> ret = new ArrayList<SJctrHostModeOptionTableKey>(128);
        boolean sysoptflg = this.getSystemOption();
        for (int optionNo = 0; optionNo < 128; ++optionNo) {
            int status = this.getHostModeOptionStatus(optionNo);
            SJctrHostModeOptionTableKey optionInfo = new SJctrHostModeOptionTableKey(optionNo, status);
            SJctrPortUtility util = this.getComUtility().getPortUtility();
            String optName = util.toExplanationDisplay(optionNo);
            if (!sysoptflg && optName.equals(HOST_MODE_OPTION_RESERVE) && optionInfo.getIOptionStatus() == 0 || this.initiatorFlg && !SJctrPortUtility.ROUND_TRIP_HOST_MODE_OPT.contains(optionNo) && optionInfo.getIOptionStatus() == 0) continue;
            ret.add(optionInfo);
        }
        return ret;
    }

    protected boolean getSystemOption() {
        SJctrWizardDataController dc = (SJctrWizardDataController)this.getDataController();
        List<?> optList = dc.getCache(SJctrGetSystemOption.class);
        boolean sysoptflg = false;
        if (optList != null && optList.size() > 0) {
            Robj_interface_DKCgetSystemOption[] sysOptList;
            SJmoThroughRmiData rmiData = (SJmoThroughRmiData)optList.get(0);
            for (Robj_interface_DKCgetSystemOption sysopt : sysOptList = (Robj_interface_DKCgetSystemOption[])rmiData.getObjRmi()) {
                int clpr = sysopt.getNCLPR();
                if (clpr != -1) continue;
                sysoptflg = sysopt.isEnable(847);
            }
        }
        return sysoptflg;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrHostModeOptionNumberColumnFromHostModeOptionTableKey(KEY_COL_HMONO));
        this.addColumn(new SJctrHostModeOptionNameColumnFromHostModeOptionTableKey(KEY_COL_HMONAME));
        this.addColumn(new SJctrHostModeOptionSetFromHostModeOptionTableKey(KEY_COL_HMOSTATE));
        SJctrSimpleDataModel buttonGroup = new SJctrSimpleDataModel();
        SJctrButtonDataModel button = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
            }
        };
        buttonGroup.addDataModel(KEY_ENABLE, button);
        button = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
            }
        };
        buttonGroup.addDataModel(KEY_DISABLE, button);
        this.addDataModel(KEY_BUTTON_GROUP, buttonGroup);
        this.setPrimaryColumn(KEY_COL_HMONO);
        this.setPrimaryClass(SJctrHostModeOptionTableKey.class);
    }

    private void initListener() {
        this.addMessageEventListener(NOTIFY_HMO_TBL.CHANGE_COMBO_BOX, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostModeOptTableModel.this.mHostmode = (Byte)event.getNofifyObject();
                SJctrHostModeOptTableModel.this.btOption.clear();
                SJctrHostModeOptTableModel.this.btAllOrOption.clear();
                SJctrHostModeOptTableModel.this.refreshTargetBasicDataList(SJctrHostModeOptTableModel.this.getAllRowData());
            }
        });
        SJctrDataObjectModel<SJctrDataObject> buttonGroup = this.getDataModel(KEY_BUTTON_GROUP);
        SJctrButtonDataModel enableButton = (SJctrButtonDataModel)buttonGroup.getDataModel(KEY_ENABLE);
        enableButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                List<Object> selectedRow;
                List<Object> hostModeOptKeyList = selectedRow = SJctrHostModeOptTableModel.this.getSelectedRowData();
                SJctrHostModeOptTableModel.this.showHMOptMsg(hostModeOptKeyList, 1);
                BitSet targetBitSet = SJctrHostModeOptTableModel.this.getSelectedRowBitSet(hostModeOptKeyList);
                if (SJctrHostModeOptTableModel.this.initiatorFlg) {
                    int optNo = targetBitSet.nextSetBit(0);
                    while (optNo >= 0) {
                        if (!SJctrPortUtility.ROUND_TRIP_HOST_MODE_OPT.contains(optNo)) {
                            SJctrError err = new SJctrError(10, 22, HGOPT_ERR_OPT_ENABLE);
                            SJcException exp = err.createException();
                            throw exp;
                        }
                        optNo = targetBitSet.nextSetBit(optNo + 1);
                    }
                }
                SJctrHostModeOptTableModel.this.btOption.or(targetBitSet);
                SJctrHostModeOptTableModel.this.refreshTargetBasicDataList(hostModeOptKeyList);
                SJctrHostModeOptTableModel.this.fireMessageEvent(NOTIFY_HMO_TBL.ENABLE);
            }
        });
        SJctrButtonDataModel disableButton = (SJctrButtonDataModel)buttonGroup.getDataModel(KEY_DISABLE);
        disableButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                List<Object> selectedRow;
                List<Object> hostModeOptKeyList = selectedRow = SJctrHostModeOptTableModel.this.getSelectedRowData();
                SJctrHostModeOptTableModel.this.showHMOptMsg(hostModeOptKeyList, 0);
                BitSet targetBitSet = SJctrHostModeOptTableModel.this.getSelectedRowBitSet(hostModeOptKeyList);
                SJctrHostModeOptTableModel.this.btOption.andNot(targetBitSet);
                SJctrHostModeOptTableModel.this.btAllOrOption.andNot(targetBitSet);
                SJctrHostModeOptTableModel.this.refreshTargetBasicDataList(hostModeOptKeyList);
                SJctrHostModeOptTableModel.this.fireMessageEvent(NOTIFY_HMO_TBL.DISABLE);
            }
        });
    }

    private BitSet getSelectedRowBitSet(List<SJctrHostModeOptionTableKey> hostModeOptKeyList) {
        BitSet retBitSet = new BitSet();
        for (SJctrHostModeOptionTableKey hostModeOptKey : hostModeOptKeyList) {
            int optionNo = hostModeOptKey.getSOptionNo();
            retBitSet.set(optionNo);
        }
        return retBitSet;
    }

    private void refreshTargetBasicDataList(List<SJctrHostModeOptionTableKey> hostModeOptKeyList) {
        for (SJctrHostModeOptionTableKey hostModeOptKey : hostModeOptKeyList) {
            int status = this.getHostModeOptionStatus(hostModeOptKey.getSOptionNo());
            hostModeOptKey.setIOptionStatus(status);
        }
        this.doRefresh(KEY_COL_HMOSTATE);
    }

    protected int getHostModeOptionStatus(int optionNo) {
        boolean andFlg = this.btOption.get(optionNo);
        if (andFlg) {
            return 1;
        }
        boolean mixFlg = this.btAllOrOption.get(optionNo);
        if (mixFlg) {
            return 2;
        }
        return 0;
    }

    public final void initBitSet(List<SJctrPortHostGroupTableKey> keyList) {
        this.btOption.set(0, 128);
        this.btAllOrOption.clear();
        for (SJctrPortHostGroupTableKey hgKey : keyList) {
            BitSet hgBitSet = hgKey.getHostGroupInfo().getBtOption();
            this.btOption.and(hgBitSet);
            this.btAllOrOption.or(hgBitSet);
        }
    }

    public BitSet getIndefiniteBitSet() {
        BitSet retBitSet = (BitSet)this.btOption.clone();
        retBitSet.flip(0, 128);
        retBitSet.and(this.btAllOrOption);
        return retBitSet;
    }

    public BitSet getBtOption() {
        return this.btOption;
    }

    public void setBtOption(BitSet btOption) {
        this.btOption = btOption;
    }

    public void showHMOptMsg(List<SJctrHostModeOptionTableKey> hostModeOptKeyList, int nowOptStatus) {
        if (this.mHostmode != 5) {
            return;
        }
        boolean msgFlg = false;
        for (SJctrHostModeOptionTableKey key : hostModeOptKeyList) {
            if (key.getSOptionNo() != 33 || key.getIOptionStatus() == nowOptStatus) continue;
            msgFlg = true;
            break;
        }
        if (msgFlg) {
            int msgCode = 0;
            msgCode = nowOptStatus == 0 ? HGOPT_ERR1 : HGOPT_ERR2;
            String strFuncID = Integer.toString(10);
            String strModuleID = Integer.toString(22);
            String strMsgID = Integer.toString(msgCode);
            SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
            SJctrDataController dc = this.getDataController();
            SJctrRelatedDispDataObject related = dc.createMsgDialog(msg);
            dc.addUpdateDisp(related);
        }
    }

    public boolean isInitiatorFlg() {
        return this.initiatorFlg;
    }

    public void setInitiatorFlg(boolean initiatorFlg) {
        this.initiatorFlg = initiatorFlg;
    }

    public static enum NOTIFY_HMO_TBL implements SJctrNotifyState
    {
        CHANGE_COMBO_BOX,
        ENABLE,
        DISABLE;

    }
}

