/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.edithostiscsi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrIscsiNameComparator;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.edithost.SJctrHostNameDataModel;
import sanproject.sn2.controller.wizard.lunm.edithostiscsi.SJctrEditHostIscsiData;
import sanproject.sn2.controller.wizard.lunm.edithostiscsi.SJctrEditHostIscsiSelectData;
import sanproject.sn2.controller.wizard.lunm.edithostiscsi.SJctrHbaIscsiNameDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrEditHostIscsiDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1100171;
    private static String KEY_HBAISCSINAMEINF = "COM_HBAISCSIINF";
    private static String KEY_HOSTNAMEINF = "COM_HOSTNAMEINF";
    private static String KEY_ALLCHG_ISCSINAME = "COM_ALLCHG_WWN";
    private static String KEY_CHKBOX_ALLCHG_ISCSINAME = "DISP_APPLY_SAME_SETTINGS_HBA_ISCSI_NAME";
    public static final String GUIDKEY_IQN = "IQN3";
    public static final String GUIDKEY_EUI = "EUI3";
    private static String TITLE = "DISP_DI12S_TITLE";
    List<SJmoPortIscsiTargetInfo> targetPortItInfoList;
    SJctrHbaIscsiNameDataModel hbaIscsiNameDataModel;
    SJctrHostNameDataModel hostNameDataModel;
    static final SJctrIscsiNameComparator iscsiNameComparator = new SJctrIscsiNameComparator();
    public static int EDITHOST_ERR_CACHEDATA_INVALID = 107003;
    public static int EDITHOST_ERR_PORT_NOT_FOUND = 106501;
    public static int EDITHOST_ERR_HOST_NOT_FOUND = 106510;
    public static int EDITHOST_ERR_ISCSINAME_ALREADY_EXISTS = 205142;
    public static int EDITHOST_ERR_ISCSINICKNAME_ALREADY_EXISTS = 105076;
    public static int EDITHOST_ERR_ISCSITARGET_UNAVAILABLE_LV4 = 105297;
    public static int EDITHOST_ERR_ISCSITARGET_UNAVAILABLE_LV7 = 205145;
    public static int EDITHOST_ERR_PORT_ATTR = 105019;

    public SJctrEditHostIscsiDC() throws SJcException {
        super(0x1100171);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_HBAISCSINAMEINF, new SJctrHbaIscsiNameDataModel());
        this.addDataObjectModel(KEY_HOSTNAMEINF, new SJctrHostNameDataModel(false));
        this.addDataObjectModel(KEY_ALLCHG_ISCSINAME, new SJctrCheckBoxDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrCheckBoxDataModel checkBox = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLCHG_ISCSINAME);
        checkBox.setLabel(util.getGuidance("LUNM", KEY_CHKBOX_ALLCHG_ISCSINAME));
    }

    @Override
    public boolean checkStartData() {
        List<?> dat = this.getCache(SJctrEditHostIscsiSelectData.class);
        if (dat == null || dat.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_CACHEDATA_INVALID);
            SJcException exp = err.createException();
            throw exp;
        }
        Object selectObj = dat.get(0);
        if (!(selectObj instanceof SJctrEditHostIscsiSelectData)) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_CACHEDATA_INVALID);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrEditHostIscsiSelectData selectData = (SJctrEditHostIscsiSelectData)selectObj;
        SJmoPortIscsiTargetInfo portIscsiTarget = selectData.getPortIscsiTrargetInfo();
        if (portIscsiTarget == null) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_CACHEDATA_INVALID);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = portIscsiTarget.getAlPortIscsiTarget();
        if (iscsiTargetList == null || iscsiTargetList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_CACHEDATA_INVALID);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<SJmoIscsiName> iscsiNameList = iscsiTargetList.get(0).getAlIscsiName();
        if (iscsiNameList == null || iscsiNameList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_CACHEDATA_INVALID);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        List<?> dat = this.getCache(SJctrEditHostIscsiSelectData.class);
        SJctrEditHostIscsiSelectData selectData = (SJctrEditHostIscsiSelectData)dat.get(0);
        SJmoPortIscsiTargetInfo selectPortItInfo = selectData.getPortIscsiTrargetInfo();
        ArrayList<SJmoIscsiTargetInfo> selectItInfoList = selectPortItInfo.getAlPortIscsiTarget();
        ArrayList<SJmoIscsiName> selectIscsiNameList = selectItInfoList.get(0).getAlIscsiName();
        SJmoIscsiTargetInfo selectItInfo = selectItInfoList.get(0);
        SJmoIscsiName selectIscsiName = selectIscsiNameList.get(0);
        List<?> modelPortDetailList = this.getCache(SJmoGetPortDetail.class);
        int portDetailIndex = Collections.binarySearch(modelPortDetailList, selectPortItInfo);
        if (portDetailIndex < 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_PORT_NOT_FOUND);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> modelPortAttrList = this.getCache(SJmoGetPortAttributeInfo.class);
        int portAttrIndex = Collections.binarySearch(modelPortAttrList, selectPortItInfo);
        if (portAttrIndex < 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_PORT_NOT_FOUND);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortAttributeInfo selectPortAttr = (SJmoPortAttributeInfo)modelPortAttrList.get(portAttrIndex);
        byte portKind = selectPortAttr.getByPortKind();
        if (portKind == 5 || portKind == 6) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_PORT_ATTR);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_CACHEDATA_INVALID);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex itIndex = new SJmoHostGroupIndex();
        itIndex.setSPort(selectPortItInfo.getSPort());
        itIndex.setSHostGroup(selectItInfo.getSIscsiTarget());
        boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(itIndex, rsgUtil);
        if (!rsgFlg) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_ISCSITARGET_UNAVAILABLE_LV4);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> modelPortItInfoList = this.getCache(SJmoGetPortIscsiTargetInfo.class);
        Collections.sort(modelPortItInfoList);
        int portItInfoIndex = Collections.binarySearch(modelPortItInfoList, selectPortItInfo);
        if (portItInfoIndex < 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_PORT_NOT_FOUND);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortIscsiTargetInfo modelPortItInfo = (SJmoPortIscsiTargetInfo)modelPortItInfoList.get(portItInfoIndex);
        ArrayList<SJmoIscsiTargetInfo> modelItInfoList = modelPortItInfo.getAlPortIscsiTarget();
        boolean result = false;
        for (SJmoIscsiTargetInfo modelItInfo : modelItInfoList) {
            if (modelItInfo.getSIscsiTarget() != selectItInfo.getSIscsiTarget()) continue;
            ArrayList<SJmoIscsiName> modelIscsiNameList = modelItInfo.getAlIscsiName();
            for (SJmoIscsiName modelIscsiName : modelIscsiNameList) {
                if (0 != iscsiNameComparator.compare(modelIscsiName, selectIscsiName)) continue;
                ArrayList<SJmoIscsiName> setIscsiNameList = new ArrayList<SJmoIscsiName>();
                setIscsiNameList.add(selectIscsiName);
                SJmoIscsiTargetInfo setItInfo = new SJmoIscsiTargetInfo();
                setItInfo.setAlIscsiName(setIscsiNameList);
                ArrayList<SJmoIscsiTargetInfo> setItInfoList = new ArrayList<SJmoIscsiTargetInfo>();
                setItInfo.setBtOption(selectItInfo.getBtOption());
                setItInfo.setIHostMode(selectItInfo.getIHostMode());
                setItInfo.setSIscsiTarget(selectItInfo.getSIscsiTarget());
                setItInfo.setStrIscsiTargetName(selectItInfo.getStrIscsiTargetName());
                setItInfo.setIHostMode(selectItInfo.getIHostMode());
                setItInfoList.add(setItInfo);
                SJmoPortIscsiTargetInfo setPortItInfo = new SJmoPortIscsiTargetInfo();
                setPortItInfo.setSPort(selectPortItInfo.getSPort());
                setPortItInfo.setAlPortIscsiTarget(setItInfoList);
                if (this.targetPortItInfoList == null) {
                    this.targetPortItInfoList = new ArrayList<SJmoPortIscsiTargetInfo>();
                }
                this.targetPortItInfoList.add(setPortItInfo);
                result = true;
                break;
            }
            if (!result) continue;
            break;
        }
        if (!result) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_HOST_NOT_FOUND);
            SJcException exp = err.createException();
            throw exp;
        }
        this.hbaIscsiNameDataModel = (SJctrHbaIscsiNameDataModel)this.getDataObjectModel(KEY_HBAISCSINAMEINF);
        this.hostNameDataModel = (SJctrHostNameDataModel)this.getDataObjectModel(KEY_HOSTNAMEINF);
        SJctrTextBoxDataModel hostNameTextBox = (SJctrTextBoxDataModel)this.hostNameDataModel.getDataModel("COM_HOSTNAME");
        SJctrComUtility comUtil = this.getComUtility();
        String iscsiNameValue = selectIscsiName.getStrIscsiName();
        String strIscsiNameHead = iscsiNameValue.substring(0, 4);
        if (strIscsiNameHead.equals(comUtil.getGuidance(GUIDKEY_IQN)) || strIscsiNameHead.equals(comUtil.getGuidance(GUIDKEY_EUI))) {
            iscsiNameValue = iscsiNameValue.substring(4);
        }
        this.hbaIscsiNameDataModel.setTextboxValue(iscsiNameValue);
        if (strIscsiNameHead.equals(comUtil.getGuidance(GUIDKEY_IQN))) {
            this.hbaIscsiNameDataModel.setSelectRadioIqn();
        } else if (strIscsiNameHead.equals(comUtil.getGuidance(GUIDKEY_EUI))) {
            this.hbaIscsiNameDataModel.setSelectRadioEui();
        }
        String hostNameValue = selectIscsiName.getStrIscsiNickName();
        hostNameTextBox.setValue(hostNameValue);
        SJctrCheckBoxDataModel sameSettingDataModel = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLCHG_ISCSINAME);
        sameSettingDataModel.setSelect(true);
        return true;
    }

    @Override
    public boolean checkEndData() {
        ArrayList<SJmoIscsiName> alIscsiTargetIscsiName;
        ArrayList<SJmoIscsiTargetInfo> modelItInfoList;
        SJmoPortIscsiTargetInfo modelPortItInfo;
        SJctrCheckBoxDataModel sameSettingDataModel = (SJctrCheckBoxDataModel)this.getDataObjectModel(KEY_ALLCHG_ISCSINAME);
        SJctrCheckBoxDataModel hostNameCheckBox = (SJctrCheckBoxDataModel)this.hostNameDataModel.getDataModel("COM_CHECKBOX");
        SJctrTextBoxDataModel hostNameTextBox = (SJctrTextBoxDataModel)this.hostNameDataModel.getDataModel("COM_HOSTNAME");
        if (!this.hbaIscsiNameDataModel.isSelectCheckBox() && !hostNameCheckBox.isSelect()) {
            return false;
        }
        ArrayList<SJmoPortDetail> confirmPortDetailList = new ArrayList<SJmoPortDetail>();
        ArrayList<SJmoPortIscsiTargetInfo> confirmBeforePortItInfoList = new ArrayList<SJmoPortIscsiTargetInfo>();
        ArrayList<SJmoPortIscsiTargetInfo> confirmPortItInfoList = new ArrayList<SJmoPortIscsiTargetInfo>();
        SJmoPortIscsiTargetInfo selectPortItInfo = this.targetPortItInfoList.get(0);
        ArrayList<SJmoIscsiTargetInfo> selectItInfoList = selectPortItInfo.getAlPortIscsiTarget();
        SJmoIscsiTargetInfo selectItInfo = selectItInfoList.get(0);
        ArrayList<SJmoIscsiName> selectIscsiNameList = selectItInfo.getAlIscsiName();
        SJmoIscsiName selectIscsiName = selectIscsiNameList.get(0);
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_CACHEDATA_INVALID);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex itIndex = new SJmoHostGroupIndex();
        List<?> modelPortDetailList = this.getCache(SJmoGetPortDetail.class);
        int portDetailIndex = Collections.binarySearch(modelPortDetailList, selectPortItInfo);
        if (portDetailIndex >= 0) {
            SJmoPortDetail modelPortDetail = (SJmoPortDetail)modelPortDetailList.get(portDetailIndex);
            confirmPortDetailList.add(modelPortDetail);
        }
        List<?> modelPortItInfoList = this.getCache(SJmoGetPortIscsiTargetInfo.class);
        Collections.sort(modelPortItInfoList);
        int portItInfoIndex = Collections.binarySearch(modelPortItInfoList, selectPortItInfo);
        if (portItInfoIndex >= 0) {
            modelPortItInfo = (SJmoPortIscsiTargetInfo)modelPortItInfoList.get(portItInfoIndex);
            modelItInfoList = modelPortItInfo.getAlPortIscsiTarget();
            boolean result = false;
            for (SJmoIscsiTargetInfo modelItInfo : modelItInfoList) {
                if (modelItInfo.getSIscsiTarget() != selectItInfo.getSIscsiTarget()) continue;
                ArrayList<SJmoIscsiName> modelIscsiNameList = modelItInfo.getAlIscsiName();
                for (SJmoIscsiName modelIscsiName : modelIscsiNameList) {
                    if (0 != iscsiNameComparator.compare(modelIscsiName, selectIscsiName)) continue;
                    SJmoPortIscsiTargetInfo beforePortIscsiTargetInfo = null;
                    SJmoIscsiTargetInfo beforeIscsiTargetInfo = null;
                    SJmoIscsiName beforeIscsiName = null;
                    SJmoPortIscsiTargetInfo createPortIscsiTargetInfo = null;
                    SJmoIscsiTargetInfo createIscsiTargetInfo = null;
                    SJmoIscsiName createIscsiName = null;
                    try {
                        beforePortIscsiTargetInfo = (SJmoPortIscsiTargetInfo)modelPortItInfo.clone();
                        beforeIscsiTargetInfo = (SJmoIscsiTargetInfo)modelItInfo.clone();
                        beforeIscsiName = (SJmoIscsiName)modelIscsiName.clone();
                        createPortIscsiTargetInfo = (SJmoPortIscsiTargetInfo)modelPortItInfo.clone();
                        createIscsiTargetInfo = (SJmoIscsiTargetInfo)modelItInfo.clone();
                        createIscsiName = (SJmoIscsiName)modelIscsiName.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        this.getLogUty().putlog("editHostData", "IscsiTargetInfo clone fail", e, 40000);
                        continue;
                    }
                    ArrayList<SJmoIscsiName> alBeforeIscsiTargetIscsiName = new ArrayList<SJmoIscsiName>(1);
                    alBeforeIscsiTargetIscsiName.add(beforeIscsiName);
                    beforeIscsiTargetInfo.setAlIscsiName(alBeforeIscsiTargetIscsiName);
                    ArrayList<SJmoIscsiTargetInfo> alBeforePortIscsiTarget = new ArrayList<SJmoIscsiTargetInfo>(1);
                    alBeforePortIscsiTarget.add(beforeIscsiTargetInfo);
                    beforePortIscsiTargetInfo.setAlPortIscsiTarget(alBeforePortIscsiTarget);
                    confirmBeforePortItInfoList.add(beforePortIscsiTargetInfo);
                    alIscsiTargetIscsiName = new ArrayList(1);
                    alIscsiTargetIscsiName.add(createIscsiName);
                    createIscsiTargetInfo.setAlIscsiName(alIscsiTargetIscsiName);
                    ArrayList<SJmoIscsiTargetInfo> alPortIscsiTarget = new ArrayList<SJmoIscsiTargetInfo>(1);
                    alPortIscsiTarget.add(createIscsiTargetInfo);
                    createPortIscsiTargetInfo.setAlPortIscsiTarget(alPortIscsiTarget);
                    confirmPortItInfoList.add(createPortIscsiTargetInfo);
                    result = true;
                    break;
                }
                if (!result) continue;
                break;
            }
        }
        if (sameSettingDataModel.isSelect()) {
            for (portItInfoIndex = 0; portItInfoIndex < modelPortItInfoList.size(); ++portItInfoIndex) {
                SJmoPortAttributeInfo seletcPortAttr;
                byte portKind;
                modelPortItInfo = (SJmoPortIscsiTargetInfo)modelPortItInfoList.get(portItInfoIndex);
                modelItInfoList = modelPortItInfo.getAlPortIscsiTarget();
                SJmoPortIndex beforePortIscsiTargetInfo = null;
                SJmoIscsiTargetIndex beforeIscsiTargetInfo = null;
                SJmoIscsiName beforeIscsiName = null;
                SJmoPortIscsiTargetInfo createPortIscsiTargetInfo = null;
                SJmoIscsiTargetInfo createIscsiTargetInfo = null;
                SJmoIscsiName createIscsiName = null;
                if (modelPortItInfo.getSPort() == selectPortItInfo.getSPort()) continue;
                List<?> modelPortAttrList = this.getCache(SJmoGetPortAttributeInfo.class);
                Collections.sort(modelPortAttrList);
                int portAttrIndex = Collections.binarySearch(modelPortAttrList, modelPortItInfo);
                if (portAttrIndex < 0 || (portKind = (seletcPortAttr = (SJmoPortAttributeInfo)modelPortAttrList.get(portAttrIndex)).getByPortKind()) == 5 || portKind == 6) continue;
                ArrayList<SJmoIscsiTargetInfo> alBeforePortIscsiTarget = new ArrayList<SJmoIscsiTargetInfo>();
                ArrayList<SJmoIscsiTargetInfo> alPortIscsiTarget = new ArrayList<SJmoIscsiTargetInfo>();
                boolean bFoundIscsiName = false;
                for (SJmoIscsiTargetInfo modelItInfo : modelItInfoList) {
                    ArrayList<SJmoIscsiName> alBeforeIscsiTargetIscsiName = new ArrayList<SJmoIscsiName>();
                    alIscsiTargetIscsiName = new ArrayList<SJmoIscsiName>();
                    ArrayList<SJmoIscsiName> modelIscsiNameList = modelItInfo.getAlIscsiName();
                    for (SJmoIscsiName modelIscsiName : modelIscsiNameList) {
                        if (0 != iscsiNameComparator.compare(modelIscsiName, selectIscsiName)) continue;
                        try {
                            beforePortIscsiTargetInfo = (SJmoPortIscsiTargetInfo)modelPortItInfo.clone();
                            beforeIscsiTargetInfo = (SJmoIscsiTargetInfo)modelItInfo.clone();
                            beforeIscsiName = (SJmoIscsiName)modelIscsiName.clone();
                            createPortIscsiTargetInfo = (SJmoPortIscsiTargetInfo)modelPortItInfo.clone();
                            createIscsiTargetInfo = (SJmoIscsiTargetInfo)modelItInfo.clone();
                            createIscsiName = (SJmoIscsiName)modelIscsiName.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            this.getLogUty().putlog("editHostData", "PortIscsiTargetInfo clone fail", e, 40000);
                            continue;
                        }
                        alBeforeIscsiTargetIscsiName.add(beforeIscsiName);
                        alIscsiTargetIscsiName.add(createIscsiName);
                        bFoundIscsiName = true;
                        break;
                    }
                    if (alIscsiTargetIscsiName.size() > 0) {
                        ((SJmoIscsiTargetInfo)beforeIscsiTargetInfo).setAlIscsiName(alBeforeIscsiTargetIscsiName);
                        createIscsiTargetInfo.setAlIscsiName(alIscsiTargetIscsiName);
                        alBeforePortIscsiTarget.add((SJmoIscsiTargetInfo)beforeIscsiTargetInfo);
                        alPortIscsiTarget.add(createIscsiTargetInfo);
                    }
                    if (!bFoundIscsiName) continue;
                    break;
                }
                if (alPortIscsiTarget.size() <= 0) continue;
                itIndex.setSPort(beforePortIscsiTargetInfo.getSPort());
                itIndex.setSHostGroup(beforeIscsiTargetInfo.getSIscsiTarget());
                boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(itIndex, rsgUtil);
                if (!rsgFlg) {
                    SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_ISCSITARGET_UNAVAILABLE_LV7);
                    SJcException exp = err.createException();
                    throw exp;
                }
                ((SJmoPortIscsiTargetInfo)beforePortIscsiTargetInfo).setAlPortIscsiTarget(alBeforePortIscsiTarget);
                createPortIscsiTargetInfo.setAlPortIscsiTarget(alPortIscsiTarget);
                confirmBeforePortItInfoList.add((SJmoPortIscsiTargetInfo)beforePortIscsiTargetInfo);
                confirmPortItInfoList.add(createPortIscsiTargetInfo);
                portDetailIndex = Collections.binarySearch(modelPortDetailList, createPortIscsiTargetInfo);
                if (portDetailIndex < 0) continue;
                SJmoPortDetail modelPortDetail = (SJmoPortDetail)modelPortDetailList.get(portDetailIndex);
                confirmPortDetailList.add(modelPortDetail);
            }
        }
        for (portItInfoIndex = 0; portItInfoIndex < confirmPortItInfoList.size(); ++portItInfoIndex) {
            SJmoPortIscsiTargetInfo confirmPortItInfo = (SJmoPortIscsiTargetInfo)confirmPortItInfoList.get(portItInfoIndex);
            ArrayList<SJmoIscsiTargetInfo> confirmItInfoList = confirmPortItInfo.getAlPortIscsiTarget();
            for (SJmoIscsiTargetInfo confirmItInfo : confirmItInfoList) {
                ArrayList<SJmoIscsiName> confirmIscsiNameList = confirmItInfo.getAlIscsiName();
                for (SJmoIscsiName confirmIscsiName : confirmIscsiNameList) {
                    if (this.hbaIscsiNameDataModel.isSelectCheckBox()) {
                        String hbaIscsiName = this.hbaIscsiNameDataModel.getTextboxValue();
                        String strRdoSelected = this.hbaIscsiNameDataModel.isSelectedIqn() ? this.getComUtility().getGuidance(GUIDKEY_IQN) : this.getComUtility().getGuidance(GUIDKEY_EUI);
                        confirmIscsiName.setStrIscsiName(strRdoSelected + hbaIscsiName);
                    }
                    if (!hostNameCheckBox.isSelect()) continue;
                    String strHostName = hostNameTextBox.getValue();
                    confirmIscsiName.setStrIscsiNickName(strHostName);
                }
            }
        }
        for (portItInfoIndex = 0; portItInfoIndex < confirmPortItInfoList.size(); ++portItInfoIndex) {
            SJmoPortIscsiTargetInfo confirmBeforePortItInfo = (SJmoPortIscsiTargetInfo)confirmBeforePortItInfoList.get(portItInfoIndex);
            ArrayList<SJmoIscsiTargetInfo> confirmBeforeItInfoList = confirmBeforePortItInfo.getAlPortIscsiTarget();
            SJmoPortIscsiTargetInfo confirmPortItInfo = (SJmoPortIscsiTargetInfo)confirmPortItInfoList.get(portItInfoIndex);
            ArrayList<SJmoIscsiTargetInfo> confirmItInfoList = confirmPortItInfo.getAlPortIscsiTarget();
            for (int itInfoIndex = 0; itInfoIndex < confirmItInfoList.size(); ++itInfoIndex) {
                SJmoIscsiTargetInfo confirmBeforeItInfo = confirmBeforeItInfoList.get(itInfoIndex);
                ArrayList<SJmoIscsiName> confirmBeforeIscsiNameList = confirmBeforeItInfo.getAlIscsiName();
                SJmoIscsiTargetInfo confirmItInfo = confirmItInfoList.get(itInfoIndex);
                ArrayList<SJmoIscsiName> confirmIscsiNameList = confirmItInfo.getAlIscsiName();
                for (int iscsiNameIndex = 0; iscsiNameIndex < confirmIscsiNameList.size(); ++iscsiNameIndex) {
                    SJmoIscsiName confirmIscsiName;
                    SJmoIscsiName confirmBeforeIscsiName = confirmBeforeIscsiNameList.get(iscsiNameIndex);
                    if (0 != iscsiNameComparator.compare(confirmBeforeIscsiName, confirmIscsiName = confirmIscsiNameList.get(iscsiNameIndex)) && !this.checkExistHbaIscsiName(modelPortItInfoList, confirmPortItInfo, confirmIscsiName)) {
                        SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_ISCSINAME_ALREADY_EXISTS);
                        SJcException exp = err.createException();
                        throw exp;
                    }
                    if ("".equals(confirmIscsiName.getStrIscsiNickName()) || confirmBeforeIscsiName.getStrIscsiNickName().equals(confirmIscsiName.getStrIscsiNickName()) || this.checkExistHostName(modelPortItInfoList, confirmPortItInfo, confirmIscsiName)) continue;
                    SJctrError err = new SJctrError(10, 22, EDITHOST_ERR_ISCSINICKNAME_ALREADY_EXISTS);
                    SJcException exp = err.createException();
                    throw exp;
                }
            }
        }
        Collections.sort(confirmPortDetailList);
        Collections.sort(confirmBeforePortItInfoList);
        Collections.sort(confirmPortItInfoList);
        SJctrEditHostIscsiData confirmData = new SJctrEditHostIscsiData();
        confirmData.setPortDetailList(confirmPortDetailList);
        confirmData.setBeforePortItInfoList(confirmBeforePortItInfoList);
        confirmData.setPortItInfoList(confirmPortItInfoList);
        ArrayList<SJctrEditHostIscsiData> confirmDataList = new ArrayList<SJctrEditHostIscsiData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrEditHostIscsiData.class, confirmDataList);
        return true;
    }

    private boolean checkExistHbaIscsiName(List portItInfoList, SJmoPortIscsiTargetInfo portItInfo, SJmoIscsiName iscsiName) {
        boolean ret = true;
        int index = Collections.binarySearch(portItInfoList, portItInfo);
        if (index >= 0) {
            SJmoPortIscsiTargetInfo modelPortItInfo = (SJmoPortIscsiTargetInfo)portItInfoList.get(index);
            ArrayList<SJmoIscsiTargetInfo> modelItInfoList = modelPortItInfo.getAlPortIscsiTarget();
            for (SJmoIscsiTargetInfo modelItInfo : modelItInfoList) {
                ArrayList<SJmoIscsiName> modelIscsiNameList = modelItInfo.getAlIscsiName();
                for (SJmoIscsiName modelIscsiName : modelIscsiNameList) {
                    if (0 != iscsiNameComparator.compare(modelIscsiName, iscsiName)) continue;
                    ret = false;
                    return ret;
                }
            }
        }
        return ret;
    }

    private boolean checkExistHostName(List portItInfoList, SJmoPortIscsiTargetInfo portItInfo, SJmoIscsiName iscsiName) {
        boolean ret = true;
        int index = Collections.binarySearch(portItInfoList, portItInfo);
        if (index >= 0) {
            SJmoPortIscsiTargetInfo modelPortItInfo = (SJmoPortIscsiTargetInfo)portItInfoList.get(index);
            ArrayList<SJmoIscsiTargetInfo> modelItInfoList = modelPortItInfo.getAlPortIscsiTarget();
            for (SJmoIscsiTargetInfo modelItInfo : modelItInfoList) {
                ArrayList<SJmoIscsiName> modelIscsiNameList = modelItInfo.getAlIscsiName();
                for (SJmoIscsiName modelIscsiName : modelIscsiNameList) {
                    if (!modelIscsiName.getStrIscsiNickName().equals(iscsiName.getStrIscsiNickName())) continue;
                    ret = false;
                    return ret;
                }
            }
        }
        return ret;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

